/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import java.util.HashMap;

public class BrowserUtil {
    private static WAdminResource bundle = WAdminResource.getBundle(BrowserUtil.class);
    public static int FILES = 0;
    public static int DIRECTORIES = 1;
    protected WsAppServer m_AppServer = null;
    protected int m_browseScope = FILES;

    public BrowserUtil(WsAppServer appServer) {
        this.m_AppServer = appServer;
        this.m_browseScope = FILES;
    }

    public BrowserUtil(WsAppServer appServer, int browseScope) {
        this.m_AppServer = appServer;
        this.m_browseScope = browseScope;
    }

    public void setAppServer(WsAppServer appServer) {
        this.m_AppServer = appServer;
    }

    public void setBrowseScope(int browseScope) {
        this.m_browseScope = browseScope;
    }

    public String showBrowser(String browserTitle, String defaultPath) throws WsAppServerFailException, GenericError {
        String filenameString = "";
        HashMap<String, String> fileTypes = new HashMap<String, String>();
        fileTypes.put("0", "*");
        try {
            if (this.m_browseScope == DIRECTORIES) {
                filenameString = this.m_AppServer.promptForDirectory(browserTitle, defaultPath, fileTypes);
                if (filenameString == null || filenameString == "" || filenameString.length() < 0) {
                    filenameString = "";
                }
            } else {
                filenameString = this.m_AppServer.promptForFilename(browserTitle, defaultPath, fileTypes);
                if (filenameString == null || filenameString == "" || filenameString.length() < 0) {
                    filenameString = "";
                }
            }
        }
        catch (WsAppServerFailException w) {
            throw w;
        }
        catch (GenericError g) {
            throw g;
        }
        return filenameString;
    }
}

