/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.tomcat;

import com.atomikos.jdbc.AtomikosDataSourceBean;
import com.atomikos.jdbc.internal.AbstractDataSourceBean;
import com.atomikos.jms.AtomikosConnectionFactoryBean;
import com.atomikos.jmx.jdbc.JmxAtomikosDataSourceBean;
import com.atomikos.jmx.jms.JmxAtomikosConnectionFactoryBean;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;

public class MBeanLifecycleListener
implements LifecycleListener {
    private static Log log = LogFactory.getLog(MBeanLifecycleListener.class);
    protected static Registry registry = MBeanUtils.createRegistry();

    public void lifecycleEvent(LifecycleEvent event) {
        if ("start".equals(event.getType())) {
            this.createMBeans();
        }
    }

    protected void createMBeans() {
        Context context = null;
        try {
            context = (Context)new InitialContext().lookup("java:/");
            this.createMBeans("", context);
        }
        catch (NamingException e) {
            log.warn((Object)"Exception while creating MBeans", (Throwable)e);
        }
    }

    protected void createMBeans(String prefix, Context context) throws NamingException {
        NamingEnumeration<Binding> bindings = context.listBindings("");
        while (bindings.hasMore()) {
            Binding binding = bindings.next();
            String name = prefix + binding.getName();
            Object value = context.lookup(binding.getName());
            if (value instanceof Context) {
                this.createMBeans(name + "/", (Context)value);
                continue;
            }
            if (value instanceof AtomikosDataSourceBean) {
                AtomikosDataSourceBean dataSource = (AtomikosDataSourceBean)value;
                this.registerMBeanForDataSource(dataSource);
                continue;
            }
            if (!(value instanceof AtomikosConnectionFactoryBean)) continue;
            AtomikosConnectionFactoryBean cf = (AtomikosConnectionFactoryBean)value;
            this.registerMBeanForConnectionFactory(cf);
        }
    }

    private void registerMBeanForConnectionFactory(AtomikosConnectionFactoryBean cf) {
        JmxAtomikosConnectionFactoryBean jmxAtomikosConnectionFactoryBean = new JmxAtomikosConnectionFactoryBean();
        jmxAtomikosConnectionFactoryBean.setMonitoredBean(cf);
        jmxAtomikosConnectionFactoryBean.setAutoRegisterWithPlatformMBeanServerOnInit(false);
        jmxAtomikosConnectionFactoryBean.init();
        try {
            registry.getMBeanServer().registerMBean(jmxAtomikosConnectionFactoryBean, null);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to register MBean for connectionFactory " + cf.getUniqueResourceName()), (Throwable)e);
        }
    }

    private void registerMBeanForDataSource(AtomikosDataSourceBean dataSource) {
        JmxAtomikosDataSourceBean jmxAtomikosDataSourceBean = new JmxAtomikosDataSourceBean();
        jmxAtomikosDataSourceBean.setMonitoredBean((AbstractDataSourceBean)dataSource);
        jmxAtomikosDataSourceBean.setAutoRegisterWithPlatformMBeanServerOnInit(false);
        jmxAtomikosDataSourceBean.init();
        try {
            registry.getMBeanServer().registerMBean(jmxAtomikosDataSourceBean, null);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to register MBean for dataSource " + dataSource.getUniqueResourceName()), (Throwable)e);
        }
    }
}

