/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.tomcat;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.ResourceRef;

public class JNDIDelegateObjectFactory
implements ObjectFactory {
    private static Log TOMCAT_LOG = LogFactory.getLog(JNDIDelegateObjectFactory.class);

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Object bean = null;
        String physicalName = null;
        if (obj instanceof ResourceRef) {
            Reference ref = (Reference)obj;
            Properties props = new Properties();
            Enumeration<RefAddr> en = ref.getAll();
            while (en.hasMoreElements()) {
                RefAddr ra = en.nextElement();
                String propName = ra.getType();
                if (propName.startsWith("env.")) {
                    props.put(propName.replace("env.", ""), ra.getContent().toString());
                }
                if (!"physicalName".equals(propName)) continue;
                physicalName = ra.getContent().toString();
            }
            TOMCAT_LOG.info((Object)("Calling JNDI with properties  : " + props));
            InitialContext context = new InitialContext(props);
            TOMCAT_LOG.info((Object)("---------- getObjectInstance: next lookup : " + physicalName));
            bean = context.lookup(physicalName);
        }
        TOMCAT_LOG.info((Object)("---------- Found :" + bean));
        return bean;
    }
}

