/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.tomcat;

import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.io.IOException;

public class CleanupPendingTransactionContextFilter
implements Filter {
    public static final String ENABLE_FILTER_PROPERTY_NAME = "com.atomikos.icatch.http.filter_requests";
    private static final Logger LOGGER = LoggerFactory.createLogger(CleanupPendingTransactionContextFilter.class);
    private boolean enabled = true;

    public void destroy() {
        LOGGER.logInfo("Destroying " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        LOGGER.logDebug("New incoming request for thread...");
        if (this.enabled) {
            this.cleanUpPendingTransactionContext();
            this.cleanUpPendingTransactionTimeout();
            try {
                chain.doFilter(req, resp);
            }
            finally {
                this.cleanUpPendingTransactionContext();
            }
        } else {
            chain.doFilter(req, resp);
        }
        LOGGER.logTrace("Incoming request done...");
    }

    private void cleanUpPendingTransactionTimeout() {
        TransactionManager tm = TransactionManagerImp.getTransactionManager();
        if (tm != null) {
            try {
                tm.setTransactionTimeout(0);
            }
            catch (Exception e) {
                LOGGER.logWarning("Failed to reset the transaction timeout", (Throwable)e);
            }
        }
    }

    private void cleanUpPendingTransactionContext() {
        Transaction tx;
        TransactionManager tm = TransactionManagerImp.getTransactionManager();
        if (tm != null && (tx = this.suspendTransaction(tm)) != null) {
            LOGGER.logWarning("Oops! Found pending transaction on HTTP request thread - please verify transaction termination and exception handling for your application...");
            this.rollbackTransaction(tx);
        }
    }

    private void rollbackTransaction(Transaction tx) {
        try {
            tx.rollback();
        }
        catch (Exception e) {
            LOGGER.logWarning("Unexpected error during rollback of pending transaction", (Throwable)e);
        }
    }

    private Transaction suspendTransaction(TransactionManager tm) {
        Transaction ret = null;
        try {
            ret = tm.suspend();
        }
        catch (Exception e) {
            LOGGER.logWarning("Unexpected error suspending transaction", (Throwable)e);
        }
        return ret;
    }

    public void init(FilterConfig config) throws ServletException {
        LOGGER.logInfo("Initializing " + this);
        String filterAsString = Configuration.getConfigProperties().getProperty(ENABLE_FILTER_PROPERTY_NAME);
        if (filterAsString != null && "false".equalsIgnoreCase(filterAsString.trim())) {
            LOGGER.logInfo("Detected com.atomikos.icatch.http.filter_requests=false - disabling filtering...");
            this.enabled = false;
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

