/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.CompareDisplayInfoObjects;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import com.sas.scheduler.visuals.swing.GroupingPanel;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.ListModel;

public class TriggeringEventPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private FlowInfo m_objFlow;
    private Frame m_frame;
    private List<TriggerEventInfo> m_lstEvents;
    private JButton m_triggerOptions;
    private StandardPanel m_selectionPanel;

    public TriggeringEventPanel(FlowInfo flow, Frame frame) {
        this.m_objFlow = flow;
        this.m_frame = frame;
        this.__initialize();
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_selectionPanel.saveSettingsAndCleanUp();
        this.m_objFlow = null;
        this.m_lstEvents = null;
        this.m_triggerOptions = null;
        this.m_selectionPanel = null;
    }

    public void addTriggerListener(ActionListener al) {
        this.m_triggerOptions.addActionListener(al);
        this.m_triggerOptions.setVisible(true);
    }

    public boolean addTriggerEvent(TriggerEventInfo event) {
        if (event.getEvent() instanceof FileEventInfo && !this.m_objFlow.getScheduler().isFileEventSupported()) {
            return false;
        }
        this.m_lstEvents.add(event);
        if (this.m_selectionPanel instanceof MultiSelectPanel) {
            MultiSelectPanel mp = (MultiSelectPanel)this.m_selectionPanel;
            mp.addTriggerEvent(event);
        } else if (this.m_selectionPanel instanceof SingleSelectPanel) {
            SingleSelectPanel sp = (SingleSelectPanel)this.m_selectionPanel;
            sp.addTriggerEvent(event);
        }
        this.refresh();
        return true;
    }

    public TriggerEventInfo[] getSelectedEvents() {
        if (this.m_selectionPanel instanceof MultiSelectPanel) {
            MultiSelectPanel mp = (MultiSelectPanel)this.m_selectionPanel;
            return mp.mc_dualList.getSelectedValues();
        }
        if (this.m_selectionPanel instanceof SingleSelectPanel) {
            return null;
        }
        return null;
    }

    public boolean removeTriggerEvent(TriggerEventInfo event) {
        this.m_lstEvents.remove(event);
        if (this.m_selectionPanel instanceof MultiSelectPanel) {
            MultiSelectPanel mp = (MultiSelectPanel)this.m_selectionPanel;
            mp.removeTriggerEvent(event);
        } else if (this.m_selectionPanel instanceof SingleSelectPanel) {
            SingleSelectPanel sp = (SingleSelectPanel)this.m_selectionPanel;
            sp.removeTriggerEvent(event);
        }
        this.refresh();
        return true;
    }

    public void refresh() {
        if (this.m_selectionPanel instanceof MultiSelectPanel) {
            MultiSelectPanel mp = (MultiSelectPanel)this.m_selectionPanel;
            mp.refresh();
        } else if (this.m_selectionPanel instanceof SingleSelectPanel) {
            SingleSelectPanel sp = (SingleSelectPanel)this.m_selectionPanel;
            sp.refresh();
        }
        this.setDataChanged(true);
    }

    public void reset(FlowInfo info) {
        this.m_objFlow = info;
        if (this.m_selectionPanel instanceof MultiSelectPanel) {
            this.m_lstEvents = this.m_objFlow.getFlowTriggerEvents("Event");
            MultiSelectPanel mp = (MultiSelectPanel)this.m_selectionPanel;
            mp.reset();
        } else if (this.m_selectionPanel instanceof SingleSelectPanel) {
            this.m_lstEvents = this.m_objFlow.getFlowTriggerEvents();
            SingleSelectPanel sp = (SingleSelectPanel)this.m_selectionPanel;
            sp.reset();
        }
        this.moveDataToView();
        this.refresh();
    }

    @Override
    public boolean validateData() {
        return this.m_selectionPanel.validateData();
    }

    @Override
    public boolean moveDataToView() {
        this.m_selectionPanel.moveDataToView();
        this.setDataChanged(false);
        return true;
    }

    @Override
    public boolean moveViewToData() {
        this.m_objFlow.setTriggerEventList(this.m_lstEvents);
        this.m_selectionPanel.moveViewToData();
        return true;
    }

    public ArrayList<String> getDependenciesList() {
        ArrayList<String> curr_dep = new ArrayList<String>();
        int numDependencies = this.m_lstEvents.size();
        for (int i = 0; i < numDependencies; ++i) {
            TriggerEventInfo entry = this.m_lstEvents.get(i);
            String dep = entry.toString();
            if (dep == null) continue;
            curr_dep.add(dep.trim());
        }
        return curr_dep;
    }

    private void __initialize() {
        String triggeroptionText = m_bundle.getString("TriggeringEventPanel.TriggerOption.txt");
        this.m_triggerOptions = new JButton(Util.getLabelWithoutMnemonic((String)triggeroptionText));
        this.m_triggerOptions.setMnemonic(Util.getDisplayedMnemonic((String)triggeroptionText));
        this.m_triggerOptions.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)triggeroptionText));
        SchedulerServerInfo sinfo = this.m_objFlow.getScheduler();
        JLabel description1 = new JLabel(MessageFormat.format(m_bundle.getString("TriggeringEventPanel.CommonDescription.fmt"), this.m_objFlow.getName()));
        String desc2 = null;
        String desc3 = null;
        if (this.m_objFlow.isFlowSubmitted()) {
            desc2 = m_bundle.getString("TriggeringEventPanel.ResubmissionDescription.txt");
        }
        String desc = null;
        desc = sinfo.isFileEventSupportedAsTriggers() ? MessageFormat.format(m_bundle.getString("TriggeringEventPanel.TimeFileDescription.fmt"), sinfo.getName()) : MessageFormat.format(m_bundle.getString("TriggeringEventPanel.TimeOnlyDescription.fmt"), sinfo.getName());
        if (desc2 != null) {
            desc3 = desc;
        } else {
            desc2 = desc;
        }
        if (sinfo.isMultiTriggersSupported()) {
            this.m_lstEvents = this.m_objFlow.getFlowTriggerEvents("Event");
            this.m_selectionPanel = new MultiSelectPanel();
        } else {
            this.m_lstEvents = this.m_objFlow.getFlowTriggerEvents();
            this.m_selectionPanel = new SingleSelectPanel();
        }
        JLabel description2 = new JLabel(desc2);
        JLabel description3 = new JLabel(desc3);
        JSeparator sepSeparator = new JSeparator(0);
        this.setLayout(new GridBagLayout());
        this.add((Component)description1, new GridBagConstraints(0, 0, 5, 1, 1.0, 1.0, 17, 3, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)description2, new GridBagConstraints(0, 1, 5, 1, 1.0, 1.0, 17, 3, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)description3, new GridBagConstraints(0, 2, 5, 1, 1.0, 1.0, 17, 3, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)sepSeparator, new GridBagConstraints(0, 3, 10, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_selectionPanel, new GridBagConstraints(0, 4, 9, 1, 1.0, 1.0, 17, 1, new Insets(5, 20, 0, 0), 0, 0));
        this.add((Component)this.m_triggerOptions, new GridBagConstraints(9, 4, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    static {
        String strClassName = TriggeringEventPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    private class MultiSelectPanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;
        private JRadioButton mc_runnowBtn;
        private JRadioButton mc_manualBtn;
        private JRadioButton mc_eventBtn;
        private ListSelector mc_dualList = new ListSelector();
        private TreeSet<TriggerEventInfo> mc_sourceList;
        private TreeSet<TriggerEventInfo> mc_targetList;
        private CollectionToListModelAdapter mc_sourceModel = new CollectionToListModelAdapter();
        private CollectionToListModelAdapter mc_targetModel = new CollectionToListModelAdapter();
        private GroupingPanel mc_grouping;
        private boolean mc_gateEnabled = true;

        public MultiSelectPanel() {
            this.__initialize();
        }

        @Override
        public void saveSettingsAndCleanUp() {
            this.mc_runnowBtn = null;
            this.mc_manualBtn = null;
            this.mc_eventBtn = null;
            this.mc_dualList = null;
            this.mc_sourceList = null;
            this.mc_targetList = null;
            this.mc_sourceModel = null;
            this.mc_targetModel = null;
            this.mc_grouping = null;
        }

        public boolean addTriggerEvent(TriggerEventInfo event) {
            this.mc_targetList.add(event);
            this.mc_targetModel.setModel(this.mc_targetList);
            this.mc_targetModel.refresh();
            this.mc_dualList.setTargetModel((ListModel)this.mc_targetModel);
            this.mc_eventBtn.setSelected(true);
            this.mc_dualList.setEnabled(true);
            if (TriggeringEventPanel.this.m_objFlow.getScheduler().getClassId().equals("8b4dc45a-f7c7-11e7-8c3f-9a214cf093ae")) {
                this.mc_grouping.setGroupingType(32);
                this.mc_grouping.setEnabled(false);
            } else if (this.mc_gateEnabled) {
                this.mc_grouping.setEnabled(true);
            }
            return true;
        }

        public boolean removeTriggerEvent(TriggerEventInfo event) {
            if (this.mc_sourceList.remove(event)) {
                this.mc_sourceModel.setModel(this.mc_sourceList);
                this.mc_sourceModel.refresh();
                this.mc_dualList.setModel((ListModel)this.mc_sourceModel);
                return true;
            }
            if (this.mc_targetList.remove(event)) {
                this.mc_targetModel.setModel(this.mc_targetList);
                this.mc_targetModel.refresh();
                this.mc_dualList.setTargetModel((ListModel)this.mc_targetModel);
                return true;
            }
            return false;
        }

        public void refresh() {
            this.setModel();
            this.moveDataToView();
            this.mc_dualList.refresh();
        }

        public void reset() {
            this.setModel();
        }

        private void __initialize() {
            String triggerType;
            this.mc_dualList.setTargetControlsVisible(false);
            this.mc_dualList.setDragAndDropEnabled(false);
            this.mc_dualList.setAlternatingSingleButtonStyle(false);
            this.mc_dualList.setAlternatingMultipleButtonStyle(false);
            String runnowStr = m_bundle.getString("TriggeringEventPanel.Button.RunNow.txt");
            this.mc_runnowBtn = new JRadioButton();
            this.mc_runnowBtn.setText(Util.getLabelWithoutMnemonic((String)runnowStr));
            this.mc_runnowBtn.setMnemonic(Util.getDisplayedMnemonic((String)runnowStr));
            this.mc_runnowBtn.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)runnowStr));
            String manualStr = m_bundle.getString("TriggeringEventPanel.Button.Manual.txt");
            this.mc_manualBtn = new JRadioButton();
            this.mc_manualBtn.setText(Util.getLabelWithoutMnemonic((String)manualStr));
            this.mc_manualBtn.setMnemonic(Util.getDisplayedMnemonic((String)manualStr));
            this.mc_manualBtn.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)manualStr));
            String eventStr = m_bundle.getString("TriggeringEventPanel.Button.Event.txt");
            this.mc_eventBtn = new JRadioButton();
            this.mc_eventBtn.setText(Util.getLabelWithoutMnemonic((String)eventStr));
            this.mc_eventBtn.setMnemonic(Util.getDisplayedMnemonic((String)eventStr));
            this.mc_eventBtn.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)eventStr));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.mc_runnowBtn);
            buttonGroup.add(this.mc_manualBtn);
            buttonGroup.add(this.mc_eventBtn);
            if (TriggeringEventPanel.this.m_objFlow.getScheduler() != null) {
                this.mc_gateEnabled = TriggeringEventPanel.this.m_objFlow.getScheduler().isORGateSupported();
            }
            this.mc_runnowBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MultiSelectPanel.this.mc_runnowBtn.isSelected()) {
                        MultiSelectPanel.this.mc_dualList.setEnabled(false);
                        MultiSelectPanel.this.mc_grouping.setEnabled(false);
                    }
                }
            });
            this.mc_manualBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MultiSelectPanel.this.mc_manualBtn.isSelected()) {
                        MultiSelectPanel.this.mc_dualList.setEnabled(false);
                        MultiSelectPanel.this.mc_grouping.setEnabled(false);
                    }
                }
            });
            this.mc_eventBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MultiSelectPanel.this.mc_eventBtn.isSelected()) {
                        MultiSelectPanel.this.mc_dualList.setEnabled(true);
                        if (TriggeringEventPanel.this.m_objFlow.getScheduler().getClassId().equals("8b4dc45a-f7c7-11e7-8c3f-9a214cf093ae")) {
                            MultiSelectPanel.this.mc_grouping.setGroupingType(32);
                            MultiSelectPanel.this.mc_grouping.setEnabled(false);
                        } else if (MultiSelectPanel.this.mc_gateEnabled) {
                            MultiSelectPanel.this.mc_grouping.setEnabled(true);
                        }
                    }
                }
            });
            int condition = 31;
            try {
                AbstractEventInfo di = TriggeringEventPanel.this.m_objFlow.getTriggerEvent().getEvent();
                if (di instanceof GroupingEventInfo) {
                    int temp = ((GroupingEventInfo)di).getEventType();
                    condition = temp == 1 ? 32 : 31;
                }
            }
            catch (Exception ex) {
                condition = 31;
            }
            this.mc_grouping = new GroupingPanel(condition);
            if (TriggeringEventPanel.this.m_objFlow.getScheduler().getClassId().equals("8b4dc45a-f7c7-11e7-8c3f-9a214cf093ae")) {
                this.mc_grouping.setGroupingType(32);
                this.mc_grouping.setEnabled(false);
            }
            if ((triggerType = TriggeringEventPanel.this.m_objFlow.getTriggerType()) == null || triggerType.compareTo("RunNow") == 0) {
                this.mc_runnowBtn.setSelected(true);
                this.mc_dualList.setEnabled(false);
                this.mc_grouping.setEnabled(false);
            } else if (triggerType.compareTo("Event") == 0 || triggerType.compareTo("TimeEvent") == 0 || triggerType.compareTo("FileEvent") == 0 || triggerType.compareTo("Gate") == 0) {
                this.mc_eventBtn.setSelected(true);
                this.mc_dualList.setEnabled(true);
                if (TriggeringEventPanel.this.m_objFlow.getScheduler().getClassId().equals("8b4dc45a-f7c7-11e7-8c3f-9a214cf093ae")) {
                    this.mc_grouping.setGroupingType(32);
                    this.mc_grouping.setEnabled(false);
                } else if (this.mc_gateEnabled) {
                    this.mc_grouping.setEnabled(true);
                } else {
                    this.mc_grouping.setEnabled(false);
                }
            } else if (triggerType.compareTo("Manual") == 0) {
                this.mc_manualBtn.setSelected(true);
                this.mc_dualList.setEnabled(false);
                this.mc_grouping.setEnabled(false);
            } else {
                this.mc_runnowBtn.setSelected(true);
                this.mc_dualList.setEnabled(false);
                this.mc_grouping.setEnabled(false);
            }
            this.setModel();
            this.setLayout(new GridBagLayout());
            this.add((Component)this.mc_runnowBtn, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.mc_manualBtn, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.mc_eventBtn, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)((Object)this.mc_dualList), new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 20, 0, 0), 0, 0));
            this.add((Component)this.mc_grouping, new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 17, 0, new Insets(10, 20, 0, 0), 0, 0));
        }

        public void setModel() {
            ArrayList<TriggerEventInfo> selected = new ArrayList<TriggerEventInfo>();
            TriggerEventInfo trigger = TriggeringEventPanel.this.m_objFlow.getTriggerEvent();
            if (trigger != null) {
                if (trigger.getEvent() instanceof GroupingEventInfo) {
                    List triggers = ((GroupingEventInfo)trigger.getEvent()).getDependencies2();
                    for (DisplayInfo di : triggers) {
                        TriggerEventInfo t = null;
                        if (di instanceof TimeEventInfo) {
                            t = new TriggerEventInfo((TimeEventInfo)di, TriggeringEventPanel.this.m_objFlow.getScheduler());
                        } else if (di instanceof FileEventInfo) {
                            t = new TriggerEventInfo((FileEventInfo)di, TriggeringEventPanel.this.m_objFlow.getScheduler());
                        } else if (di instanceof GroupingEventInfo) {
                            t = null;
                        }
                        if (t == null) continue;
                        selected.add(t);
                    }
                } else {
                    selected.add(trigger);
                }
            }
            this.mc_sourceList = new TreeSet(new CompareDisplayInfoObjects());
            this.mc_targetList = new TreeSet(new CompareDisplayInfoObjects());
            ArrayList available = new ArrayList();
            available.addAll(TriggeringEventPanel.this.m_lstEvents);
            if (selected.size() > 0) {
                block1: for (int j = available.size() - 1; j >= 0; --j) {
                    AbstractEventInfo aInfo = ((TriggerEventInfo)available.get(j)).getEvent();
                    for (int i = 0; i < selected.size(); ++i) {
                        AbstractEventInfo sInfo = ((TriggerEventInfo)selected.get(i)).getEvent();
                        if (aInfo == sInfo) {
                            available.remove(j);
                            this.mc_targetList.add((TriggerEventInfo)selected.get(i));
                            continue block1;
                        }
                        if (sInfo == null) continue;
                        if (aInfo.getId() != null && sInfo.getId() != null) {
                            if (aInfo.getId().compareTo(sInfo.getId()) != 0) continue;
                            available.remove(j);
                            this.mc_targetList.add((TriggerEventInfo)selected.get(i));
                            continue block1;
                        }
                        if (aInfo.toString().compareTo(sInfo.toString()) != 0) continue;
                        available.remove(j);
                        this.mc_targetList.add((TriggerEventInfo)selected.get(i));
                        continue block1;
                    }
                }
            }
            this.mc_sourceList.addAll(available);
        }

        @Override
        public boolean validateData() {
            TriggerEventInfo[] selected;
            if (this.mc_eventBtn.isSelected() && (selected = this.mc_dualList.getSelectedValues()).length < 1) {
                MessageUtil.displayMessage(TriggeringEventPanel.this.m_frame, m_bundle.getString("TriggeringEventPanel.NoTrigger.Msg.txt"), m_bundle.getString("TriggeringEventPanel.Title.txt"), 0, -1);
                return false;
            }
            return true;
        }

        @Override
        public boolean moveDataToView() {
            this.mc_sourceModel.setModel(this.mc_sourceList);
            this.mc_targetModel.setModel(this.mc_targetList);
            this.mc_dualList.setModel((ListModel)this.mc_sourceModel);
            this.mc_dualList.setTargetModel((ListModel)this.mc_targetModel);
            this.setDataChanged(false);
            return true;
        }

        @Override
        public boolean moveViewToData() {
            int i;
            TriggerEventInfo[] selected = this.mc_dualList.getSelectedValues();
            if (this.mc_eventBtn.isSelected()) {
                TriggerEventInfo trigger = null;
                if (selected.length == 1) {
                    trigger = selected[0];
                } else if (selected.length > 1) {
                    int type = 0;
                    if (this.mc_grouping.getGroupingType() == 32) {
                        type = 1;
                    }
                    GroupingEventInfo gei = new GroupingEventInfo(null, type);
                    for (i = 0; i < selected.length; ++i) {
                        TriggerEventInfo t = selected[i];
                        gei.addDependency(t.getEvent());
                    }
                    trigger = new TriggerEventInfo(gei, TriggeringEventPanel.this.m_objFlow.getScheduler());
                }
                TriggeringEventPanel.this.m_objFlow.setTriggerEvent(trigger);
            } else if (this.mc_runnowBtn.isSelected()) {
                TriggeringEventPanel.this.m_objFlow.setTriggerType("RunNow");
            } else if (this.mc_manualBtn.isSelected()) {
                TriggeringEventPanel.this.m_objFlow.setTriggerEvent(null);
                TriggeringEventPanel.this.m_objFlow.setTriggerType("Manual");
            }
            TriggerEventInfo[] available = this.mc_dualList.getAvailableValues();
            ArrayList<TriggerEventInfo> events = new ArrayList<TriggerEventInfo>();
            int num = available.length;
            for (i = 0; i < num; ++i) {
                events.add(available[i]);
            }
            num = selected.length;
            for (i = 0; i < num; ++i) {
                events.add(selected[i]);
            }
            TriggeringEventPanel.this.m_objFlow.setTriggerEventList(events);
            return true;
        }

        private class ListSelector
        extends DualListSelector {
            private static final long serialVersionUID = 1L;
            JList mcc_sourceList;
            JList mcc_targetList;

            public ListSelector() {
                String sourceText = m_bundle.getString("TriggeringEventPanel.SourceLabel.txt");
                this.sourceLabel.setText(Util.getLabelWithoutMnemonic((String)sourceText));
                this.sourceLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)sourceText));
                String targetText = m_bundle.getString("TriggeringEventPanel.TargetLabel.txt");
                this.targetLabel.setText(Util.getLabelWithoutMnemonic((String)targetText));
                this.targetLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)targetText));
                this.rightButton.setToolTipText(m_bundle.getString("TriggeringEventPanel.RightButton.ToolTip.txt"));
                this.allRightButton.setToolTipText(m_bundle.getString("TriggeringEventPanel.AllRightButton.ToolTip.txt"));
                this.leftButton.setToolTipText(m_bundle.getString("TriggeringEventPanel.LeftButton.ToolTip.txt"));
                this.allLeftButton.setToolTipText(m_bundle.getString("TriggeringEventPanel.AllLeftButton.ToolTip.txt"));
                this.getSourceComponent().setToolTipText(m_bundle.getString("TriggeringEventPanel.SourceList.ToolTip.txt"));
                this.getTargetComponent().setToolTipText(m_bundle.getString("TriggeringEventPanel.TargetList.ToolTip.txt"));
                this.__initialize();
            }

            public void refresh() {
            }

            public TriggerEventInfo[] getAvailableValues() {
                CollectionToListModelAdapter model = (CollectionToListModelAdapter)this.mcc_sourceList.getModel();
                Object[] temp = model.getModel().toArray();
                int num = temp.length;
                TriggerEventInfo[] triggers = new TriggerEventInfo[num];
                for (int i = 0; i < num; ++i) {
                    triggers[i] = (TriggerEventInfo)temp[i];
                }
                return triggers;
            }

            public TriggerEventInfo[] getSelectedValues() {
                CollectionToListModelAdapter model = (CollectionToListModelAdapter)this.mcc_targetList.getModel();
                Object[] temp = model.getModel().toArray();
                int num = temp.length;
                TriggerEventInfo[] triggers = new TriggerEventInfo[num];
                for (int i = 0; i < num; ++i) {
                    triggers[i] = (TriggerEventInfo)temp[i];
                }
                return triggers;
            }

            public void __initialize() {
                this.mcc_sourceList = (JList)this.getSourceComponent();
                this.mcc_targetList = (JList)this.getTargetComponent();
            }
        }
    }

    public class SingleSelectPanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;
        private TriggerEventInfo mc_objCurrentTriggeringEvent = null;
        private String mc_strCurrentTriggerType = null;
        private JComboBox mc_cmbEvents;

        public SingleSelectPanel() {
            this.__initialize();
        }

        @Override
        public void saveSettingsAndCleanUp() {
            this.mc_objCurrentTriggeringEvent = null;
            this.mc_strCurrentTriggerType = null;
            this.mc_cmbEvents = null;
        }

        public boolean addTriggerEvent(TriggerEventInfo event) {
            if (event.getEvent() instanceof FileEventInfo && !TriggeringEventPanel.this.m_objFlow.getScheduler().isFileEventSupported()) {
                return false;
            }
            this.mc_cmbEvents.addItem(event);
            this.mc_cmbEvents.setSelectedItem(event);
            this.mc_objCurrentTriggeringEvent = event;
            this.mc_strCurrentTriggerType = TriggeringEventPanel.this.m_objFlow.getTriggerType();
            return true;
        }

        public boolean removeTriggerEvent(TriggerEventInfo event) {
            int numItems = this.mc_cmbEvents.getItemCount();
            for (int i = 0; i < numItems; ++i) {
                TriggerEventInfo temp = (TriggerEventInfo)this.mc_cmbEvents.getItemAt(i);
                if (!event.equals((Object)temp)) continue;
                this.mc_cmbEvents.removeItemAt(i);
                break;
            }
            if (this.mc_objCurrentTriggeringEvent != null && this.mc_objCurrentTriggeringEvent.equals((Object)event)) {
                this.mc_objCurrentTriggeringEvent = null;
                this.mc_cmbEvents.setSelectedIndex(0);
            } else {
                this.__setSelectedTrigger();
            }
            return true;
        }

        public void refresh() {
            this.mc_cmbEvents.invalidate();
            this.paintAll(this.mc_cmbEvents.getGraphics());
            this.setDataChanged(true);
        }

        public void reset() {
            this.mc_objCurrentTriggeringEvent = TriggeringEventPanel.this.m_objFlow.getTriggerEvent();
            this.mc_strCurrentTriggerType = TriggeringEventPanel.this.m_objFlow.getTriggerType();
            if (this.mc_objCurrentTriggeringEvent == null) {
                this.mc_strCurrentTriggerType = null;
            }
            this.mc_cmbEvents.removeAllItems();
        }

        private void __initialize() {
            this.mc_cmbEvents = new JComboBox();
            this.mc_cmbEvents.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TriggerEventInfo selectedEvent = (TriggerEventInfo)SingleSelectPanel.this.mc_cmbEvents.getSelectedItem();
                    TriggeringEventPanel.this.m_objFlow.setTriggerEvent(selectedEvent);
                }
            });
            this.mc_objCurrentTriggeringEvent = TriggeringEventPanel.this.m_objFlow.getTriggerEvent();
            this.mc_strCurrentTriggerType = TriggeringEventPanel.this.m_objFlow.getTriggerType();
            if (this.mc_objCurrentTriggeringEvent == null) {
                this.mc_strCurrentTriggerType = null;
            }
            this.setLayout(new GridBagLayout());
            this.mc_cmbEvents.setPreferredSize(new Dimension(450, 21));
            this.add((Component)this.mc_cmbEvents, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void __setSelectedTrigger() {
            if (null == this.mc_strCurrentTriggerType && null == this.mc_objCurrentTriggeringEvent) {
                this.mc_strCurrentTriggerType = "RunNow";
                this.mc_cmbEvents.setSelectedIndex(0);
            } else {
                this.mc_cmbEvents.setSelectedIndex(0);
                int numItems = this.mc_cmbEvents.getItemCount();
                for (int i = 0; i < numItems; ++i) {
                    TriggerEventInfo event = (TriggerEventInfo)this.mc_cmbEvents.getItemAt(i);
                    if (!event.equals((Object)this.mc_objCurrentTriggeringEvent)) continue;
                    this.mc_cmbEvents.setSelectedIndex(i);
                    break;
                }
            }
        }

        @Override
        public boolean moveViewToData() {
            TriggerEventInfo selectedEvent = (TriggerEventInfo)this.mc_cmbEvents.getSelectedItem();
            TriggeringEventPanel.this.m_objFlow.setTriggerEvent(selectedEvent);
            return true;
        }

        @Override
        public boolean moveDataToView() {
            for (TriggerEventInfo event : TriggeringEventPanel.this.m_lstEvents) {
                this.mc_cmbEvents.addItem(event);
            }
            this.__setSelectedTrigger();
            this.setDataChanged(false);
            return true;
        }
    }
}

