/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import com.sas.scheduler.visuals.swing.FileEventDialog;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.TimeEventDialog;
import com.sas.scheduler.visuals.swing.TimeEventInterface;
import com.sas.scheduler.visuals.swing.TriggerOptionsPanel;
import com.sas.scheduler.visuals.swing.TriggeringEventPanel;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class TriggerEventDialog
extends StandardDialog {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private TriggeringEventPanel m_triggerEventPanel = null;
    private PromptCallbackInterface m_prompt;
    private TimeEventInterface m_timeEventDialog = null;
    private NumberFormat m_nf = NumberFormat.getInstance();
    private int m_nextID = 1;
    private HashMap<String, String> m_ids = new HashMap();

    public TriggerEventDialog(Frame frame, FlowInfo info, String title, PromptCallbackInterface prompt) {
        super(frame, title, true);
        this.m_prompt = prompt;
        this.m_triggerEventPanel = new TriggeringEventPanel(info, frame);
        this.m_triggerEventPanel.addTriggerListener(new cActionListener(frame, info));
        this.setMainPanel(this.m_triggerEventPanel);
        this.setHelpProduct("scheduler");
        this.setHelpTopic("window_scheduleflow");
    }

    public boolean setTimeEventDialog(TimeEventInterface dialog) {
        this.m_timeEventDialog = dialog;
        return true;
    }

    private String genId(String key) {
        String id = this.m_ids.get(key);
        if (id == null) {
            id = this.m_nf.format(this.m_nextID++);
            while (this.m_ids.containsValue(id)) {
                id = this.m_nf.format(this.m_nextID++);
            }
            this.m_ids.put(key, id);
        }
        return id;
    }

    static {
        String strClassName = TimeEventDialog.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    private class cActionListener
    implements ActionListener {
        TriggerOptionsPanel mc_panel = null;
        FlowInfo mc_finfo = null;
        Frame mc_frame = null;
        SchedulerServerInfo mc_schinfo = null;

        public cActionListener(Frame frame, FlowInfo info) {
            this.mc_frame = frame;
            this.mc_finfo = info;
            this.mc_schinfo = info.getScheduler();
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            TriggerEventInfo orig_trigger = this.mc_finfo.getTriggerEvent();
            ArrayList orig_triggers = new ArrayList();
            orig_triggers.addAll(this.mc_finfo.getFlowTriggerEvents());
            this.mc_frame.setCursor(Cursor.getPredefinedCursor(3));
            StandardDialog dlg = new StandardDialog(this.mc_frame, m_bundle.getString("TriggerEventDialog.TriggerOption.Title.txt"), true);
            this.mc_panel = new TriggerOptionsPanel(this.mc_finfo);
            this.mc_panel.addNewTimeEventListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeEventInterface dlg2;
                    if (TriggerEventDialog.this.m_timeEventDialog != null) {
                        dlg2 = TriggerEventDialog.this.m_timeEventDialog.getInstance(new TimeEventInfo());
                        dlg2.setTitle(m_bundle.getString("TriggerEventDialog.NewTimeDep.txt"));
                    } else {
                        dlg2 = new TimeEventDialog(cActionListener.this.mc_frame, m_bundle.getString("TriggerEventDialog.NewTimeDep.txt"), new TimeEventInfo());
                    }
                    dlg2.makeVisible();
                    if (1 == dlg2.getReturnValue()) {
                        TimeEventInfo tei = dlg2.getTimeEvent();
                        TriggerEventInfo trigger = new TriggerEventInfo(tei, cActionListener.this.mc_schinfo);
                        trigger.setId(TriggerEventDialog.this.genId(tei.toString()));
                        cActionListener.this.mc_finfo.addTriggerEventList(trigger);
                        TriggerEventInfo[] selected = TriggerEventDialog.this.m_triggerEventPanel.getSelectedEvents();
                        if (selected == null) {
                            cActionListener.this.mc_finfo.setActiveTriggerDataBinding(trigger);
                        } else if (selected.length >= 1) {
                            GroupingEventInfo gei = new GroupingEventInfo(null, 0);
                            for (int i = 0; i < selected.length; ++i) {
                                TriggerEventInfo t = selected[i];
                                gei.addDependency(t.getEvent());
                            }
                            gei.addDependency(trigger.getEvent());
                            TriggerEventInfo active = new TriggerEventInfo(gei, cActionListener.this.mc_finfo.getScheduler());
                            cActionListener.this.mc_finfo.setActiveTriggerDataBinding(active);
                        } else {
                            cActionListener.this.mc_finfo.setActiveTriggerDataBinding(trigger);
                        }
                        cActionListener.this.mc_panel.updateTriggerEventList(cActionListener.this.mc_finfo);
                        cActionListener.this.mc_panel.setSelected(trigger);
                        TriggerEventDialog.this.m_triggerEventPanel.addTriggerEvent(trigger);
                    }
                }
            });
            this.mc_panel.addNewFileEventListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileEventInfo temp = new FileEventInfo();
                    temp.setScheduler(cActionListener.this.mc_schinfo);
                    FileEventDialog dlg2 = new FileEventDialog(cActionListener.this.mc_frame, m_bundle.getString("TriggerEventDialog.NewFileDep.txt"), temp, TriggerEventDialog.this.m_prompt);
                    dlg2.makeVisible();
                    if (1 == dlg2.getReturnValue()) {
                        FileEventInfo fei = dlg2.getFileEvent();
                        TriggerEventInfo trigger = new TriggerEventInfo(fei, cActionListener.this.mc_schinfo);
                        trigger.setId(TriggerEventDialog.this.genId(fei.toString()));
                        cActionListener.this.mc_finfo.addTriggerEventList(trigger);
                        TriggerEventInfo[] selected = TriggerEventDialog.this.m_triggerEventPanel.getSelectedEvents();
                        if (selected == null) {
                            cActionListener.this.mc_finfo.setActiveTriggerDataBinding(trigger);
                        } else if (selected.length >= 1) {
                            GroupingEventInfo gei = new GroupingEventInfo(null, 0);
                            for (int i = 0; i < selected.length; ++i) {
                                TriggerEventInfo t = selected[i];
                                gei.addDependency(t.getEvent());
                            }
                            gei.addDependency(trigger.getEvent());
                            TriggerEventInfo active = new TriggerEventInfo(gei, cActionListener.this.mc_finfo.getScheduler());
                            cActionListener.this.mc_finfo.setActiveTriggerDataBinding(active);
                        } else {
                            cActionListener.this.mc_finfo.setActiveTriggerDataBinding(trigger);
                        }
                        cActionListener.this.mc_panel.updateTriggerEventList(cActionListener.this.mc_finfo);
                        cActionListener.this.mc_panel.setSelected(trigger);
                        TriggerEventDialog.this.m_triggerEventPanel.addTriggerEvent(trigger);
                    }
                }
            });
            this.mc_panel.addEditEventListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object dlg2;
                    TriggerEventInfo trigger = cActionListener.this.mc_panel.getSelected();
                    if (trigger == null) {
                        MessageUtil.displayMessage(cActionListener.this.mc_frame, m_bundle.getString("TriggerEventDialog.Edit.NoTriggerSelected.txt"), m_bundle.getString("TriggerEventDialog.Schedule.Title.txt"), 2);
                        return;
                    }
                    boolean okay = false;
                    if (trigger.getType().compareTo("FileEvent") == 0) {
                        FileEventInfo fei = (FileEventInfo)trigger.getEvent();
                        dlg2 = new FileEventDialog(cActionListener.this.mc_frame, m_bundle.getString("TriggerEventDialog.EditFileDep.txt"), fei, TriggerEventDialog.this.m_prompt);
                        ((StandardDialog)dlg2).makeVisible();
                        if (1 == ((StandardDialog)dlg2).getReturnValue()) {
                            fei = ((FileEventDialog)dlg2).getFileEvent();
                            trigger.setEvent((DisplayInfo)fei);
                            okay = true;
                        }
                    } else {
                        TimeEventInfo tei = (TimeEventInfo)trigger.getEvent();
                        if (TriggerEventDialog.this.m_timeEventDialog != null) {
                            dlg2 = TriggerEventDialog.this.m_timeEventDialog.getInstance(tei);
                            dlg2.setTitle(m_bundle.getString("TriggerEventDialog.EditTimeDep.txt"));
                            dlg2.setTimeEvent(tei);
                        } else {
                            dlg2 = new TimeEventDialog(cActionListener.this.mc_frame, m_bundle.getString("TriggerEventDialog.EditTimeDep.txt"), tei);
                        }
                        dlg2.makeVisible();
                        if (1 == dlg2.getReturnValue()) {
                            tei = dlg2.getTimeEvent();
                            trigger.setEvent((DisplayInfo)tei);
                            okay = true;
                        }
                    }
                    if (okay) {
                        cActionListener.this.mc_finfo.updateTriggerEventList(trigger);
                        TriggerEventInfo[] selected = TriggerEventDialog.this.m_triggerEventPanel.getSelectedEvents();
                        if (selected == null) {
                            cActionListener.this.mc_finfo.setActiveTriggerDataBinding(trigger);
                        } else if (selected.length >= 2) {
                            GroupingEventInfo gei = new GroupingEventInfo(null, 0);
                            for (int i = 0; i < selected.length; ++i) {
                                TriggerEventInfo t = selected[i];
                                gei.addDependency(t.getEvent());
                            }
                            gei.addDependency(trigger.getEvent());
                            TriggerEventInfo active = new TriggerEventInfo(gei, cActionListener.this.mc_finfo.getScheduler());
                            cActionListener.this.mc_finfo.setActiveTriggerDataBinding(active);
                        } else if (selected.length == 1) {
                            cActionListener.this.mc_finfo.setActiveTriggerDataBinding(trigger);
                        }
                        cActionListener.this.mc_panel.updateTriggerEventList(cActionListener.this.mc_finfo);
                        cActionListener.this.mc_panel.setSelected(trigger);
                        TriggerEventDialog.this.m_triggerEventPanel.refresh();
                    }
                }
            });
            this.mc_panel.addDeleteEventListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TriggerEventInfo tei = cActionListener.this.mc_panel.getSelected();
                    if (tei == null) {
                        return;
                    }
                    cActionListener.this.mc_finfo.removeTriggerEventList(tei);
                    TriggerEventInfo[] selected = TriggerEventDialog.this.m_triggerEventPanel.getSelectedEvents();
                    if (selected != null) {
                        if (selected.length >= 2) {
                            GroupingEventInfo gei = new GroupingEventInfo(null, 0);
                            for (int i = 0; i < selected.length; ++i) {
                                TriggerEventInfo t = selected[i];
                                gei.addDependency(t.getEvent());
                            }
                            TriggerEventInfo active = new TriggerEventInfo(gei, cActionListener.this.mc_finfo.getScheduler());
                            cActionListener.this.mc_finfo.setActiveTriggerDataBinding(active);
                        } else if (selected.length == 1) {
                            cActionListener.this.mc_finfo.setActiveTriggerDataBinding(selected[0]);
                        }
                    }
                    cActionListener.this.mc_panel.updateTriggerEventList(cActionListener.this.mc_finfo);
                    TriggerEventDialog.this.m_triggerEventPanel.removeTriggerEvent(tei);
                }
            });
            this.mc_frame.setCursor(Cursor.getPredefinedCursor(0));
            dlg.setMainPanel(this.mc_panel);
            dlg.setHelpProduct("scheduler");
            dlg.setHelpTopic("window_triggeroptions");
            dlg.makeVisible();
            if (dlg.getReturnValue() == 2) {
                this.mc_finfo.setTriggerEvent(orig_trigger);
                this.mc_finfo.setTriggerEventList(orig_triggers);
                TriggerEventDialog.this.m_triggerEventPanel.reset(this.mc_finfo);
            }
        }
    }
}

