/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.AbstractRecurrence;
import com.sas.scheduler.model.DailyRecurrence;
import com.sas.scheduler.model.DateList;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.InvalidRecurrenceException;
import com.sas.scheduler.model.MonthlyRecurrence;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.Timezone;
import com.sas.scheduler.model.WeeklyRecurrence;
import com.sas.scheduler.model.YearlyRecurrence;
import com.sas.scheduler.visuals.swing.DateRangePanel;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.scheduler.visuals.swing.TimeHourMinutePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class TimeEventPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private TimeEventInfo m_timeEventInfo;
    private final String m_recurrenceNone = m_bundle.getString("TimeEventPanel.recurrenceNoneLabel.txt");
    private final String m_recurrenceHourly = m_bundle.getString("TimeEventPanel.recurrenceHourlyLabel.txt");
    private final String m_recurrenceDaily = m_bundle.getString("TimeEventPanel.recurrenceDailyLabel.txt");
    private final String m_recurrenceWeekly = m_bundle.getString("TimeEventPanel.recurrenceWeeklyLabel.txt");
    private final String m_recurrenceMonthly = m_bundle.getString("TimeEventPanel.recurrenceMonthlyLabel.txt");
    private final String m_recurrenceYearly = m_bundle.getString("TimeEventPanel.recurrenceYearlyLabel.txt");
    private final int PreferredWidth = Integer.valueOf(m_bundle.getString("TimeEventPanel.PreferredSize.Width.txt"));
    private final int PreferredHeight = Integer.valueOf(m_bundle.getString("TimeEventPanel.PreferredSize.Height.txt"));
    private static final String LISTSEPARATORTOKENS = ",; ";
    private Calendar m_currentDate;
    private int m_currentHour = 0;
    private int m_currentMinute = 0;
    private String m_currentTimezone = null;
    private NumberFormat m_nf_minutes;
    private JLabel m_recurrenceLabel;
    private JComboBox m_recurrenceComboBox;
    private dateListPanel m_dateListPanel;
    private hourlyPanel m_hourlyPanel;
    private dailyPanel m_dailyPanel;
    private weeklyPanel m_weeklyPanel;
    private monthlyPanel m_monthlyPanel;
    private yearlyPanel m_yearlyPanel;
    private boolean m_endTimeSupported = false;
    private boolean m_timezoneSupported = false;
    private boolean m_limitSkipsSupported = false;
    private String m_errorMsg;
    private boolean m_recurrenceEnabled;
    private Frame m_frame;

    public TimeEventPanel(Frame frame) {
        this(frame, null, true);
    }

    public TimeEventPanel(Frame frame, boolean endTime) {
        this(frame, null, endTime);
    }

    public TimeEventPanel(Frame frame, TimeEventInfo event) {
        this(frame, event, true);
    }

    protected TimeEventPanel(Frame frame, TimeEventInfo event, boolean endTime) {
        this(frame, event, endTime, false);
    }

    protected TimeEventPanel(Frame frame, TimeEventInfo event, boolean endTime, boolean showTimezone) {
        this(frame, event, endTime, false, false);
    }

    protected TimeEventPanel(Frame frame, TimeEventInfo event, boolean endTime, boolean showTimezone, boolean limitSkips) {
        this.m_endTimeSupported = endTime;
        this.m_timezoneSupported = showTimezone;
        this.m_limitSkipsSupported = limitSkips;
        this.m_errorMsg = null;
        this.m_frame = frame;
        this.initialize();
        this.setRecurrenceEnabled(true);
        this.m_nf_minutes = NumberFormat.getInstance();
        this.m_nf_minutes.setMaximumIntegerDigits(2);
        this.m_nf_minutes.setMinimumIntegerDigits(2);
        this.m_nf_minutes.setGroupingUsed(false);
        this.setEvent(event);
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_recurrenceLabel = null;
        this.m_recurrenceComboBox = null;
        this.m_dateListPanel = null;
        this.m_hourlyPanel = null;
        this.m_dailyPanel = null;
        this.m_weeklyPanel = null;
        this.m_monthlyPanel = null;
        this.m_yearlyPanel = null;
        this.m_errorMsg = null;
        this.m_frame = null;
    }

    public TimeEventInfo getEvent() {
        return this.m_timeEventInfo;
    }

    public void setEvent(TimeEventInfo event) {
        this.m_timeEventInfo = event;
        if (this.m_timeEventInfo != null) {
            this.setInfo(this.m_timeEventInfo);
        }
    }

    public String getErrorMessage() {
        return this.m_errorMsg;
    }

    public void setEditable(boolean editable) {
    }

    public void setRecurrenceEnabled(boolean enabled) {
        this.m_recurrenceEnabled = enabled;
    }

    public boolean getRecurrenceEnabled() {
        return this.m_recurrenceEnabled;
    }

    public void setValues() {
        if (this.m_timeEventInfo == null) {
            return;
        }
        this.setInfo(this.m_timeEventInfo);
    }

    public TimeEventInfo getValues() throws InvalidRecurrenceException {
        TimeEventInfo teInfo = new TimeEventInfo();
        return this.getInfo(teInfo);
    }

    @Override
    public boolean onParentOK() {
        this.validateData();
        if (this.m_errorMsg != null && this.m_errorMsg.length() > 0) {
            JOptionPane.showMessageDialog(this, this.m_errorMsg, m_bundle.getString("TimeEventDialog.title.txt"), 0);
            return false;
        }
        return true;
    }

    @Override
    public boolean onParentCancel() {
        return true;
    }

    @Override
    public boolean validateData() {
        this.m_errorMsg = null;
        try {
            if (this.m_timeEventInfo == null) {
                this.m_timeEventInfo = new TimeEventInfo();
            }
            this.getInfo(this.m_timeEventInfo);
        }
        catch (InvalidRecurrenceException e) {
            this.m_errorMsg = e.getLocalizedMessage();
            return false;
        }
        return this.m_errorMsg == null;
    }

    @Override
    public boolean moveDataToView() {
        if (this.m_timeEventInfo != null) {
            this.setInfo(this.m_timeEventInfo);
        }
        return true;
    }

    private void initialize() {
        this.m_currentDate = new GregorianCalendar(Locale.getDefault());
        this.m_currentHour = this.m_currentDate.get(11);
        this.m_currentMinute = this.m_currentDate.get(12);
        this.m_currentTimezone = this.m_timezoneSupported ? Timezone.getID((Calendar)this.m_currentDate) : null;
        this.m_recurrenceLabel = new JLabel(m_bundle.getString("TimeEventPanel.recurrenceLabel.txt"));
        this.m_recurrenceComboBox = new JComboBox();
        this.m_recurrenceComboBox.addItem(this.m_recurrenceNone);
        this.m_recurrenceComboBox.addItem(this.m_recurrenceHourly);
        this.m_recurrenceComboBox.addItem(this.m_recurrenceDaily);
        this.m_recurrenceComboBox.addItem(this.m_recurrenceWeekly);
        this.m_recurrenceComboBox.addItem(this.m_recurrenceMonthly);
        this.m_recurrenceComboBox.addItem(this.m_recurrenceYearly);
        this.m_recurrenceLabel.setLabelFor(this.m_recurrenceComboBox);
        this.m_recurrenceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TimeEventPanel.this.updateRecurrenceType();
                }
                catch (RuntimeException ex) {
                    String message = ex.getLocalizedMessage();
                    if (message == null || message.length() == 0) {
                        message = ex.toString();
                    }
                    MessageUtil.displayMessage(TimeEventPanel.this.m_frame, message, m_bundle.getString("Common.TimeEvent.ErrorMsg.Title.txt"), 0, -1);
                }
            }
        });
        this.m_dateListPanel = new dateListPanel(this.m_frame);
        this.m_hourlyPanel = new hourlyPanel(this.m_frame, this.m_endTimeSupported);
        this.m_dailyPanel = new dailyPanel(this.m_frame, this.m_endTimeSupported);
        this.m_weeklyPanel = new weeklyPanel(this.m_frame, this.m_endTimeSupported);
        this.m_monthlyPanel = new monthlyPanel(this.m_frame, this.m_endTimeSupported);
        this.m_yearlyPanel = new yearlyPanel(this.m_frame, this.m_endTimeSupported);
        GridBagConstraints gbc_recurrenceLabel = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_recurrenceComboBox = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 120, 0, 5), 0, 0);
        GridBagConstraints gbc_filler = new GridBagConstraints(2, 0, 2, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_panels = new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(7, 0, 0, 5), 0, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_recurrenceLabel, gbc_recurrenceLabel);
        this.add((Component)this.m_recurrenceComboBox, gbc_recurrenceComboBox);
        this.add((Component)new JLabel(), gbc_filler);
        this.add((Component)this.m_dateListPanel, gbc_panels);
        this.add((Component)this.m_hourlyPanel, gbc_panels);
        this.add((Component)this.m_dailyPanel, gbc_panels);
        this.add((Component)this.m_weeklyPanel, gbc_panels);
        this.add((Component)this.m_monthlyPanel, gbc_panels);
        this.add((Component)this.m_yearlyPanel, gbc_panels);
        this.m_recurrenceComboBox.setSelectedItem(this.m_recurrenceNone);
    }

    private TimeEventInfo getInfo(TimeEventInfo teInfo) throws InvalidRecurrenceException {
        String item = (String)this.m_recurrenceComboBox.getSelectedItem();
        if (item.equals(this.m_recurrenceNone)) {
            teInfo = this.m_dateListPanel.getInfo(teInfo);
        } else if (item.equals(this.m_recurrenceHourly)) {
            teInfo = this.m_hourlyPanel.getInfo(teInfo);
        } else if (item.equals(this.m_recurrenceDaily)) {
            teInfo = this.m_dailyPanel.getInfo(teInfo);
        } else if (item.equals(this.m_recurrenceWeekly)) {
            teInfo = this.m_weeklyPanel.getInfo(teInfo);
        } else if (item.equals(this.m_recurrenceMonthly)) {
            teInfo = this.m_monthlyPanel.getInfo(teInfo);
        } else if (item.equals(this.m_recurrenceYearly)) {
            teInfo = this.m_yearlyPanel.getInfo(teInfo);
        }
        IRecurrenceInfo info = teInfo.getRecurrence();
        if (info != null && info instanceof AbstractRecurrence) {
            Calendar endDate = ((AbstractRecurrence)info).getEndDate();
            Calendar startDate = ((AbstractRecurrence)info).getStartDate();
            List nextDate = ((AbstractRecurrence)info).getNextDates(startDate, endDate, 1);
            if (endDate != null) {
                if (this.m_currentDate.after(endDate)) {
                    this.m_errorMsg = m_bundle.getString("TimeEventPanel.errorPastDate.txt");
                } else if (startDate != null && startDate.after(endDate)) {
                    this.m_errorMsg = m_bundle.getString("TimeEventPanel.errorStartPastEndDate.txt");
                } else if (nextDate.size() == 0) {
                    this.m_errorMsg = m_bundle.getString("TimeEventPanel.errorNoDateInTimeLine.txt");
                }
            }
        }
        return teInfo;
    }

    private void setInfo(TimeEventInfo info) {
        IRecurrenceInfo recurrence = this.m_timeEventInfo.getRecurrence();
        if (recurrence instanceof DateList) {
            this.m_recurrenceComboBox.setSelectedItem(this.m_recurrenceNone);
            this.m_dateListPanel.setInfo(info);
        } else if (recurrence instanceof DailyRecurrence) {
            String startHours = this.m_timeEventInfo.getHours();
            if (startHours.indexOf(44) != -1 || startHours.indexOf(59) != -1) {
                this.m_recurrenceComboBox.setSelectedItem(this.m_recurrenceHourly);
                this.m_hourlyPanel.setInfo(info);
            } else {
                this.m_recurrenceComboBox.setSelectedItem(this.m_recurrenceDaily);
                this.m_dailyPanel.setInfo(info);
            }
        } else if (recurrence instanceof WeeklyRecurrence) {
            this.m_recurrenceComboBox.setSelectedItem(this.m_recurrenceWeekly);
            this.m_weeklyPanel.setInfo(info);
        } else if (recurrence instanceof MonthlyRecurrence) {
            this.m_recurrenceComboBox.setSelectedItem(this.m_recurrenceMonthly);
            this.m_monthlyPanel.setInfo(info);
        } else if (recurrence instanceof YearlyRecurrence) {
            this.m_recurrenceComboBox.setSelectedItem(this.m_recurrenceYearly);
            this.m_yearlyPanel.setInfo(info);
        }
        this.updateRecurrenceType();
    }

    private void updateRecurrenceType() {
        String selected = (String)this.m_recurrenceComboBox.getSelectedItem();
        if (selected.equals(this.m_recurrenceNone)) {
            this.m_dateListPanel.setVisible(true);
            this.m_hourlyPanel.setVisible(false);
            this.m_dailyPanel.setVisible(false);
            this.m_weeklyPanel.setVisible(false);
            this.m_monthlyPanel.setVisible(false);
            this.m_yearlyPanel.setVisible(false);
        } else if (selected.equals(this.m_recurrenceHourly)) {
            this.m_dateListPanel.setVisible(false);
            this.m_hourlyPanel.setVisible(true);
            this.m_dailyPanel.setVisible(false);
            this.m_weeklyPanel.setVisible(false);
            this.m_monthlyPanel.setVisible(false);
            this.m_yearlyPanel.setVisible(false);
        } else if (selected.equals(this.m_recurrenceDaily)) {
            this.m_dateListPanel.setVisible(false);
            this.m_hourlyPanel.setVisible(false);
            this.m_dailyPanel.setVisible(true);
            this.m_weeklyPanel.setVisible(false);
            this.m_monthlyPanel.setVisible(false);
            this.m_yearlyPanel.setVisible(false);
        } else if (selected.equals(this.m_recurrenceWeekly)) {
            this.m_dateListPanel.setVisible(false);
            this.m_hourlyPanel.setVisible(false);
            this.m_dailyPanel.setVisible(false);
            this.m_weeklyPanel.setVisible(true);
            this.m_monthlyPanel.setVisible(false);
            this.m_yearlyPanel.setVisible(false);
        } else if (selected.equals(this.m_recurrenceMonthly)) {
            this.m_dateListPanel.setVisible(false);
            this.m_hourlyPanel.setVisible(false);
            this.m_dailyPanel.setVisible(false);
            this.m_weeklyPanel.setVisible(false);
            this.m_monthlyPanel.setVisible(true);
            this.m_yearlyPanel.setVisible(false);
        } else if (selected.equals(this.m_recurrenceYearly)) {
            this.m_dateListPanel.setVisible(false);
            this.m_hourlyPanel.setVisible(false);
            this.m_dailyPanel.setVisible(false);
            this.m_weeklyPanel.setVisible(false);
            this.m_monthlyPanel.setVisible(false);
            this.m_yearlyPanel.setVisible(true);
        }
        this.invalidate();
    }

    static {
        String strClassName = TimeEventPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    private class dateListPanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;
        private Frame mc_frame;
        private TimeHourMinutePanel mc_hourminutepanel;
        private DateRangePanel mc_datepanel;

        public dateListPanel(Frame frame) {
            this.mc_frame = frame;
            this.__initialize();
        }

        private void __initialize() {
            int minute = TimeEventPanel.this.m_currentMinute + 5;
            int hour = minute > 59 ? TimeEventPanel.this.m_currentHour + 1 : TimeEventPanel.this.m_currentHour;
            this.mc_hourminutepanel = new TimeHourMinutePanel(hour, minute, 1, TimeEventPanel.this.m_currentTimezone);
            this.mc_datepanel = new DateRangePanel(this.mc_frame, false, false);
            GridBagConstraints gbc_time = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_range = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_filler = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 5), 0, 0);
            this.setPreferredSize(new Dimension(TimeEventPanel.this.PreferredWidth, TimeEventPanel.this.PreferredHeight));
            this.setLayout(new GridBagLayout());
            this.add((Component)this.mc_hourminutepanel, gbc_time);
            this.add((Component)this.mc_datepanel, gbc_range);
            this.add((Component)new StandardPanel(), gbc_filler);
        }

        public TimeEventInfo getInfo(TimeEventInfo timeevent) {
            int hour = this.mc_hourminutepanel.getHour();
            int minute = this.mc_hourminutepanel.getMinutes();
            timeevent.setHours(String.valueOf(hour));
            timeevent.setMinutes(TimeEventPanel.this.m_nf_minutes.format(minute));
            timeevent.setTimezoneId(this.mc_hourminutepanel.getTimezone());
            DateList dateList = new DateList();
            Calendar start = this.mc_datepanel.getStartDate();
            GregorianCalendar end = new GregorianCalendar(start.get(1), start.get(2), start.get(5), 23, 59);
            GregorianCalendar calendar = new GregorianCalendar(start.get(1), start.get(2), start.get(5), hour, minute);
            dateList.addDate((Calendar)calendar);
            start.set(11, 0);
            start.set(12, 0);
            dateList.setStartDate(start);
            dateList.setEndDate((Calendar)end);
            timeevent.setRecurrence((IRecurrenceInfo)dateList);
            if (TimeEventPanel.this.m_currentDate.after(calendar)) {
                TimeEventPanel.this.m_errorMsg = m_bundle.getString("TimeEventPanel.errorPastDate.txt");
            }
            return timeevent;
        }

        public void setInfo(TimeEventInfo info) {
            List dl;
            DateList recurrence = null;
            if (info.getRecurrence() instanceof DateList) {
                recurrence = (DateList)info.getRecurrence();
            }
            if (recurrence == null) {
                return;
            }
            String startHours = info.getHours();
            StringTokenizer st = new StringTokenizer(startHours, TimeEventPanel.LISTSEPARATORTOKENS);
            if (st.hasMoreTokens()) {
                int hour1 = Integer.parseInt(st.nextToken());
                this.mc_hourminutepanel.setHour(hour1);
            }
            this.mc_hourminutepanel.setMinute(Integer.parseInt(info.getMinutes()));
            String timezone = info.getTimezoneId();
            if (timezone != null) {
                this.mc_hourminutepanel.setTimezone(timezone);
            }
            if (((AbstractRecurrence)info.getRecurrence()).getStartDate() == null) {
                dl = ((DateList)info.getRecurrence()).getDatesToRun();
                this.mc_datepanel.setStartDate((Calendar)dl.get(0));
            } else {
                this.mc_datepanel.setStartDate(((AbstractRecurrence)info.getRecurrence()).getStartDate());
            }
            if (((AbstractRecurrence)info.getRecurrence()).getEndDate() == null) {
                dl = ((DateList)info.getRecurrence()).getDatesToRun();
                int last = dl.size() - 1;
                this.mc_datepanel.setEndDate((Calendar)dl.get(last));
            } else {
                this.mc_datepanel.setEndDate(((AbstractRecurrence)info.getRecurrence()).getEndDate());
            }
        }
    }

    private class hourlyPanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;
        private Frame mc_frame;
        private boolean mc_endTimeSupported;
        private JComboBox mc_recurEveryComboBox = new JComboBox();
        private TimeHourMinutePanel mc_hourminutepanel;
        private DateRangePanel mc_datepanel;

        public hourlyPanel(Frame frame, boolean showEndTime) {
            this.mc_frame = frame;
            this.mc_endTimeSupported = showEndTime;
            this.__initialize();
        }

        public TimeEventInfo getInfo(TimeEventInfo timeevent) {
            DailyRecurrence dailyRecurrence = new DailyRecurrence();
            int timeHours = this.mc_hourminutepanel.getHour();
            int lastHour = 0;
            switch (this.mc_recurEveryComboBox.getSelectedIndex()) {
                case 0: {
                    timeevent.setHours(this.getHourSequence(timeHours, 1));
                    lastHour = 23;
                    dailyRecurrence.setHourly(1, timeHours);
                    break;
                }
                case 1: {
                    timeevent.setHours(this.getHourSequence(timeHours, 2));
                    lastHour = 22 + timeHours;
                    dailyRecurrence.setHourly(2, timeHours);
                    break;
                }
                case 2: {
                    timeevent.setHours(this.getHourSequence(timeHours, 3));
                    lastHour = 21 + timeHours;
                    dailyRecurrence.setHourly(3, timeHours);
                    break;
                }
                case 3: {
                    timeevent.setHours(this.getHourSequence(timeHours, 4));
                    lastHour = 20 + timeHours;
                    dailyRecurrence.setHourly(4, timeHours);
                    break;
                }
                case 4: {
                    timeevent.setHours(this.getHourSequence(timeHours, 6));
                    lastHour = 18 + timeHours;
                    dailyRecurrence.setHourly(6, timeHours);
                    break;
                }
                case 5: {
                    timeevent.setHours(this.getHourSequence(timeHours, 8));
                    lastHour = 16 + timeHours;
                    dailyRecurrence.setHourly(8, timeHours);
                    break;
                }
                case 6: {
                    timeevent.setHours(this.getHourSequence(timeHours, 12));
                    lastHour = 12 + timeHours;
                    dailyRecurrence.setHourly(12, timeHours);
                }
            }
            int minute = this.mc_hourminutepanel.getMinutes();
            timeevent.setMinutes(TimeEventPanel.this.m_nf_minutes.format(minute));
            timeevent.setTimezoneId(this.mc_hourminutepanel.getTimezone());
            Calendar start = this.mc_datepanel.getStartDate();
            dailyRecurrence.setStartDate(start);
            Calendar end = this.mc_datepanel.getEndDate();
            dailyRecurrence.setEndDate(end);
            if (end != null) {
                List nextDate = dailyRecurrence.getNextDates(start, end, 0);
                boolean past = true;
                Iterator i = nextDate.iterator();
                while (past && i.hasNext()) {
                    Calendar cal = (Calendar)i.next();
                    cal.set(11, lastHour);
                    cal.set(12, minute);
                    if (!cal.after(TimeEventPanel.this.m_currentDate)) continue;
                    past = false;
                }
                if (past) {
                    TimeEventPanel.this.m_errorMsg = m_bundle.getString("TimeEventPanel.errorPastDate.txt");
                }
            }
            timeevent.setRecurrence((IRecurrenceInfo)dailyRecurrence);
            return timeevent;
        }

        public void setInfo(TimeEventInfo info) {
            DailyRecurrence recurrence = null;
            if (info.getRecurrence() instanceof DailyRecurrence) {
                recurrence = (DailyRecurrence)info.getRecurrence();
            }
            if (recurrence == null) {
                return;
            }
            String startHours = info.getHours();
            StringTokenizer st = new StringTokenizer(startHours, TimeEventPanel.LISTSEPARATORTOKENS);
            if (st.hasMoreTokens()) {
                int hour1 = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    int hour2 = Integer.parseInt(st.nextToken());
                    int spacing = hour2 - hour1;
                    this.mc_hourminutepanel.setHourLimit(spacing);
                    this.mc_hourminutepanel.setHour(hour1);
                    switch (spacing) {
                        case 1: {
                            this.mc_recurEveryComboBox.setSelectedIndex(0);
                            break;
                        }
                        case 2: {
                            this.mc_recurEveryComboBox.setSelectedIndex(1);
                            break;
                        }
                        case 3: {
                            this.mc_recurEveryComboBox.setSelectedIndex(2);
                            break;
                        }
                        case 4: {
                            this.mc_recurEveryComboBox.setSelectedIndex(3);
                            break;
                        }
                        case 6: {
                            this.mc_recurEveryComboBox.setSelectedIndex(4);
                            break;
                        }
                        case 8: {
                            this.mc_recurEveryComboBox.setSelectedIndex(5);
                            break;
                        }
                        case 12: {
                            this.mc_recurEveryComboBox.setSelectedIndex(6);
                        }
                    }
                }
            }
            this.mc_hourminutepanel.setMinute(Integer.parseInt(info.getMinutes()));
            String timezone = info.getTimezoneId();
            if (timezone != null) {
                this.mc_hourminutepanel.setTimezone(timezone);
            }
            this.mc_datepanel.setStartDate(((AbstractRecurrence)info.getRecurrence()).getStartDate());
            this.mc_datepanel.setEndDate(((AbstractRecurrence)info.getRecurrence()).getEndDate());
        }

        private void __initialize() {
            JPanel panel = new JPanel();
            TitledBorder border = new TitledBorder(m_bundle.getString("TimeEventPanel.HourlyPanel.IntervalBorderTitle.txt"));
            panel.setBorder(border);
            JLabel label = new JLabel(m_bundle.getString("TimeEventPanel.HourlyPanel.IntervalLabel.txt"));
            this.mc_recurEveryComboBox.addItem(m_bundle.getString("TimeEventPanel.HourlyPanel.recurEveryOne.txt"));
            this.mc_recurEveryComboBox.addItem(m_bundle.getString("TimeEventPanel.HourlyPanel.recurEveryTwo.txt"));
            this.mc_recurEveryComboBox.addItem(m_bundle.getString("TimeEventPanel.HourlyPanel.recurEveryThree.txt"));
            this.mc_recurEveryComboBox.addItem(m_bundle.getString("TimeEventPanel.HourlyPanel.recurEveryFour.txt"));
            this.mc_recurEveryComboBox.addItem(m_bundle.getString("TimeEventPanel.HourlyPanel.recurEverySix.txt"));
            this.mc_recurEveryComboBox.addItem(m_bundle.getString("TimeEventPanel.HourlyPanel.recurEveryEight.txt"));
            this.mc_recurEveryComboBox.addItem(m_bundle.getString("TimeEventPanel.HourlyPanel.recurEveryTwelve.txt"));
            label.setLabelFor(this.mc_recurEveryComboBox);
            int minute = TimeEventPanel.this.m_currentMinute + 5;
            int hour = TimeEventPanel.this.m_currentMinute > 59 ? TimeEventPanel.this.m_currentHour + 1 : TimeEventPanel.this.m_currentHour;
            this.mc_hourminutepanel = new TimeHourMinutePanel(hour, minute, 5, TimeEventPanel.this.m_currentTimezone);
            this.mc_hourminutepanel.setHourLimit(1);
            this.mc_recurEveryComboBox.addActionListener(new EveryComboBoxListener(this.mc_hourminutepanel));
            this.mc_datepanel = new DateRangePanel(this.mc_frame, this.mc_endTimeSupported, this.mc_endTimeSupported);
            GridBagConstraints gbc_label = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_every = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            panel.setLayout(new GridBagLayout());
            panel.add((Component)label, gbc_label);
            panel.add((Component)this.mc_recurEveryComboBox, gbc_every);
            GridBagConstraints gbc_interval = new GridBagConstraints(0, 0, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_time = new GridBagConstraints(0, 1, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_range = new GridBagConstraints(0, 2, 10, 50, 1.0, 1.0, 12, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_filler = new GridBagConstraints(0, 3, 10, 1, 1.0, 1.0, 12, 1, new Insets(0, 0, 0, 5), 0, 0);
            this.setPreferredSize(new Dimension(TimeEventPanel.this.PreferredWidth, TimeEventPanel.this.PreferredHeight));
            this.setLayout(new GridBagLayout());
            this.add((Component)panel, gbc_interval);
            this.add((Component)this.mc_hourminutepanel, gbc_time);
            this.add((Component)this.mc_datepanel, gbc_range);
            this.add((Component)new StandardPanel(), gbc_filler);
        }

        private String getHourSequence(int offset, int interval) {
            int hour = offset;
            StringBuffer s = new StringBuffer();
            while (true) {
                s.append(hour);
                if ((hour += interval) >= 24) {
                    hour -= 24;
                }
                if (hour == offset) break;
                s.append(",");
            }
            return s.toString();
        }

        private class EveryComboBoxListener
        implements ActionListener {
            private TimeHourMinutePanel mc_panel;

            public EveryComboBoxListener(TimeHourMinutePanel panel) {
                this.mc_panel = panel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ((JComboBox)e.getSource()).getSelectedIndex();
                switch (index) {
                    case 0: {
                        this.mc_panel.setHourLimit(1);
                        break;
                    }
                    case 1: {
                        this.mc_panel.setHourLimit(2);
                        break;
                    }
                    case 2: {
                        this.mc_panel.setHourLimit(3);
                        break;
                    }
                    case 3: {
                        this.mc_panel.setHourLimit(4);
                        break;
                    }
                    case 4: {
                        this.mc_panel.setHourLimit(6);
                        break;
                    }
                    case 5: {
                        this.mc_panel.setHourLimit(8);
                        break;
                    }
                    case 6: {
                        this.mc_panel.setHourLimit(12);
                    }
                }
            }
        }
    }

    private class dailyPanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;
        private static final int MAXDAYS = 1000;
        private Frame mc_frame;
        private boolean mc_endTimeSupported;
        private JRadioButton mc_everyButton = new JRadioButton(TimeEventPanel.access$200().getString("TimeEventPanel.DailyPanel.IntervalLabel.txt"), true);
        private JRadioButton mc_weekdayButton = new JRadioButton(TimeEventPanel.access$200().getString("TimeEventPanel.DailyPanel.recurEveryWeekDay.txt"), false);
        private JComboBox mc_recurEveryComboBox = new JComboBox();
        private TimeHourMinutePanel mc_hourminutepanel;
        private DateRangePanel mc_datepanel;

        public dailyPanel(Frame frame, boolean showEndTime) {
            this.mc_frame = frame;
            this.mc_endTimeSupported = showEndTime;
            this.__initialize();
        }

        public TimeEventInfo getInfo(TimeEventInfo timeevent) {
            DailyRecurrence dailyRecurrence = new DailyRecurrence();
            int index = this.mc_recurEveryComboBox.getSelectedIndex();
            dailyRecurrence.setSkipCount(index + 1);
            dailyRecurrence.setWeekDays(this.mc_weekdayButton.isSelected());
            int timeHours = this.mc_hourminutepanel.getHour();
            timeevent.setHours(String.valueOf(timeHours));
            int minute = this.mc_hourminutepanel.getMinutes();
            timeevent.setMinutes(TimeEventPanel.this.m_nf_minutes.format(minute));
            timeevent.setTimezoneId(this.mc_hourminutepanel.getTimezone());
            Calendar start = this.mc_datepanel.getStartDate();
            dailyRecurrence.setStartDate(start);
            Calendar end = this.mc_datepanel.getEndDate();
            dailyRecurrence.setEndDate(end);
            if (end != null) {
                List nextDate = dailyRecurrence.getNextDates(start, end, 0);
                boolean past = true;
                Iterator i = nextDate.iterator();
                while (past && i.hasNext()) {
                    Calendar cal = (Calendar)i.next();
                    cal.set(11, timeHours);
                    cal.set(12, minute);
                    if (!cal.after(TimeEventPanel.this.m_currentDate)) continue;
                    past = false;
                }
                if (past) {
                    TimeEventPanel.this.m_errorMsg = m_bundle.getString("TimeEventPanel.errorPastDate.txt");
                }
            }
            timeevent.setRecurrence((IRecurrenceInfo)dailyRecurrence);
            return timeevent;
        }

        public void setInfo(TimeEventInfo info) {
            String timezone;
            DailyRecurrence recurrence = null;
            if (info.getRecurrence() instanceof DailyRecurrence) {
                recurrence = (DailyRecurrence)info.getRecurrence();
            }
            if (recurrence == null) {
                return;
            }
            int skip = recurrence.getSkipCount();
            this.mc_recurEveryComboBox.setSelectedIndex(skip - 1);
            String startHours = info.getHours();
            StringTokenizer st = new StringTokenizer(startHours, TimeEventPanel.LISTSEPARATORTOKENS);
            if (st.hasMoreTokens()) {
                int hour1 = Integer.parseInt(st.nextToken());
                this.mc_hourminutepanel.setHour(hour1);
            }
            this.mc_hourminutepanel.setMinute(Integer.parseInt(info.getMinutes()));
            if (recurrence.isWeekDays()) {
                this.mc_weekdayButton.setSelected(true);
            }
            if ((timezone = info.getTimezoneId()) != null) {
                this.mc_hourminutepanel.setTimezone(timezone);
            }
            this.mc_datepanel.setStartDate(((AbstractRecurrence)info.getRecurrence()).getStartDate());
            this.mc_datepanel.setEndDate(((AbstractRecurrence)info.getRecurrence()).getEndDate());
        }

        private void __initialize() {
            JPanel panel = new JPanel();
            TitledBorder border = new TitledBorder(m_bundle.getString("TimeEventPanel.DailyPanel.IntervalBorderTitle.txt"));
            panel.setBorder(border);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.mc_everyButton);
            buttonGroup.add(this.mc_weekdayButton);
            this.mc_recurEveryComboBox.addItem(m_bundle.getString("TimeEventPanel.DailyPanel.recurEveryOneDay.txt"));
            for (int i = 2; i < 1000; ++i) {
                this.mc_recurEveryComboBox.addItem(MessageFormat.format(m_bundle.getString("TimeEventPanel.DailyPanel.recurEveryPluralDays.fmt"), String.valueOf(i)));
            }
            this.mc_recurEveryComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dailyPanel.this.mc_everyButton.setSelected(true);
                }
            });
            int minute = TimeEventPanel.this.m_currentMinute + 5;
            int hour = minute > 59 ? TimeEventPanel.this.m_currentHour + 1 : TimeEventPanel.this.m_currentHour;
            this.mc_hourminutepanel = new TimeHourMinutePanel(hour, minute, 1, TimeEventPanel.this.m_currentTimezone);
            this.mc_datepanel = new DateRangePanel(this.mc_frame, this.mc_endTimeSupported, this.mc_endTimeSupported);
            GridBagConstraints gbc_label = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_every = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_weekday = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            panel.setLayout(new GridBagLayout());
            panel.add((Component)this.mc_everyButton, gbc_label);
            panel.add((Component)this.mc_recurEveryComboBox, gbc_every);
            panel.add((Component)this.mc_weekdayButton, gbc_weekday);
            GridBagConstraints gbc_interval = new GridBagConstraints(0, 0, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_time = new GridBagConstraints(0, 1, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_range = new GridBagConstraints(0, 2, 10, 50, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_filler = new GridBagConstraints(0, 3, 10, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 5), 0, 0);
            this.setPreferredSize(new Dimension(TimeEventPanel.this.PreferredWidth, TimeEventPanel.this.PreferredHeight));
            this.setLayout(new GridBagLayout());
            this.add((Component)panel, gbc_interval);
            this.add((Component)this.mc_hourminutepanel, gbc_time);
            this.add((Component)this.mc_datepanel, gbc_range);
            this.add((Component)new StandardPanel(), gbc_filler);
        }
    }

    private class weeklyPanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;
        private static final int MAXWEEKS = 1000;
        private Frame mc_frame;
        private boolean mc_endTimeSupported;
        private JComboBox mc_recurEveryComboBox = new JComboBox();
        private int mc_interval = 0;
        private JLabel mc_message;
        private JCheckBox mc_recurWeekSundayCheckBox;
        private JCheckBox mc_recurWeekMondayCheckBox;
        private JCheckBox mc_recurWeekTuesdayCheckBox;
        private JCheckBox mc_recurWeekWednesdayCheckBox;
        private JCheckBox mc_recurWeekThursdayCheckBox;
        private JCheckBox mc_recurWeekFridayCheckBox;
        private JCheckBox mc_recurWeekSaturdayCheckBox;
        private TimeHourMinutePanel mc_hourminutepanel;
        private DateRangePanel mc_datepanel;

        public weeklyPanel(Frame frame, boolean showEndTime) {
            this.mc_frame = frame;
            this.mc_endTimeSupported = showEndTime;
            this.__initialize();
        }

        public TimeEventInfo getInfo(TimeEventInfo timeevent) throws InvalidRecurrenceException {
            WeeklyRecurrence weeklyRecurrence = new WeeklyRecurrence();
            int interval = this.mc_recurEveryComboBox.getSelectedIndex() + 1;
            weeklyRecurrence.setSkipCount(interval);
            int weekdayMask = 0;
            if (this.mc_recurWeekSundayCheckBox.isSelected()) {
                weekdayMask |= 0x40;
            }
            if (this.mc_recurWeekMondayCheckBox.isSelected()) {
                weekdayMask |= 1;
            }
            if (this.mc_recurWeekTuesdayCheckBox.isSelected()) {
                weekdayMask |= 2;
            }
            if (this.mc_recurWeekWednesdayCheckBox.isSelected()) {
                weekdayMask |= 4;
            }
            if (this.mc_recurWeekThursdayCheckBox.isSelected()) {
                weekdayMask |= 8;
            }
            if (this.mc_recurWeekFridayCheckBox.isSelected()) {
                weekdayMask |= 0x10;
            }
            if (this.mc_recurWeekSaturdayCheckBox.isSelected()) {
                weekdayMask |= 0x20;
            }
            if (!weeklyRecurrence.setDaysToRun(weekdayMask)) {
                InvalidRecurrenceException e = new InvalidRecurrenceException(m_bundle.getString("TimeEventPanel.errorMissingDayInWeekly.txt"));
                throw e;
            }
            int timeHours = this.mc_hourminutepanel.getHour();
            timeevent.setHours(String.valueOf(timeHours));
            int minute = this.mc_hourminutepanel.getMinutes();
            timeevent.setMinutes(TimeEventPanel.this.m_nf_minutes.format(minute));
            timeevent.setTimezoneId(this.mc_hourminutepanel.getTimezone());
            Calendar start = this.mc_datepanel.getStartDate();
            weeklyRecurrence.setStartDate(start);
            Calendar end = this.mc_datepanel.getEndDate();
            weeklyRecurrence.setEndDate(end);
            if (end != null) {
                List nextDate = weeklyRecurrence.getNextDates(start, end, 0);
                boolean past = true;
                Iterator i = nextDate.iterator();
                while (past && i.hasNext()) {
                    Calendar cal = (Calendar)i.next();
                    cal.set(11, timeHours);
                    cal.set(12, minute);
                    if (!cal.after(TimeEventPanel.this.m_currentDate)) continue;
                    past = false;
                }
                if (past) {
                    TimeEventPanel.this.m_errorMsg = m_bundle.getString("TimeEventPanel.errorPastDate.txt");
                }
            }
            timeevent.setRecurrence((IRecurrenceInfo)weeklyRecurrence);
            return timeevent;
        }

        public void setInfo(TimeEventInfo info) {
            WeeklyRecurrence recurrence = null;
            if (info.getRecurrence() instanceof WeeklyRecurrence) {
                recurrence = (WeeklyRecurrence)info.getRecurrence();
            }
            if (recurrence == null) {
                return;
            }
            this.mc_recurEveryComboBox.setSelectedIndex(recurrence.getSkipCount() - 1);
            this.setWeeklyRecurrence(recurrence.getDaysToRun());
            String startHours = info.getHours();
            StringTokenizer st = new StringTokenizer(startHours, TimeEventPanel.LISTSEPARATORTOKENS);
            if (st.hasMoreTokens()) {
                int hour1 = Integer.parseInt(st.nextToken());
                this.mc_hourminutepanel.setHour(hour1);
            }
            this.mc_hourminutepanel.setMinute(Integer.parseInt(info.getMinutes()));
            String timezone = info.getTimezoneId();
            if (timezone != null) {
                this.mc_hourminutepanel.setTimezone(timezone);
            }
            this.mc_datepanel.setStartDate(((AbstractRecurrence)info.getRecurrence()).getStartDate());
            this.mc_datepanel.setEndDate(((AbstractRecurrence)info.getRecurrence()).getEndDate());
        }

        private void __initialize() {
            int minute;
            JPanel panel = new JPanel();
            TitledBorder border = new TitledBorder(m_bundle.getString("TimeEventPanel.WeeklyPanel.IntervalBorderTitle.txt"));
            panel.setBorder(border);
            JLabel label = new JLabel(m_bundle.getString("TimeEventPanel.WeeklyPanel.IntervalLabel.txt"));
            this.mc_recurEveryComboBox.addItem(m_bundle.getString("TimeEventPanel.WeeklyPanel.recurEveryOneWeek.txt"));
            for (int i = 2; i < 1000; ++i) {
                this.mc_recurEveryComboBox.addItem(MessageFormat.format(m_bundle.getString("TimeEventPanel.WeeklyPanel.recurEveryPluralWeeks.fmt"), String.valueOf(i)));
            }
            label.setLabelFor(this.mc_recurEveryComboBox);
            this.mc_recurWeekSundayCheckBox = new JCheckBox(m_bundle.getString("TimeEventPanel.recurSunday.txt"), true);
            this.mc_recurWeekMondayCheckBox = new JCheckBox(m_bundle.getString("TimeEventPanel.recurMonday.txt"));
            this.mc_recurWeekTuesdayCheckBox = new JCheckBox(m_bundle.getString("TimeEventPanel.recurTuesday.txt"));
            this.mc_recurWeekWednesdayCheckBox = new JCheckBox(m_bundle.getString("TimeEventPanel.recurWednesday.txt"));
            this.mc_recurWeekThursdayCheckBox = new JCheckBox(m_bundle.getString("TimeEventPanel.recurThursday.txt"));
            this.mc_recurWeekFridayCheckBox = new JCheckBox(m_bundle.getString("TimeEventPanel.recurFriday.txt"));
            this.mc_recurWeekSaturdayCheckBox = new JCheckBox(m_bundle.getString("TimeEventPanel.recurSaturday.txt"));
            if (TimeEventPanel.this.m_limitSkipsSupported) {
                CheckBoxListener l = new CheckBoxListener();
                this.mc_message = new JLabel(m_bundle.getString("TimeEventPanel.WeeklyPanel.IntervalWarning.txt"));
                this.mc_message.setVisible(false);
                this.mc_recurWeekSundayCheckBox.addItemListener(l);
                this.mc_recurWeekMondayCheckBox.addItemListener(l);
                this.mc_recurWeekTuesdayCheckBox.addItemListener(l);
                this.mc_recurWeekWednesdayCheckBox.addItemListener(l);
                this.mc_recurWeekThursdayCheckBox.addItemListener(l);
                this.mc_recurWeekFridayCheckBox.addItemListener(l);
                this.mc_recurWeekSaturdayCheckBox.addItemListener(l);
                this.mc_recurEveryComboBox.addItemListener(l);
                this.mc_interval = this.mc_recurEveryComboBox.getSelectedIndex() + 1;
            }
            int hour = (minute = TimeEventPanel.this.m_currentMinute + 5) > 59 ? TimeEventPanel.this.m_currentHour + 1 : TimeEventPanel.this.m_currentHour;
            this.mc_hourminutepanel = new TimeHourMinutePanel(hour, minute, 1, TimeEventPanel.this.m_currentTimezone);
            this.mc_datepanel = new DateRangePanel(this.mc_frame, this.mc_endTimeSupported, this.mc_endTimeSupported);
            GridBagConstraints gbc_label = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_every = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_msg = new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 12, 2, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_weekdaySunday = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_weekdayMonday = new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_weekdayTuesday = new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_weekdayWednesday = new GridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_weekdayThursday = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_weekdayFriday = new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_weekdaySaturday = new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            panel.setLayout(new GridBagLayout());
            panel.add((Component)label, gbc_label);
            panel.add((Component)this.mc_recurEveryComboBox, gbc_every);
            if (this.mc_message != null) {
                panel.add((Component)this.mc_message, gbc_msg);
            }
            panel.add((Component)this.mc_recurWeekSundayCheckBox, gbc_weekdaySunday);
            panel.add((Component)this.mc_recurWeekMondayCheckBox, gbc_weekdayMonday);
            panel.add((Component)this.mc_recurWeekTuesdayCheckBox, gbc_weekdayTuesday);
            panel.add((Component)this.mc_recurWeekWednesdayCheckBox, gbc_weekdayWednesday);
            panel.add((Component)this.mc_recurWeekThursdayCheckBox, gbc_weekdayThursday);
            panel.add((Component)this.mc_recurWeekFridayCheckBox, gbc_weekdayFriday);
            panel.add((Component)this.mc_recurWeekSaturdayCheckBox, gbc_weekdaySaturday);
            GridBagConstraints gbc_interval = new GridBagConstraints(0, 0, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_time = new GridBagConstraints(0, 1, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_range = new GridBagConstraints(0, 2, 10, 50, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_filler = new GridBagConstraints(0, 3, 10, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 5), 0, 0);
            this.setPreferredSize(new Dimension(TimeEventPanel.this.PreferredWidth, TimeEventPanel.this.PreferredHeight));
            this.setLayout(new GridBagLayout());
            this.add((Component)panel, gbc_interval);
            this.add((Component)this.mc_hourminutepanel, gbc_time);
            this.add((Component)this.mc_datepanel, gbc_range);
            this.add((Component)new StandardPanel(), gbc_filler);
        }

        private void setWeeklyRecurrence(int value) {
            if ((0x40 & value) != 0) {
                this.mc_recurWeekSundayCheckBox.setSelected(true);
            } else {
                this.mc_recurWeekSundayCheckBox.setSelected(false);
            }
            if ((1 & value) != 0) {
                this.mc_recurWeekMondayCheckBox.setSelected(true);
            } else {
                this.mc_recurWeekMondayCheckBox.setSelected(false);
            }
            if ((2 & value) != 0) {
                this.mc_recurWeekTuesdayCheckBox.setSelected(true);
            } else {
                this.mc_recurWeekTuesdayCheckBox.setSelected(false);
            }
            if ((4 & value) != 0) {
                this.mc_recurWeekWednesdayCheckBox.setSelected(true);
            } else {
                this.mc_recurWeekWednesdayCheckBox.setSelected(false);
            }
            if ((8 & value) != 0) {
                this.mc_recurWeekThursdayCheckBox.setSelected(true);
            } else {
                this.mc_recurWeekThursdayCheckBox.setSelected(false);
            }
            if ((0x10 & value) != 0) {
                this.mc_recurWeekFridayCheckBox.setSelected(true);
            } else {
                this.mc_recurWeekFridayCheckBox.setSelected(false);
            }
            if ((0x20 & value) != 0) {
                this.mc_recurWeekSaturdayCheckBox.setSelected(true);
            } else {
                this.mc_recurWeekSaturdayCheckBox.setSelected(false);
            }
        }

        class CheckBoxListener
        implements ItemListener {
            CheckBoxListener() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object source = e.getSource();
                int interval = weeklyPanel.this.mc_recurEveryComboBox.getSelectedIndex() + 1;
                if (source == weeklyPanel.this.mc_recurEveryComboBox) {
                    if (interval > 1 && weeklyPanel.this.mc_interval == 1) {
                        weeklyPanel.this.mc_message.setVisible(true);
                        weeklyPanel.this.mc_recurWeekSundayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekMondayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekTuesdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekWednesdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekThursdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekFridayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekSaturdayCheckBox.setSelected(false);
                    } else if (interval == 1) {
                        weeklyPanel.this.mc_message.setVisible(false);
                    }
                    weeklyPanel.this.mc_interval = interval;
                } else if (e.getStateChange() == 1 && interval > 1) {
                    if (source == weeklyPanel.this.mc_recurWeekSundayCheckBox) {
                        weeklyPanel.this.mc_recurWeekMondayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekTuesdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekWednesdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekThursdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekFridayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekSaturdayCheckBox.setSelected(false);
                    } else if (source == weeklyPanel.this.mc_recurWeekMondayCheckBox) {
                        weeklyPanel.this.mc_recurWeekSundayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekTuesdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekWednesdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekThursdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekFridayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekSaturdayCheckBox.setSelected(false);
                    } else if (source == weeklyPanel.this.mc_recurWeekTuesdayCheckBox) {
                        weeklyPanel.this.mc_recurWeekSundayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekMondayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekWednesdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekThursdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekFridayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekSaturdayCheckBox.setSelected(false);
                    } else if (source == weeklyPanel.this.mc_recurWeekWednesdayCheckBox) {
                        weeklyPanel.this.mc_recurWeekSundayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekMondayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekTuesdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekThursdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekFridayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekSaturdayCheckBox.setSelected(false);
                    } else if (source == weeklyPanel.this.mc_recurWeekThursdayCheckBox) {
                        weeklyPanel.this.mc_recurWeekSundayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekMondayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekTuesdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekWednesdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekFridayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekSaturdayCheckBox.setSelected(false);
                    } else if (source == weeklyPanel.this.mc_recurWeekFridayCheckBox) {
                        weeklyPanel.this.mc_recurWeekSundayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekMondayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekTuesdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekWednesdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekThursdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekSaturdayCheckBox.setSelected(false);
                    } else if (source == weeklyPanel.this.mc_recurWeekSaturdayCheckBox) {
                        weeklyPanel.this.mc_recurWeekSundayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekMondayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekTuesdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekWednesdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekThursdayCheckBox.setSelected(false);
                        weeklyPanel.this.mc_recurWeekFridayCheckBox.setSelected(false);
                    }
                }
            }
        }
    }

    private class monthlyPanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;
        private static final int MAXMONTHS = 999;
        private Frame mc_frame;
        private boolean mc_endTimeSupported;
        private JComboBox mc_recurEveryComboBox = new JComboBox();
        private JRadioButton mc_recurMonthOnDayButton;
        private JComboBox mc_recurMonthDayComboBox = new JComboBox();
        private JRadioButton mc_recurMonthOnWeekdayButton;
        private JComboBox mc_recurMonthWeekdayOccurrenceComboBox;
        private JComboBox mc_recurMonthWeekdayComboBox;
        private TimeHourMinutePanel mc_hourminutepanel;
        private DateRangePanel mc_datepanel;

        public monthlyPanel(Frame frame, boolean showEndTime) {
            this.mc_frame = frame;
            this.mc_endTimeSupported = showEndTime;
            this.__initialize();
        }

        public TimeEventInfo getInfo(TimeEventInfo timeevent) throws InvalidRecurrenceException {
            MonthlyRecurrence monthlyRecurrence = new MonthlyRecurrence();
            int interval = this.mc_recurEveryComboBox.getSelectedIndex() + 1;
            monthlyRecurrence.setSkipCount(interval);
            if (this.mc_recurMonthOnDayButton.isSelected()) {
                int index = this.mc_recurMonthDayComboBox.getSelectedIndex();
                if (index == 31) {
                    monthlyRecurrence.setRecurringDay(128, 6);
                } else {
                    monthlyRecurrence.setDayOfMonth(index + 1);
                }
            } else if (this.mc_recurMonthOnWeekdayButton.isSelected()) {
                int occurrence = 0;
                int index = this.mc_recurMonthWeekdayOccurrenceComboBox.getSelectedIndex();
                switch (index) {
                    case 0: {
                        occurrence = 1;
                        break;
                    }
                    case 1: {
                        occurrence = 2;
                        break;
                    }
                    case 2: {
                        occurrence = 3;
                        break;
                    }
                    case 3: {
                        occurrence = 4;
                        break;
                    }
                    case 4: {
                        occurrence = 6;
                    }
                }
                int weekday = 0;
                index = this.mc_recurMonthWeekdayComboBox.getSelectedIndex();
                switch (index) {
                    case 0: {
                        weekday = 64;
                        break;
                    }
                    case 1: {
                        weekday = 1;
                        break;
                    }
                    case 2: {
                        weekday = 2;
                        break;
                    }
                    case 3: {
                        weekday = 4;
                        break;
                    }
                    case 4: {
                        weekday = 8;
                        break;
                    }
                    case 5: {
                        weekday = 16;
                        break;
                    }
                    case 6: {
                        weekday = 32;
                    }
                }
                monthlyRecurrence.setRecurringDay(weekday, occurrence);
            }
            int timeHours = this.mc_hourminutepanel.getHour();
            timeevent.setHours(String.valueOf(timeHours));
            int minute = this.mc_hourminutepanel.getMinutes();
            timeevent.setMinutes(TimeEventPanel.this.m_nf_minutes.format(minute));
            timeevent.setTimezoneId(this.mc_hourminutepanel.getTimezone());
            Calendar start = this.mc_datepanel.getStartDate();
            monthlyRecurrence.setStartDate(start);
            Calendar end = this.mc_datepanel.getEndDate();
            monthlyRecurrence.setEndDate(end);
            if (end != null) {
                List nextDate = monthlyRecurrence.getNextDates(start, end, 0);
                boolean past = true;
                Iterator i = nextDate.iterator();
                while (past && i.hasNext()) {
                    Calendar cal = (Calendar)i.next();
                    cal.set(11, timeHours);
                    cal.set(12, minute);
                    if (!cal.after(TimeEventPanel.this.m_currentDate)) continue;
                    past = false;
                }
                if (past) {
                    TimeEventPanel.this.m_errorMsg = m_bundle.getString("TimeEventPanel.errorPastDate.txt");
                }
            }
            timeevent.setRecurrence((IRecurrenceInfo)monthlyRecurrence);
            return timeevent;
        }

        public void setInfo(TimeEventInfo info) {
            MonthlyRecurrence recurrence = null;
            if (info.getRecurrence() instanceof MonthlyRecurrence) {
                recurrence = (MonthlyRecurrence)info.getRecurrence();
            }
            if (recurrence == null) {
                return;
            }
            this.mc_recurEveryComboBox.setSelectedIndex(recurrence.getSkipCount() - 1);
            if (recurrence.getDayOfMonth() > 0) {
                this.mc_recurMonthOnDayButton.setSelected(true);
                int day = recurrence.getDayOfMonth();
                this.mc_recurMonthDayComboBox.setSelectedIndex(day - 1);
            } else if (recurrence.getDayOfWeek() > 0) {
                int week = recurrence.getWhichWeek();
                int day = recurrence.getDayOfWeek();
                if (day == 128) {
                    this.mc_recurMonthOnDayButton.setSelected(true);
                    this.mc_recurMonthDayComboBox.setSelectedIndex(31);
                } else {
                    this.mc_recurMonthOnWeekdayButton.setSelected(true);
                    switch (week) {
                        case 1: {
                            this.mc_recurMonthWeekdayOccurrenceComboBox.setSelectedIndex(0);
                            break;
                        }
                        case 2: {
                            this.mc_recurMonthWeekdayOccurrenceComboBox.setSelectedIndex(1);
                            break;
                        }
                        case 3: {
                            this.mc_recurMonthWeekdayOccurrenceComboBox.setSelectedIndex(2);
                            break;
                        }
                        case 4: {
                            this.mc_recurMonthWeekdayOccurrenceComboBox.setSelectedIndex(3);
                            break;
                        }
                        case 6: {
                            this.mc_recurMonthWeekdayOccurrenceComboBox.setSelectedIndex(4);
                        }
                    }
                    switch (day) {
                        case 64: {
                            this.mc_recurMonthWeekdayComboBox.setSelectedIndex(0);
                            break;
                        }
                        case 1: {
                            this.mc_recurMonthWeekdayComboBox.setSelectedIndex(1);
                            break;
                        }
                        case 2: {
                            this.mc_recurMonthWeekdayComboBox.setSelectedIndex(2);
                            break;
                        }
                        case 4: {
                            this.mc_recurMonthWeekdayComboBox.setSelectedIndex(3);
                            break;
                        }
                        case 8: {
                            this.mc_recurMonthWeekdayComboBox.setSelectedIndex(4);
                            break;
                        }
                        case 16: {
                            this.mc_recurMonthWeekdayComboBox.setSelectedIndex(5);
                            break;
                        }
                        case 32: {
                            this.mc_recurMonthWeekdayComboBox.setSelectedIndex(6);
                        }
                    }
                }
            }
            String startHours = info.getHours();
            StringTokenizer st = new StringTokenizer(startHours, TimeEventPanel.LISTSEPARATORTOKENS);
            if (st.hasMoreTokens()) {
                int hour1 = Integer.parseInt(st.nextToken());
                this.mc_hourminutepanel.setHour(hour1);
            }
            this.mc_hourminutepanel.setMinute(Integer.parseInt(info.getMinutes()));
            String timezone = info.getTimezoneId();
            if (timezone != null) {
                this.mc_hourminutepanel.setTimezone(timezone);
            }
            this.mc_datepanel.setStartDate(((AbstractRecurrence)info.getRecurrence()).getStartDate());
            this.mc_datepanel.setEndDate(((AbstractRecurrence)info.getRecurrence()).getEndDate());
        }

        private void __initialize() {
            JPanel panel = new JPanel();
            TitledBorder border = new TitledBorder(m_bundle.getString("TimeEventPanel.MonthlyPanel.IntervalBorderTitle.txt"));
            panel.setBorder(border);
            JLabel label = new JLabel(m_bundle.getString("TimeEventPanel.MonthlyPanel.IntervalLabel.txt"));
            this.mc_recurEveryComboBox.addItem(m_bundle.getString("TimeEventPanel.MonthlyPanel.recurEveryOneMonth.txt"));
            for (int i = 2; i < 999; ++i) {
                this.mc_recurEveryComboBox.addItem(MessageFormat.format(m_bundle.getString("TimeEventPanel.MonthlyPanel.recurEveryPluralMonths.fmt"), String.valueOf(i)));
            }
            label.setLabelFor(this.mc_recurEveryComboBox);
            if (TimeEventPanel.this.m_limitSkipsSupported) {
                this.mc_recurEveryComboBox.setVisible(false);
            }
            this.mc_recurMonthOnDayButton = new JRadioButton(m_bundle.getString("TimeEventPanel.MonthlyPanel.DayLabel.txt"), true);
            this.mc_recurMonthOnWeekdayButton = new JRadioButton(m_bundle.getString("TimeEventPanel.MonthlyPanel.WeekLabel.txt"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.mc_recurMonthOnDayButton);
            buttonGroup.add(this.mc_recurMonthOnWeekdayButton);
            for (int day = 1; day < 32; ++day) {
                this.mc_recurMonthDayComboBox.addItem(String.valueOf(day));
            }
            this.mc_recurMonthDayComboBox.addItem(m_bundle.getString("TimeEventPanel.recurOccurrenceLast.txt"));
            this.mc_recurMonthDayComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    monthlyPanel.this.mc_recurMonthOnDayButton.setSelected(true);
                }
            });
            this.mc_recurMonthWeekdayOccurrenceComboBox = new JComboBox();
            this.mc_recurMonthWeekdayOccurrenceComboBox.addItem(m_bundle.getString("TimeEventPanel.recurOccurrenceFirst.txt"));
            this.mc_recurMonthWeekdayOccurrenceComboBox.addItem(m_bundle.getString("TimeEventPanel.recurOccurrenceSecond.txt"));
            this.mc_recurMonthWeekdayOccurrenceComboBox.addItem(m_bundle.getString("TimeEventPanel.recurOccurrenceThird.txt"));
            this.mc_recurMonthWeekdayOccurrenceComboBox.addItem(m_bundle.getString("TimeEventPanel.recurOccurrenceFourth.txt"));
            this.mc_recurMonthWeekdayOccurrenceComboBox.addItem(m_bundle.getString("TimeEventPanel.recurOccurrenceLast.txt"));
            this.mc_recurMonthWeekdayOccurrenceComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    monthlyPanel.this.mc_recurMonthOnWeekdayButton.setSelected(true);
                }
            });
            this.mc_recurMonthWeekdayComboBox = new JComboBox();
            this.mc_recurMonthWeekdayComboBox.addItem(m_bundle.getString("TimeEventPanel.recurSunday.txt"));
            this.mc_recurMonthWeekdayComboBox.addItem(m_bundle.getString("TimeEventPanel.recurMonday.txt"));
            this.mc_recurMonthWeekdayComboBox.addItem(m_bundle.getString("TimeEventPanel.recurTuesday.txt"));
            this.mc_recurMonthWeekdayComboBox.addItem(m_bundle.getString("TimeEventPanel.recurWednesday.txt"));
            this.mc_recurMonthWeekdayComboBox.addItem(m_bundle.getString("TimeEventPanel.recurThursday.txt"));
            this.mc_recurMonthWeekdayComboBox.addItem(m_bundle.getString("TimeEventPanel.recurFriday.txt"));
            this.mc_recurMonthWeekdayComboBox.addItem(m_bundle.getString("TimeEventPanel.recurSaturday.txt"));
            this.mc_recurMonthWeekdayComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    monthlyPanel.this.mc_recurMonthOnWeekdayButton.setSelected(true);
                }
            });
            int minute = TimeEventPanel.this.m_currentMinute + 5;
            int hour = minute > 59 ? TimeEventPanel.this.m_currentHour + 1 : TimeEventPanel.this.m_currentHour;
            this.mc_hourminutepanel = new TimeHourMinutePanel(hour, minute, 1, TimeEventPanel.this.m_currentTimezone);
            this.mc_datepanel = new DateRangePanel(this.mc_frame, this.mc_endTimeSupported, this.mc_endTimeSupported);
            GridBagConstraints gbc_label = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_every = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_daylabel = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_daynumber = new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_weeklabel = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_week = new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_weekday = new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            panel.setLayout(new GridBagLayout());
            panel.add((Component)label, gbc_label);
            panel.add((Component)this.mc_recurEveryComboBox, gbc_every);
            panel.add((Component)this.mc_recurMonthOnDayButton, gbc_daylabel);
            panel.add((Component)this.mc_recurMonthDayComboBox, gbc_daynumber);
            panel.add((Component)this.mc_recurMonthOnWeekdayButton, gbc_weeklabel);
            panel.add((Component)this.mc_recurMonthWeekdayOccurrenceComboBox, gbc_week);
            panel.add((Component)this.mc_recurMonthWeekdayComboBox, gbc_weekday);
            GridBagConstraints gbc_interval = new GridBagConstraints(0, 0, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_time = new GridBagConstraints(0, 1, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_range = new GridBagConstraints(0, 2, 10, 50, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_filler = new GridBagConstraints(0, 3, 10, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
            this.setPreferredSize(new Dimension(TimeEventPanel.this.PreferredWidth, TimeEventPanel.this.PreferredHeight));
            this.setLayout(new GridBagLayout());
            this.add((Component)panel, gbc_interval);
            this.add((Component)this.mc_hourminutepanel, gbc_time);
            this.add((Component)this.mc_datepanel, gbc_range);
            this.add((Component)new StandardPanel(), gbc_filler);
        }
    }

    private class yearlyPanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;
        private static final int MAXMONTHS = 999;
        private Frame mc_frame;
        private boolean mc_endTimeSupported;
        private JComboBox mc_recurEveryComboBox = new JComboBox();
        private JRadioButton mc_recurMonthOnDayButton;
        private JComboBox mc_recurMonthDayComboBox = new JComboBox();
        private JRadioButton mc_recurMonthOnWeekdayButton;
        private JComboBox mc_recurMonthWeekdayOccurrenceComboBox;
        private JComboBox mc_recurMonthWeekdayComboBox;
        private JComboBox mc_recurMonthComboBox;
        private TimeHourMinutePanel mc_hourminutepanel;
        private DateRangePanel mc_datepanel;

        public yearlyPanel(Frame frame, boolean showEndTime) {
            this.mc_frame = frame;
            this.mc_endTimeSupported = showEndTime;
            this.__initialize();
        }

        public TimeEventInfo getInfo(TimeEventInfo timeevent) throws InvalidRecurrenceException {
            YearlyRecurrence yearlyRecurrence = new YearlyRecurrence();
            int interval = this.mc_recurEveryComboBox.getSelectedIndex() + 1;
            yearlyRecurrence.setSkipCount(interval);
            int month = this.mc_recurMonthComboBox.getSelectedIndex() + 1;
            if (this.mc_recurMonthOnDayButton.isSelected()) {
                int index = this.mc_recurMonthDayComboBox.getSelectedIndex();
                if (index == 31) {
                    yearlyRecurrence.setFloatingDay(month, 128, 6);
                } else {
                    yearlyRecurrence.setDate(month, index + 1);
                }
            } else if (this.mc_recurMonthOnWeekdayButton.isSelected()) {
                int occurrence = 0;
                int index = this.mc_recurMonthWeekdayOccurrenceComboBox.getSelectedIndex();
                switch (index) {
                    case 0: {
                        occurrence = 1;
                        break;
                    }
                    case 1: {
                        occurrence = 2;
                        break;
                    }
                    case 2: {
                        occurrence = 3;
                        break;
                    }
                    case 3: {
                        occurrence = 4;
                        break;
                    }
                    case 4: {
                        occurrence = 6;
                    }
                }
                int weekday = 0;
                index = this.mc_recurMonthWeekdayComboBox.getSelectedIndex();
                switch (index) {
                    case 0: {
                        weekday = 64;
                        break;
                    }
                    case 1: {
                        weekday = 1;
                        break;
                    }
                    case 2: {
                        weekday = 2;
                        break;
                    }
                    case 3: {
                        weekday = 4;
                        break;
                    }
                    case 4: {
                        weekday = 8;
                        break;
                    }
                    case 5: {
                        weekday = 16;
                        break;
                    }
                    case 6: {
                        weekday = 32;
                    }
                }
                yearlyRecurrence.setFloatingDay(month, weekday, occurrence);
            }
            int timeHours = this.mc_hourminutepanel.getHour();
            timeevent.setHours(String.valueOf(timeHours));
            int minute = this.mc_hourminutepanel.getMinutes();
            timeevent.setMinutes(TimeEventPanel.this.m_nf_minutes.format(minute));
            timeevent.setTimezoneId(this.mc_hourminutepanel.getTimezone());
            Calendar start = this.mc_datepanel.getStartDate();
            yearlyRecurrence.setStartDate(start);
            Calendar end = this.mc_datepanel.getEndDate();
            yearlyRecurrence.setEndDate(end);
            if (end != null) {
                List nextDate = yearlyRecurrence.getNextDates(start, end, 0);
                boolean past = true;
                Iterator i = nextDate.iterator();
                while (past && i.hasNext()) {
                    Calendar cal = (Calendar)i.next();
                    cal.set(11, timeHours);
                    cal.set(12, minute);
                    if (!cal.after(TimeEventPanel.this.m_currentDate)) continue;
                    past = false;
                }
                if (past) {
                    TimeEventPanel.this.m_errorMsg = m_bundle.getString("TimeEventPanel.errorPastDate.txt");
                }
            }
            timeevent.setRecurrence((IRecurrenceInfo)yearlyRecurrence);
            return timeevent;
        }

        public void setInfo(TimeEventInfo info) {
            YearlyRecurrence recurrence = null;
            if (info.getRecurrence() instanceof YearlyRecurrence) {
                recurrence = (YearlyRecurrence)info.getRecurrence();
            }
            if (recurrence == null) {
                return;
            }
            this.mc_recurEveryComboBox.setSelectedIndex(recurrence.getSkipCount() - 1);
            int month = recurrence.getMonth();
            this.mc_recurMonthComboBox.setSelectedIndex(month - 1);
            if (recurrence.getDay() > 0) {
                this.mc_recurMonthOnDayButton.setSelected(true);
                int day = recurrence.getDay();
                this.mc_recurMonthDayComboBox.setSelectedIndex(day - 1);
            } else if (recurrence.getDayOfWeek() > 0) {
                int week = recurrence.getWhichWeek();
                int day = recurrence.getDayOfWeek();
                if (day == 128) {
                    this.mc_recurMonthOnDayButton.setSelected(true);
                    this.mc_recurMonthDayComboBox.setSelectedIndex(31);
                } else {
                    this.mc_recurMonthOnWeekdayButton.setSelected(true);
                    switch (week) {
                        case 1: {
                            this.mc_recurMonthWeekdayOccurrenceComboBox.setSelectedIndex(0);
                            break;
                        }
                        case 2: {
                            this.mc_recurMonthWeekdayOccurrenceComboBox.setSelectedIndex(1);
                            break;
                        }
                        case 3: {
                            this.mc_recurMonthWeekdayOccurrenceComboBox.setSelectedIndex(2);
                            break;
                        }
                        case 4: {
                            this.mc_recurMonthWeekdayOccurrenceComboBox.setSelectedIndex(3);
                            break;
                        }
                        case 6: {
                            this.mc_recurMonthWeekdayOccurrenceComboBox.setSelectedIndex(4);
                        }
                    }
                    switch (day) {
                        case 64: {
                            this.mc_recurMonthWeekdayComboBox.setSelectedIndex(0);
                            break;
                        }
                        case 1: {
                            this.mc_recurMonthWeekdayComboBox.setSelectedIndex(1);
                            break;
                        }
                        case 2: {
                            this.mc_recurMonthWeekdayComboBox.setSelectedIndex(2);
                            break;
                        }
                        case 4: {
                            this.mc_recurMonthWeekdayComboBox.setSelectedIndex(3);
                            break;
                        }
                        case 8: {
                            this.mc_recurMonthWeekdayComboBox.setSelectedIndex(4);
                            break;
                        }
                        case 16: {
                            this.mc_recurMonthWeekdayComboBox.setSelectedIndex(5);
                            break;
                        }
                        case 32: {
                            this.mc_recurMonthWeekdayComboBox.setSelectedIndex(6);
                        }
                    }
                }
            }
            String startHours = info.getHours();
            StringTokenizer st = new StringTokenizer(startHours, TimeEventPanel.LISTSEPARATORTOKENS);
            if (st.hasMoreTokens()) {
                int hour1 = Integer.parseInt(st.nextToken());
                this.mc_hourminutepanel.setHour(hour1);
            }
            this.mc_hourminutepanel.setMinute(Integer.parseInt(info.getMinutes()));
            String timezone = info.getTimezoneId();
            if (timezone != null) {
                this.mc_hourminutepanel.setTimezone(timezone);
            }
            this.mc_datepanel.setStartDate(((AbstractRecurrence)info.getRecurrence()).getStartDate());
            this.mc_datepanel.setEndDate(((AbstractRecurrence)info.getRecurrence()).getEndDate());
        }

        private void __initialize() {
            JPanel panel = new JPanel();
            TitledBorder border = new TitledBorder(m_bundle.getString("TimeEventPanel.HourlyPanel.IntervalBorderTitle.txt"));
            panel.setBorder(border);
            JLabel label = new JLabel(m_bundle.getString("TimeEventPanel.YearlyPanel.IntervalLabel.txt"));
            this.mc_recurEveryComboBox.addItem(m_bundle.getString("TimeEventPanel.YearlyPanel.recurEveryOneYear.txt"));
            for (int i = 2; i < 999; ++i) {
                this.mc_recurEveryComboBox.addItem(MessageFormat.format(m_bundle.getString("TimeEventPanel.YearlyPanel.recurEveryPluralYears.fmt"), String.valueOf(i)));
            }
            label.setLabelFor(this.mc_recurEveryComboBox);
            if (TimeEventPanel.this.m_limitSkipsSupported) {
                this.mc_recurEveryComboBox.setVisible(false);
            }
            this.mc_recurMonthComboBox = new JComboBox();
            this.mc_recurMonthComboBox.addItem(m_bundle.getObject("TimeEventPanel.YearlyPanel.recurMonthJanuary.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getObject("TimeEventPanel.YearlyPanel.recurMonthFebruary.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getObject("TimeEventPanel.YearlyPanel.recurMonthMarch.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getObject("TimeEventPanel.YearlyPanel.recurMonthApril.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getObject("TimeEventPanel.YearlyPanel.recurMonthMay.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getObject("TimeEventPanel.YearlyPanel.recurMonthJune.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getObject("TimeEventPanel.YearlyPanel.recurMonthJuly.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getObject("TimeEventPanel.YearlyPanel.recurMonthAugust.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getObject("TimeEventPanel.YearlyPanel.recurMonthSeptember.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getObject("TimeEventPanel.YearlyPanel.recurMonthOctober.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getObject("TimeEventPanel.YearlyPanel.recurMonthNovember.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getObject("TimeEventPanel.YearlyPanel.recurMonthDecember.txt"));
            this.mc_recurMonthOnDayButton = new JRadioButton(m_bundle.getString("TimeEventPanel.YearlyPanel.DayLabel.txt"), true);
            this.mc_recurMonthOnWeekdayButton = new JRadioButton(m_bundle.getString("TimeEventPanel.YearlyPanel.WeekLabel.txt"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.mc_recurMonthOnDayButton);
            buttonGroup.add(this.mc_recurMonthOnWeekdayButton);
            for (int day = 1; day < 32; ++day) {
                this.mc_recurMonthDayComboBox.addItem(String.valueOf(day));
            }
            this.mc_recurMonthDayComboBox.addItem(m_bundle.getString("TimeEventPanel.recurOccurrenceLast.txt"));
            this.mc_recurMonthDayComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    yearlyPanel.this.mc_recurMonthOnDayButton.setSelected(true);
                }
            });
            this.mc_recurMonthWeekdayOccurrenceComboBox = new JComboBox();
            this.mc_recurMonthWeekdayOccurrenceComboBox.addItem(m_bundle.getString("TimeEventPanel.recurOccurrenceFirst.txt"));
            this.mc_recurMonthWeekdayOccurrenceComboBox.addItem(m_bundle.getString("TimeEventPanel.recurOccurrenceSecond.txt"));
            this.mc_recurMonthWeekdayOccurrenceComboBox.addItem(m_bundle.getString("TimeEventPanel.recurOccurrenceThird.txt"));
            this.mc_recurMonthWeekdayOccurrenceComboBox.addItem(m_bundle.getString("TimeEventPanel.recurOccurrenceFourth.txt"));
            this.mc_recurMonthWeekdayOccurrenceComboBox.addItem(m_bundle.getString("TimeEventPanel.recurOccurrenceLast.txt"));
            this.mc_recurMonthWeekdayOccurrenceComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    yearlyPanel.this.mc_recurMonthOnWeekdayButton.setSelected(true);
                }
            });
            this.mc_recurMonthWeekdayComboBox = new JComboBox();
            this.mc_recurMonthWeekdayComboBox.addItem(m_bundle.getString("TimeEventPanel.recurSunday.txt"));
            this.mc_recurMonthWeekdayComboBox.addItem(m_bundle.getString("TimeEventPanel.recurMonday.txt"));
            this.mc_recurMonthWeekdayComboBox.addItem(m_bundle.getString("TimeEventPanel.recurTuesday.txt"));
            this.mc_recurMonthWeekdayComboBox.addItem(m_bundle.getString("TimeEventPanel.recurWednesday.txt"));
            this.mc_recurMonthWeekdayComboBox.addItem(m_bundle.getString("TimeEventPanel.recurThursday.txt"));
            this.mc_recurMonthWeekdayComboBox.addItem(m_bundle.getString("TimeEventPanel.recurFriday.txt"));
            this.mc_recurMonthWeekdayComboBox.addItem(m_bundle.getString("TimeEventPanel.recurSaturday.txt"));
            this.mc_recurMonthWeekdayComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    yearlyPanel.this.mc_recurMonthOnWeekdayButton.setSelected(true);
                }
            });
            int minute = TimeEventPanel.this.m_currentMinute + 5;
            int hour = minute > 59 ? TimeEventPanel.this.m_currentHour + 1 : TimeEventPanel.this.m_currentHour;
            this.mc_hourminutepanel = new TimeHourMinutePanel(hour, minute, 1, TimeEventPanel.this.m_currentTimezone);
            this.mc_datepanel = new DateRangePanel(this.mc_frame, this.mc_endTimeSupported, this.mc_endTimeSupported);
            GridBagConstraints gbc_label = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_every = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_month = new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_daylabel = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_daynumber = new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_weeklabel = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_week = new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_weekday = new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
            panel.setLayout(new GridBagLayout());
            panel.add((Component)label, gbc_label);
            panel.add((Component)this.mc_recurEveryComboBox, gbc_every);
            if (TimeEventPanel.this.m_limitSkipsSupported) {
                panel.add((Component)this.mc_recurMonthComboBox, gbc_every);
            } else {
                panel.add((Component)this.mc_recurMonthComboBox, gbc_month);
            }
            panel.add((Component)this.mc_recurMonthOnDayButton, gbc_daylabel);
            panel.add((Component)this.mc_recurMonthDayComboBox, gbc_daynumber);
            panel.add((Component)this.mc_recurMonthOnWeekdayButton, gbc_weeklabel);
            panel.add((Component)this.mc_recurMonthWeekdayOccurrenceComboBox, gbc_week);
            panel.add((Component)this.mc_recurMonthWeekdayComboBox, gbc_weekday);
            GridBagConstraints gbc_interval = new GridBagConstraints(0, 0, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_time = new GridBagConstraints(0, 1, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_range = new GridBagConstraints(0, 2, 10, 50, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_filler = new GridBagConstraints(0, 3, 10, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 5), 0, 0);
            this.setPreferredSize(new Dimension(TimeEventPanel.this.PreferredWidth, TimeEventPanel.this.PreferredHeight));
            this.setLayout(new GridBagLayout());
            this.add((Component)panel, gbc_interval);
            this.add((Component)this.mc_hourminutepanel, gbc_time);
            this.add((Component)this.mc_datepanel, gbc_range);
            this.add((Component)new StandardPanel(), gbc_filler);
        }
    }
}

