/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.metadata.remote.MdException;
import com.sas.scheduler.visuals.swing.ButtonsLayout;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class MessageUtil {
    private static final ResourceBundle m_bundle;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int ERROR_MESSAGE = 0;
    public static final int DEFAULT_OPTION = -1;
    public static final int OK_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES_OPTION_BUTTON = 1;
    public static final int NO_OPTION_BUTTON = 0;
    public static final int CANCEL_OPTION_BUTTON = -1;
    public static final int OK_OPTION_BUTTON = 2;
    public static final int CLOSED_OPTION_BUTTON = -2;
    public static final int ACCESSING = 0;
    public static final int CREATING = 1;
    public static final int READING = 2;
    public static final int WRITING = 3;
    public static final int DELETING = 4;
    public static final int CHECKING_OUT = 5;
    public static final int CHECKING_IN = 6;
    public static final int FETCHING = 7;

    private MessageUtil() {
    }

    public static void displayMessage(Frame frame, String sMessage, String sTitle, int eType) {
        MessageUtil.displayMessage(frame, sMessage, sTitle, eType, -1);
    }

    public static int displayMessage(Frame frame, String sMessage, String sTitle, int eType, int eOptions) {
        cDisplayMessageRunnable run = new cDisplayMessageRunnable(frame, sMessage, sTitle, eType, eOptions, false);
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return run.getReturnCode();
    }

    public static void displayListMessage(Frame frame, String sMessage, List<?> lValues, String sTitle, int eType) {
        MessageUtil.displayListMessage(frame, sMessage, lValues, sTitle, eType, -1);
    }

    public static int displayListMessage(Frame frame, String sMessage, List<?> lValues, String sTitle, int eType, int eOptions) {
        cDisplayMessageRunnable run = new cDisplayMessageRunnable(frame, sMessage, lValues, sTitle, eType, eOptions);
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return run.getReturnCode();
    }

    public static int displayScrollableMessage(Frame frame, String sMessage, String sTitle) {
        return MessageUtil.displayScrollableMessage(frame, sMessage, sTitle, 1, -1);
    }

    public static int displayScrollableMessage(Frame frame, String sMessage, String sTitle, int eType, int eOptions) {
        cDisplayMessageRunnable run = new cDisplayMessageRunnable(frame, sMessage, sTitle, eType, eOptions, true);
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return run.getReturnCode();
    }

    public static void displayMetadataExceptionMessage(final Exception e, final String sTitle, final int sAccess) {
        if (!(e instanceof MdException)) {
            return;
        }
        Runnable runDisplayMessage = new Runnable(){

            @Override
            public void run() {
                String exceptionMessage = e.getLocalizedMessage() == null ? m_bundle.getString("MessageUtil.ErrorNullException.txt") : e.getLocalizedMessage();
                String sText = null;
                Object[] obj = new Object[]{exceptionMessage};
                switch (sAccess) {
                    case 0: {
                        sText = MessageFormat.format(m_bundle.getString("MessageUtil.ErrorAccessingMetadata.fmt"), obj);
                        break;
                    }
                    case 1: {
                        sText = MessageFormat.format(m_bundle.getString("MessageUtil.ErrorCreatingMetadata.fmt"), obj);
                        break;
                    }
                    case 2: {
                        sText = MessageFormat.format(m_bundle.getString("MessageUtil.ErrorReadingMetadata.fmt"), obj);
                        break;
                    }
                    case 3: {
                        sText = MessageFormat.format(m_bundle.getString("MessageUtil.ErrorWritingMetadata.fmt"), obj);
                        break;
                    }
                    case 4: {
                        sText = MessageFormat.format(m_bundle.getString("MessageUtil.ErrorDeletingMetadata.fmt"), obj);
                        break;
                    }
                    case 5: {
                        sText = MessageFormat.format(m_bundle.getString("MessageUtil.ErrorCheckingoutMetadata.fmt"), obj);
                        break;
                    }
                    case 6: {
                        sText = MessageFormat.format(m_bundle.getString("MessageUtil.ErrorCheckinginMetadata.fmt"), obj);
                        break;
                    }
                    case 7: {
                        sText = MessageFormat.format(m_bundle.getString("MessageUtil.ErrorFetchingMetadata.fmt"), obj);
                    }
                }
                MessageUtil.displayMessage(null, sText, sTitle, 0, -1);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runDisplayMessage.run();
        } else {
            SwingUtilities.invokeLater(runDisplayMessage);
        }
    }

    protected static int showLongMessageDialog(Frame frame, String sMessage, String sTitle, int eType, int eOptions) {
        cMessageDialog dialog = new cMessageDialog(frame, sMessage, sTitle, eType, eOptions);
        dialog.pack();
        MessageUtil.centerOver(dialog, frame);
        dialog.setVisible(true);
        return dialog.getReturn();
    }

    protected static int showListMessageDialog(Frame frame, String sMessage, List<?> lValues, String sTitle, int eType, int eOptions) {
        cMessageDialog dialog = new cMessageDialog(frame, sMessage, lValues, sTitle, eType, eOptions);
        dialog.pack();
        MessageUtil.centerOver(dialog, frame);
        dialog.setVisible(true);
        return dialog.getReturn();
    }

    protected static int showDetailsMessageDialog(Frame frame, String sMessage, String sTitle, int eType, int eOption) {
        cMessageDialog dialog = new cMessageDialog(frame, sMessage, eType, eOption, sTitle);
        dialog.pack();
        MessageUtil.centerOver(dialog, frame);
        dialog.setVisible(true);
        return dialog.getReturn();
    }

    private static void centerOver(Window window, Component component) {
        int amountOver;
        Dimension size = window.getSize();
        int x = 0;
        int y = 0;
        if (component != null) {
            Point location = component.getLocationOnScreen();
            Dimension componentSize = component.getSize();
            location.x += componentSize.width / 2;
            location.y += componentSize.height / 2;
            x = location.x - size.width / 2;
            y = location.y - size.height / 2;
        } else {
            x = size.width / 2;
            y = size.height / 2;
        }
        Dimension screenSize = window.getToolkit().getScreenSize();
        if (x + size.width > screenSize.width && (amountOver = x + size.width - screenSize.width) > 0 && x - amountOver > 0) {
            x -= amountOver;
        }
        if (y + size.height > screenSize.height && (amountOver = y + size.height - screenSize.height) > 0 && y - amountOver > 0) {
            y -= amountOver;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        window.setLocation(x, y);
    }

    public static String messageString(String pattern, Object parm1) {
        Object[] args = new Object[]{parm1.toString()};
        return MessageFormat.format(pattern, args);
    }

    public static String messageString(String pattern, Object parm1, Object parm2) {
        Object[] args = new Object[]{parm1.toString(), parm2.toString()};
        return MessageFormat.format(pattern, args);
    }

    public static String messageString(String pattern, Object parm1, Object parm2, Object parm3) {
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString()};
        return MessageFormat.format(pattern, args);
    }

    public static String messageString(String pattern, Object parm1, Object parm2, Object parm3, Object parm4) {
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString()};
        return MessageFormat.format(pattern, args);
    }

    public static String messageString(String pattern, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5) {
        Object[] args = new Object[]{parm1 != null ? parm1.toString() : "", parm2 != null ? parm2.toString() : "", parm3 != null ? parm3.toString() : "", parm4 != null ? parm4.toString() : "", parm5 != null ? parm5.toString() : ""};
        return MessageFormat.format(pattern, args);
    }

    public static String messageString(String pattern, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5, Object parm6) {
        Object[] args = new Object[]{parm1 != null ? parm1.toString() : "", parm2 != null ? parm2.toString() : "", parm3 != null ? parm3.toString() : "", parm4 != null ? parm4.toString() : "", parm5 != null ? parm5.toString() : "", parm6 != null ? parm6.toString() : ""};
        return MessageFormat.format(pattern, args);
    }

    static {
        String strClassName = MessageUtil.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    private static class cDisplayMessageRunnable
    implements Runnable {
        private Frame m_frame;
        private String m_sTitle;
        private List<?> m_lValues;
        private String m_sMessage;
        private int m_eType;
        private int m_eOptions;
        private boolean m_scrollbars = false;
        private int m_eReturnCode;

        public cDisplayMessageRunnable(Frame frame, String sMessage, List<?> lValues, String sTitle, int eType, int eOptions) {
            this.m_frame = frame;
            this.m_sMessage = sMessage;
            this.m_lValues = lValues;
            this.m_sTitle = sTitle;
            this.m_eType = eType;
            this.m_eOptions = eOptions;
        }

        public cDisplayMessageRunnable(Frame frame, String sMessage, String sTitle, int eType, int eOptions, boolean scrollbars) {
            this.m_frame = frame;
            this.m_sMessage = sMessage;
            this.m_sTitle = sTitle;
            this.m_eType = eType;
            this.m_eOptions = eOptions;
            this.m_scrollbars = scrollbars;
        }

        @Override
        public void run() {
            this.m_eReturnCode = this.m_lValues != null ? MessageUtil.showListMessageDialog(this.m_frame, this.m_sMessage, this.m_lValues, this.m_sTitle, this.m_eType, this.m_eOptions) : (this.m_scrollbars ? MessageUtil.showDetailsMessageDialog(this.m_frame, this.m_sMessage, this.m_sTitle, this.m_eType, this.m_eOptions) : MessageUtil.showLongMessageDialog(this.m_frame, this.m_sMessage, this.m_sTitle, this.m_eType, this.m_eOptions));
        }

        public int getReturnCode() {
            return this.m_eReturnCode;
        }
    }

    private static class cMessageDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private int m_eReturn = -2;
        private JTextArea m_txtMessage;
        private JLabel m_lblIcon;
        private JPanel m_pnlButtons;
        private JList m_lstValues;
        private JScrollPane m_scrValues;
        private static final int PANE_WIDTH = 550;
        private static final int PANE_HEIGHT = 300;

        public cMessageDialog(Frame frmParent, String sMessage, String sTitle, int eType, int eOptions) {
            super(frmParent, sTitle, true);
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            this.addCloseAction();
            this.m_txtMessage = this.createMessageText(sMessage);
            this.m_lblIcon = this.createIconLabel(eType);
            this.m_pnlButtons = this.createButtonsPanel(eOptions);
            this.layoutComponents();
        }

        public cMessageDialog(Frame frmParent, String sMessage, List<?> lValues, String sTitle, int eType, int eOptions) {
            super(frmParent, sTitle, true);
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            this.addCloseAction();
            this.m_txtMessage = this.createMessageText(sMessage);
            this.m_lstValues = this.createValuesList(lValues);
            this.m_scrValues = new JScrollPane(this.m_lstValues);
            this.m_lblIcon = this.createIconLabel(eType);
            this.m_pnlButtons = this.createButtonsPanel(eOptions);
            this.layoutComponents();
        }

        public cMessageDialog(Frame frmParent, String sMessage, int eType, int eOptions, String sTitle) {
            super(frmParent, sTitle, true);
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            this.addCloseAction();
            this.m_txtMessage = null;
            JTextArea text = this.createMessageText(sMessage);
            this.m_scrValues = new JScrollPane(text, 20, 31);
            this.m_scrValues.setPreferredSize(new Dimension(550, 300));
            this.m_lblIcon = this.createIconLabel(eType);
            this.m_pnlButtons = this.createButtonsPanel(eOptions);
            this.layoutComponents();
        }

        public int getReturn() {
            return this.m_eReturn;
        }

        public void setReturn(int eReturn) {
            this.m_eReturn = eReturn;
        }

        protected JTextArea createMessageText(String sMessage) {
            JTextArea txtMessage = new JTextArea();
            Font fnt = this.getFont();
            txtMessage.setFont(new Font("Dialog", fnt.getStyle(), fnt.getSize()));
            txtMessage.setColumns(30);
            txtMessage.setText(sMessage);
            txtMessage.setBackground(SystemColor.control);
            txtMessage.setWrapStyleWord(true);
            txtMessage.setLineWrap(true);
            txtMessage.setEditable(false);
            return txtMessage;
        }

        protected JLabel createIconLabel(int eType) {
            String sIconRes;
            switch (eType) {
                case 2: {
                    sIconRes = "OptionPane.warningIcon";
                    break;
                }
                case 0: {
                    sIconRes = "OptionPane.errorIcon";
                    break;
                }
                default: {
                    sIconRes = "OptionPane.informationIcon";
                }
            }
            return new JLabel(UIManager.getDefaults().getIcon(sIconRes));
        }

        protected JList createValuesList(List<?> lValues) {
            return new JList<Object>(lValues.toArray());
        }

        protected JPanel createButtonsPanel(int eOptions) {
            JPanel pnlButtons = new JPanel(new ButtonsLayout());
            switch (eOptions) {
                default: {
                    pnlButtons.add(new cOptionButton(this, 2));
                    break;
                }
                case 2: {
                    pnlButtons.add(new cOptionButton(this, 2));
                    pnlButtons.add(new cOptionButton(this, -1));
                    break;
                }
                case 0: {
                    pnlButtons.add(new cOptionButton(this, 1));
                    pnlButtons.add(new cOptionButton(this, 0));
                    break;
                }
                case 1: {
                    pnlButtons.add(new cOptionButton(this, 1));
                    pnlButtons.add(new cOptionButton(this, 0));
                    pnlButtons.add(new cOptionButton(this, -1));
                }
            }
            JButton btnDefault = (JButton)pnlButtons.getComponents()[0];
            this.getRootPane().setDefaultButton(btnDefault);
            return pnlButtons;
        }

        protected void layoutComponents() {
            Container pnlContents = this.getContentPane();
            pnlContents.setLayout(new GridBagLayout());
            pnlContents.add((Component)this.m_lblIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(7, 7, 7, 7), 0, 0));
            if (this.m_txtMessage == null && this.m_scrValues != null) {
                pnlContents.add((Component)this.m_scrValues, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 7, 7, 7), 0, 0));
            } else {
                pnlContents.add((Component)this.m_txtMessage, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(7, 7, 7, 7), 0, 0));
                if (this.m_scrValues != null) {
                    pnlContents.add((Component)this.m_scrValues, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 7, 7, 7), 0, 0));
                }
            }
            pnlContents.add((Component)this.m_pnlButtons, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 15, 0, new Insets(7, 0, 7, 0), 0, 0));
            this.pack();
        }

        protected void addCloseAction() {
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "close");
            this.getRootPane().getActionMap().put("close", new cCloseAction());
        }

        @Override
        public void dispose() {
            super.dispose();
        }

        protected class cCloseAction
        extends AbstractAction {
            private static final long serialVersionUID = 1L;

            protected cCloseAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                cMessageDialog.this.dispose();
            }
        }
    }

    private static class cOptionButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private cMessageDialog m_dlgParent;
        private int m_eReturnCode;

        public cOptionButton(cMessageDialog dlgParent, int eReturnCode) {
            switch (eReturnCode) {
                case 2: {
                    String okText = m_bundle.getString("MessageUtil.Button.OK.txt");
                    this.setText(Util.getLabelWithoutMnemonic((String)okText));
                    this.setMnemonic(Util.getDisplayedMnemonic((String)okText));
                    this.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)okText));
                    break;
                }
                case -1: {
                    String cancelText = m_bundle.getString("MessageUtil.Button.Cancel.txt");
                    this.setText(Util.getLabelWithoutMnemonic((String)cancelText));
                    this.setMnemonic(Util.getDisplayedMnemonic((String)cancelText));
                    this.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)cancelText));
                    break;
                }
                case 1: {
                    String yesText = m_bundle.getString("MessageUtil.Button.Yes.txt");
                    this.setText(Util.getLabelWithoutMnemonic((String)yesText));
                    this.setMnemonic(Util.getDisplayedMnemonic((String)yesText));
                    this.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)yesText));
                    break;
                }
                case 0: {
                    String noText = m_bundle.getString("MessageUtil.Button.No.txt");
                    this.setText(Util.getLabelWithoutMnemonic((String)noText));
                    this.setMnemonic(Util.getDisplayedMnemonic((String)noText));
                    this.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)noText));
                }
            }
            this.m_dlgParent = dlgParent;
            this.m_eReturnCode = eReturnCode;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.m_dlgParent.setReturn(this.m_eReturnCode);
            this.m_dlgParent.dispose();
        }
    }
}

