/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobEventInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class JobEventPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private Frame m_frame;
    private FlowInfo m_flow;
    private JobInfo m_dependentJob;
    private List<?> m_jobEvents;
    private boolean m_editmode = false;
    private String m_sDefaultDescription = null;
    private JobEventInfo m_jobevent;
    private JComboBox m_cmbevents;
    private JTextArea m_txtdescription;
    private JLabel m_blankfield1;
    private JLabel m_blankfield2;
    private JTextField m_txtMinutes;
    private JLabel m_lblMinutes;
    private JComboBox m_cmbReturnCodeCondition;
    private JTextField m_txtReturnCode;

    public JobEventPanel(Frame frame, JobInfo job, FlowInfo flow, List<?> jobEvents) {
        this.m_frame = frame;
        this.m_dependentJob = job;
        this.m_flow = flow;
        this.m_jobEvents = jobEvents;
        this.m_editmode = false;
        this.__initialize(-1, -1, 0);
    }

    public JobEventPanel(Frame frame, JobEventInfo oJobEvent, JobInfo job, FlowInfo flow, List<?> jobEvents) {
        this.m_frame = frame;
        this.m_dependentJob = job;
        this.m_flow = flow;
        this.m_jobEvents = jobEvents;
        this.m_editmode = false;
        this.m_sDefaultDescription = oJobEvent.getDescription();
        this.__initialize(oJobEvent.getEventType(), oJobEvent.getOperator(), oJobEvent.getValue());
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_flow = null;
        this.m_dependentJob = null;
        this.m_sDefaultDescription = null;
        this.m_jobEvents = null;
        this.m_frame = null;
        this.m_txtdescription = null;
        this.m_txtMinutes = null;
        this.m_lblMinutes = null;
        this.m_cmbReturnCodeCondition = null;
        this.m_txtReturnCode = null;
    }

    @Override
    public boolean moveViewToData() {
        this.m_jobevent.setDescription(this.m_txtdescription.getText());
        return true;
    }

    @Override
    public boolean moveDataToView() {
        if (null != this.m_sDefaultDescription) {
            this.m_txtdescription.setText(this.m_sDefaultDescription);
        }
        return true;
    }

    private void __initialize(int nDefaultDependencyType, int nDefaultOperator, int nDefaultValue) {
        int x;
        this.m_jobevent = new JobEventInfo(this.m_dependentJob, nDefaultDependencyType, nDefaultOperator, nDefaultValue);
        String eventlistText = m_bundle.getString("JobEventPanel.EventList.Title.txt");
        JLabel lbleventlist = new JLabel(Util.getLabelWithoutMnemonic((String)eventlistText));
        this.m_cmbevents = new JComboBox();
        lbleventlist.setToolTipText(m_bundle.getString("JobEventPanel.EventList.ToolTipText.txt"));
        this.m_cmbevents.setToolTipText(m_bundle.getString("JobEventPanel.EventList.ToolTipText.txt"));
        lbleventlist.setLabelFor(lbleventlist);
        lbleventlist.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)eventlistText));
        String descText = m_bundle.getString("JobEventPanel.Description.Title.txt");
        JLabel lbldescription = new JLabel(Util.getLabelWithoutMnemonic((String)descText));
        this.m_txtdescription = new JTextArea();
        lbldescription.setToolTipText(m_bundle.getString("JobEventPanel.Description.ToolTipText.txt"));
        this.m_txtdescription.setToolTipText(m_bundle.getString("JobEventPanel.Description.ToolTipText.txt"));
        JScrollPane scrdescription = new JScrollPane(this.m_txtdescription);
        scrdescription.setPreferredSize(new Dimension(300, 100));
        lbldescription.setLabelFor(this.m_txtdescription);
        lbldescription.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)descText));
        this.m_blankfield1 = new JLabel("");
        this.m_blankfield2 = new JLabel("");
        this.m_lblMinutes = new JLabel(m_bundle.getString("JobEventPanel.Minutes.txt"));
        this.m_lblMinutes.setVisible(false);
        this.m_txtMinutes = new JTextField();
        this.m_txtMinutes.setVisible(false);
        this.m_cmbReturnCodeCondition = new JComboBox();
        this.m_cmbReturnCodeCondition.setVisible(false);
        this.m_txtReturnCode = new JTextField();
        this.m_txtReturnCode.setMinimumSize(new Dimension(100, 20));
        this.m_txtReturnCode.setVisible(false);
        DisplayMap oSelectedReturnCodeConditionCount = null;
        ArrayList<DisplayMap> alRCConditions = new ArrayList<DisplayMap>();
        DisplayMap map = null;
        map = new DisplayMap(FlowInfo.ArithmeticOperator_Equal_Text, 21);
        alRCConditions.add(map);
        map = new DisplayMap(FlowInfo.ArithmeticOperator_NotEqual_Text, 22);
        alRCConditions.add(map);
        map = new DisplayMap(FlowInfo.ArithmeticOperator_GreaterThan_Text, 23);
        alRCConditions.add(map);
        map = new DisplayMap(FlowInfo.ArithmeticOperator_GreaterThanEqual_Text, 24);
        alRCConditions.add(map);
        map = new DisplayMap(FlowInfo.ArithmeticOperator_LessThan_Text, 25);
        alRCConditions.add(map);
        map = new DisplayMap(FlowInfo.ArithmeticOperator_LessThanEqual_Text, 26);
        alRCConditions.add(map);
        if (-1 != nDefaultOperator) {
            Iterator i = alRCConditions.iterator();
            boolean found = false;
            while (!found && i.hasNext()) {
                map = (DisplayMap)i.next();
                int condition = map.getIntValue();
                if (nDefaultOperator != condition) continue;
                oSelectedReturnCodeConditionCount = map;
                found = true;
            }
        }
        this.m_cmbReturnCodeCondition.setModel(new DefaultComboBoxModel<Object>(alRCConditions.toArray()));
        if (null != oSelectedReturnCodeConditionCount) {
            this.m_cmbReturnCodeCondition.setSelectedItem(oSelectedReturnCodeConditionCount);
        }
        SchedulerServerInfo scheduler = this.m_flow.getScheduler();
        int[] eventType = null;
        eventType = this.m_dependentJob != null && !this.m_dependentJob.isSubflow() ? SchedulerServerInfo.getAllJobEvents((String)scheduler.getClassId()) : SchedulerServerInfo.getAllSubFlowEvents((String)scheduler.getClassId());
        DisplayMap[] eventDesc = new DisplayMap[eventType.length];
        for (x = 0; x < eventType.length; ++x) {
            eventDesc[x] = new DisplayMap(JobEventInfo.getEventTypeDescription((int)eventType[x]), eventType[x]);
        }
        this.m_cmbevents.setModel(new DefaultComboBoxModel<DisplayMap>(eventDesc));
        switch (nDefaultDependencyType) {
            case 3: 
            case 13: {
                this.m_txtReturnCode.setText(Integer.toString(nDefaultValue));
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 15: {
                this.m_txtMinutes.setText(Integer.toString(nDefaultValue));
            }
        }
        this.m_cmbevents.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JobEventPanel.this.conditionChanged();
                }
            }
        });
        if (-1 != nDefaultDependencyType) {
            for (x = 0; x < eventType.length; ++x) {
                if (eventType[x] != nDefaultDependencyType) continue;
                this.m_cmbevents.setSelectedIndex(x);
                break;
            }
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)lbleventlist, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 28, 0));
        this.add((Component)this.m_cmbevents, new GridBagConstraints(1, 0, 3, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.m_blankfield1, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_blankfield2, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.m_txtMinutes, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_lblMinutes, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.m_cmbReturnCodeCondition, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 50, 0));
        this.add((Component)this.m_txtReturnCode, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 12, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)lbldescription, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 28, 0));
        this.add((Component)scrdescription, new GridBagConstraints(1, 2, 3, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void conditionChanged() {
        this.m_jobevent.setEventType(((DisplayMap)this.m_cmbevents.getSelectedItem()).getIntValue());
        switch (this.m_jobevent.getEventType()) {
            case 3: 
            case 13: {
                this.m_blankfield1.setVisible(false);
                this.m_blankfield2.setVisible(false);
                this.m_lblMinutes.setVisible(false);
                this.m_txtMinutes.setVisible(false);
                this.m_cmbReturnCodeCondition.setVisible(true);
                this.m_txtReturnCode.setVisible(true);
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 15: {
                this.m_blankfield1.setVisible(false);
                this.m_blankfield2.setVisible(false);
                this.m_lblMinutes.setVisible(true);
                this.m_txtMinutes.setVisible(true);
                this.m_cmbReturnCodeCondition.setVisible(false);
                this.m_txtReturnCode.setVisible(false);
                break;
            }
            default: {
                this.m_blankfield1.setVisible(true);
                this.m_blankfield2.setVisible(true);
                this.m_lblMinutes.setVisible(false);
                this.m_txtMinutes.setVisible(false);
                this.m_cmbReturnCodeCondition.setVisible(false);
                this.m_txtReturnCode.setVisible(false);
            }
        }
    }

    public JobEventInfo getJobEvent() {
        return this.m_jobevent;
    }

    @Override
    public boolean validateData() {
        String errormessage;
        this.m_jobevent.setEventType(((DisplayMap)this.m_cmbevents.getSelectedItem()).getIntValue());
        switch (this.m_jobevent.getEventType()) {
            case 3: 
            case 13: {
                if (this.m_txtReturnCode.getText().equalsIgnoreCase("")) {
                    MessageUtil.displayMessage(this.m_frame, m_bundle.getString("JobEventPanel.ReturnCodeBlank.txt"), m_bundle.getString("JobEventPanel.ErrorMsg.Title.txt"), 0, -1);
                    return false;
                }
                DisplayMap entry = (DisplayMap)this.m_cmbReturnCodeCondition.getSelectedItem();
                this.m_jobevent.setOperator(entry.getIntValue());
                this.m_jobevent.setValue(Integer.parseInt(this.m_txtReturnCode.getText()));
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 15: {
                if (this.m_txtMinutes.getText().equalsIgnoreCase("")) {
                    MessageUtil.displayMessage(this.m_frame, m_bundle.getString("JobEventPanel.MinutesBlank.txt"), m_bundle.getString("JobEventPanel.ErrorMsg.Title.txt"), 0, -1);
                    return false;
                }
                this.m_jobevent.setOperator(-1);
                this.m_jobevent.setValue(Integer.parseInt(this.m_txtMinutes.getText()));
                break;
            }
            default: {
                this.m_jobevent.setOperator(-1);
                this.m_jobevent.setValue(0);
            }
        }
        if (!this.m_editmode) {
            String checkID = this.m_dependentJob.getId();
            String dependencyID = this.m_jobevent.toString() + checkID;
            int numEvents = this.m_jobEvents != null ? this.m_jobEvents.size() : 0;
            for (int i = 0; i < numEvents; ++i) {
                String id;
                DisplayInfo info = (DisplayInfo)this.m_jobEvents.get(i);
                String string = id = info != null ? info.getId() : null;
                if (id == null || dependencyID.compareTo(id) != 0) continue;
                MessageUtil.displayMessage(this.m_frame, m_bundle.getString("JobEventPanel.DuplicateEventError.txt"), m_bundle.getString("JobEventPanel.ErrorMsg.Title.txt"), 0, -1);
                return false;
            }
        }
        if ((errormessage = this.checkForCircularDeps(this.m_flow)) != null) {
            MessageUtil.displayMessage(this.m_frame, errormessage, m_bundle.getString("JobEventPanel.ErrorMsg.Title.txt"), 0, -1);
            return false;
        }
        return true;
    }

    private String checkForCircularDeps(FlowInfo flow) {
        return null;
    }

    static {
        String strClassName = JobEventPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    private static class DisplayMap {
        private String mc_displayText;
        private int mc_intValue;

        public DisplayMap(String displayText, int value) {
            this.mc_displayText = displayText;
            this.mc_intValue = value;
        }

        public String toString() {
            return this.mc_displayText;
        }

        public int getIntValue() {
            return this.mc_intValue;
        }
    }
}

