/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DeployedJobInterface;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.JobDeployerInterface;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SASFolder;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerResultSet;
import com.sas.scheduler.visuals.swing.DeployJobPanel;
import com.sas.scheduler.visuals.swing.DirectoryPanel;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.ProgressIndicator;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;

public class DeployedJobDialog
extends StandardDialog
implements DeployedJobInterface {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    public static final String Default_Title;
    private static final String FILEPLACEHOLDER = "$INPUT$";
    private static final String RUNASPLACEHOLDER = "$USER$";
    protected String m_name;
    protected String m_title;
    protected JobDeployerInterface m_callback;
    protected PromptCallbackInterface m_prompt = null;
    protected List<BatchServerInfo> m_batchservers;
    protected boolean m_preserve = false;
    protected boolean m_hideSourceFile = false;
    protected SASFolder m_folder;
    protected String m_fileContent;
    protected DeployJobPanel m_jobpanel;
    protected String m_initpath = null;
    protected SASFolder m_initfolder = null;
    protected String m_srcpath = null;
    protected String m_srcname = null;
    protected String m_targetname = null;
    protected String m_basename = null;
    protected String m_fullname = null;
    protected DirectoryInfo m_dir;
    protected List<DisplayInfo> m_jobObjects = new Vector<DisplayInfo>();
    protected boolean m_multiselect = true;
    protected SchedulerResultSet m_results;
    private Map<String, BatchServerInfo> _workspaceCache = Collections.synchronizedMap(new HashMap());

    public DeployedJobDialog(Frame owner, String name, String title, List<BatchServerInfo> batchservers, JobDeployerInterface callback, PromptCallbackInterface prompt, boolean showSourceFile, SASFolder folder, String fileContent) throws SchedulerException {
        this(owner, name, title, batchservers, callback, prompt, false, showSourceFile, folder, fileContent);
    }

    public DeployedJobDialog(Frame owner, List<?> jobs, List<BatchServerInfo> batchservers, JobDeployerInterface callback, PromptCallbackInterface prompt, String title, boolean showSourceFile, SASFolder folder, String fileContent) throws SchedulerException {
        this(owner, DeployedJobDialog.convertJobListToFilename(jobs), title, batchservers, callback, prompt, false, showSourceFile, folder, fileContent);
        int numJobs = jobs.size();
        if (numJobs > 0) {
            DisplayInfo job = (DisplayInfo)jobs.get(0);
            this.m_jobObjects.add(0, job);
            for (int i = 1; i < numJobs; ++i) {
                job = (DisplayInfo)jobs.get(i);
                this.m_jobObjects.add(i, job);
            }
        }
    }

    private static String convertJobListToFilename(List<?> jobs) {
        StringBuffer name = new StringBuffer();
        int numJobs = jobs.size();
        if (numJobs <= 0) {
            return null;
        }
        name.append(((DisplayInfo)jobs.get(0)).getName());
        for (int i = 1; i < numJobs; ++i) {
            name.append(";");
            name.append(((DisplayInfo)jobs.get(i)).getName());
        }
        return name.toString();
    }

    protected DeployedJobDialog(Frame owner, String name, String title, List<BatchServerInfo> batchservers, JobDeployerInterface callback, PromptCallbackInterface prompt, boolean preservation, boolean hideSourceFile, SASFolder folder, String fileContent) throws SchedulerException {
        super(owner, title, true);
        this.m_title = title;
        this.m_name = name;
        this.m_batchservers = batchservers;
        this.m_callback = callback;
        this.m_prompt = prompt;
        this.m_preserve = preservation;
        this.m_hideSourceFile = hideSourceFile;
        this.m_folder = folder;
        this.m_fileContent = fileContent;
        this.setHelpProduct("scheduler");
        this.setHelpTopic("window_deploy_ds_program");
        this.initialize();
    }

    private void initialize() throws SchedulerException {
        if (this.m_batchservers == null || this.m_batchservers.size() == 0) {
            throw new SchedulerException(m_bundle.getString("DeployedJobDialog.Error.NoBatchServers.txt"));
        }
        this.m_jobpanel = new DeployJobPanel(this.m_batchservers, this.m_title, this.m_hideSourceFile, this.m_preserve);
        ActionListener deploydirListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchServerInfo bsinfo = DeployedJobDialog.this.m_jobpanel.getSelectedServer();
                DirectoryInfo dirInfo = DeployedJobDialog.this.m_jobpanel.getSelectedDirectory();
                if (dirInfo != null) {
                    DeployedJobDialog.this.m_jobpanel.setSelectedJCLDirectory(dirInfo);
                }
                if (bsinfo.getOperatingSystem() == 2) {
                    DeployedJobDialog.this.updateJCLInBackground(bsinfo);
                }
            }
        };
        this.m_jobpanel.addBatchServerListener(deploydirListener);
        this.m_jobpanel.addDirListener(deploydirListener);
        BatchServerInfo bsinfo = this.m_jobpanel.getSelectedServer();
        if (bsinfo != null && bsinfo.getOperatingSystem() == 2) {
            this.updateJCLInBackground(bsinfo);
        }
        ActionListener newdirListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!DeployedJobDialog.this.btnNewDirOnclicked()) {
                        MessageUtil.displayMessage(DeployedJobDialog.this.m_frame, m_bundle.getString("DeployedJobDialog.Warning.NewDir.txt"), DeployedJobDialog.this.m_title, 2, -1);
                    }
                }
                catch (RuntimeException ex) {
                    String message = ex.getLocalizedMessage();
                    if (message == null || message.length() == 0) {
                        message = m_bundle.getString("DeployedJobDialog.Warning.NewDir.txt");
                    }
                    MessageUtil.displayMessage(DeployedJobDialog.this.m_frame, ex.getLocalizedMessage(), DeployedJobDialog.this.m_title, 0, -1);
                }
            }
        };
        this.m_jobpanel.addNewDirListener(newdirListener);
        ActionListener browseListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filename;
                BatchServerInfo bsinfo = DeployedJobDialog.this.m_jobpanel.getSelectedServer();
                if (DeployedJobDialog.this.m_callback.getWorkspaceServerFromCache(bsinfo) == null) {
                    DeployedJobDialog.this._workspaceCache.put(bsinfo.getId(), bsinfo);
                }
                if ((filename = DeployedJobDialog.this.m_prompt.browseFileSystem(bsinfo, DeployedJobDialog.this.m_title, DeployedJobDialog.this.m_initpath, ";", DeployedJobDialog.this.m_multiselect)) != null) {
                    DeployedJobDialog.this.m_jobpanel.setFilename(filename);
                }
            }
        };
        this.m_jobpanel.addBrowseListener(browseListener);
        PropertyChangeListener filenameListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String filename = DeployedJobDialog.this.m_jobpanel.getFilename();
                String[] files = filename.split(";");
                String names = null;
                for (int y = 0; y < files.length; ++y) {
                    filename = files[y];
                    if (filename.length() <= 0) continue;
                    try {
                        String name = null;
                        int index = filename.lastIndexOf("\\");
                        if (index == -1) {
                            index = filename.lastIndexOf("/");
                        }
                        if ((index = (name = index >= 0 ? filename.substring(index + 1) : filename).lastIndexOf(46)) > 0) {
                            name = name.substring(0, index);
                        }
                        if (names != null) {
                            String[] currentList = names.split(";");
                            name = DeployedJobDialog.this.m_callback.uniqueName(name, currentList);
                        } else {
                            name = DeployedJobDialog.this.m_callback.uniqueName(name, null);
                        }
                        names = names == null ? name : names + ";" + name;
                    }
                    catch (RuntimeException ex) {
                        ex.printStackTrace();
                        DeployedJobDialog.this.m_jobpanel.setJobName("");
                    }
                    DeployedJobDialog.this.m_jobpanel.setJobName(names);
                }
            }
        };
        this.m_jobpanel.addFilenameListener(filenameListener);
        ActionListener selectFolderListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SASFolder folder = DeployedJobDialog.this.selectFolders();
                if (folder != null) {
                    DeployedJobDialog.this.m_folder = folder;
                    String name = folder.getLocation();
                    DeployedJobDialog.this.m_jobpanel.setFolder(name);
                }
            }
        };
        this.m_jobpanel.addSelectFolderListener(selectFolderListener);
        this.m_jobpanel.setFilename(this.m_name);
        if (this.m_folder == null && this.m_initfolder != null) {
            this.m_folder = this.m_initfolder;
        }
        if (!this.m_preserve && this.m_folder != null) {
            String name = this.m_folder.getLocation();
            this.m_jobpanel.setFolder(name);
        }
        StandardPanel mainpanel = new StandardPanel();
        mainpanel.setLayout(new GridBagLayout());
        GridBagConstraints jobpanel_gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 28, 0);
        mainpanel.add((Component)this.m_jobpanel, jobpanel_gbc);
        this.setMainPanel(mainpanel);
    }

    public String getDirectoryName() {
        if (this.m_dir != null) {
            return this.m_dir.getName();
        }
        return null;
    }

    public boolean setDefaultDirectory(String dirname) {
        return this.m_jobpanel.setSelectedDirectory(dirname);
    }

    public BatchServerInfo getBatchServer() {
        return this.m_jobpanel.getSelectedServer();
    }

    public boolean setDefaultBatchServer(String batchserver) {
        return this.m_jobpanel.setSelectedServer(batchserver);
    }

    public String getSourcePath() {
        return this.m_srcpath;
    }

    public boolean setDefaultSourcePath(String initpath) {
        this.m_initpath = initpath;
        return true;
    }

    public String getFileContent() {
        return this.m_fileContent;
    }

    public String getFolder() {
        return this.m_jobpanel.getFolder();
    }

    public SASFolder getSASFolder() {
        if (this.m_folder == null && this.m_jobpanel.getFolder().compareTo(DeployJobPanel.FOLDER_PRESERVE_PREVIOUS_VALUE) == 0) {
            SASFolder folder = new SASFolder(DeployJobPanel.FOLDER_PRESERVE_PREVIOUS_VALUE);
            return folder;
        }
        return this.m_folder;
    }

    public boolean setDefaultFolder(String initfolder) {
        this.m_initfolder = this.m_callback.getFolder(initfolder);
        this.m_jobpanel.setFolder(initfolder);
        this.m_folder = this.m_initfolder;
        return true;
    }

    public String[] getDeployedJobNames() {
        return this.m_jobpanel.getJobName().split(";");
    }

    public List<DisplayInfo> getAssociatedJobs() {
        return this.m_jobObjects;
    }

    public List<JobInfo> getDeployedJobs() {
        return null;
    }

    public String[] getSourceFileNames() {
        return this.m_jobpanel.getFilename().split(";");
    }

    public DirectoryInfo getSelectedDirectory() {
        return this.m_jobpanel.getSelectedDirectory();
    }

    public int getNumberOfDirectories() {
        return this.m_jobpanel.getNumDirectories();
    }

    public String getJCL() {
        return this.m_jobpanel.getJCL();
    }

    public String getJCLPath() {
        return this.m_jobpanel.getSelectedJCLDirectory().getPath();
    }

    public SchedulerResultSet getResults() {
        return this.m_results;
    }

    @Override
    protected boolean onOK() throws SchedulerException {
        this.m_eReturnValue = 64;
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.m_jobpanel.validateData()) {
            try {
                block7: {
                    this.m_results = this.m_callback.deploy((DeployedJobInterface)this);
                    this.setCursor(Cursor.getDefaultCursor());
                    if (this.m_results.getReturnValue() == 0) {
                        return false;
                    }
                    this.m_eReturnValue = 1;
                    try {
                        Set<String> keys = this._workspaceCache.keySet();
                        Iterator<String> i = keys.iterator();
                        while (i.hasNext()) {
                            BatchServerInfo binfo = this._workspaceCache.get(i.next());
                            this.m_callback.disconnectFromWorkspaceServer(binfo);
                        }
                    }
                    catch (Exception e) {
                        boolean debug;
                        boolean bl = debug = System.getProperty("Debug") != null;
                        if (!debug) break block7;
                        e.printStackTrace();
                    }
                }
                return true;
            }
            catch (RuntimeException e) {
                this.m_results = new SchedulerResultSet(0, e.toString(), 0, this.m_jobObjects);
                this.m_prompt.showResults(this.m_title, this.m_results);
                this.m_frame.setCursor(Cursor.getDefaultCursor());
                return false;
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.m_results = new SchedulerResultSet(0, this.m_jobpanel.getErrorMessage(), 0, this.m_jobObjects);
        this.m_prompt.showResults(this.m_title, this.m_results);
        return false;
    }

    @Override
    protected boolean onCancel() throws SchedulerException {
        block3: {
            try {
                Set<String> keys = this._workspaceCache.keySet();
                Iterator<String> i = keys.iterator();
                while (i.hasNext()) {
                    BatchServerInfo binfo = this._workspaceCache.get(i.next());
                    this.m_callback.disconnectFromWorkspaceServer(binfo);
                }
            }
            catch (Exception e) {
                boolean debug;
                boolean bl = debug = System.getProperty("Debug") != null;
                if (!debug) break block3;
                e.printStackTrace();
            }
        }
        return super.onCancel();
    }

    protected SASFolder selectFolders() {
        String initfolder = "";
        if (this.m_initfolder == null) {
            initfolder = this.m_jobpanel.getFolder();
            if (initfolder.compareTo(DeployJobPanel.FOLDER_PRESERVE_PREVIOUS_VALUE) == 0) {
                initfolder = "";
            } else {
                this.m_initfolder = this.m_callback.getFolder(initfolder);
            }
        } else {
            initfolder = this.m_initfolder.getLocation();
        }
        return this.m_prompt.browseSASFolders(initfolder);
    }

    private void updateJCLInBackground(BatchServerInfo bsinfo) {
        String msg = m_bundle.getString("DeployedJobDialog.BuildJCLProgressIndicator.Message.txt");
        ProgressIndicator request = new ProgressIndicator(this.m_frame, msg, this.m_title);
        request.setDelayBeforeProgressCancelDialog(5);
        boolean connected = this.m_callback.checkConnectionToWorkspaceServer(bsinfo);
        if (connected) {
            cRunnable_UpdateJCL jclinit = new cRunnable_UpdateJCL(bsinfo);
            request.execute(jclinit);
        } else {
            MessageUtil.displayMessage(this.m_frame, m_bundle.getString("DeployedJobDialog.Warning.UnableToConnectToAppServer.NoJCL.txt"), this.m_title, 2, -1);
        }
    }

    protected void updateJCL(BatchServerInfo bsinfo) {
        if (bsinfo.getOperatingSystem() == 2) {
            try {
                String dirString = "./";
                DirectoryInfo dinfo = this.m_jobpanel.getSelectedDirectory();
                if (dinfo != null) {
                    dirString = dinfo.getPath();
                }
                String jcl = this.GenerateJCLFromTemplate(dirString, this.m_callback.getJCLTemplate(bsinfo));
                this.m_jobpanel.setJCL(jcl);
            }
            catch (RuntimeException ex) {
                String message = ex.getLocalizedMessage();
                if (message == null || message.length() == 0) {
                    message = ex.toString();
                }
                MessageUtil.displayMessage(this.m_frame, message, this.m_title, 0, -1);
            }
        }
    }

    protected boolean btnNewDirOnclicked() {
        StandardDialog dlg = new StandardDialog(this, m_bundle.getString("DeployedJobDialog.NewDirectory.txt"), true);
        DirectoryPanel panel = new DirectoryPanel(this.m_callback.getExistingDeploymentDirectories(this.m_jobpanel.getSelectedServer()), this.m_frame);
        panel.addBrowseListener(new cBrowseAction(panel));
        dlg.setMainPanel(panel);
        dlg.setHelpProduct("scheduler");
        dlg.setHelpTopic("window_newdeploymentdir");
        dlg.makeVisible();
        boolean rc = true;
        DirectoryInfo dir = panel.getDirectory();
        if (1 == dlg.getReturnValue() && (rc = this.m_jobpanel.addDirectory(dir))) {
            try {
                rc = this.m_callback.updateSASAppServerDirectories(this.m_jobpanel.getSelectedServer(), this.m_jobpanel.getDirectories());
            }
            catch (SchedulerException ex) {
                rc = false;
                String message = ex.getLocalizedMessage();
                if (message == null || message.length() == 0) {
                    message = ex.toString();
                }
                MessageUtil.displayMessage(this.m_frame, message, this.m_title, 0, -1);
            }
        }
        return rc;
    }

    public String GenerateJCLFromTemplate(String filepath, String template) {
        if (template == null) {
            return null;
        }
        String jcl = template;
        if (filepath.indexOf("/") < 0) {
            jcl = DeployedJobDialog.replaceString(jcl, "//*SYSIN   DD DISP=SHR", "//SYSIN    DD DISP=SHR");
            jcl = DeployedJobDialog.replaceString(jcl, "//*           DSN=", "//            DSN=");
            jcl = DeployedJobDialog.replaceString(jcl, "//SYSIN    DD PATHOPTS", "//*SYSIN   DD PATHOPTS");
            jcl = DeployedJobDialog.replaceString(jcl, "//            PATH=", "//*           PATH=");
        } else {
            jcl = DeployedJobDialog.replaceString(jcl, "//SYSIN    DD DISP=SHR", "//*SYSIN   DD DISP=SHR");
            jcl = DeployedJobDialog.replaceString(jcl, "//            DSN=", "//*           DSN=");
            jcl = DeployedJobDialog.replaceString(jcl, "//*SYSIN   DD PATHOPTS", "//SYSIN    DD PATHOPTS");
            jcl = DeployedJobDialog.replaceString(jcl, "//*           PATH=", "//            PATH=");
        }
        return jcl;
    }

    public String GenerateJCLFromTemplate(String filename, String runas, String template) {
        String jcl = template;
        if (filename.length() > 0) {
            StringBuffer neoFilename = new StringBuffer();
            int pathLength = filename.length();
            int index = 0;
            int start = 20;
            if (filename.indexOf("/") < 0) {
                jcl = DeployedJobDialog.replaceString(jcl, FILEPLACEHOLDER, filename);
            } else {
                if (pathLength > 71 - start) {
                    neoFilename.append(filename.substring(0, 71 - start) + "+\n");
                    index = 71 - start;
                    pathLength -= index;
                    while (index + 56 <= pathLength) {
                        neoFilename.append("//             " + filename.substring(index, index + 56) + "+\n");
                        index += 56;
                    }
                    neoFilename.append("//             " + filename.substring(index));
                } else {
                    neoFilename.append(filename);
                }
                String uss = "PATH='$INPUT$";
                jcl = DeployedJobDialog.replaceString(jcl, uss, "PATH='" + neoFilename.toString());
            }
        }
        if (runas != null && runas.length() > 0) {
            jcl = DeployedJobDialog.replaceString(jcl, RUNASPLACEHOLDER, runas);
        }
        return jcl;
    }

    private static String replaceString(String s, String searchString, String replaceString) {
        while (s.indexOf(searchString) != -1) {
            if (s.startsWith(searchString)) {
                s = replaceString + s.substring(s.indexOf(searchString) + searchString.length());
                continue;
            }
            s = s.substring(0, s.indexOf(searchString)) + replaceString + s.substring(s.indexOf(searchString) + searchString.length());
        }
        return s;
    }

    static {
        String strClassName = DeployedJobDialog.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        Default_Title = m_bundle.getString("DeployedJobDialog.Title.txt");
    }

    private class cRunnable_UpdateJCL
    implements Runnable {
        private BatchServerInfo mc_bsinfo;

        public cRunnable_UpdateJCL(BatchServerInfo bsinfo) {
            this.mc_bsinfo = bsinfo;
        }

        @Override
        public void run() {
            DeployedJobDialog.this.updateJCL(this.mc_bsinfo);
        }
    }

    protected class cBrowseAction
    implements ActionListener {
        DirectoryPanel mc_panel;

        public cBrowseAction(DirectoryPanel panel) {
            this.mc_panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String text = DeployedJobDialog.this.m_prompt.launchDirChooser(DeployedJobDialog.this.m_jobpanel.getSelectedServer(), DeployedJobDialog.this.m_title);
            if (text != null) {
                this.mc_panel.setDirectoryText(text);
            }
        }
    }
}

