/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.visuals.swing.MaxDimension;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;

public class DeployJobPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    public static final String BATCHSERVER_PRESERVE_PREVIOUS_VALUE;
    public static final String FOLDER_PRESERVE_PREVIOUS_VALUE;
    private static final BatchServerInfo preserveServer;
    private BatchServerInfo m_batchserver;
    private List<BatchServerInfo> m_servers;
    private String m_errormsg;
    private JPanel m_commonPanel;
    private boolean m_dirty = false;
    private JLabel m_serverlabel;
    private JComboBox m_comboServers = new JComboBox();
    private JTextField m_filename = new JTextField();
    private JButton m_browse = new JButton();
    private JLabel m_dirlabel;
    private JComboBox m_directories = new JComboBox();
    private JButton m_newdir = new JButton();
    private JLabel m_namelabel;
    private JTextField m_name = new JTextField();
    private JLabel m_folderlabel;
    private JTextField m_folder = new JTextField();
    private JButton m_selectFolder = new JButton();
    private JPanel m_zOSPanel;
    private JComboBox m_jcldirs = new JComboBox();
    private JTextArea m_editpanel;
    private boolean m_hideSource = false;
    private boolean m_preserve = false;
    private PropertyChangeListener m_pclFilename = null;
    public static final String FILE_SEPARATOR = ";";
    private static final int FIELD_WIDTH = 350;
    private static final int FIELD_HEIGHT = 20;
    private static final int PANE_WIDTH = 550;
    private static final int PANE_HEIGHT = 300;
    private static final int PANE_ROWS = 10;

    public DeployJobPanel(List<BatchServerInfo> servers) {
        this(servers, m_bundle.getString("DeployJobPanel.Title.txt"), false, false);
    }

    public DeployJobPanel(List<BatchServerInfo> servers, boolean hideSourceFile, boolean preservation) {
        this(servers, m_bundle.getString("DeployJobPanel.Title.txt"), hideSourceFile, preservation);
    }

    public DeployJobPanel(List<BatchServerInfo> servers, String title, boolean hideSourceFile, boolean preservation) {
        this.setName(title);
        this.m_servers = servers;
        this.m_hideSource = hideSourceFile;
        this.m_preserve = preservation;
        this._initialize();
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_servers = null;
        this.m_commonPanel = null;
        this.m_serverlabel = null;
        this.m_comboServers = null;
        this.m_browse = null;
        this.m_dirlabel = null;
        this.m_newdir = null;
        this.m_namelabel = null;
        this.m_folderlabel = null;
        this.m_selectFolder = null;
    }

    public BatchServerInfo getSelectedServer() {
        this.serverSelectionChanged();
        return this.m_batchserver;
    }

    public boolean setSelectedServer(String id) {
        int num = this.m_comboServers.getItemCount();
        for (int i = 0; i < num; ++i) {
            BatchServerInfo binfo = (BatchServerInfo)this.m_comboServers.getItemAt(i);
            if (binfo.getId().compareTo(id) != 0) continue;
            this.m_comboServers.setSelectedIndex(i);
            this.serverSelectionChanged();
            return true;
        }
        return false;
    }

    public boolean setSelectedServer(BatchServerInfo info) {
        int num = this.m_comboServers.getItemCount();
        for (int i = 0; i < num; ++i) {
            BatchServerInfo binfo = (BatchServerInfo)this.m_comboServers.getItemAt(i);
            if (binfo.getName().compareTo(info.getName()) != 0) continue;
            this.m_comboServers.setSelectedIndex(i);
            this.serverSelectionChanged();
            return true;
        }
        return false;
    }

    public List<DirectoryInfo> getDirectories() {
        ArrayList<DirectoryInfo> directories = new ArrayList<DirectoryInfo>();
        int num = this.m_directories.getItemCount();
        for (int i = 0; i < num; ++i) {
            DirectoryInfo info = (DirectoryInfo)this.m_directories.getItemAt(i);
            directories.add(info);
        }
        return directories;
    }

    public DirectoryInfo getSelectedDirectory() {
        return (DirectoryInfo)this.m_directories.getSelectedItem();
    }

    public boolean setSelectedDirectory(String dirname) {
        int num = this.m_directories.getItemCount();
        for (int i = 0; i < num; ++i) {
            DirectoryInfo binfo = (DirectoryInfo)this.m_directories.getItemAt(i);
            if (binfo.getName().compareTo(dirname) != 0) continue;
            this.m_directories.setSelectedIndex(i);
            this.serverSelectionChanged();
            return true;
        }
        return false;
    }

    public boolean setSelectedDirectory(DirectoryInfo info) {
        int num = this.m_directories.getItemCount();
        for (int i = 0; i < num; ++i) {
            DirectoryInfo binfo = (DirectoryInfo)this.m_directories.getItemAt(i);
            if (binfo.getName().compareTo(info.getName()) != 0) continue;
            this.m_directories.setSelectedIndex(i);
            this.serverSelectionChanged();
            return true;
        }
        return false;
    }

    public DirectoryInfo getSelectedJCLDirectory() {
        return (DirectoryInfo)this.m_jcldirs.getSelectedItem();
    }

    public boolean setSelectedJCLDirectory(DirectoryInfo info) {
        int num = this.m_jcldirs.getItemCount();
        for (int i = 0; i < num; ++i) {
            DirectoryInfo binfo = (DirectoryInfo)this.m_jcldirs.getItemAt(i);
            if (binfo.getName().compareTo(info.getName()) != 0) continue;
            this.m_jcldirs.setSelectedIndex(i);
            this.serverSelectionChanged();
            return true;
        }
        return false;
    }

    public int getNumDirectories() {
        return this.m_directories.getItemCount();
    }

    public String getJobName() {
        return this.m_name.getText();
    }

    public boolean setJobName(String name) {
        this.m_name.setText(name);
        return true;
    }

    public String getFilename() {
        return this.m_filename.getText();
    }

    public boolean isJobNameVisible() {
        return this.m_name.isVisible();
    }

    private void checkFilenameforList() {
        String filename = this.m_filename.getText();
        int index = filename.indexOf(FILE_SEPARATOR);
        if (index >= 0) {
            this.m_namelabel.setVisible(false);
            this.m_name.setVisible(false);
        } else {
            this.m_namelabel.setVisible(true);
            this.m_name.setVisible(true);
        }
    }

    public boolean setFilename(String name) {
        this.m_filename.setText(name);
        this.checkFilenameforList();
        this.m_filename.firePropertyChange("setText", false, true);
        return true;
    }

    public String getFolder() {
        return this.m_folder.getText();
    }

    public boolean setFolder(String name) {
        this.m_folder.setText(name);
        this.m_folder.setToolTipText(name);
        this.m_folder.firePropertyChange("setText", false, true);
        return true;
    }

    public String getJCL() {
        if (this.m_zOSPanel.isVisible()) {
            return this.m_editpanel.getText();
        }
        return null;
    }

    public boolean setJCL(String text) {
        if (this.m_zOSPanel.isVisible()) {
            this.m_editpanel.setText(text);
            this.m_editpanel.firePropertyChange("setJCL", false, true);
            return true;
        }
        return false;
    }

    public boolean addDirectory(DirectoryInfo dir) {
        if (this.m_batchserver.addDirectory(dir)) {
            this.m_directories.addItem(dir);
            this.m_directories.setSelectedItem(dir);
            if (this.m_batchserver.getOperatingSystem() == 2) {
                this.m_jcldirs.addItem(dir);
                this.m_jcldirs.setSelectedItem(dir);
            }
            return true;
        }
        return false;
    }

    public void addNewDirListener(ActionListener al) {
        this.m_newdir.addActionListener(al);
        this.m_newdir.setVisible(true);
        this.m_commonPanel.invalidate();
    }

    public void addDirListener(ActionListener al) {
        this.m_directories.addActionListener(al);
    }

    public void addBrowseListener(ActionListener al) {
        this.m_browse.addActionListener(al);
        if (!this.m_hideSource) {
            this.m_browse.setVisible(true);
        }
        this.m_commonPanel.invalidate();
    }

    public void addSelectFolderListener(ActionListener al) {
        this.m_selectFolder.addActionListener(al);
        this.m_selectFolder.setVisible(true);
        this.m_commonPanel.invalidate();
    }

    public void addFilenameListener(PropertyChangeListener pcl) {
        this.m_pclFilename = pcl;
        this.m_filename.addPropertyChangeListener("setText", this.m_pclFilename);
    }

    public void resetFilenameListener(PropertyChangeListener pcl) {
        if (this.m_pclFilename != null) {
            this.m_filename.removePropertyChangeListener(this.m_pclFilename);
        }
        this.addFilenameListener(pcl);
    }

    public void addBatchServerListener(ActionListener al) {
        this.m_comboServers.addActionListener(al);
    }

    public void addJCLListener(PropertyChangeListener pcl) {
        this.m_editpanel.addPropertyChangeListener("setJCL", pcl);
    }

    public String getErrorMessage() {
        return this.m_errormsg;
    }

    @Override
    public boolean validateData() {
        DirectoryInfo directory = this.getSelectedDirectory();
        if (!(this.m_preserve || directory != null && directory.getPath().length() > 0)) {
            this.m_errormsg = m_bundle.getString("DeployJobPanel.Error.Invalid_DirName.txt");
            return false;
        }
        String filename = this.getFilename();
        if (filename == null || filename.length() <= 0) {
            this.m_errormsg = m_bundle.getString("DeployJobPanel.Error.Invalid_Filename.txt");
            return false;
        }
        String name = this.getJobName();
        if (name == null || name.length() <= 0) {
            this.m_errormsg = m_bundle.getString("DeployJobPanel.Error.Invalid_JobName.txt");
            return false;
        }
        String folder = this.getFolder();
        if (folder == null || folder.length() <= 0) {
            this.m_errormsg = m_bundle.getString("DeployJobPanel.Error.Invalid_Folder.txt");
            return false;
        }
        if (this.m_zOSPanel.isVisible() && ((directory = this.getSelectedJCLDirectory()) == null || directory.getPath().length() <= 0)) {
            this.m_errormsg = m_bundle.getString("DeployJobPanel.Error.Invalid_JCLDirName.txt");
            return false;
        }
        this.m_errormsg = null;
        return true;
    }

    private void _initialize() {
        if (this.m_preserve) {
            this.setFolder(FOLDER_PRESERVE_PREVIOUS_VALUE);
            this.m_comboServers.addItem(preserveServer);
        }
        for (BatchServerInfo server : this.m_servers) {
            this.m_comboServers.addItem(server);
        }
        this.m_comboServers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeployJobPanel.this.serverSelectionChanged();
            }
        });
        this.m_filename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeployJobPanel.this.checkFilenameforList();
                DeployJobPanel.this.m_filename.firePropertyChange("setText", false, true);
            }
        });
        this.m_filename.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DeployJobPanel.this.m_dirty = false;
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (DeployJobPanel.this.m_dirty) {
                    DeployJobPanel.this.checkFilenameforList();
                    DeployJobPanel.this.m_filename.firePropertyChange("setText", false, true);
                }
            }
        });
        this.m_filename.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DeployJobPanel.this.m_dirty = true;
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.createCommonPanel();
        this.createzOSPanel();
        this.layoutComponents();
        this.serverSelectionChanged();
    }

    private void createCommonPanel() {
        this.m_commonPanel = new JPanel();
        String serverText = m_bundle.getString("DeployJobPanel.BatchServerLabel.txt");
        this.m_serverlabel = new JLabel(Util.getLabelWithoutMnemonic((String)serverText));
        this.m_serverlabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)serverText));
        this.m_serverlabel.setLabelFor(this.m_comboServers);
        String dirText = m_bundle.getString("DeployJobPanel.DirectoryLabel.txt");
        this.m_dirlabel = new JLabel(Util.getLabelWithoutMnemonic((String)dirText));
        this.m_dirlabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)dirText));
        this.m_dirlabel.setLabelFor(this.m_directories);
        String newdirText = m_bundle.getString("DeployJobPanel.NewDir.txt");
        this.m_newdir.setText(Util.getLabelWithoutMnemonic((String)newdirText));
        this.m_newdir.setMnemonic(Util.getDisplayedMnemonic((String)newdirText));
        this.m_newdir.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)newdirText));
        String fileText = m_bundle.getString("DeployJobPanel.FilenameLabel.txt");
        JLabel filelabel = new JLabel(Util.getLabelWithoutMnemonic((String)fileText));
        filelabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)fileText));
        filelabel.setLabelFor(this.m_filename);
        String browseText = m_bundle.getString("DeployJobPanel.Browse.txt");
        this.m_browse.setText(Util.getLabelWithoutMnemonic((String)browseText));
        this.m_browse.setMnemonic(Util.getDisplayedMnemonic((String)browseText));
        this.m_browse.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)browseText));
        String nameText = m_bundle.getString("DeployJobPanel.JobNameLabel.txt");
        this.m_namelabel = new JLabel(Util.getLabelWithoutMnemonic((String)nameText));
        this.m_namelabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)nameText));
        this.m_namelabel.setLabelFor(this.m_name);
        String folderText = m_bundle.getString("DeployJobPanel.FolderLabel.txt");
        this.m_folderlabel = new JLabel(Util.getLabelWithoutMnemonic((String)folderText));
        this.m_folderlabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)folderText));
        this.m_folderlabel.setLabelFor(this.m_folder);
        this.m_folder.setEditable(false);
        String selectText = m_bundle.getString("DeployJobPanel.Select.txt");
        this.m_selectFolder.setText(Util.getLabelWithoutMnemonic((String)selectText));
        this.m_selectFolder.setMnemonic(Util.getDisplayedMnemonic((String)selectText));
        this.m_selectFolder.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)selectText));
        MaxDimension dim = new MaxDimension(0, 0);
        dim.max(this.m_newdir.getPreferredSize());
        dim.max(this.m_browse.getPreferredSize());
        dim.max(this.m_selectFolder.getPreferredSize());
        this.m_newdir.setPreferredSize(dim);
        this.m_browse.setPreferredSize(dim);
        this.m_selectFolder.setPreferredSize(dim);
        GridBagConstraints gbc_serversLabel = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_servers = new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_filenameLabel = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(12, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_filename = new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 18, 2, new Insets(12, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_browse = new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_directoriesLabel = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(12, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_directories = new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 18, 0, new Insets(12, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_newdir = new GridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_nameLabel = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 0, new Insets(7, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_name = new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 18, 2, new Insets(7, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_folderLabel = new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 0, new Insets(7, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_folder = new GridBagConstraints(1, 4, 2, 1, 1.0, 1.0, 18, 2, new Insets(7, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_selectFolder = new GridBagConstraints(3, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0);
        Dimension fielddim = new Dimension(350, 20);
        this.m_comboServers.setPreferredSize(fielddim);
        this.m_directories.setPreferredSize(fielddim);
        this.m_directories.setAutoscrolls(true);
        this.m_directories.setRenderer(new MyCellRenderer());
        this.m_filename.setPreferredSize(fielddim);
        if (this.m_hideSource) {
            filelabel.setVisible(false);
            this.m_filename.setVisible(false);
        }
        this.m_name.setPreferredSize(fielddim);
        this.m_commonPanel.setLayout(new GridBagLayout());
        this.m_commonPanel.add((Component)this.m_serverlabel, gbc_serversLabel);
        this.m_commonPanel.add((Component)this.m_comboServers, gbc_servers);
        this.m_commonPanel.add((Component)this.m_dirlabel, gbc_directoriesLabel);
        this.m_commonPanel.add((Component)this.m_directories, gbc_directories);
        this.m_commonPanel.add((Component)this.m_newdir, gbc_newdir);
        this.m_commonPanel.add((Component)filelabel, gbc_filenameLabel);
        this.m_commonPanel.add((Component)this.m_filename, gbc_filename);
        this.m_commonPanel.add((Component)this.m_browse, gbc_browse);
        this.m_commonPanel.add((Component)this.m_namelabel, gbc_nameLabel);
        this.m_commonPanel.add((Component)this.m_name, gbc_name);
        this.m_commonPanel.add((Component)this.m_folderlabel, gbc_folderLabel);
        this.m_commonPanel.add((Component)this.m_folder, gbc_folder);
        this.m_commonPanel.add((Component)this.m_selectFolder, gbc_selectFolder);
        this.m_newdir.setVisible(false);
        this.m_browse.setVisible(false);
    }

    private void serverSelectionChanged() {
        if (!this.m_comboServers.isVisible()) {
            this.m_zOSPanel.setVisible(false);
            return;
        }
        BatchServerInfo oSelectedItem = (BatchServerInfo)this.m_comboServers.getSelectedItem();
        if (this.m_batchserver != oSelectedItem) {
            this.m_batchserver = oSelectedItem;
            this.m_directories.removeAllItems();
            this.m_jcldirs.removeAllItems();
            for (DirectoryInfo dir : this.m_batchserver.getDirectories()) {
                this.m_directories.addItem(dir);
                if (this.m_batchserver.getOperatingSystem() != 2) continue;
                this.m_jcldirs.addItem(dir);
            }
            boolean enable = !this.m_batchserver.equals(preserveServer);
            this.m_directories.setEnabled(enable);
            this.m_newdir.setEnabled(enable);
            this.m_jcldirs.setEnabled(enable);
            switch (this.m_batchserver.getOperatingSystem()) {
                case -1: {
                    this.m_zOSPanel.setVisible(false);
                    break;
                }
                case 0: {
                    this.m_zOSPanel.setVisible(false);
                    break;
                }
                case 1: {
                    this.m_zOSPanel.setVisible(false);
                    break;
                }
                case 2: {
                    this.m_zOSPanel.setVisible(true);
                    break;
                }
                case 3: {
                    this.m_zOSPanel.setVisible(false);
                }
            }
            Window parentWindow = (Window)this.getTopLevelAncestor();
            if (parentWindow != null) {
                parentWindow.pack();
            }
        } else if (this.m_batchserver == null) {
            this.m_zOSPanel.setVisible(false);
        }
    }

    private void createzOSPanel() {
        this.m_zOSPanel = new JPanel();
        this.m_zOSPanel.setBorder(new TitledBorder(m_bundle.getString("DeployJobPanel.JCLDirectoryTitleBorder.txt")));
        String dirText = m_bundle.getString("DeployJobPanel.JCLDirectoryLabel.txt");
        JLabel dirlabel = new JLabel(Util.getLabelWithoutMnemonic((String)dirText));
        dirlabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)dirText));
        dirlabel.setLabelFor(this.m_jcldirs);
        this.m_editpanel = new JTextArea();
        this.m_editpanel.setLineWrap(false);
        this.m_editpanel.setRows(10);
        JScrollPane scrollpane = new JScrollPane(this.m_editpanel);
        scrollpane.setPreferredSize(new Dimension(550, 300));
        GridBagConstraints gbc_directoriesLabel = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(1, 5, 0, 5), 0, 0);
        GridBagConstraints gbc_directories = new GridBagConstraints(1, 0, 1, 1, 25.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_editpanel = new GridBagConstraints(0, 1, 2, 10, 1.0, 1.0, 16, 1, new Insets(7, 5, 5, 5), 0, 0);
        this.m_zOSPanel.setLayout(new GridBagLayout());
        this.m_zOSPanel.add((Component)dirlabel, gbc_directoriesLabel);
        this.m_zOSPanel.add((Component)this.m_jcldirs, gbc_directories);
        this.m_zOSPanel.add((Component)scrollpane, gbc_editpanel);
    }

    private void layoutComponents() {
        int rows = 0;
        int cols = 1;
        int hGap = 10;
        int vGap = 10;
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(rows, cols, hGap, vGap, false, false, false);
        mainLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout((LayoutManager)mainLayout);
        this.add(this.m_commonPanel);
        this.add(this.m_zOSPanel);
    }

    static {
        String strClassName = DeployJobPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        BATCHSERVER_PRESERVE_PREVIOUS_VALUE = m_bundle.getString("DeployJobPanel.BatchServer.PreservePreviousValue.txt");
        FOLDER_PRESERVE_PREVIOUS_VALUE = m_bundle.getString("DeployJobPanel.Folder.PreservePreviousValue.txt");
        preserveServer = new BatchServerInfo(BATCHSERVER_PRESERVE_PREVIOUS_VALUE);
    }

    private static class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            DirectoryInfo dir = (DirectoryInfo)value;
            if (dir != null) {
                this.setText(dir.getName());
                Color highlight = new Color(1);
                this.setForeground(isSelected ? Color.WHITE : highlight);
                this.setBackground(isSelected ? highlight : Color.WHITE);
                this.setToolTipText(isSelected ? dir.getPath() : "");
            } else {
                this.setText("");
            }
            return this;
        }
    }
}

