/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.visuals.swing.JobEventPanel;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class AssociatedJobPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private JLabel m_lblJob;
    private JComboBox m_cmbJobList;
    private Frame m_frame;

    public AssociatedJobPanel(Frame frame, List listOfJobs, DisplayInfo defaultjob) {
        this.m_frame = frame;
        this.__initialize(listOfJobs, defaultjob != null ? defaultjob.getName() : null);
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_lblJob = null;
    }

    public void __initialize(List jobs, String defaultjob) {
        this.m_cmbJobList = new JComboBox();
        ArrayList<String> arr = new ArrayList<String>(jobs.size() + 1);
        arr.add(0, m_bundle.getString("AssociatedJobPanel.SelectOne.txt"));
        arr.addAll(1, jobs);
        this.m_cmbJobList.setModel(new DefaultComboBoxModel<Object>(arr.toArray()));
        this.m_cmbJobList.setToolTipText(m_bundle.getString("AssociatedJobPanel.Jobs.ToolTip.txt"));
        String jobString = m_bundle.getString("AssociatedJobPanel.Jobs.txt");
        this.m_lblJob = new JLabel(Util.getLabelWithoutMnemonic((String)jobString));
        this.m_lblJob.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)jobString));
        this.m_lblJob.setLabelFor(this.m_cmbJobList);
        if (defaultjob != null) {
            for (int i = 1; i < arr.size(); ++i) {
                String name = ((DisplayInfo)arr.get(i)).getName();
                if (name == null || !name.equals(defaultjob)) continue;
                this.m_cmbJobList.setSelectedIndex(i);
                break;
            }
        } else if (this.m_cmbJobList.getItemCount() != 0) {
            this.m_cmbJobList.setSelectedIndex(0);
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_lblJob, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.m_cmbJobList, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
    }

    public DisplayInfo getSelectedJob() {
        Object obj = this.m_cmbJobList.getSelectedItem();
        if (obj instanceof DisplayInfo) {
            return (DisplayInfo)obj;
        }
        return null;
    }

    @Override
    public boolean validateData() {
        DisplayInfo job = this.getSelectedJob();
        if (job == null) {
            MessageUtil.displayMessage(this.m_frame, m_bundle.getString("AssociatedJobPanel.NoJob.Msg.txt"), m_bundle.getString("AssociatedJobPanel.Title.txt"), 0, -1);
            return false;
        }
        return true;
    }

    static {
        String strClassName = JobEventPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

