/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.cq.internal.command;

import java.io.IOException;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.cq.internal.command.BaseCQCommand;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.ResourcePermission;
import org.jetbrains.annotations.NotNull;

public class MonitorCQ
extends BaseCQCommand {
    private static final MonitorCQ singleton = new MonitorCQ();

    public static Command getCommand() {
        return singleton;
    }

    private MonitorCQ() {
    }

    @Override
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long start) throws IOException {
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        int op = clientMessage.getPart(0).getInt();
        if (op < 1) {
            String err = String.format("%s: The MonitorCq operation is invalid.", serverConnection.getName());
            this.sendCqResponse(47, err, clientMessage.getTransactionId(), null, serverConnection);
            return;
        }
        String regionName = null;
        if (clientMessage.getNumberOfParts() == 2 && (regionName = clientMessage.getPart(1).getCachedString()) == null) {
            String err = String.format("%s: A null Region name was passed for MonitorCq operation.", serverConnection.getName());
            this.sendCqResponse(47, err, clientMessage.getTransactionId(), null, serverConnection);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received MonitorCq request from {} op: {}{}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString(), (Object)op, regionName != null ? " RegionName: " + regionName : "");
        }
        securityService.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.READ);
        try {
            CqService cqService = crHelper.getCache().getCqService();
            cqService.start();
            throw new CqException("Invalid CQ Monitor request received.");
        }
        catch (CqException cqe) {
            this.sendCqResponse(50, "", clientMessage.getTransactionId(), cqe, serverConnection);
        }
        catch (Exception e) {
            String err = String.format("Exception while handling the monitor request, the operation is %s", op);
            this.sendCqResponse(50, err, clientMessage.getTransactionId(), e, serverConnection);
        }
    }
}

