/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.servlet.remote;

import jakarta.servlet.ServletException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jcr.Repository;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.jackrabbit.rmi.remote.RemoteRepository;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.servlet.remote.RemoteBindingServlet;

public class JNDIRemoteBindingServlet
extends RemoteBindingServlet {
    private static final long serialVersionUID = -7984144838866544543L;
    private Context context;
    private String location = RemoteRepository.class.getName().replace('.', '/');

    public void init() throws ServletException {
        try {
            Hashtable<String, String> environment = new Hashtable<String, String>();
            Enumeration names = this.getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name.equals("location")) {
                    this.location = this.getInitParameter(name);
                    continue;
                }
                if (name.equals(Repository.class.getName()) || name.equals(RemoteAdapterFactory.class.getName())) continue;
                environment.put(name, this.getInitParameter(name));
            }
            this.context = new InitialContext(environment);
            this.context.bind(this.location, (Object)this.getRemoteRepository());
        }
        catch (NamingException e) {
            throw new ServletException("Failed to bind remote repository to JNDI: " + this.location, (Throwable)e);
        }
    }

    public void destroy() {
        try {
            this.context.unbind(this.location);
        }
        catch (NamingException e) {
            this.log("Failed to unbind remote repository from JNDI: " + this.location, e);
        }
    }
}

