/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.servlet.login;

import jakarta.servlet.FilterConfig;
import jakarta.servlet.http.HttpServletRequest;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.servlet.login.AbstractLoginFilter;

public class ContainerLoginFilter
extends AbstractLoginFilter {
    private char[] password = new char[0];

    @Override
    public void init(FilterConfig config) {
        super.init(config);
        String password = config.getInitParameter("password");
        if (password != null) {
            this.password = password.toCharArray();
        }
    }

    @Override
    protected Credentials getCredentials(HttpServletRequest request) {
        String user = request.getRemoteUser();
        if (user != null) {
            return new SimpleCredentials(user, this.password);
        }
        return null;
    }
}

