/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.servlet.login;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.servlet.ServletRepository;

public abstract class AbstractLoginFilter
implements Filter {
    private Repository repository;
    private String workspace;
    private String sessionAttribute;
    private String nodeAttribute;

    public void init(FilterConfig config) {
        this.repository = new ServletRepository(config);
        this.workspace = config.getInitParameter("workspace");
        this.sessionAttribute = config.getInitParameter(Session.class.getName());
        if (this.sessionAttribute == null) {
            this.sessionAttribute = Session.class.getName();
        }
        this.nodeAttribute = config.getInitParameter(Node.class.getName());
        if (this.nodeAttribute == null) {
            this.nodeAttribute = Node.class.getName();
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            Credentials credentials = this.getCredentials(httpRequest);
            Session session = this.repository.login(credentials, this.workspace);
            try {
                request.setAttribute(this.sessionAttribute, (Object)session);
                request.setAttribute(this.nodeAttribute, (Object)session.getRootNode());
                chain.doFilter(request, response);
                if (session.hasPendingChanges()) {
                    session.save();
                }
            }
            finally {
                session.logout();
            }
        }
        catch (ServletException e) {
            Throwable cause = e.getRootCause();
            if (cause instanceof AccessDeniedException) {
                httpResponse.sendError(403, cause.getMessage());
            }
            throw e;
        }
        catch (LoginException e) {
            httpResponse.sendError(401, e.getMessage());
        }
        catch (NoSuchWorkspaceException e) {
            throw new ServletException("Workspace " + this.workspace + " not found in the content repository", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ServletException("Unable to access the content repository", (Throwable)e);
        }
    }

    protected abstract Credentials getCredentials(HttpServletRequest var1);
}

