/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.servlet.jackrabbit;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.stats.RepositoryStatisticsImpl;

public class StatisticsServlet
extends HttpServlet {
    private static final long serialVersionUID = -7494195499389135951L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RepositoryContext context;
        String klass = RepositoryContext.class.getName();
        String name = this.getServletConfig().getInitParameter(klass);
        if (name == null) {
            name = klass;
        }
        if ((context = (RepositoryContext)this.getServletContext().getAttribute(name)) != null) {
            RepositoryStatisticsImpl statistics = context.getRepositoryStatistics();
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            ((Writer)writer).write(123);
            this.write((Writer)writer, "read", statistics.getTimeSeries(RepositoryStatistics.Type.SESSION_READ_COUNTER));
            ((Writer)writer).write(44);
            this.write((Writer)writer, "write", statistics.getTimeSeries(RepositoryStatistics.Type.SESSION_WRITE_COUNTER));
            ((Writer)writer).write(44);
            this.write((Writer)writer, "login", statistics.getTimeSeries(RepositoryStatistics.Type.SESSION_LOGIN_COUNTER));
            ((Writer)writer).write(125);
        } else {
            response.sendError(500, "Jackrabbit repository internals are not available");
        }
    }

    private void write(Writer writer, String name, TimeSeries series) throws IOException {
        writer.write(34);
        writer.write(name);
        writer.write(34);
        writer.write(58);
        writer.write(123);
        this.write(writer, "second", series.getValuePerSecond());
        writer.write(44);
        this.write(writer, "minute", series.getValuePerMinute());
        writer.write(44);
        this.write(writer, "hour", series.getValuePerHour());
        writer.write(44);
        this.write(writer, "week", series.getValuePerWeek());
        writer.write(125);
    }

    private void write(Writer writer, String name, long[] values) throws IOException {
        writer.write(34);
        writer.write(name);
        writer.write(34);
        writer.write(58);
        writer.write(91);
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                writer.write(44);
            }
            writer.write(String.valueOf(values[i]));
        }
        writer.write(93);
    }
}

