/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.servlet;

import jakarta.servlet.GenericServlet;
import jakarta.servlet.ServletContext;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.repository.RepositoryFactory;

public class ServletRepositoryFactory
implements RepositoryFactory {
    private final GenericServlet servlet;

    public ServletRepositoryFactory(GenericServlet servlet) {
        this.servlet = servlet;
    }

    public Repository getRepository() throws RepositoryException {
        ServletContext context;
        Object repository;
        String name = this.servlet.getInitParameter(Repository.class.getName());
        if (name == null) {
            name = Repository.class.getName();
        }
        if ((repository = (context = this.servlet.getServletContext()).getAttribute(name)) instanceof Repository) {
            return (Repository)repository;
        }
        if (repository != null) {
            throw new RepositoryException("Invalid repository: Attribute " + name + " in servlet context " + context.getServletContextName() + " is an instance of " + repository.getClass().getName());
        }
        throw new RepositoryException("Repository not found: Attribute " + name + " does not exist in servlet context " + context.getServletContextName());
    }
}

