/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.servlet;

import jakarta.servlet.GenericServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.repository.ProxyRepository;
import org.apache.jackrabbit.servlet.ServletRepository;

public abstract class AbstractRepositoryServlet
extends HttpServlet {
    public void init() throws ServletException {
        this.getServletContext().setAttribute(this.getAttributeName(), (Object)new ProxyRepository(){

            protected Repository getRepository() throws RepositoryException {
                return AbstractRepositoryServlet.this.getRepository();
            }
        });
    }

    public void destroy() {
        this.getServletContext().removeAttribute(this.getAttributeName());
    }

    protected abstract Repository getRepository() throws RepositoryException;

    protected String getAttributeName() {
        String name = Repository.class.getName();
        return this.getInitParameter(name, name);
    }

    protected String getInitParameter(String name, String def) {
        String value = this.getInitParameter(name);
        if (value == null) {
            value = def;
        }
        return value;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletRepository repository = new ServletRepository((GenericServlet)this);
        String info = request.getPathInfo();
        if (info == null || info.equals("/")) {
            Properties descriptors = new Properties();
            String[] keys = repository.getDescriptorKeys();
            for (int i = 0; i < keys.length; ++i) {
                descriptors.setProperty(keys[i], repository.getDescriptor(keys[i]));
            }
            response.setContentType("text/plain; charset=ISO-8859-1");
            descriptors.store((OutputStream)response.getOutputStream(), this.getAttributeName());
        } else {
            String key = info.substring(1);
            String descriptor = repository.getDescriptor(key);
            if (descriptor != null) {
                response.setContentType("text/plain; charset=UTF-8");
                response.getWriter().write(descriptor);
            } else {
                response.sendError(404, "Repository descriptor " + key + " not found");
            }
        }
    }
}

