/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util.impl;

import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.Locale;
import java.util.ResourceBundle;

public final class ResourceMessageFormatter
extends MessageFormatter {
    private ClassLoader _classLoader;
    private String _bundleName;
    private String _resourceName;

    public ResourceMessageFormatter(ClassLoader classLoader, String bundleName, String resourceName, Object[] messageArguments) {
        super(messageArguments);
        this._classLoader = classLoader;
        this._bundleName = bundleName;
        this._resourceName = resourceName;
    }

    public ResourceMessageFormatter(String bundleName, String resourceName, Object[] messageArguments) {
        this(null, bundleName, resourceName, messageArguments);
    }

    @Override
    public String getTemplate(Locale locale) {
        String template = null;
        if (this._bundleName != null) {
            ResourceBundle bundle;
            if (locale == null) {
                locale = LocaleUtilities.getDefaultViewerLocale();
            }
            if ((bundle = this._classLoader != null ? ResourceBundle.getBundle(this._bundleName, locale, this._classLoader) : ResourceBundle.getBundle(this._bundleName, locale)) != null) {
                template = bundle.getString(this._resourceName);
            }
        }
        return template;
    }

    @Override
    public String getMessageInfo() {
        String def = (this._classLoader != null ? this._classLoader.getClass().getName() + ": " : "") + this._bundleName + ": " + this._resourceName;
        return def;
    }
}

