/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util.impl;

import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution.OLAPConnectionResource;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.expr.olap.MemberTuple;
import com.sas.iquery.metadata.impl.olap.olapserver.OlapServerMember;
import com.sas.iquery.metadata.physical.Connection;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Member;
import com.sas.iquery.metadata.physical.OlapItem;
import com.sas.iquery.metadata.physical.OlapSchema;
import com.sas.iquery.metadata.physical.olap.AllLevel;
import com.sas.iquery.metadata.physical.oma.OMAOlapSchema;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.util.ChainedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OLAPServerUtilities {
    private MetadataInterface _olapMetadata = null;
    private String _highestAncestor = null;
    private boolean _isMemberNamesOrphaned = false;
    private Map<String, String> _parentList = new HashMap<String, String>();
    private static final Logger _logger = LogManager.getLogger(OLAPServerUtilities.class);
    private static final Logger _mdxLogger = LogManager.getLogger(MDXGenerationUtil.class);

    public static synchronized OLAPServerUtilities getInstance() {
        return new OLAPServerUtilities();
    }

    private OLAPServerUtilities() {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public synchronized void setMetadataInterace(MetadataInterface olapMetadata) {
        this._olapMetadata = olapMetadata;
    }

    public synchronized String getFilterTupleAncestor() {
        return this._highestAncestor;
    }

    public synchronized boolean isFilterMemberNamesOrphaned() {
        return this._isMemberNamesOrphaned;
    }

    public synchronized Map<String, String> getFilterTupleParentList() {
        return this._parentList;
    }

    public synchronized List<MemberTuple> getFilterTupleList(OLAPDataSetInterface olapDataSet, List<String> memberStrings, boolean isPrompt) throws MetadataException {
        ArrayList<MemberTuple> returnList = new ArrayList<MemberTuple>();
        String mdxInstruction = null;
        try {
            mdxInstruction = olapDataSet.getQueryStatement();
        }
        catch (OLAPException e) {
            throw new MetadataException(OLAPServerUtilities.getArrayMessageFormatter("DataServices.OLAPExceptionm.Message.txt", null, (Exception)((Object)e)), (Throwable)e);
        }
        if (mdxInstruction == null) {
            return returnList;
        }
        ResultSetMetadataInterface resultSetMeta = null;
        try {
            resultSetMeta = olapDataSet.getResultSetMetadata();
        }
        catch (IllegalStateException e) {
            throw new MetadataException(OLAPServerUtilities.getArrayMessageFormatter("DataServices.MetadataException.Message.txt", mdxInstruction, e), (Throwable)e);
        }
        catch (OLAPException e) {
            throw new MetadataException(OLAPServerUtilities.getArrayMessageFormatter("DataServices.MetadataException.Message.txt", mdxInstruction, (Exception)((Object)e)), (Throwable)e);
        }
        try {
            String uniqueLevelName;
            TupleInterface[] tuples = resultSetMeta.getTuples(0, 0, -1);
            ArrayList<String> levelNamesInResultSet = new ArrayList<String>();
            int highLevelOfAncestor = 999999;
            for (int ii = 0; ii < tuples.length; ++ii) {
                int depthi = tuples[ii].getTupleDepth();
                TupleElementInterface[] tupleElementi = tuples[ii].getElements(depthi - 1, 1);
                uniqueLevelName = tupleElementi[0].getUniqueLevelName().trim();
                if (depthi >= highLevelOfAncestor) continue;
                this._highestAncestor = uniqueLevelName;
                highLevelOfAncestor = depthi;
            }
            for (int i = 0; i < tuples.length; ++i) {
                int depthOfThisTuple = tuples[i].getTupleDepth();
                TupleElementInterface[] tupleElement = tuples[i].getElements(depthOfThisTuple - 1, 1);
                uniqueLevelName = tupleElement[0].getUniqueLevelName().trim();
                if (levelNamesInResultSet.contains(uniqueLevelName)) continue;
                levelNamesInResultSet.add(uniqueLevelName);
                for (int x = 0; x < tupleElement.length; ++x) {
                    TupleInterface tup = tupleElement[x].getTuple();
                    int tupdep = tup.getTupleDepth();
                    for (int a = 0; a < tupdep; ++a) {
                        TupleElementInterface tupe = tup.getElement(a);
                        String parentLevelOfThisTuple = tupe.getUniqueLevelName().trim();
                        int depthPar = tupe.getLevelDepth();
                        if (levelNamesInResultSet.contains(parentLevelOfThisTuple) || depthPar < highLevelOfAncestor) continue;
                        levelNamesInResultSet.add(parentLevelOfThisTuple);
                    }
                }
            }
            String parentTestNamePrevious = "";
            String parentName = "";
            String previousName = "";
            String parentLevelName = "";
            String previousLevelName = "";
            for (int i = 0; i < tuples.length; ++i) {
                TupleElementInterface[] tupleElement = tuples[i].getElements(0, -1);
                ArrayList<String> lostAncestors = new ArrayList<String>();
                if (tupleElement.length > 0) {
                    MemberTuple emTupleElement = new MemberTuple();
                    MemberTuple emTupleElementPrevious = returnList.size() > 0 ? returnList.get(returnList.size() - 1) : null;
                    int locationOfTuple = tupleElement.length - 1;
                    String tupleName = tupleElement[locationOfTuple].getName().trim();
                    String uniqueLevelName2 = tupleElement[locationOfTuple].getUniqueLevelName().trim();
                    String lastOrphanedParentString = tupleName;
                    int childCount = tupleElement[locationOfTuple].getChildCount();
                    if (uniqueLevelName2.equalsIgnoreCase(this._highestAncestor)) {
                        emTupleElement.setFilterParent(true);
                        this.updateParentList(tupleName.trim());
                        emTupleElement.setParentName(tupleName.trim());
                    } else {
                        for (int x = 0; x < locationOfTuple; ++x) {
                            String uLN = tupleElement[x].getUniqueLevelName().trim();
                            String name = tupleElement[x].getName().trim();
                            boolean isOrphan = false;
                            if (levelNamesInResultSet.contains(uLN) && !memberStrings.contains(name) && !isPrompt) {
                                isOrphan = true;
                            } else if (isPrompt && memberStrings.size() > 0) {
                                String valueInMemberString = memberStrings.get(0);
                                if (levelNamesInResultSet.contains(uLN) && !MDXGenerationUtil.containsValue(valueInMemberString, name)) {
                                    isOrphan = true;
                                }
                            }
                            if (isOrphan) {
                                if (!name.equalsIgnoreCase(tupleName)) {
                                    lastOrphanedParentString = name;
                                }
                                lostAncestors.add(name);
                                this._isMemberNamesOrphaned = true;
                                continue;
                            }
                            if (!levelNamesInResultSet.contains(uLN)) continue;
                            this.updateParentList(name);
                        }
                        emTupleElement.setLostAncestors(lostAncestors);
                        parentName = tupleName;
                        parentLevelName = uniqueLevelName2;
                        if (locationOfTuple > 0) {
                            parentName = tupleElement[locationOfTuple - 1].getName().trim();
                        }
                        if (memberStrings.contains(parentName)) {
                            emTupleElement.setParentName(parentName);
                        } else if (emTupleElement.isOrphaned()) {
                            emTupleElement.setParentName(lastOrphanedParentString);
                        } else {
                            emTupleElement.setParentName(tupleName);
                        }
                        if (parentName.equalsIgnoreCase(parentTestNamePrevious) && levelNamesInResultSet.contains(parentLevelName)) {
                            emTupleElement.setContinued(true);
                            if (parentName.equalsIgnoreCase(tupleName)) {
                                emTupleElement.setFilterParent(true);
                            } else {
                                emTupleElement.setFilterParent(false);
                            }
                            this.updateParentList(parentName);
                            emTupleElement.setParentName(parentName);
                        } else if (parentName.equalsIgnoreCase(previousName) && levelNamesInResultSet.contains(previousLevelName)) {
                            emTupleElement.setContinued(true);
                            this.updateParentList(previousName);
                            if (emTupleElementPrevious != null) {
                                emTupleElementPrevious.setFilterParent(true);
                                emTupleElementPrevious.setChildren(true);
                                emTupleElementPrevious.setParentName(previousName);
                            }
                            emTupleElement.setParentName(parentName);
                        } else if (childCount > 0) {
                            this.updateParentList(tupleName);
                        } else if (!tupleName.equalsIgnoreCase(parentName) && levelNamesInResultSet.contains(parentLevelName)) {
                            this.updateParentList(parentName);
                        }
                    }
                    if (emTupleElement.isFilterParent()) {
                        if (childCount > 0) {
                            emTupleElement.setChildren(true);
                        }
                    } else if (emTupleElement.isOrphaned()) {
                        emTupleElement.setContinued(false);
                        emTupleElement.setParentName(lastOrphanedParentString);
                        if (childCount > 0) {
                            emTupleElement.setChildren(true);
                        }
                    } else if (this.getParentCount(tupleName) > 1 && !emTupleElement.isFilterParent() && childCount > 0) {
                        emTupleElement.setChildren(true);
                        emTupleElement.setFilterParent(true);
                    }
                    if (childCount == 0) {
                        emTupleElement.setChildren(false);
                    } else {
                        emTupleElement.setChildren(true);
                    }
                    previousName = tupleName;
                    parentTestNamePrevious = parentName;
                    previousLevelName = uniqueLevelName2;
                    emTupleElement.setName(tupleName);
                    returnList.add(emTupleElement);
                    continue;
                }
                if (!_logger.isEnabled(Level.ERROR)) continue;
                _logger.error(IQMetadataResourceBundle.getStringResource("MemberFitlerExpressionNoTuples.txt"));
            }
        }
        catch (OLAPException oe) {
            throw new MetadataException(OLAPServerUtilities.getArrayMessageFormatter("DataServices.MetadataException.Message.txt", mdxInstruction, (Exception)((Object)oe)), (Throwable)oe);
        }
        for (MemberTuple element : returnList) {
            String parentCount;
            int counter;
            String name = element.getParentName().trim();
            if (this._parentList.containsKey(name) && (counter = Integer.parseInt(parentCount = this._parentList.get(name))) > 1 && element.isFilterParent()) {
                element.setIncludeAllDescendents(false);
            }
            if (element.hasChildren()) continue;
            element.setIncludeAllDescendents(false);
        }
        return returnList;
    }

    private static MessageFormatter getArrayMessageFormatter(String resourceKey, String queryString, Exception e) {
        Object[] msgArgs;
        MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter(resourceKey, new Object[0]);
        if (queryString == null && e == null) {
            return msg;
        }
        if (e == null) {
            msgArgs = new Object[]{msg, queryString};
        } else {
            Throwable t = ChainedException.getRootException((Throwable)e);
            if (queryString == null) {
                Object[] objectArray;
                if (e != t && t != null) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = msg;
                    objectArray = objectArray2;
                    objectArray2[1] = t;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = msg;
                    objectArray = objectArray3;
                    objectArray3[1] = e;
                }
                msgArgs = objectArray;
            } else {
                Object[] objectArray;
                if (e != t && t != null) {
                    Object[] objectArray4 = new Object[3];
                    objectArray4[0] = msg;
                    objectArray4[1] = queryString;
                    objectArray = objectArray4;
                    objectArray4[2] = t;
                } else {
                    Object[] objectArray5 = new Object[3];
                    objectArray5[0] = msg;
                    objectArray5[1] = queryString;
                    objectArray = objectArray5;
                    objectArray5[2] = e;
                }
                msgArgs = objectArray;
            }
        }
        ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs);
        if (_mdxLogger.isEnabled(Level.ERROR)) {
            _mdxLogger.error(msg + ":" + queryString, (Throwable)e);
        }
        return msF;
    }

    private synchronized void updateParentList(String parentName) {
        if (!this._parentList.containsKey(parentName)) {
            this._parentList.put(parentName, Integer.toString(1));
        } else {
            String countera = this._parentList.get(parentName);
            this._parentList.remove(parentName);
            int counter = Integer.parseInt(countera);
            String value = Integer.toString(++counter);
            this._parentList.put(parentName, value);
        }
    }

    private synchronized int getParentCount(String parentName) {
        if (!this._parentList.containsKey(parentName)) {
            return 0;
        }
        String countera = this._parentList.get(parentName);
        this._parentList.remove(parentName);
        int counter = Integer.parseInt(countera);
        return counter;
    }

    public synchronized String getHierarchyExpression(Hierarchy hierarchy, String startingLevelName) throws MetadataException {
        Cube owningCube;
        if (this._olapMetadata == null) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(hierarchy.toString());
            }
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoConnect.txt"));
            throw new MetadataException(msF);
        }
        String uniqueLevelName = null;
        List<com.sas.iquery.metadata.physical.Level> levels = hierarchy.getLevels();
        if (null == levels || 0 == levels.size()) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(hierarchy.toString());
            }
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoLevels.txt"));
            throw new MetadataException(msF);
        }
        com.sas.iquery.metadata.physical.Level topLevel = levels.get(0);
        String cubeName = null;
        Dimension dim = null;
        dim = topLevel.getOwningDimension();
        if (dim != null && (owningCube = dim.getOwningCube()) != null) {
            cubeName = owningCube.getCubeName();
        }
        String levelNameToUse = null;
        com.sas.iquery.metadata.physical.Level levelToUse = topLevel;
        this.setOLAPServerUtil(topLevel);
        if (topLevel instanceof AllLevel) {
            if (levels.size() > 1) {
                levelToUse = levels.get(1);
                levelNameToUse = levelToUse.getLevelName();
            }
        } else {
            levelNameToUse = levelToUse.getLevelName();
        }
        if (startingLevelName != null) {
            if (startingLevelName.equals("SAS_BIQ_DefaultMemberLevelName")) {
                uniqueLevelName = hierarchy.getUniqueName() + ".DefaultMember.Level";
            } else {
                levelNameToUse = startingLevelName;
            }
        }
        if (uniqueLevelName == null) {
            try {
                uniqueLevelName = this.getLevelNameFromOlapServer(hierarchy, cubeName, levelNameToUse);
            }
            catch (OLAPException oe) {
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoLevels.txt"), hierarchy.toString(), cubeName, levelNameToUse);
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error((Object)msF, (Throwable)oe);
                }
                throw new MetadataException((MessageFormatter)msF, (Throwable)oe);
            }
        }
        if (uniqueLevelName == null) {
            uniqueLevelName = this.getLevelNameFromOMR(levels, levelNameToUse);
        }
        if (uniqueLevelName == null) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(hierarchy.toString());
            }
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoLevels.txt"));
            throw new MetadataException(msF);
        }
        return uniqueLevelName;
    }

    public synchronized LevelInterface getLevelFromOlapServer(String cubeName, String dimensionName, String uniqueHierarchyName, String levelName) throws MetadataException {
        if (cubeName == null || dimensionName == null) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("OLAPServerUtilitiesNullParams.fmt.txt", this._olapMetadata, cubeName, dimensionName));
        }
        if (this._olapMetadata == null) {
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, cubeName, IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoConnect.txt"));
            throw new MetadataException(msF);
        }
        if (uniqueHierarchyName == null && levelName == null) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(dimensionName);
            }
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("OLAPServerUtilitiesNullHierLevel.txt", new Object[0]));
        }
        LevelInterface level = null;
        Filter filter = new Filter();
        filter.setCubeName(cubeName);
        filter.setDimensionName(dimensionName);
        if (uniqueHierarchyName != null) {
            filter.setUniqueHierarchyName(uniqueHierarchyName);
        }
        try {
            HierarchyInterface[] hierarchies = this._olapMetadata.getHierarchies(filter);
            if (hierarchies == null) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(filter.toString());
                }
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoHierarchies.txt"));
                throw new MetadataException(msF);
            }
            if (hierarchies.length == 0) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(filter.toString());
                }
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoHierarchies.txt"));
                throw new MetadataException(msF);
            }
            level = this.getLevel(hierarchies, levelName, null);
        }
        catch (OLAPException oE) {
            if (_logger.isEnabled(Level.ERROR)) {
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, filter.toString(), IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesServerError.txt"));
                _logger.error((Object)msF, (Throwable)oE);
            }
            throw new MetadataException(oE);
        }
        if (level == null) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("OLAPServerUtilitiesNoLevel.fmt.txt", cubeName, dimensionName, uniqueHierarchyName, levelName);
            throw new MetadataException(msg);
        }
        return level;
    }

    private synchronized String getLevelNameFromOlapServer(Hierarchy hierarchy, String cubeName, String levelNameToUse) throws MetadataException, OLAPException {
        String uniqueLevelName = "All";
        if (this._olapMetadata == null) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("OLAPServerUtilitiesNoConnect.txt", new Object[0]));
        }
        Filter filter = new Filter();
        filter.setCubeName(cubeName);
        filter.setUniqueHierarchyName(hierarchy.getHierarchyUniqueName());
        filter.setLevelName(levelNameToUse);
        LevelInterface[] levelI = this._olapMetadata.getLevels(filter);
        if (levelI != null && levelI.length > 0 && levelI[0] != null) {
            uniqueLevelName = levelI[0].getUniqueName();
        }
        if (uniqueLevelName == null) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(filter.toString());
            }
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesUniqueNull.txt"));
            throw new MetadataException(msF);
        }
        return uniqueLevelName;
    }

    private String getLevelNameFromOMR(List<com.sas.iquery.metadata.physical.Level> levels, String levelNameToUse) throws MetadataException {
        String uniqueName = null;
        OlapItem levelToUse = null;
        for (com.sas.iquery.metadata.physical.Level level : levels) {
            this.setOLAPServerUtil(level);
            if (!level.getLevelName().equals(levelNameToUse)) continue;
            levelToUse = level;
            break;
        }
        if (levelToUse != null) {
            uniqueName = levelToUse.getUniqueName();
        }
        return uniqueName;
    }

    public List<Member> getMembers(MetadataInterface olapMetadata, String cubeName, Dimension dimension, Hierarchy hierarchy, String levelName) throws MetadataException {
        if (cubeName == null || dimension == null) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("OLAPServerUtilitiesNullParams.fmt.txt", this._olapMetadata, cubeName, dimension));
        }
        if (hierarchy == null && levelName == null) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(dimension.toString());
            }
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("OLAPServerUtilitiesNullHierLevel.txt", new Object[0]));
        }
        String hierarchyUniqueName = hierarchy.getUniqueName();
        ArrayList<Member> members = new ArrayList<Member>();
        LevelInterface level = this.getLevelFromOlapServer(cubeName, dimension.getDimensionName(), hierarchyUniqueName, levelName);
        if (level == null) {
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, dimension.toString(), cubeName, hierarchyUniqueName, levelName);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error((Object)msF);
            }
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("OLAPServerUtilitiesNoLevel.txt", new Object[0]));
        }
        MemberInterface[] olapMembers = null;
        try {
            olapMembers = level.getMembers();
        }
        catch (OLAPException e) {
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, level.toString(), IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesOELevel.txt"));
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error((Object)msF, (Throwable)e);
            }
            throw new MetadataException((MessageFormatter)msF, (Throwable)e);
        }
        if (olapMembers == null) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(level.toString());
            }
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesHierarchyImplNoMembers.txt"));
            throw new MetadataException(msF);
        }
        for (int i = 0; i < olapMembers.length; ++i) {
            OlapServerMember member = new OlapServerMember(olapMembers[i]);
            member.setOwningDimension(dimension.getOwningDimension());
            member.setOwningHierarchy(hierarchy);
            members.add(member);
        }
        return members;
    }

    public synchronized MetadataInterface getOlapMetadata() {
        return this._olapMetadata;
    }

    private LevelInterface getLevel(HierarchyInterface[] hierarchies, String levelName, LevelInterface levelIn) throws OLAPException {
        LevelInterface level = levelIn;
        if (levelName == null) {
            for (int i = 0; i < hierarchies.length && level == null; ++i) {
                LevelInterface[] levels = hierarchies[i].getLevels();
                for (int j = 0; j < levels.length && level == null; ++j) {
                    if (levels[j].getType() != 2) continue;
                    level = levels[j];
                }
            }
        } else {
            for (int i = 0; i < hierarchies.length && level == null; ++i) {
                LevelInterface[] levels = hierarchies[i].getLevels();
                for (int j = 0; j < levels.length && level == null; ++j) {
                    if (!levelName.equalsIgnoreCase(levels[j].getName())) continue;
                    level = levels[j];
                }
            }
        }
        return level;
    }

    private void setOLAPServerUtil(com.sas.iquery.metadata.physical.Level level) {
        if (level instanceof AllLevel) {
            AllLevel allLevel = (AllLevel)level;
            allLevel.setOLAPServerUtilities(this);
        }
    }

    public synchronized void setOLAPConnection(MetadataInterface metaI) {
        this._olapMetadata = metaI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOLAPConnection(Cube cube, Dimension dimension) throws MetadataException {
        block10: {
            try {
                OlapSchema olapSchema = cube.getOwningOlapSchema();
                if (olapSchema == null) break block10;
                Connection conn = ((OMAOlapSchema)olapSchema).getConnection();
                if (conn != null) {
                    if (olapSchema instanceof OMAOlapSchema) {
                        OLAPServerUtilities oLAPServerUtilities = this;
                        synchronized (oLAPServerUtilities) {
                            if (this._olapMetadata == null) {
                                this._olapMetadata = ((OMAOlapSchema)olapSchema).getMetadata();
                            }
                            break block10;
                        }
                    }
                    ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, cube.getCubeName(), IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoCredentials.txt"));
                    throw new MetadataException(msF);
                }
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, cube.getCubeName(), IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoCredentials.txt"));
                throw new MetadataException(msF);
            }
            catch (IQueryServicesException se) {
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, cube.getCubeName(), IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesUnableToConnect.txt"));
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error((Object)msF, (Throwable)se);
                }
                throw new MetadataException((MessageFormatter)msF, (Throwable)se);
            }
        }
        if (this._olapMetadata == null) {
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, cube.getCubeName(), IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoConnection.txt"));
            throw new MetadataException(msF);
        }
    }

    public synchronized void setOlapMetadata(DataSelection dataSelection, Cube cube) throws MetadataException {
        _logger.debug(">> getOlapMetadataStatement");
        if (this._olapMetadata == null) {
            if (dataSelection == null) {
                throw new IQueryServicesIllegalArgumentException(IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilNoModel.txt", new Object[0]));
            }
            Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale(dataSelection);
            RetrievalPolicy policy = new RetrievalPolicy();
            policy.getConnectionConfiguration().setConnectionLifetime(1);
            OLAPConnectionResource olapConnectionResource = null;
            try {
                olapConnectionResource = OLAPConnectionInfoUtil.getConnection(dataSelection, policy, computationalLocale);
            }
            catch (IQueryServicesException e) {
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, cube, IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesUnableToConnect.txt"));
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error((Object)msF, (Throwable)e);
                }
                throw new MetadataException((MessageFormatter)msF, (Throwable)e);
            }
            if (olapConnectionResource == null) {
                MessageFormatter message = IQMetadataResourceBundle.getMessageFormatter("OLAPServerUtilitiesUnableToConnect.txt", new Object[0]);
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(cube.getCubeName() + ": " + message);
                }
                throw new MetadataException(message);
            }
            String constructor = "IGNOREISESSION";
            try {
                this._olapMetadata = olapConnectionResource.createMetadataInterface(dataSelection, constructor, cube, true, true, null);
            }
            catch (IQueryServicesException e) {
                ConnectionResources.close(olapConnectionResource);
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, cube, IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesUnableToConnect.txt"));
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error((Object)msF, (Throwable)e);
                }
                throw new MetadataException((MessageFormatter)msF, (Throwable)e);
            }
            if (this._olapMetadata == null) {
                ConnectionResources.close(olapConnectionResource);
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(cube.getCubeName());
                }
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesUnableToConnect.txt"));
                throw new MetadataException(msF);
            }
        }
    }

    public synchronized void setOlapMetadata(Dimension dimension) throws MetadataException {
        _logger.debug(">> getOlapMetadataStatement");
        if (dimension != null) {
            this.setOLAPConnection(dimension.getOwningCube(), dimension);
        }
        if (this._olapMetadata == null) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("OLAPServerUtilitiesNoConnect.txt", new Object[0]));
        }
    }
}

