/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util.impl;

import com.sas.MissingValues;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.util.DatePeriod;
import com.sas.util.LocalizableString;
import com.sas.util.LocalizableToStringInterface;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;

public abstract class MessageFormatter
implements LocalizableToStringInterface {
    protected Object[] _messageArguments;

    protected MessageFormatter(Object ... messageArguments) {
        this._messageArguments = messageArguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private String format(String template, Object[] arguments, Locale locale) {
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale();
        }
        String message = null;
        if (arguments == null) {
            return template;
        }
        MessageFormat format = new MessageFormat(template, locale);
        Object[] localizedArguments = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Object argument = arguments[i];
            if (argument instanceof IQueryServicesException) {
                localizedArguments[i] = ((IQueryServicesException)argument).getMessage(locale);
                continue;
            }
            if (argument instanceof IQueryServicesRuntimeException) {
                localizedArguments[i] = ((IQueryServicesRuntimeException)argument).getMessage(locale);
                continue;
            }
            if (argument instanceof LocalizableString) {
                localizedArguments[i] = ((LocalizableString)argument).getText(locale);
                continue;
            }
            if (argument instanceof LocalizableToStringInterface) {
                localizedArguments[i] = ((LocalizableToStringInterface)argument).toString(locale);
                continue;
            }
            if (argument instanceof PromptDefinitionInterface) {
                localizedArguments[i] = ((PromptDefinitionInterface)argument).getPromptLabel(locale);
                continue;
            }
            if (argument instanceof ExpressionInterface) {
                try {
                    localizedArguments[i] = StringExpressionUtil.getInstance().getReadableText((ExpressionInterface)argument, locale);
                }
                catch (MetadataException e) {
                    localizedArguments[i] = argument;
                }
                continue;
            }
            if (argument instanceof PromptDefinitionInterface) {
                localizedArguments[i] = ((PromptDefinitionInterface)argument).getPromptLabel(locale);
                continue;
            }
            if (argument instanceof Throwable) {
                Class<Locale> e = Locale.class;
                // MONITORENTER : java.util.Locale.class
                Locale saveLocale = Locale.getDefault();
                try {
                    Locale.setDefault(locale);
                    localizedArguments[i] = ((Throwable)argument).getLocalizedMessage();
                }
                finally {
                    Locale.setDefault(saveLocale);
                }
                // MONITOREXIT : e
                continue;
            }
            if (argument instanceof Locale) {
                localizedArguments[i] = "'" + argument + "' " + ((Locale)argument).getDisplayName(locale);
                continue;
            }
            if (argument instanceof MissingValues) {
                localizedArguments[i] = argument + " (" + MissingValues.toDisplayString((MissingValues)((MissingValues)argument), (Locale)locale) + ")";
                continue;
            }
            if (argument instanceof DatePeriod) {
                DatePeriod dp = (DatePeriod)argument;
                DateFormat dateFormat = null;
                localizedArguments[i] = dp.toString(dateFormat, locale);
                continue;
            }
            localizedArguments[i] = argument;
        }
        try {
            return format.format(localizedArguments, new StringBuffer(), (FieldPosition)null).toString();
        }
        catch (IllegalArgumentException e) {
            System.err.println(e);
            System.err.println("locale = " + locale);
            System.err.println("template = " + template);
            System.err.println("localized Args:");
            int i = 0;
            while (i < localizedArguments.length) {
                Object obj = localizedArguments[i];
                System.err.println("object [" + i + "]: " + obj + " (" + obj.getClass().getName() + ")");
                ++i;
            }
            return message;
        }
    }

    public String toString(Locale locale) {
        return this.getMessage(locale);
    }

    public String toString() {
        return this.getMessage(null);
    }

    public String getMessage(Locale locale) {
        String template = this.getTemplate(locale);
        if (template == null) {
            template = this.getMessageInfo();
        }
        String message = this.format(template, this._messageArguments, locale);
        return message;
    }

    protected abstract String getTemplate(Locale var1);

    public abstract String getMessageInfo();
}

