/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util.impl;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.RBMessageFormatter;
import com.sas.util.RBBase;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class IQUtilResourceBundle
extends RBBase {
    private static final Logger _logger = LogManager.getLogger((String)"IQDataServicesResourceBundle.class");
    private static IQUtilResourceBundle defaultBundle = new IQUtilResourceBundle();
    private static final String EMPTY_STR = "";

    @SASScope
    public static MessageFormatter getMessageFormatter(String resourceName, Object[] args) {
        return new RBMessageFormatter(defaultBundle, resourceName, args);
    }

    @SASScope
    public static MessageFormatter getMessageFormatter(String resourceName) {
        return IQUtilResourceBundle.getMessageFormatter(resourceName, null);
    }

    @SASScope
    public static MessageFormatter getMessageFormatter(ExpressionInterface expr) {
        return IQUtilResourceBundle.getMessageFormatter("{0}", new Object[]{expr});
    }

    @SASScope
    protected IQUtilResourceBundle() {
    }

    @SASScope
    public IQUtilResourceBundle(String source) {
        super(source);
    }

    @SASScope
    public IQUtilResourceBundle(String source, Locale locale) {
        super(source);
        this._getResources(locale);
    }

    @SASScope
    public static String getStringResource(String classKey, String subKey) {
        String result = defaultBundle._getStringResource(classKey + subKey);
        if (result == null) {
            result = EMPTY_STR;
        }
        return result;
    }

    @SASScope
    public static String getStringResource(String key) {
        String result = defaultBundle._getStringResource(key);
        if (result == null) {
            result = EMPTY_STR;
        }
        return result;
    }

    @SASScope
    public static int getIntResource(String key) {
        return IQUtilResourceBundle.getIntResource(key, 0);
    }

    @SASScope
    public static int getIntResource(String key, int notFoundReturnValue) {
        int result = Integer.MIN_VALUE;
        try {
            String strValue = IQUtilResourceBundle.getStringResource(key);
            result = Integer.parseInt(strValue);
        }
        catch (MissingResourceException mre) {
            result = notFoundReturnValue;
            _logger.debug("Missing Resource (" + key + ")");
        }
        catch (NumberFormatException nfe) {
            result = notFoundReturnValue;
            _logger.debug("Numeric format exception " + nfe.getMessage());
        }
        return result;
    }

    @SASScope
    public static ResourceBundle getResources() {
        return defaultBundle._getResources();
    }

    @SASScope
    public static String getMessageString(String key, Object[] args) {
        String pattern = IQUtilResourceBundle.getStringResource(key);
        return MessageFormat.format(pattern, args);
    }

    @SASScope
    public String getString(String classKey, String subKey) {
        String key = classKey + subKey;
        String result = this._getStringResource(key);
        if (result == null) {
            result = IQUtilResourceBundle.getStringResource(key);
        }
        return result;
    }

    @SASScope
    public String getString(String key) {
        String result = this._getStringResource(key);
        if (result == null) {
            result = IQUtilResourceBundle.getStringResource(key);
        }
        return result;
    }

    @SASScope
    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    @SASScope
    public int getInt(String key, int notFoundReturnValue) {
        int result = Integer.MIN_VALUE;
        try {
            String strValue = this.getString(key);
            result = strValue.length() > 0 ? Integer.parseInt(strValue) : notFoundReturnValue;
        }
        catch (MissingResourceException mre) {
            result = notFoundReturnValue;
            _logger.debug("Missing Resource (" + key + ")");
        }
        catch (NumberFormatException nfe) {
            result = notFoundReturnValue;
            _logger.debug("Numeric format exception " + nfe.getMessage());
        }
        return result;
    }

    @SASScope
    public ResourceBundle getResourceBundle() {
        return this._getResources();
    }

    @SASScope
    public String messageString(String key, Object[] args) {
        String pattern = this._getStringResource(key);
        if (pattern == null) {
            pattern = IQUtilResourceBundle.getStringResource(key);
        }
        return MessageFormat.format(pattern, args);
    }

    public static String getStringResource(String key, Locale locale) {
        String result = defaultBundle._getStringResource(key, locale);
        if (result == null) {
            result = EMPTY_STR;
        }
        return result;
    }

    public static String getMessageString(String key, Object[] args, Locale locale) {
        String pattern = IQUtilResourceBundle.getStringResource(key, locale);
        return MessageFormat.format(pattern, args);
    }
}

