/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util.impl;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.dataselectors.filterandrank.RankOrderEnum;
import com.sas.dataselectors.filterandrank.RankTypeEnum;
import com.sas.dataselectors.filters.timebased.RelativeTimeFilterValueFormatter;
import com.sas.datatypes.DataTypeInterface;
import com.sas.iquery.dataretrieval.convenience.ByGroupCreator;
import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.NamedObjectInterface;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.step.CompoundStep;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryRankFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryTupleFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberPropertiesFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeFirstLastPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeNParallelPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeNPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeRangeFilter;
import com.sas.iquery.metadata.business.step.relational.DataItemRankFilter;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ConstantExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.iquery.metadata.expr.NonCalculatedValue;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.olap.BaseFilterExpression;
import com.sas.iquery.metadata.expr.olap.DataBasedFilterExpression;
import com.sas.iquery.metadata.expr.olap.DataBasedFilterExpression_Between;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterFirstLastPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNParallelPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeRangeFilterExpression;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Between;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Contains;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_In;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Like;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_TestForNull;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.serverprop.FunctionSignature;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.IQUtilResourceBundle;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MemberLevelComparator;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PropertyInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import com.sas.text.SASFormat;
import com.sas.util.Strings;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@SubjectToChange
public class AppliedFilter {
    private static final String PROP_PREFIX = "AppliedFiltersUtil.";
    private static final String PROP_POSTFIX = ".fmt.txt";
    public static final String OLAP_MEASURES = "AppliedFiltersUtil.measures.fmt.txt";
    public static final String OLAP_TIME_FILTER_PERIODS = "OLAPTimeFilterUtil.periods.txt";
    public static final String OLAP_TIME_FILTER_PERIOD = "OLAPTimeFilterUtil.period.txt";
    public static final String OLAP_TIME_FILTER_YEARS = "OLAPTimeFilterUtil.years.txt";
    public static final String OLAP_TIME_FILTER_YEAR = "OLAPTimeFilterUtil.year.txt";
    public static final String OLAP_TIME_FILTER_WEEKS = "OLAPTimeFilterUtil.weeks.txt";
    public static final String OLAP_TIME_FILTER_WEEK = "OLAPTimeFilterUtil.week.txt";
    public static final String OLAP_TIME_FILTER_SECONDS = "OLAPTimeFilterUtil.seconds.txt";
    public static final String OLAP_TIME_FILTER_SECOND = "OLAPTimeFilterUtil.second.txt";
    public static final String OLAP_TIME_FILTER_QTRS = "OLAPTimeFilterUtil.quarters.txt";
    public static final String OLAP_TIME_FILTER_QTR = "OLAPTimeFilterUtil.quarter.txt";
    public static final String OLAP_TIME_FILTER_MONTHS = "OLAPTimeFilterUtil.months.txt";
    public static final String OLAP_TIME_FILTER_MONTH = "OLAPTimeFilterUtil.month.txt";
    public static final String OLAP_TIME_FILTER_MINUTES = "OLAPTimeFilterUtil.minutes.txt";
    public static final String OLAP_TIME_FILTER_MINUTE = "OLAPTimeFilterUtil.minute.txt";
    public static final String OLAP_TIME_FILTER_HOURS = "OLAPTimeFilterUtil.hours.txt";
    public static final String OLAP_TIME_FILTER_HOUR = "OLAPTimeFilterUtil.hour.txt";
    public static final String OLAP_TIME_FILTER_HALF_YEARS = "OLAPTimeFilterUtil.halfYears.txt";
    public static final String OLAP_TIME_FILTER_HALF_YEAR = "OLAPTimeFilterUtil.halfYear.txt";
    public static final String OLAP_TIME_FILTER_DAYS = "OLAPTimeFilterUtil.days.txt";
    public static final String OLAP_TIME_FILTER_DAY = "OLAPTimeFilterUtil.day.txt";
    public static final String COLUMNS = "AppliedFiltersUtil.columns.fmt.txt";
    public static final String ROWS = "AppliedFiltersUtil.rows.fmt.txt";
    public static final String UTIL_BOOLEAN_OR = "Util.Boolean.OR.Label.txt";
    public static final String UTIL_BOOLEAN_AND = "Util.Boolean.AND.Label.txt";
    public static final String CONTAINS = "AppliedFiltersUtil.CONTAINS.fmt.txt";
    public static final String DOES_NOT_CONTAIN = "AppliedFiltersUtil.DOES_NOT_CONTAIN.fmt.txt";
    public static final String LIKE = "AppliedFiltersUtil.LIKE.fmt.txt";
    public static final String NOT_LIKE = "AppliedFiltersUtil.NOT_LIKE.fmt.txt";
    public static final String IS_IN_LIST_OR_EQUAL_TO = "AppliedFiltersUtil.IS_IN_LIST_OR_EQUAL_TO.fmt.txt";
    public static final String IS_NOT_IN_LIST_OR_EQUAL_TO = "AppliedFiltersUtil.IS_NOT_IN_LIST_OR_EQUAL_TO.fmt.txt";
    public static final String IS_NULL = "AppliedFiltersUtil.IS_NULL.fmt.txt";
    public static final String IS_NOT_NULL = "AppliedFiltersUtil.IS_NOT_NULL.fmt.txt";
    public static final String GROUP = "AppliedFiltersUtil.GROUP.fmt.txt";
    public static final String NOT_GROUP = "AppliedFiltersUtil.NOT_GROUP.fmt.txt";
    public static final String COMPOUND = "AppliedFiltersUtil.COMPOUND.fmt.txt";
    public static final String NOT_COMPOUND = "AppliedFiltersUtil.NOT_COMPOUND.fmt.txt";
    public static final String COMPOUND_JOIN = "AppliedFiltersUtil.COMPOUND_JOIN.fmt.txt";
    public static final String LIST_OF_VALUES = "AppliedFiltersUtil.LIST_OF_VALUES.fmt.txt";
    public static final String LIST_OF_VALUES_SEPARATOR = "AppliedFiltersUtil.LIST_OF_VALUES_SEPARATOR.fmt.txt";
    public static final String LIST_OF_VALUES_JOIN = "AppliedFiltersUtil.LIST_OF_VALUES_JOIN.fmt.txt";
    public static final String CHARACTER_DI = "AppliedFiltersUtil.CHARACTER_DI.fmt.txt";
    public static final String AGGREGATE_DI = "AppliedFiltersUtil.AGGREGATE_DI.fmt.txt";
    public static final String AGGREGATE_DI_MISSING_FUNCTION = "AppliedFiltersUtil.AGGREGATE_DI_MISSING_FUNCTION.fmt.txt";
    public static final String DETAIL_DI = "AppliedFiltersUtil.DETAIL_DI.fmt.txt";
    public static final String RANK_SUM = "AppliedFiltersUtil.RANK_SUM.fmt.txt";
    public static final String RANK_PERCENT = "AppliedFiltersUtil.RANK_PERCENT.fmt.txt";
    public static final String RANK_COUNT = "AppliedFiltersUtil.RANK_COUNT.fmt.txt";
    public static final String RANK_TOP = "AppliedFiltersUtil.RANK_TOP.fmt.txt";
    public static final String RANK_BOTTOM = "AppliedFiltersUtil.RANK_BOTTOM.fmt.txt";
    public static final String OLAP_RANK_WITH_TIES = "AppliedFiltersUtil.OLAP_RANK_WITH_TIES.fmt.txt";
    public static final String OLAP_RANK_WITHOUT_TIES = "AppliedFiltersUtil.OLAP_RANK_WITHOUT_TIES.fmt.txt";
    public static final String ESCAPE = "AppliedFiltersUtil.ESCAPE.fmt.txt";
    public static final String IS_BETWEEN = "AppliedFiltersUtil.IS_BETWEEN.fmt.txt";
    public static final String IS_NOT_BETWEEN = "AppliedFiltersUtil.IS_NOT_BETWEEN.fmt.txt";
    public static final String DBFE_BETWEEN = "AppliedFiltersUtil.DBFE_BETWEEN.fmt.txt";
    public static final String DBFE_NOT_BETWEEN = "AppliedFiltersUtil.DBFE_NOT_BETWEEN.fmt.txt";
    public static final String IS_EQUAL = "AppliedFiltersUtil.IS_EQUAL.fmt.txt";
    public static final String IS_GREATER_THAN = "AppliedFiltersUtil.IS_GREATER_THAN.fmt.txt";
    public static final String IS_GREATER_THAN_OR_EQUAL = "AppliedFiltersUtil.IS_GREATER_THAN_OR_EQUAL.fmt.txt";
    public static final String IS_LESS_THAN = "AppliedFiltersUtil.IS_LESS_THAN.fmt.txt";
    public static final String IS_LESS_THAN_OR_EQUAL = "AppliedFiltersUtil.IS_LESS_THAN_OR_EQUAL.fmt.txt";
    public static final String IS_NOT_EQUAL = "AppliedFiltersUtil.IS_NOT_EQUAL.fmt.txt";
    public static final String RANK_WITH_TIES = "AppliedFiltersUtil.RANK_WITH_TIES.fmt.txt";
    public static final String RANK_WITHOUT_TIES = "AppliedFiltersUtil.RANK_WITHOUT_TIES.fmt.txt";
    public static final String TEXT_FORMAT = "AppliedFiltersUtil.TEXT_FORMAT.fmt.txt";
    public static final String ROW_COLUMN_FILTER = "AppliedFiltersUtil.ROW_COLUMN_FILTER.fmt.txt";
    public static final String STEP_FILTER = "AppliedFiltersUtil.STEP_FILTER.fmt.txt";
    public static final String TIME_FIRST_PERIODS_FILTER = "AppliedFiltersUtil.TIME_FIRST_PERIODS_FILTER.fmt.txt";
    public static final String TIME_FIRST_PERIODS_RELATIVE_FILTER = "AppliedFiltersUtil.TIME_FIRST_PERIODS_RELATIVE_FILTER.fmt.txt";
    public static final String TIME_LAST_PERIODS_FILTER = "AppliedFiltersUtil.TIME_LAST_PERIODS_FILTER.fmt.txt";
    public static final String TIME_LAST_PERIODS_RELATIVE_FILTER = "AppliedFiltersUtil.TIME_LAST_PERIODS_RELATIVE_FILTER.fmt.txt";
    public static final String TIME_RANGE_ABSOLUTE_TO_ABSOLUTE_FILTER = "AppliedFiltersUtil.TIME_RANGE_ABSOLUTE_TO_ABSOLUTE_FILTER.fmt.txt";
    public static final String TIME_RANGE_ABSOLUTE_TO_RELATIVE_FILTER = "AppliedFiltersUtil.TIME_RANGE_ABSOLUTE_TO_RELATIVE_FILTER.fmt.txt";
    public static final String TIME_RANGE_RELATIVE_TO_ABSOLUTE_FILTER = "AppliedFiltersUtil.TIME_RANGE_RELATIVE_TO_ABSOLUTE_FILTER.fmt.txt";
    public static final String TIME_RANGE_RELATIVE_TO_RELATIVE_FILTER = "AppliedFiltersUtil.TIME_RANGE_RELATIVE_TO_RELATIVE_FILTER.fmt.txt";
    public static final String OLAP_EQUAL_TO = "AppliedFiltersUtil.OLAP_EQUAL_TO.fmt.txt";
    public static final String OLAP_IS_NOT_EQUAL_TO = "AppliedFiltersUtil.OLAP_IS_NOT_EQUAL_TO.fmt.txt";
    public static final String TIME_PARALLEL_PERIODS_ABSOLUTE_TO_ABSOLUTE_FILTER = "Time_Parallel_Periods_Asolute_To_Absolute_Filter";
    public static final String TIME_PARALLEL_PERIODS_ABSOLUTE_TO_RELATIVE_FILTER = "Time_Parallel_Periods_Asolute_To_Relative_Filter";
    public static final String TIME_PARALLEL_PERIODS_RELATIVE_TO_ABSOLUTE_FILTER = "Time_Parallel_Periods_Relative_To_Absolute_Filter";
    public static final String TIME_PARALLEL_PERIODS_RELATIVE_TO_RELATIVE_FILTER = "Time_Parallel_Periods_Relative_To_Relative_Filter";
    private static final String START_SPAN_BEGIN = "XAF_#$%$#";
    private static final String START_SPAN_END = "XAF_!!789";
    private static final String NBSPACE = "XAF_%@$x$*";
    private static final String END_SPAN = "XAF_$$**";
    private static StringExpressionUtil expressionUtil = StringExpressionUtil.getInstance();
    private static final String EMPTY_STRING = "";
    @SASScope
    private static final Logger _logger = LogManager.getLogger((String)"AppliedOLAPFilter.class");

    private static String addLabelTextToFilterText(String filterText, String label, String labelSeparator, Locale locale) {
        String completeText = EMPTY_STRING;
        if (filterText != null) {
            if (label != null && label.length() > 0 && labelSeparator != null) {
                label = label + labelSeparator;
            }
            Object[] msgArgs = new Object[]{label, filterText};
            completeText = AppliedFilter.getMessageString(STEP_FILTER, msgArgs, locale);
        }
        return completeText;
    }

    private static List<String> encodeFilterText(List<String> filterStrings) {
        ArrayList<String> encodedStrings = new ArrayList<String>(filterStrings.size());
        for (String s : filterStrings) {
            encodedStrings.add(AppliedFilter.encodeSpecialCharacters(s));
        }
        return encodedStrings;
    }

    private static String encodeSpecialCharacters(String string) {
        if (string == null || string.length() == 0) {
            return EMPTY_STRING;
        }
        int length = string.length();
        string = Strings.replace((String)string, (int)0, (int)(length - 1), (String)START_SPAN_BEGIN, (String)"<span ");
        string = Strings.replace((String)string, (int)0, (int)(length - 1), (String)START_SPAN_END, (String)">");
        string = Strings.replace((String)string, (int)0, (int)(length - 1), (String)END_SPAN, (String)"</span>");
        string = Strings.replace((String)string, (int)0, (int)(length - 1), (String)NBSPACE, (String)"&#160;");
        return string;
    }

    public static List<String> getAllOLAPAppliedFilterDescription(DataSelection model, MetadataInterface metadata, boolean applyPromptValues, Locale locale, boolean showByGroupFilter) {
        List<String> filters = new ArrayList<String>();
        if (model != null && model.getBusinessModel() != null && model.getBusinessModel().getStructure().isOLAP()) {
            DataSourceCube cube = null;
            String cubeName = null;
            try {
                cube = OLAPConnectionInfoUtil.getCube(model);
            }
            catch (GenerationException e) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            if (cube != null) {
                try {
                    cubeName = cube.getCubeName();
                }
                catch (MetadataException e) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (locale == null && metadata != null) {
                try {
                    locale = ConnectionUtil.getConnectionLocale(metadata);
                }
                catch (ExecutionException e) {
                    locale = null;
                }
            }
            if (locale == null) {
                locale = LocaleUtilities.getDefaultComputationalLocale(model);
            }
            List<String> olapFilters = AppliedFilter.getAppliedOLAPFilters(model, ", ", metadata, cubeName, applyPromptValues, locale, showByGroupFilter);
            String andString = AppliedFilter.getStringResource(UTIL_BOOLEAN_AND, locale);
            for (String obj : olapFilters) {
                if (obj.length() <= 0) continue;
                if (filters.size() > 0) {
                    filters.add(andString);
                }
                filters.add(obj);
            }
            filters = AppliedFilter.encodeFilterText(filters);
        }
        return filters;
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getAllRelationalAppliedFilterDescription(DataSelection model, MetadataInterface metadata, boolean applyPromptValues, Locale locale, boolean showByGroupFilter) {
        List<String> filters = new ArrayList<String>();
        if (model != null && model.getBusinessModel() != null && model.getBusinessModel().getStructure().isRelational()) {
            if (locale == null && metadata != null) {
                try {
                    locale = ConnectionUtil.getConnectionLocale(metadata);
                }
                catch (ExecutionException e) {
                    locale = null;
                }
            }
            if (locale == null) {
                locale = LocaleUtilities.getDefaultComputationalLocale(model);
            }
            filters.addAll(AppliedFilter.getAllNonStepRelationalAppliedFilterDescriptions(model, locale, showByGroupFilter, applyPromptValues));
            ArrayList<Object> olapFilters = new ArrayList<Object>();
            List<StepInterface> rowAndColSteps = model.getSteps(Role.ROW);
            rowAndColSteps.addAll(model.getSteps(Role.COLUMN));
            for (int j = 0; j < rowAndColSteps.size(); ++j) {
                Object text = EMPTY_STRING;
                StepInterface step = rowAndColSteps.get(j);
                if (step instanceof DataItemNavigationFilter) continue;
                text = step instanceof com.sas.iquery.metadata.business.step.olap.DataItemRankFilter ? AppliedFilter.getRankStepText(model, (com.sas.iquery.metadata.business.step.olap.DataItemRankFilter)step, locale, applyPromptValues) : (step instanceof BusinessQueryRankFilter ? AppliedFilter.getRankRelationalStepTextForBQRF(model, (BusinessQueryRankFilter)step, locale, applyPromptValues) : step.toString());
                olapFilters.add(text);
            }
            List<DataItem> items = model.getResultItems();
            for (DataItem di : items) {
                String string = EMPTY_STRING;
                List<StepInterface> diSteps = di.getSteps();
                for (int j = diSteps.size() - 1; j >= 0; --j) {
                    void var11_18;
                    StepInterface step = diSteps.get(j);
                    if (step instanceof DataItemNavigationFilter) continue;
                    if (step instanceof DataItemRankFilter) {
                        String string2 = AppliedFilter.getRankRelationalStepText(di, (DataItemRankFilter)step, locale);
                    } else if (step instanceof com.sas.iquery.metadata.business.step.olap.DataItemRankFilter) {
                        String string3 = AppliedFilter.getRankStepText(model, (com.sas.iquery.metadata.business.step.olap.DataItemRankFilter)step, locale, applyPromptValues);
                    } else {
                        String string4 = step.toString();
                    }
                    olapFilters.add(var11_18);
                }
            }
            String andString = AppliedFilter.getStringResource(UTIL_BOOLEAN_AND, locale);
            for (String string : olapFilters) {
                if (string.length() <= 0) continue;
                if (filters.size() > 0) {
                    filters.add(andString);
                }
                filters.add(string);
            }
            filters = AppliedFilter.encodeFilterText(filters);
        }
        return filters;
    }

    private static List<String> getAppliedOLAPFilters(DataSelection model, String labelSeparator, MetadataInterface metadata, String cubeName, boolean applyPromptValues, Locale locale, boolean showByGroupFilter) {
        ArrayList<String> filters = new ArrayList<String>();
        List<FilterItem> filterItems = model.getFilters();
        for (FilterItem filter : filterItems) {
            String dataItemLabel;
            String description;
            boolean showFilter = true;
            if (!showByGroupFilter && ByGroupCreator.isByGroupFilter(model, filter)) {
                showFilter = false;
            }
            if (!showFilter) continue;
            String expressionText = AppliedFilter.getTextForOLAPExpression(model, cubeName, filter.getExpression(), metadata, locale, applyPromptValues);
            List<DataItem> dataItems = filter.getDataItems(1);
            NamedObjectInterface dataItem = null;
            for (DataItem di : dataItems) {
                if (di.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE) continue;
                dataItem = di;
                break;
            }
            if ((description = AppliedFilter.addLabelTextToFilterText(expressionText, dataItemLabel = dataItem != null ? dataItem.getLabel() : null, EMPTY_STRING, locale)) == null || description.length() <= 0) continue;
            filters.add(description);
        }
        List<DataItem> items = model.getResultItems();
        for (DataItem di : items) {
            String text = null;
            List<StepInterface> diSteps = di.getSteps();
            ArrayList stepTypesList = new ArrayList(4);
            for (int j = diSteps.size() - 1; j >= 0; --j) {
                String completeText;
                StepInterface step = diSteps.get(j);
                Class<?> stepClass = step.getClass();
                if (stepTypesList.contains(stepClass) || step instanceof DataItemNavigationFilter) continue;
                stepTypesList.add(stepClass);
                text = AppliedFilter.getTextForStep(model, cubeName, step, metadata, locale, applyPromptValues);
                if (text.trim().length() <= 0 || (completeText = AppliedFilter.addLabelTextToFilterText(text, di.getLabel(), labelSeparator, locale)) == null || completeText.length() <= 0) continue;
                filters.add(completeText);
            }
        }
        filters.addAll(AppliedFilter.getBusinessQueryFiltersForRole(model, Role.COLUMN, metadata, applyPromptValues, locale));
        filters.addAll(AppliedFilter.getBusinessQueryFiltersForRole(model, Role.ROW, metadata, applyPromptValues, locale));
        return filters;
    }

    private static List<String> getBusinessQueryFiltersForRole(DataSelection model, Role role, MetadataInterface metadata, boolean applyPromptValues, Locale locale) {
        ArrayList<String> filters = new ArrayList<String>();
        List<StepInterface> steps = model.getSteps(role);
        for (StepInterface step : steps) {
            String messageText = AppliedFilter.getOLAPBusinessQueryStepFilterDescription(model, role, step, metadata, applyPromptValues, locale);
            if (messageText == null || messageText.length() <= 0) continue;
            filters.add(messageText);
            break;
        }
        return filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFirstLastMemberUniqueNameViaMDX(boolean isFirstWanted, String cubeName, String uniqueLevelName, MetadataInterface metadata) throws OLAPException {
        Object connection = metadata.getConnection();
        String firstLastMemberUniqueName = null;
        StringBuffer query = new StringBuffer();
        if (cubeName != null && !cubeName.trim().equals(EMPTY_STRING) && uniqueLevelName != null && !uniqueLevelName.trim().equals(EMPTY_STRING) && connection != null) {
            query.append("SELECT ");
            if (isFirstWanted) {
                query.append("OPENINGPERIOD(");
            } else {
                query.append("CLOSINGPERIOD(");
            }
            query.append(uniqueLevelName).append(") ON COLUMNS FROM ").append("[").append(cubeName).append("]");
        }
        OLAPDataSet olapDataSet = null;
        try {
            TupleElementInterface[] tupleElements;
            olapDataSet = new OLAPDataSet(connection, query.toString());
            AxisInterface columnAxis = olapDataSet.getResultSetMetadata().getAxes(0, 1)[0];
            TupleInterface[] tempTuples = columnAxis.getTuples(0, -1);
            if (tempTuples.length > 0 && (tupleElements = tempTuples[0].getElements(0, -1)).length > 0) {
                firstLastMemberUniqueName = tupleElements[0].getName();
            }
        }
        catch (OLAPException e) {
            _logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (olapDataSet != null) {
                try {
                    olapDataSet.close();
                }
                catch (OLAPException e) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return firstLastMemberUniqueName;
    }

    private static String getFormatForOperator(ComparisonOperator operator) {
        String format = EMPTY_STRING;
        if (operator == ComparisonOperator.COMPARE_EQ) {
            format = IS_EQUAL;
        } else if (operator == ComparisonOperator.COMPARE_NEQ) {
            format = IS_NOT_EQUAL;
        } else if (operator == ComparisonOperator.COMPARE_GT) {
            format = IS_GREATER_THAN;
        } else if (operator == ComparisonOperator.COMPARE_GE) {
            format = IS_GREATER_THAN_OR_EQUAL;
        } else if (operator == ComparisonOperator.COMPARE_LT) {
            format = IS_LESS_THAN;
        } else if (operator == ComparisonOperator.COMPARE_LE) {
            format = IS_LESS_THAN_OR_EQUAL;
        }
        return format;
    }

    private static String getFormattedDataValueFromExpression(BusinessModel model, Object filter, Locale locale) {
        String returnValue = EMPTY_STRING;
        if (filter != null) {
            SASFormat sasFormat;
            List<ExpressionInterface> leftExps = filter instanceof DataItemDataBasedFilter ? ((DataItemDataBasedFilter)filter).getLeftExpression() : (filter instanceof BusinessQueryDataBasedFilter ? ((BusinessQueryDataBasedFilter)filter).getLeftExpression() : (filter instanceof DataBasedFilterExpression ? ((DataBasedFilterExpression)filter).getLeftExpression() : null));
            List<ModelItem> rightExps = filter instanceof DataItemDataBasedFilter ? ((DataItemDataBasedFilter)filter).getRightExpression() : (filter instanceof BusinessQueryDataBasedFilter ? ((BusinessQueryDataBasedFilter)filter).getRightExpression() : (filter instanceof DataBasedFilterExpression ? ((DataBasedFilterExpression)filter).getRightExpression() : null));
            DataItem di = null;
            if (leftExps != null) {
                if (leftExps.size() == 1 && leftExps.get(0) instanceof DataItem) {
                    di = (DataItem)leftExps.get(0);
                } else if (leftExps.size() == 2 && leftExps.get(1) instanceof DataItem) {
                    di = (DataItem)leftExps.get(1);
                }
            }
            if (di != null && (sasFormat = AppliedFilter.newSASFormat(model, di.getFormat(), locale)) != null && rightExps != null && rightExps.size() == 1 && rightExps.get(0) instanceof StringExpression) {
                try {
                    String valueAsString = ((StringExpression)rightExps.get(0)).getText();
                    Double doubleValue = Double.valueOf(valueAsString);
                    returnValue = sasFormat.format((Object)doubleValue).trim();
                }
                catch (MetadataException e) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (rightExps != null) {
                returnValue = AppliedFilter.getReadableText(rightExps, locale);
            }
        }
        return returnValue;
    }

    private static LevelInterface getLevel(BusinessQuery model, MetadataInterface metadata, String cubeName, String uniqueLevelName, String uniqueMemberName) {
        LevelInterface level = null;
        BusinessModel bm = model.getBusinessModel();
        if (uniqueLevelName == null && uniqueMemberName == null || bm == null) {
            return null;
        }
        try {
            if (metadata != null) {
                if (uniqueLevelName != null) {
                    Filter filter = new Filter();
                    filter.setUniqueLevelName(uniqueLevelName);
                    filter.setCubeName(cubeName);
                    level = metadata.getLevel(filter);
                } else {
                    Filter filter = new Filter();
                    filter.setTreeOperator(Filter.SELF_TREE_OPERATOR);
                    filter.setUniqueMemberName(uniqueMemberName);
                    filter.setCubeName(cubeName);
                    MemberInterface[] members = metadata.getMembers(filter, 0, 1);
                    if (members.length > 0) {
                        level = members[0].getLevel();
                    }
                }
            }
        }
        catch (OLAPException e) {
            _logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return level;
    }

    public static String getOLAPBusinessQueryStepFilterDescription(DataSelection model, Role role, StepInterface step, MetadataInterface metadata, boolean applyPromptValues, Locale locale) {
        String messageText = EMPTY_STRING;
        String filterDescriptionText = step.toString();
        DataSourceCube cube = null;
        String cubeName = EMPTY_STRING;
        try {
            cube = OLAPConnectionInfoUtil.getCube(model);
            cubeName = cube.getCubeName();
            if (locale == null && metadata != null) {
                try {
                    locale = ConnectionUtil.getConnectionLocale(metadata);
                }
                catch (ExecutionException e) {
                    locale = null;
                }
            }
            if (locale == null) {
                locale = LocaleUtilities.getDefaultComputationalLocale(model);
            }
            if (step instanceof BusinessQueryDataBasedFilter) {
                String leftText = AppliedFilter.getReadableTextForMembers(model, cubeName, ((BusinessQueryDataBasedFilter)step).getLeftExpression(), metadata, locale, ".", applyPromptValues);
                String rightText = AppliedFilter.getFormattedDataValueFromExpression(model, step, locale);
                ComparisonOperator operator = ((BusinessQueryDataBasedFilter)step).getOperator();
                String operatorText = ((BusinessQueryDataBasedFilter)step).getOperator().toString();
                String format = AppliedFilter.getFormatForOperator(operator);
                if (format != null && format.length() > 0) {
                    Object[] args = new Object[]{leftText, rightText};
                    messageText = AppliedFilter.getMessageString(format, args, locale);
                } else {
                    Object[] args = new Object[]{leftText, operatorText, rightText};
                    messageText = AppliedFilter.getMessageString(TEXT_FORMAT, args, locale);
                }
            } else if (!(step instanceof BusinessQueryTupleFilter) && step instanceof BusinessQueryRankFilter) {
                messageText = AppliedFilter.getRankStepText(model, cubeName, (BusinessQueryRankFilter)step, metadata, locale, applyPromptValues);
            }
            if (messageText != null && messageText.length() > 0) {
                String label = EMPTY_STRING;
                if (role == Role.ROW) {
                    label = AppliedFilter.getStringResource(ROWS, locale);
                } else if (role == Role.COLUMN) {
                    label = AppliedFilter.getStringResource(COLUMNS, locale);
                }
                label = label + ", ";
                Object[] args = new Object[]{label, messageText};
                filterDescriptionText = AppliedFilter.getMessageString(ROW_COLUMN_FILTER, args, locale);
            }
        }
        catch (GenerationException e) {
            _logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (MetadataException e) {
            _logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return filterDescriptionText;
    }

    public static String getOLAPDataItemStepFilterDescription(DataSelection dataSelection, DataItem dataItem, StepInterface step, MetadataInterface metadata, boolean applyPromptValues, Locale locale) {
        if (locale == null && metadata != null) {
            try {
                locale = ConnectionUtil.getConnectionLocale(metadata);
            }
            catch (ExecutionException e) {
                locale = null;
            }
        }
        if (locale == null) {
            locale = LocaleUtilities.getDefaultComputationalLocale(dataSelection);
        }
        String description = EMPTY_STRING;
        DataSourceCube cube = null;
        String cubeName = EMPTY_STRING;
        try {
            String dataItemLabel;
            String stepText;
            cube = OLAPConnectionInfoUtil.getCube(dataSelection);
            cubeName = cube.getCubeName();
            if (cubeName.length() > 0 && (stepText = AppliedFilter.getTextForStep(dataSelection, cubeName, step, metadata, locale, applyPromptValues)).trim().length() > 0 && (description = AppliedFilter.addLabelTextToFilterText(stepText, dataItemLabel = dataItem != null ? dataItem.getLabel() : null, EMPTY_STRING, locale)) != null && description.length() > 0) {
                description = AppliedFilter.encodeFilterText(Collections.singletonList(description)).get(0);
            }
        }
        catch (MetadataException e) {
            _logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (GenerationException e) {
            _logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return description;
    }

    public static String getOLAPParentFilterDescription(DataSelection model, ExpressionInterface filter, MetadataInterface metadata, boolean applyPromptValues, Locale locale) {
        DataSourceCube cube = null;
        String cubeName = EMPTY_STRING;
        String description = EMPTY_STRING;
        if (locale == null) {
            locale = LocaleUtilities.getDefaultComputationalLocale(model);
        }
        try {
            ExpressionInterface expression;
            cube = OLAPConnectionInfoUtil.getCube(model);
            cubeName = cube.getCubeName();
            if (filter instanceof BaseFilterExpression && (expression = ((BaseFilterExpression)filter).getWhatToCompare()) instanceof DataItem) {
                String expressionText = AppliedFilter.getTextForOLAPExpression(model, cubeName, filter, metadata, locale, applyPromptValues);
                description = AppliedFilter.addLabelTextToFilterText(expressionText, ((DataItem)expression).getLabel(), EMPTY_STRING, locale);
            }
        }
        catch (GenerationException e) {
            _logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (MetadataException e) {
            _logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return description;
    }

    private static String getOLAPTimeFilterFirstLastPeriodsText(BusinessQuery model, String cubeName, MetadataInterface metadata, Locale locale, int n, String searchDirection, String levelName) {
        String text = EMPTY_STRING;
        BusinessQuery bq = model;
        try {
            String levelString1;
            List<String> levelTextNames = AppliedFilter.getReadableTextForTimeLevel(model, metadata, cubeName, levelName, null, locale);
            String currentMemberText = AppliedFilter.queryMetadataForRelativeMemberText(bq, metadata, cubeName, levelName, searchDirection);
            String singularLevelName = EMPTY_STRING;
            String pluralLevelName = EMPTY_STRING;
            if (levelTextNames != null && levelTextNames.size() == 2) {
                singularLevelName = levelTextNames.get(0);
                pluralLevelName = levelTextNames.get(1);
            }
            LevelInterface level = AppliedFilter.getLevel(model, metadata, cubeName, levelName, null);
            int type = 32768;
            if (level != null) {
                try {
                    type = level.getType();
                }
                catch (OLAPException e) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            String firstLevelText = RelativeTimeFilterValueFormatter.getReadableTextForTimeLevel((int)type, (int)0, (Locale)locale);
            String lastLevelText = RelativeTimeFilterValueFormatter.getReadableTextForTimeLevel((int)type, (int)1, (Locale)locale);
            String string = levelString1 = n > 1 ? pluralLevelName : singularLevelName;
            if (searchDirection.equals("BACKWARD")) {
                if (currentMemberText.length() > 0) {
                    Object[] args = new Object[]{n, levelString1, lastLevelText, currentMemberText};
                    text = AppliedFilter.getMessageString(TIME_LAST_PERIODS_RELATIVE_FILTER, args, locale);
                }
            } else if (currentMemberText.length() > 0) {
                Object[] args = new Object[]{n, levelString1, firstLevelText, currentMemberText};
                text = AppliedFilter.getMessageString(TIME_FIRST_PERIODS_RELATIVE_FILTER, args, locale);
            }
        }
        catch (MetadataException e) {
            _logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (OLAPException e) {
            _logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return text;
    }

    private static String getOLAPTimeFilterNPeriodsText(BusinessQuery model, String cubeName, MetadataInterface metadata, Locale locale, int n, String searchDirection, String dateMember, boolean applyPromptValues) {
        String memberText = AppliedFilter.getReadableTextForMembers(model, cubeName, Collections.singletonList(dateMember), metadata, locale, ",", applyPromptValues);
        List<String> levelTextNames = AppliedFilter.getReadableTextForTimeLevel(model, metadata, cubeName, null, dateMember, locale);
        String singularLevelName = EMPTY_STRING;
        String pluralLevelName = EMPTY_STRING;
        if (levelTextNames.size() == 2) {
            singularLevelName = levelTextNames.get(0);
            pluralLevelName = levelTextNames.get(1);
        }
        String format = searchDirection.equals("BACKWARD") ? TIME_LAST_PERIODS_FILTER : TIME_FIRST_PERIODS_FILTER;
        String levelStringText = n > 1 ? pluralLevelName : singularLevelName;
        Object[] args = new Object[]{n, levelStringText, memberText};
        return AppliedFilter.getMessageString(format, args, locale);
    }

    private static String getOLAPTimeRangeFilterText(BusinessQuery model, String cubeName, MetadataInterface metadata, Locale locale, String startDateMember, String endDateMember, String levelName, boolean applyPromptValues) {
        boolean isStartMemberRelative = startDateMember == null;
        boolean isEndMemberRelative = endDateMember == null;
        String text = EMPTY_STRING;
        try {
            String pluralLevelText = EMPTY_STRING;
            List<String> levelTextNames = null;
            LevelInterface level = null;
            if (levelName != null) {
                levelTextNames = AppliedFilter.getReadableTextForTimeLevel(model, metadata, cubeName, levelName, null, locale);
                level = AppliedFilter.getLevel(model, metadata, cubeName, levelName, null);
            } else {
                String memberName = startDateMember != null ? startDateMember : endDateMember;
                levelTextNames = AppliedFilter.getReadableTextForTimeLevel(model, metadata, cubeName, null, memberName, locale);
                level = AppliedFilter.getLevel(model, metadata, cubeName, null, memberName);
            }
            if (levelTextNames != null && levelTextNames.size() == 2) {
                pluralLevelText = levelTextNames.get(1).toString();
            }
            int type = 32768;
            if (level != null) {
                try {
                    type = level.getType();
                }
                catch (OLAPException e) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            String firstLevelText = RelativeTimeFilterValueFormatter.getReadableTextForTimeLevel((int)type, (int)0, (Locale)locale);
            String lastLevelText = RelativeTimeFilterValueFormatter.getReadableTextForTimeLevel((int)type, (int)1, (Locale)locale);
            String startDateMemberText = EMPTY_STRING;
            startDateMemberText = isStartMemberRelative ? AppliedFilter.queryMetadataForRelativeMemberText(model, metadata, cubeName, levelName, "FORWARD") : AppliedFilter.getReadableTextForMembers(model, cubeName, Collections.singletonList(startDateMember), metadata, locale, ",", applyPromptValues);
            String endDateMemberText = EMPTY_STRING;
            endDateMemberText = isEndMemberRelative ? AppliedFilter.queryMetadataForRelativeMemberText(model, metadata, cubeName, levelName, "BACKWARD") : AppliedFilter.getReadableTextForMembers(model, cubeName, Collections.singletonList(endDateMember), metadata, locale, ",", applyPromptValues);
            if (!isStartMemberRelative && !isEndMemberRelative) {
                Object[] args = new Object[]{pluralLevelText, startDateMemberText, endDateMemberText};
                text = AppliedFilter.getMessageString(TIME_RANGE_ABSOLUTE_TO_ABSOLUTE_FILTER, args, locale);
            } else if (isStartMemberRelative && isEndMemberRelative) {
                Object[] args = new Object[]{pluralLevelText, firstLevelText, startDateMemberText, lastLevelText, endDateMemberText};
                text = AppliedFilter.getMessageString(TIME_RANGE_RELATIVE_TO_RELATIVE_FILTER, args, locale);
            } else if (isStartMemberRelative && !isEndMemberRelative) {
                Object[] args = new Object[]{pluralLevelText, firstLevelText, startDateMemberText, endDateMemberText};
                text = AppliedFilter.getMessageString(TIME_RANGE_RELATIVE_TO_ABSOLUTE_FILTER, args, locale);
            } else if (!isStartMemberRelative && isEndMemberRelative) {
                Object[] args = new Object[]{pluralLevelText, startDateMemberText, lastLevelText, endDateMemberText};
                text = AppliedFilter.getMessageString(TIME_RANGE_ABSOLUTE_TO_RELATIVE_FILTER, args, locale);
            }
        }
        catch (MetadataException e) {
            _logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (OLAPException e) {
            _logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return text;
    }

    private static RankOrderEnum getRankOrder(String iqRankOrder) {
        Object order = "Top".equals(iqRankOrder) ? RankOrderEnum.TOP : ("Bottom".equals(iqRankOrder) ? RankOrderEnum.BOTTOM : null);
        return order;
    }

    private static String getRankRelationalStepText(DataItem di, DataItemRankFilter filter, Locale locale) {
        String rankTypeString = AppliedFilter.getRelationalRankTypeString(filter, locale);
        String rankOrder = filter.getRankOrder() == 0 ? RANK_TOP : RANK_BOTTOM;
        rankOrder = AppliedFilter.getStringResource(rankOrder, locale);
        int rankValue = filter.getValue();
        String msgPattern = filter.isIncludeTies() ? RANK_WITH_TIES : RANK_WITHOUT_TIES;
        String byRankName = di.getLabel(locale);
        if (byRankName == null || byRankName.length() == 0) {
            byRankName = di.toString();
        }
        Object[] args = new Object[]{rankOrder, rankValue, rankTypeString, byRankName};
        return AppliedFilter.getMessageString(msgPattern, args, locale);
    }

    private static String getRankRelationalStepTextForBQRF(BusinessQuery model, BusinessQueryRankFilter filter, Locale locale, boolean applyPromptValues) {
        String rankType = filter.getRankType();
        if (rankType.equals("Sum")) {
            rankType = AppliedFilter.getStringResource(RANK_SUM, locale);
        } else if (rankType.equals("Count")) {
            rankType = AppliedFilter.getStringResource(RANK_COUNT, locale);
        } else if (rankType.equals("Percent")) {
            rankType = AppliedFilter.getStringResource(RANK_PERCENT, locale);
        }
        String rankOrder = "Top".equals(filter.getRankOrder()) ? RANK_TOP : RANK_BOTTOM;
        rankOrder = AppliedFilter.getStringResource(rankOrder, locale);
        int rankValue = filter.getValue();
        String msgPattern = filter.isIncludeTies() ? RANK_WITH_TIES : RANK_WITHOUT_TIES;
        List qualifiers = filter.getRankQualifiers();
        String byRankName = AppliedFilter.getTextForValueList(qualifiers, model, locale, LIST_OF_VALUES, LIST_OF_VALUES_JOIN, LIST_OF_VALUES_SEPARATOR, applyPromptValues);
        Object[] args = new Object[]{rankOrder, rankValue, rankType, byRankName};
        return AppliedFilter.getMessageString(msgPattern, args, locale);
    }

    private static String getRelationalRankTypeString(DataItemRankFilter filter, Locale locale) {
        String rankTypeString = EMPTY_STRING;
        switch (filter.getRankType()) {
            case 0: {
                rankTypeString = RANK_COUNT;
                break;
            }
            case 1: {
                rankTypeString = RANK_PERCENT;
                break;
            }
            case 2: {
                rankTypeString = RANK_SUM;
            }
        }
        return AppliedFilter.getStringResource(rankTypeString, locale);
    }

    private static String getRankStepText(BusinessQuery model, com.sas.iquery.metadata.business.step.olap.DataItemRankFilter filter, Locale locale, boolean applyPromptValues) {
        String rankTypeString = EMPTY_STRING;
        switch (filter.getRankType()) {
            case 0: {
                rankTypeString = RANK_COUNT;
                break;
            }
            case 1: {
                rankTypeString = RANK_PERCENT;
                break;
            }
            case 2: {
                rankTypeString = RANK_SUM;
            }
        }
        rankTypeString = AppliedFilter.getStringResource(rankTypeString, locale);
        String rankOrder = filter.getRankOrder() == 0 ? RANK_TOP : RANK_BOTTOM;
        rankOrder = AppliedFilter.getStringResource(rankOrder, locale);
        int rankValue = filter.getValue();
        String msgPattern = filter.isIncludeTies() ? RANK_WITH_TIES : RANK_WITHOUT_TIES;
        List<ExpressionInterface> rankQualifiers = filter.getRankQualifiers();
        String readableTextForMembers = AppliedFilter.getTextForValueList(rankQualifiers, model, locale, LIST_OF_VALUES, LIST_OF_VALUES_JOIN, LIST_OF_VALUES_SEPARATOR, applyPromptValues);
        Object[] msgArgs = new Object[]{rankOrder, rankValue, rankTypeString, readableTextForMembers};
        return AppliedFilter.getMessageString(msgPattern, msgArgs, locale);
    }

    private static String getRankStepText(BusinessQuery model, String cubeName, BusinessQueryRankFilter filter, MetadataInterface metadata, Locale locale, boolean applyPromptValues) {
        String rankOrderString = EMPTY_STRING;
        String rankTypeString = EMPTY_STRING;
        RankOrderEnum roe = AppliedFilter.getRankOrder(filter.getRankOrder());
        if (roe == RankOrderEnum.TOP) {
            rankOrderString = RANK_TOP;
        } else if (roe == RankOrderEnum.BOTTOM) {
            rankOrderString = RANK_BOTTOM;
        }
        rankOrderString = AppliedFilter.getStringResource(rankOrderString, locale);
        RankTypeEnum rte = AppliedFilter.getRankType(filter.getRankType());
        if (rte == RankTypeEnum.COUNT) {
            rankTypeString = RANK_COUNT;
        } else if (rte == RankTypeEnum.PERCENT) {
            rankTypeString = RANK_PERCENT;
        } else if (rte == RankTypeEnum.SUM) {
            rankTypeString = RANK_SUM;
        }
        rankTypeString = AppliedFilter.getStringResource(rankTypeString, locale);
        int rankValue = filter.getValue();
        String msgPattern = filter.isIncludeTies() ? RANK_WITH_TIES : RANK_WITHOUT_TIES;
        String readableTextForMembers = AppliedFilter.getReadableTextForMembers(model, cubeName, filter.getRankQualifiers(), metadata, locale, ".", applyPromptValues);
        if (readableTextForMembers.trim().length() == 0) {
            msgPattern = filter.isIncludeTies() ? OLAP_RANK_WITH_TIES : OLAP_RANK_WITHOUT_TIES;
            Object[] args = new Object[]{rankOrderString, rankValue, rankTypeString};
            return AppliedFilter.getMessageString(msgPattern, args, locale);
        }
        Object[] args = new Object[]{rankOrderString, rankValue, rankTypeString, readableTextForMembers};
        return AppliedFilter.getMessageString(msgPattern, args, locale);
    }

    private static String getStringResource(String key, Locale locale) {
        try {
            return IQUtilResourceBundle.getStringResource(key, locale);
        }
        catch (Exception e) {
            _logger.error(e.getLocalizedMessage(), (Throwable)e);
            return EMPTY_STRING;
        }
    }

    private static RankTypeEnum getRankType(String iqRankType) {
        Object type = "Count".equals(iqRankType) ? RankTypeEnum.COUNT : ("Percent".equals(iqRankType) ? RankTypeEnum.PERCENT : ("Sum".equals(iqRankType) ? RankTypeEnum.SUM : null));
        return type;
    }

    private static String getReadableText(List list, Locale locale) {
        StringBuilder sb = new StringBuilder();
        int kSize = list.size();
        for (int k = 0; k < kSize; ++k) {
            try {
                ExpressionInterface stringExpression = (ExpressionInterface)list.get(k);
                String readableText = expressionUtil.getReadableText(stringExpression);
                if (readableText == null) continue;
                if (k != 0) {
                    sb.append(", ");
                }
                sb.append(readableText);
                continue;
            }
            catch (MetadataException e) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return sb.toString();
    }

    private static String getReadableTextForMembers(BusinessQuery model, String cubeName, List list, MetadataInterface metadata, Locale locale, String separator, boolean applyPromptValue) {
        StringBuilder sb = new StringBuilder();
        BusinessQuery bq = model;
        if (list != null) {
            int kSize = list.size();
            for (int k = 0; k < kSize; ++k) {
                try {
                    ConstantExpression cont;
                    String uniqueMemberName;
                    String memberText = null;
                    Object obj = list.get(k);
                    if (obj instanceof StringExpression) {
                        String readableText = expressionUtil.getReadableText((StringExpression)obj);
                        memberText = AppliedFilter.queryMetadataForMemberText(bq, metadata, cubeName, readableText);
                    } else if (obj instanceof DataItem) {
                        memberText = ((DataItem)obj).getLabel();
                    } else if (obj instanceof String) {
                        String uniqueMemberName2 = (String)obj;
                        if (uniqueMemberName2.length() > 0) {
                            memberText = AppliedFilter.queryMetadataForMemberText(bq, metadata, cubeName, uniqueMemberName2);
                        }
                    } else if (obj instanceof Prompt) {
                        memberText = AppliedFilter.getPromptDescription((Prompt)obj, bq, locale, applyPromptValue);
                        if (memberText == null) {
                            memberText = ((Prompt)obj).getLabel();
                        }
                    } else if (obj instanceof ConstantExpression && (uniqueMemberName = (cont = (ConstantExpression)obj).getValue()).length() > 0) {
                        memberText = AppliedFilter.queryMetadataForMemberText(bq, metadata, cubeName, uniqueMemberName);
                    }
                    if (memberText == null || memberText.length() <= 0) continue;
                    if (k != 0) {
                        sb.append(separator);
                    }
                    sb.append(memberText);
                    continue;
                }
                catch (MetadataException e) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                    continue;
                }
                catch (OLAPException e) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return sb.toString();
    }

    @Nonnull
    private static List<String> getReadableTextForTimeLevel(BusinessQuery model, MetadataInterface metadata, String cubeName, String uniqueLevelName, String uniqueMemberName, Locale locale) {
        LevelInterface level = AppliedFilter.getLevel(model, metadata, cubeName, uniqueLevelName, uniqueMemberName);
        ArrayList<String> levelNameList = new ArrayList<String>(2);
        if (level != null) {
            int type = 32768;
            try {
                type = level.getType();
            }
            catch (OLAPException e) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            switch (type) {
                case 1024: {
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_DAY, locale));
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_DAYS, locale));
                    break;
                }
                case 64: {
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_HALF_YEAR, locale));
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_HALF_YEARS, locale));
                    break;
                }
                case 2048: {
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_HOUR, locale));
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_HOURS, locale));
                    break;
                }
                case 4096: {
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_MINUTE, locale));
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_MINUTES, locale));
                    break;
                }
                case 256: {
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_MONTH, locale));
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_MONTHS, locale));
                    break;
                }
                case 128: {
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_QTR, locale));
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_QTRS, locale));
                    break;
                }
                case 8192: {
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_SECOND, locale));
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_SECONDS, locale));
                    break;
                }
                case 512: {
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_WEEK, locale));
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_WEEKS, locale));
                    break;
                }
                case 32: {
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_YEAR, locale));
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_YEARS, locale));
                    break;
                }
                case 16384: {
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_PERIOD, locale));
                    levelNameList.add(AppliedFilter.getStringResource(OLAP_TIME_FILTER_PERIODS, locale));
                    break;
                }
            }
        }
        return levelNameList;
    }

    private static String getTextForOLAPExpression(BusinessQuery model, String cubeName, ExpressionInterface expression, MetadataInterface metadata, Locale locale, boolean applyPromptValues) {
        String text = EMPTY_STRING;
        if (expression instanceof MemberFilterExpression) {
            List<ExpressionInterface> members = ((MemberFilterExpression)expression).getMemberNames();
            text = AppliedFilter.getReadableTextForMembers(model, cubeName, members, metadata, locale, ", ", applyPromptValues);
            Object[] msgArgs = new Object[]{text};
            text = ((MemberFilterExpression)expression).isNegated() ? AppliedFilter.getMessageString(OLAP_IS_NOT_EQUAL_TO, msgArgs, locale) : AppliedFilter.getMessageString(OLAP_EQUAL_TO, msgArgs, locale);
        } else if (expression instanceof DataBasedFilterExpression) {
            String leftText = AppliedFilter.getReadableTextForMembers(model, cubeName, ((DataBasedFilterExpression)expression).getLeftExpression(), metadata, locale, ".", applyPromptValues);
            String rightText = AppliedFilter.getReadableText(((DataBasedFilterExpression)expression).getRightExpression(), locale);
            ComparisonOperator operator = ((DataBasedFilterExpression)expression).getComparisonOperator();
            String operatorText = ((DataBasedFilterExpression)expression).getComparisonOperator().toString();
            String format = AppliedFilter.getFormatForOperator(operator);
            if (format.length() > 0) {
                Object[] args = new Object[]{leftText, rightText};
                text = AppliedFilter.getMessageString(format, args, locale);
            } else {
                Object[] args = new Object[]{leftText, operatorText, rightText};
                text = AppliedFilter.getMessageString(TEXT_FORMAT, args, locale);
            }
        } else if (expression instanceof TimeFilterNPeriodsExpression) {
            TimeFilterNPeriodsExpression timeFilter = (TimeFilterNPeriodsExpression)expression;
            ExpressionInterface periods = timeFilter.getPeriods();
            int n = 0;
            if (periods != null) {
                String per = periods.toString();
                n = Integer.parseInt(per);
            }
            String searchDirection = timeFilter.getSearchDirection();
            ExpressionInterface date = timeFilter.getDate();
            String dateMember = null;
            if (date != null) {
                dateMember = date.toString();
            }
            text = AppliedFilter.getOLAPTimeFilterNPeriodsText(model, cubeName, metadata, locale, n, searchDirection, dateMember, applyPromptValues);
        } else if (expression instanceof TimeFilterFirstLastPeriodsExpression) {
            TimeFilterFirstLastPeriodsExpression timeFilter = (TimeFilterFirstLastPeriodsExpression)expression;
            ExpressionInterface periods = timeFilter.getPeriods();
            int n = 0;
            if (periods != null) {
                String per = periods.toString();
                n = Integer.parseInt(per);
            }
            String searchDirection = timeFilter.getSearchDirection();
            ExpressionInterface level = timeFilter.getLevel();
            String levelName = null;
            if (level != null) {
                levelName = level.toString();
            }
            text = AppliedFilter.getOLAPTimeFilterFirstLastPeriodsText(model, cubeName, metadata, locale, n, searchDirection, levelName);
        } else if (!(expression instanceof TimeFilterNParallelPeriodsExpression) && expression instanceof TimeRangeFilterExpression) {
            TimeRangeFilterExpression timeFilter = (TimeRangeFilterExpression)expression;
            ExpressionInterface startDate = timeFilter.getStartMember();
            ExpressionInterface endDate = timeFilter.getEndMember();
            ExpressionInterface level = timeFilter.getLevelName();
            String startDateMember = null;
            String endDateMember = null;
            String levelName = null;
            if (startDate != null) {
                startDateMember = startDate.toString();
            }
            if (endDate != null) {
                endDateMember = endDate.toString();
            }
            if (level != null) {
                levelName = level.toString();
            }
            text = AppliedFilter.getOLAPTimeRangeFilterText(model, cubeName, metadata, locale, startDateMember, endDateMember, levelName, applyPromptValues);
        }
        return text;
    }

    private static String getTextForStep(BusinessQuery model, String cubeName, StepInterface step, MetadataInterface metadata, Locale locale, boolean applyPromptValues) {
        String text;
        block28: {
            text = EMPTY_STRING;
            if (step instanceof CompoundStep) {
                List<StepInterface> steps = ((CompoundStep)step).getSteps();
                List<String> stepConditions = ((CompoundStep)step).getStepsConditions();
                int conditionSize = stepConditions.size();
                int kSize = steps.size();
                for (int k = 0; k < kSize; ++k) {
                    StepInterface cStep = steps.get(k);
                    String newText = AppliedFilter.getTextForStep(model, cubeName, cStep, metadata, locale, applyPromptValues);
                    if (newText == null || newText.trim().length() <= 0) continue;
                    if (kSize > 1) {
                        newText = "(" + newText + ")";
                    }
                    text = text.length() == 0 ? newText : text + newText;
                    if (conditionSize <= k) continue;
                    text = text + " " + stepConditions.get(k) + " ";
                }
            } else if (step instanceof DataItemMemberFilter) {
                List<NonCalculatedValue> members = ((DataItemMemberFilter)step).getMemberNames();
                text = AppliedFilter.getReadableTextForMembers(model, cubeName, members, metadata, locale, ", ", applyPromptValues);
                Object[] msgArgs = new Object[]{text};
                text = ((DataItemMemberFilter)step).isNegated() ? AppliedFilter.getMessageString(OLAP_IS_NOT_EQUAL_TO, msgArgs, locale) : AppliedFilter.getMessageString(OLAP_EQUAL_TO, msgArgs, locale);
            } else if (step instanceof com.sas.iquery.metadata.business.step.olap.DataItemRankFilter) {
                text = AppliedFilter.getRankStepText(model, (com.sas.iquery.metadata.business.step.olap.DataItemRankFilter)step, locale, applyPromptValues);
            } else if (step instanceof DataItemMemberPropertiesFilter) {
                String propertyName = ((DataItemMemberPropertiesFilter)step).getMemberPropertyName();
                Filter filter = new Filter();
                filter.setPropertyName(propertyName);
                filter.setCubeName(cubeName);
                try {
                    String propertyLabel = EMPTY_STRING;
                    if (metadata != null) {
                        PropertyInterface[] properties = metadata.getProperties(filter);
                        propertyLabel = properties[0].getLabel();
                    }
                    String rightText = AppliedFilter.getReadableText(((DataItemMemberPropertiesFilter)step).getRightExpression(), locale);
                    ComparisonOperator operator = ((DataItemMemberPropertiesFilter)step).getOperator();
                    String operatorText = ((DataItemMemberPropertiesFilter)step).getOperator().toString();
                    String format = AppliedFilter.getFormatForOperator(operator);
                    if (format.length() > 0) {
                        Object[] args = new Object[]{propertyLabel, rightText};
                        text = AppliedFilter.getMessageString(format, args, locale);
                        break block28;
                    }
                    Object[] args = new Object[]{propertyLabel, operatorText, rightText};
                    text = AppliedFilter.getMessageString(TEXT_FORMAT, args, locale);
                }
                catch (OLAPException e) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            } else if (step instanceof DataItemDataBasedFilter) {
                String leftText = AppliedFilter.getReadableTextForMembers(model, cubeName, ((DataItemDataBasedFilter)step).getLeftExpression(), metadata, locale, ".", applyPromptValues);
                String rightText = AppliedFilter.getFormattedDataValueFromExpression(model.getBusinessModel(), step, locale);
                ComparisonOperator operator = ((DataItemDataBasedFilter)step).getOperator();
                String operatorText = ((DataItemDataBasedFilter)step).getOperator().toString();
                String format = AppliedFilter.getFormatForOperator(operator);
                if (format != null && format.length() > 0) {
                    Object[] args = new Object[]{leftText, rightText};
                    text = AppliedFilter.getMessageString(format, args, locale);
                } else {
                    Object[] args = new Object[]{leftText, operatorText, rightText};
                    text = AppliedFilter.getMessageString(TEXT_FORMAT, args, locale);
                }
            } else if (step instanceof DataItemTimeNPeriodsFilter) {
                DataItemTimeNPeriodsFilter timeFilter = (DataItemTimeNPeriodsFilter)step;
                ExpressionInterface periods = timeFilter.getPeriods();
                int n = 0;
                if (periods != null) {
                    String per = periods.toString();
                    n = Integer.parseInt(per);
                }
                String searchDirection = timeFilter.getSearchDirection();
                String dateMember = timeFilter.getMember().toString();
                text = AppliedFilter.getOLAPTimeFilterNPeriodsText(model, cubeName, metadata, locale, n, searchDirection, dateMember, applyPromptValues);
            } else if (step instanceof DataItemTimeFirstLastPeriodsFilter) {
                DataItemTimeFirstLastPeriodsFilter timeFilter = (DataItemTimeFirstLastPeriodsFilter)step;
                ExpressionInterface periods = timeFilter.getPeriods();
                int n = 0;
                if (periods != null) {
                    String per = periods.toString();
                    n = Integer.parseInt(per);
                }
                String searchDirection = timeFilter.getSearchDirection();
                String levelName = timeFilter.getLevel().toString();
                text = AppliedFilter.getOLAPTimeFilterFirstLastPeriodsText(model, cubeName, metadata, locale, n, searchDirection, levelName);
            } else if (!(step instanceof DataItemTimeNParallelPeriodsFilter) && step instanceof DataItemTimeRangeFilter) {
                DataItemTimeRangeFilter timeFilter = (DataItemTimeRangeFilter)step;
                ExpressionInterface startDate = timeFilter.getStartMember();
                ExpressionInterface endDate = timeFilter.getEndMember();
                ExpressionInterface level = timeFilter.getLevelName();
                String startDateMember = null;
                String endDateMember = null;
                String levelName = null;
                if (startDate != null) {
                    startDateMember = startDate.toString();
                }
                if (endDate != null) {
                    endDateMember = endDate.toString();
                }
                if (level != null) {
                    levelName = level.toString();
                }
                text = AppliedFilter.getOLAPTimeRangeFilterText(model, cubeName, metadata, locale, startDateMember, endDateMember, levelName, applyPromptValues);
            }
        }
        return text;
    }

    private static SASFormat newSASFormat(BusinessModel model, String formatName, Locale locale) {
        SASFormat theSASFormat = null;
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale(model);
        }
        if (formatName != null && (formatName = formatName.trim()).length() > 0) {
            try {
                theSASFormat = SASFormat.getInstance((String)formatName, (Locale)locale);
            }
            catch (RuntimeException e) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return theSASFormat;
    }

    private static String queryMetadataForMemberText(BusinessQuery bq, MetadataInterface metadata, String cubeName, String uniqueMemberName) throws MetadataException, OLAPException {
        String memberText = EMPTY_STRING;
        Filter filter = new Filter();
        filter.setTreeOperator(Filter.ANCESTORS_TREE_OPERATOR | Filter.SELF_TREE_OPERATOR);
        filter.setUniqueMemberName(uniqueMemberName);
        filter.setCubeName(cubeName);
        if (metadata != null) {
            MemberInterface[] members = metadata.getMembers(filter, 0, -1);
            Arrays.sort(members, MemberLevelComparator.defaultInstance);
            for (MemberInterface member : members) {
                if (member.getType() == 2 && members.length != 1) continue;
                String label = member.getLabel().trim();
                if (memberText != null) {
                    if (memberText.length() > 0) {
                        memberText = memberText + ".";
                    }
                    memberText = memberText + label;
                    continue;
                }
                memberText = label;
            }
        }
        return memberText;
    }

    private static String queryMetadataForRelativeMemberText(BusinessQuery bq, MetadataInterface metadata, String cubeName, String uniqueLevelName, String direction) throws MetadataException, OLAPException {
        LevelInterface level;
        String memberText = EMPTY_STRING;
        String memberUniqueName = null;
        Filter filter = new Filter();
        filter.setUniqueLevelName(uniqueLevelName);
        filter.setCubeName(cubeName);
        if (metadata != null && (level = metadata.getLevel(filter)) != null && direction != null) {
            MemberInterface[] members = null;
            int index = 0;
            if (direction.equals("BACKWARD")) {
                try {
                    index = level.getMemberCount() - 1;
                }
                catch (OLAPException e) {
                    index = -1;
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                    memberUniqueName = AppliedFilter.getFirstLastMemberUniqueNameViaMDX(false, cubeName, uniqueLevelName, metadata);
                }
            }
            if (index >= 0) {
                try {
                    members = metadata.getMembers(filter, index, 1);
                }
                catch (OLAPException e) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                    String string = memberUniqueName = direction.equals("BACKWARD") ? AppliedFilter.getFirstLastMemberUniqueNameViaMDX(false, cubeName, uniqueLevelName, metadata) : AppliedFilter.getFirstLastMemberUniqueNameViaMDX(true, cubeName, uniqueLevelName, metadata);
                }
            }
            if (members != null && members.length > 0) {
                memberUniqueName = members[0].getUniqueName();
            }
        }
        if (memberUniqueName != null) {
            memberText = AppliedFilter.queryMetadataForMemberText(bq, metadata, cubeName, memberUniqueName);
        }
        return memberText;
    }

    private static String getPromptDescription(Prompt prompt, BusinessQuery businessQuery, Locale locale, boolean applyPromptValue) {
        PromptValuesInterface promptValues;
        String promptValueString = null;
        String promptText = null;
        PromptDefinitionInterface promptDefinition = prompt.getPromptDefinition();
        if (promptDefinition != null && ((promptText = promptDefinition.getPromptLabel(locale)) == null || promptText.trim().length() == 0)) {
            promptText = promptDefinition.getPromptDescription(locale);
        }
        if (applyPromptValue && businessQuery != null && (promptValues = businessQuery.getPromptValues()) != null) {
            try {
                if (promptValues.isPromptValueAvailable(prompt.getPromptDefinition())) {
                    Object value = promptValues.getPromptValue(prompt.getPromptDefinition());
                    DataTypeInterface promptDataType = prompt.getPromptDefinition().getPromptDataType();
                    promptValueString = promptDataType.getDisplayString(value, locale);
                    if (promptValueString != null && promptValueString.length() > 0) {
                        promptText = promptValueString;
                    }
                }
            }
            catch (PromptValueNotFoundException e) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return promptText;
    }

    private static String getTextForMultipleConditionalExpression(MultipleConditionalExpression expression, BusinessQuery model, Locale locale, boolean applyPromptValues) {
        boolean isNegated = expression.isNegated();
        String outerFormat = isNegated ? NOT_GROUP : GROUP;
        List<ExpressionInterface> list = expression.getExpressionList();
        String seprFormat = AppliedFilter.getConditionalRelationTypeText(expression.getRelationType());
        return AppliedFilter.getTextForValueList(list, model, locale, outerFormat, COMPOUND_JOIN, seprFormat, applyPromptValues);
    }

    private static String getTextForConditionalExpression_Contains(SimpleConditionalExpression_Contains expression, BusinessQuery model, Locale locale, boolean applyPromptValues) {
        String msgFormat = expression.isNegated() ? DOES_NOT_CONTAIN : CONTAINS;
        String whatToCompare = AppliedFilter.getTextForRelationalExpression(expression.getWhatToCompare(), model, locale, applyPromptValues);
        String whatToContain = AppliedFilter.getTextForRelationalExpression(expression.getWhatToContain(), model, locale, applyPromptValues);
        Object[] args = new Object[]{whatToCompare, whatToContain};
        return AppliedFilter.getMessageString(msgFormat, args, locale);
    }

    private static String getTextForConditionalExpression_Between(SimpleConditionalExpression_Between expression, BusinessQuery model, Locale locale, boolean applyPromptValues) {
        boolean isNegated = expression.isNegated();
        ExpressionInterface what = expression.getWhatToCompare();
        ExpressionInterface left = expression.getLeftExpression();
        ExpressionInterface right = expression.getRightExpression();
        if (left == null && right != null || right == null && left != null) {
            String msgFormat = isNegated ? AppliedFilter.getFormatForOperator(ComparisonOperator.COMPARE_NEQ) : AppliedFilter.getFormatForOperator(ComparisonOperator.COMPARE_EQ);
            return AppliedFilter.getTextForComparisonExpression(what, msgFormat, left == null ? right : left, model, locale, applyPromptValues);
        }
        return AppliedFilter.getTextForBetweenExpression(isNegated, what, left, right, model, locale, applyPromptValues);
    }

    private static String getTextForConditionalExpression_In(SimpleConditionalExpression_In expression, BusinessQuery model, Locale locale, boolean applyPromptValues) {
        String msgFormat = expression.isNegated() ? IS_NOT_IN_LIST_OR_EQUAL_TO : IS_IN_LIST_OR_EQUAL_TO;
        String whatToCompare = AppliedFilter.getTextForRelationalExpression(expression.getWhatToCompare(), model, locale, applyPromptValues);
        String comparisonList = AppliedFilter.getTextForValueList(expression.getComparisonList(), model, locale, LIST_OF_VALUES, LIST_OF_VALUES_JOIN, LIST_OF_VALUES_SEPARATOR, applyPromptValues);
        Object[] args = new Object[]{whatToCompare, comparisonList};
        return AppliedFilter.getMessageString(msgFormat, args, locale);
    }

    private static String getTextForConditionalExpression_Like(SimpleConditionalExpression_Like expression, BusinessQuery model, Locale locale, boolean applyPromptValues) {
        Object[] args;
        String msgFormat = expression.isNegated() ? NOT_LIKE : LIKE;
        String whatToCompare = AppliedFilter.getTextForRelationalExpression(expression.getWhatToCompare(), model, locale, applyPromptValues);
        String likePattern = AppliedFilter.getTextForRelationalExpression(expression.getPatternExpression(), model, locale, applyPromptValues);
        Character escape = expression.getEscapeCharacter();
        if (escape != null) {
            args = new Object[]{escape};
            likePattern = likePattern.concat(AppliedFilter.getMessageString(ESCAPE, args, locale));
        }
        args = new Object[]{whatToCompare, likePattern};
        return AppliedFilter.getMessageString(msgFormat, args, locale);
    }

    private static String getTextForConditionalExpression_TestForNull(SimpleConditionalExpression_TestForNull expression, BusinessQuery model, Locale locale, boolean applyPromptValues) {
        String msgFormat = expression.isNegated() ? IS_NOT_NULL : IS_NULL;
        String whatToCompare = AppliedFilter.getTextForRelationalExpression(expression.getWhatToCompare(), model, locale, applyPromptValues);
        Object[] args = new Object[]{whatToCompare};
        return AppliedFilter.getMessageString(msgFormat, args, locale);
    }

    private static String getTextForCompoundConditionalExpression(CompoundConditionalExpression expression, BusinessQuery model, Locale locale, boolean applyPromptValues) {
        boolean isNegated = expression.isNegated();
        ExpressionInterface left = expression.getLeftExpression();
        ConditionalRelationType type = expression.getRelationType();
        ExpressionInterface right = expression.getRightExpression();
        if (type == null && (left == null && right != null || right == null && left != null)) {
            String msgFormat = isNegated ? NOT_GROUP : GROUP;
            String text = EMPTY_STRING;
            text = left != null ? AppliedFilter.getTextForRelationalExpression(left, model, locale, applyPromptValues) : AppliedFilter.getTextForRelationalExpression(right, model, locale, applyPromptValues);
            Object[] args = new Object[]{text};
            return AppliedFilter.getMessageString(msgFormat, args, locale);
        }
        String msgFormat = isNegated ? NOT_COMPOUND : COMPOUND;
        String leftExpression = AppliedFilter.getTextForRelationalExpression(left, model, locale, applyPromptValues);
        String typeString = AppliedFilter.getStringResource(AppliedFilter.getConditionalRelationTypeText(type), locale);
        String rightExpression = AppliedFilter.getTextForRelationalExpression(right, model, locale, applyPromptValues);
        Object[] args = new Object[]{leftExpression, typeString, rightExpression};
        return AppliedFilter.getMessageString(msgFormat, args, locale);
    }

    private static String getMessageString(String key, Object[] args, Locale locale) {
        try {
            return IQUtilResourceBundle.getMessageString(key, args, locale);
        }
        catch (MissingResourceException e) {
            _logger.error(e.getLocalizedMessage(), (Throwable)e);
            return EMPTY_STRING;
        }
    }

    private static String format(String pattern, Object[] args) {
        try {
            return MessageFormat.format(pattern, args);
        }
        catch (IllegalArgumentException e) {
            _logger.error(e.getLocalizedMessage(), (Throwable)e);
            return EMPTY_STRING;
        }
    }

    private static String getConditionalRelationTypeText(ConditionalRelationType relType) {
        if (relType == null) {
            return EMPTY_STRING;
        }
        if (relType.equals(ConditionalRelationType.AND)) {
            return UTIL_BOOLEAN_AND;
        }
        if (relType.equals(ConditionalRelationType.OR)) {
            return UTIL_BOOLEAN_OR;
        }
        return EMPTY_STRING;
    }

    private static String getTextForConditionalExpression_Comparison(SimpleConditionalExpression_Comparison expression, BusinessQuery model, Locale locale, boolean applyPromptValues) {
        return AppliedFilter.getTextForComparisonExpression(expression.getLeftExpression(), AppliedFilter.getOperatorString(expression.isNegated(), expression.getComparisonOperator(), locale), expression.getRightExpression(), model, locale, applyPromptValues);
    }

    private static String getTextForComparisonExpression(ExpressionInterface left, String comparisonOperatorPattern, ExpressionInterface right, BusinessQuery model, Locale locale, boolean applyPromptValues) {
        String leftExpression = AppliedFilter.getTextForRelationalExpression(left, model, locale, applyPromptValues);
        String rightExpression = AppliedFilter.getTextForRelationalExpression(right, model, locale, applyPromptValues);
        Object[] args = new Object[]{leftExpression, rightExpression};
        return AppliedFilter.getMessageString(comparisonOperatorPattern, args, locale);
    }

    private static String getTextForBetweenExpression(boolean isNegated, ExpressionInterface what, ExpressionInterface left, ExpressionInterface right, BusinessQuery model, Locale locale, boolean applyPromptValues) {
        String msgFormat = isNegated ? IS_NOT_BETWEEN : IS_BETWEEN;
        String whatExpression = AppliedFilter.getTextForRelationalExpression(what, model, locale, applyPromptValues);
        String leftExpression = AppliedFilter.getTextForRelationalExpression(left, model, locale, applyPromptValues);
        String rightExpression = AppliedFilter.getTextForRelationalExpression(right, model, locale, applyPromptValues);
        Object[] args = new Object[]{whatExpression, leftExpression, rightExpression};
        return AppliedFilter.getMessageString(msgFormat, args, locale);
    }

    private static String getOperatorString(boolean isNegated, ComparisonOperator operator, Locale locale) {
        if (operator != null) {
            if (isNegated) {
                if (operator == ComparisonOperator.COMPARE_EQ) {
                    return IS_NOT_EQUAL;
                }
                if (operator == ComparisonOperator.COMPARE_NEQ) {
                    return IS_EQUAL;
                }
                if (operator == ComparisonOperator.COMPARE_GT) {
                    return IS_LESS_THAN_OR_EQUAL;
                }
                if (operator == ComparisonOperator.COMPARE_LE) {
                    return IS_GREATER_THAN;
                }
                if (operator == ComparisonOperator.COMPARE_GE) {
                    return IS_LESS_THAN;
                }
                if (operator == ComparisonOperator.COMPARE_LT) {
                    return IS_GREATER_THAN_OR_EQUAL;
                }
            } else {
                return AppliedFilter.getFormatForOperator(operator);
            }
        }
        return EMPTY_STRING;
    }

    private static String getTextForValueList(List expressionList, BusinessQuery model, Locale locale, String outer, String join, String sepr, boolean applyPromptValues) {
        if (expressionList == null || expressionList.size() == 0) {
            return EMPTY_STRING;
        }
        sepr = AppliedFilter.getStringResource(sepr, locale);
        String text = EMPTY_STRING;
        Iterator iter = expressionList.iterator();
        Object obj = iter.next();
        ExpressionInterface expr = null;
        if (obj instanceof ExpressionInterface) {
            expr = (ExpressionInterface)obj;
            text = AppliedFilter.getTextForRelationalExpression(expr, model, locale, applyPromptValues);
        } else {
            text = obj.toString();
        }
        while (iter.hasNext()) {
            obj = iter.next();
            String temp = null;
            if (obj instanceof ExpressionInterface) {
                expr = (ExpressionInterface)obj;
                temp = AppliedFilter.getTextForRelationalExpression(expr, model, locale, applyPromptValues);
            } else {
                temp = obj.toString();
            }
            text = AppliedFilter.getMessageString(join, new Object[]{text, sepr, temp}, locale);
        }
        return AppliedFilter.getMessageString(outer, new Object[]{text}, locale);
    }

    private static String getColumnText(Column column, Locale locale) {
        String text = column.getLabel();
        if (text != null) {
            return text;
        }
        StringBuffer relationalText = new StringBuffer();
        try {
            Table table = column.getOwningTable();
            relationalText.append(table.getLabel());
            relationalText.append(".");
            relationalText.append(column.getSasName());
        }
        catch (Exception e) {
            _logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return relationalText.toString();
    }

    private static String getConstantExpressionText(ConstantExpressionInterface constantExpression) {
        if (constantExpression.getExpressionType() == 3) {
            return AppliedFilter.generateQuotedLiteral(constantExpression.getValue());
        }
        return constantExpression.toString();
    }

    private static String generateQuotedLiteral(String s) {
        if (s == null) {
            return "null";
        }
        StringBuffer result = new StringBuffer();
        result.append("'");
        s = s.replaceAll("'", "''");
        result.append(s).append("'");
        return result.toString();
    }

    private static String getTextForFunctionCall(FunctionCall expr, BusinessQuery model, Locale locale, boolean applyPromptValues) {
        String msgFormat = EMPTY_STRING;
        List<ExpressionInterface> args = expr.getArguments();
        FunctionSignature signature = expr.getFunctionSignature();
        if (signature != null) {
            msgFormat = signature.getSyntaxTemplateFor(args);
        }
        Object[] argText = new Object[args.size()];
        int i = 0;
        Iterator<ExpressionInterface> iter = args.iterator();
        while (iter.hasNext()) {
            argText[i++] = AppliedFilter.getTextForRelationalExpression(iter.next(), model, locale, applyPromptValues);
        }
        return AppliedFilter.format(msgFormat, argText);
    }

    private static String getTextForConditionalExpression(ConditionalExpression cond, BusinessQuery model, Locale locale, boolean applyPromptValues) {
        if (cond == null) {
            return EMPTY_STRING;
        }
        if (cond instanceof CompoundConditionalExpression) {
            return AppliedFilter.getTextForCompoundConditionalExpression((CompoundConditionalExpression)cond, model, locale, applyPromptValues);
        }
        if (cond instanceof SimpleConditionalExpression_Comparison) {
            return AppliedFilter.getTextForConditionalExpression_Comparison((SimpleConditionalExpression_Comparison)cond, model, locale, applyPromptValues);
        }
        if (cond instanceof SimpleConditionalExpression_Between) {
            return AppliedFilter.getTextForConditionalExpression_Between((SimpleConditionalExpression_Between)cond, model, locale, applyPromptValues);
        }
        if (cond instanceof SimpleConditionalExpression_Contains) {
            return AppliedFilter.getTextForConditionalExpression_Contains((SimpleConditionalExpression_Contains)cond, model, locale, applyPromptValues);
        }
        if (cond instanceof SimpleConditionalExpression_In) {
            return AppliedFilter.getTextForConditionalExpression_In((SimpleConditionalExpression_In)cond, model, locale, applyPromptValues);
        }
        if (cond instanceof SimpleConditionalExpression_Like) {
            return AppliedFilter.getTextForConditionalExpression_Like((SimpleConditionalExpression_Like)cond, model, locale, applyPromptValues);
        }
        if (cond instanceof SimpleConditionalExpression_TestForNull) {
            return AppliedFilter.getTextForConditionalExpression_TestForNull((SimpleConditionalExpression_TestForNull)cond, model, locale, applyPromptValues);
        }
        if (cond instanceof MultipleConditionalExpression) {
            return AppliedFilter.getTextForMultipleConditionalExpression((MultipleConditionalExpression)cond, model, locale, applyPromptValues);
        }
        if (cond instanceof DataBasedFilterExpression) {
            return AppliedFilter.getTextForDataBasedFilterExpression((DataBasedFilterExpression)cond, model, locale, applyPromptValues);
        }
        if (cond instanceof DataBasedFilterExpression_Between) {
            return AppliedFilter.getTextForDataBasedFilterExpression_Between((DataBasedFilterExpression_Between)cond, model, locale, applyPromptValues);
        }
        return cond.toString();
    }

    private static String getTextForDataBasedFilterExpression(DataBasedFilterExpression expression, BusinessQuery model, Locale locale, boolean applyPromptValues) {
        String leftText = AppliedFilter.getTextForValueList(expression.getLeftExpression(), model, locale, LIST_OF_VALUES, LIST_OF_VALUES_JOIN, LIST_OF_VALUES_SEPARATOR, applyPromptValues);
        String rightText = AppliedFilter.getReadableText(expression.getRightExpression(), locale);
        ComparisonOperator operator = expression.getComparisonOperator();
        String operatorText = expression.getComparisonOperator().toString();
        String format = AppliedFilter.getFormatForOperator(operator);
        if (format.length() > 0) {
            Object[] args = new Object[]{leftText, rightText};
            return AppliedFilter.getMessageString(format, args, locale);
        }
        Object[] args = new Object[]{leftText, operatorText, rightText};
        return AppliedFilter.getMessageString(TEXT_FORMAT, args, locale);
    }

    private static String getTextForDataBasedFilterExpression_Between(DataBasedFilterExpression_Between expression, BusinessQuery model, Locale locale, boolean applyPromptValues) {
        boolean isNegated = expression.isNegated();
        String msgFormat = isNegated ? DBFE_NOT_BETWEEN : DBFE_BETWEEN;
        String outer = LIST_OF_VALUES;
        String join = LIST_OF_VALUES_JOIN;
        String sepr = LIST_OF_VALUES_SEPARATOR;
        String whatToFilter = AppliedFilter.getTextForRelationalExpression(expression.getWhatToFilter(), model, locale, applyPromptValues);
        String whatToCompare = AppliedFilter.getTextForValueList(expression.getWhatToCompare(), model, locale, LIST_OF_VALUES, LIST_OF_VALUES_JOIN, LIST_OF_VALUES_SEPARATOR, applyPromptValues);
        String lowerBound = AppliedFilter.getTextForValueList(expression.getLowerBound(), model, locale, LIST_OF_VALUES, LIST_OF_VALUES_JOIN, LIST_OF_VALUES_SEPARATOR, applyPromptValues);
        String upperBound = AppliedFilter.getTextForValueList(expression.getUpperBound(), model, locale, LIST_OF_VALUES, LIST_OF_VALUES_JOIN, LIST_OF_VALUES_SEPARATOR, applyPromptValues);
        Object[] args = new Object[]{whatToFilter, whatToCompare, lowerBound, upperBound};
        return AppliedFilter.getMessageString(msgFormat, args, locale);
    }

    private static String getDataItemText(DataItem di, Locale locale) {
        String label = di.getLabel(locale);
        String msgFormat = EMPTY_STRING;
        if (di.getUsage() == DataItemActionType.USAGE_AGGREGATE) {
            msgFormat = AGGREGATE_DI;
            String function = di.getAggregationType().getSyntaxToken();
            if (function.length() > 0) {
                Object[] args = new Object[]{label, function};
                return AppliedFilter.getMessageString(msgFormat, args, locale);
            }
            Object[] args = new Object[]{label};
            return AppliedFilter.getMessageString(AGGREGATE_DI_MISSING_FUNCTION, args, locale);
        }
        msgFormat = di.getUsage() == DataItemActionType.USAGE_DETAIL ? DETAIL_DI : CHARACTER_DI;
        Object[] args = new Object[]{label};
        return AppliedFilter.getMessageString(msgFormat, args, locale);
    }

    private static String getTextForRelationalExpression(ExpressionInterface expression, BusinessQuery model, Locale locale, boolean applyPromptValues) {
        String text = EMPTY_STRING;
        if (expression == null) {
            return text;
        }
        if (expression instanceof DataItem) {
            text = AppliedFilter.getDataItemText((DataItem)expression, locale);
        } else if (expression instanceof StringExpression) {
            try {
                text = ((StringExpression)expression).getText();
            }
            catch (Exception exception) {}
        } else {
            text = expression instanceof Prompt ? AppliedFilter.getPromptDescription((Prompt)expression, model, locale, applyPromptValues) : (expression instanceof Column ? AppliedFilter.getColumnText((Column)expression, locale) : (expression instanceof FunctionCall ? AppliedFilter.getTextForFunctionCall((FunctionCall)expression, model, locale, applyPromptValues) : (expression instanceof ConditionalExpression ? AppliedFilter.getTextForConditionalExpression((ConditionalExpression)expression, model, locale, applyPromptValues) : (expression instanceof ConstantExpressionInterface ? AppliedFilter.getConstantExpressionText((ConstantExpressionInterface)expression) : expression.toString()))));
        }
        return text;
    }

    private static List<String> getAllNonStepRelationalAppliedFilterDescriptions(DataSelection model, Locale locale, boolean showByGroupFilter, boolean applyPromptValues) {
        ArrayList<String> filters = new ArrayList<String>();
        ArrayList<String> relFilters = new ArrayList<String>();
        List<FilterItem> filterItems = model.getFilters();
        for (FilterItem filter : filterItems) {
            boolean showFilter = true;
            if (!showByGroupFilter && ByGroupCreator.isByGroupFilter(model, filter)) {
                showFilter = false;
            }
            if (!showFilter) continue;
            relFilters.add(AppliedFilter.getTextForRelationalExpression(filter.getExpression(), model, locale, applyPromptValues));
        }
        String andString = AppliedFilter.getStringResource(UTIL_BOOLEAN_AND, locale);
        for (String obj : relFilters) {
            if (obj.length() <= 0) continue;
            if (filters.size() > 0) {
                filters.add(andString);
            }
            filters.add(obj);
        }
        return AppliedFilter.encodeFilterText(filters);
    }
}

