/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.impl.Utils;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

@SASScope
public abstract class TypedVector
extends Vector {
    public static final String EVENT_OBJECT_PROPERTY_CHANGED = IQMetadataResourceBundle.getStringResource("EventNames.ObjectPropertyChange.txt");
    public static final String EVENT_LIST_ELEMENT_ADDED = IQMetadataResourceBundle.getStringResource("EventNames.ListElementAdded.txt");
    public static final String EVENT_LIST_ELEMENT_REMOVED = IQMetadataResourceBundle.getStringResource("EventNames.ListElementRemoved.txt");
    protected Vector listeners = new Vector();

    protected abstract void checkObject(Object var1);

    @Override
    public void add(int index, Object obj) {
        this.insertElementAt(obj, index);
    }

    @Override
    public boolean add(Object obj) {
        this.addElement(obj);
        return true;
    }

    public void addElement(Object obj) {
        this.checkObject(obj);
        super.addElement(obj);
        this.fireChangeEvent(EVENT_LIST_ELEMENT_ADDED);
    }

    @Override
    public boolean addAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.checkObject(it.next());
        }
        boolean rc = super.addAll(c);
        this.fireChangeEvent(EVENT_LIST_ELEMENT_ADDED);
        return rc;
    }

    @Override
    public boolean addAll(int index, Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.checkObject(it.next());
        }
        boolean rc = super.addAll(index, c);
        this.fireChangeEvent(EVENT_LIST_ELEMENT_ADDED);
        return rc;
    }

    public void insertElementAt(Object obj, int index) {
        this.checkObject(obj);
        super.insertElementAt(obj, index);
        this.fireChangeEvent(EVENT_LIST_ELEMENT_ADDED);
    }

    @Override
    public Object set(int index, Object obj) {
        this.checkObject(obj);
        Object objRc = super.set(index, obj);
        this.fireChangeEvent(EVENT_OBJECT_PROPERTY_CHANGED);
        return objRc;
    }

    public void setElementAt(Object obj, int index) {
        this.checkObject(obj);
        super.setElementAt(obj, index);
        this.fireChangeEvent(EVENT_OBJECT_PROPERTY_CHANGED);
    }

    @Override
    public void clear() {
        super.clear();
        this.fireChangeEvent(EVENT_OBJECT_PROPERTY_CHANGED);
    }

    @Override
    public Object remove(int index) {
        Object rc = super.remove(index);
        this.fireChangeEvent(EVENT_OBJECT_PROPERTY_CHANGED);
        return rc;
    }

    @Override
    public boolean remove(Object o) {
        boolean rc = super.remove(o);
        this.fireChangeEvent(EVENT_OBJECT_PROPERTY_CHANGED);
        return rc;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean rc = super.removeAll(c);
        this.fireChangeEvent(EVENT_OBJECT_PROPERTY_CHANGED);
        return rc;
    }

    @Override
    public void removeAllElements() {
        super.removeAllElements();
        this.fireChangeEvent(EVENT_OBJECT_PROPERTY_CHANGED);
    }

    @Override
    public boolean removeElement(Object obj) {
        boolean rc = super.removeElement(obj);
        this.fireChangeEvent(EVENT_OBJECT_PROPERTY_CHANGED);
        return rc;
    }

    @Override
    public void removeElementAt(int index) {
        super.removeElementAt(index);
        this.fireChangeEvent(EVENT_OBJECT_PROPERTY_CHANGED);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
        this.fireChangeEvent(EVENT_OBJECT_PROPERTY_CHANGED);
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean rc = super.retainAll(c);
        this.fireChangeEvent(EVENT_OBJECT_PROPERTY_CHANGED);
        return rc;
    }

    @Override
    public void setSize(int newSize) {
        super.setSize(newSize);
        this.fireChangeEvent(EVENT_OBJECT_PROPERTY_CHANGED);
    }

    public void addListener(PropertyChangeListener listener) {
        Utils.addListener(this.listeners, listener);
    }

    public void removeListener(PropertyChangeListener listener) {
        Utils.removeListener(this.listeners, listener);
    }

    private void fireChangeEvent(String propertyName) {
        if (this.listeners.size() > 0) {
            Utils.fireChangeEvent(this.listeners, this, propertyName, null, null);
        }
    }
}

