/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RetryUtil {
    public static final String IQ_RETRYUTIL_WAIT_MS_PROPNAME = "IQ.RetryUtil.RetryWaitMs";
    public static final Integer IQ_RETRYUTIL_WAIT_MS_DEFAULT = 10;
    public static final String IQ_RETRYUTIL_MAX_RETRIES_PROPNAME = "IQ.RetryUtil.MaxRetries";
    public static final Integer IQ_RETRYUTIL_MAX_RETRIES_DEFAULT = 10;
    public static final String IQ_RETRYUTIL_LOGGING = "IQ.RetryUtil.Logging";
    static final Logger _logger = LogManager.getLogger((String)"IQ.RetryUtil.Logging");

    public static <T> T tryAction(Actor<T> actor, Logger logger) throws ActionFailed {
        long maxRetries = Integer.getInteger(IQ_RETRYUTIL_MAX_RETRIES_PROPNAME, IQ_RETRYUTIL_MAX_RETRIES_DEFAULT).intValue();
        long retryWaitMs = Integer.getInteger(IQ_RETRYUTIL_WAIT_MS_PROPNAME, IQ_RETRYUTIL_WAIT_MS_DEFAULT).intValue();
        return RetryUtil.tryAction(actor, maxRetries, retryWaitMs, logger);
    }

    public static <T> T tryAction(Actor<T> actor) throws ActionFailed {
        long maxRetries = Integer.getInteger(IQ_RETRYUTIL_MAX_RETRIES_PROPNAME, IQ_RETRYUTIL_MAX_RETRIES_DEFAULT).intValue();
        long retryWaitMs = Integer.getInteger(IQ_RETRYUTIL_WAIT_MS_PROPNAME, IQ_RETRYUTIL_WAIT_MS_DEFAULT).intValue();
        return RetryUtil.tryAction(actor, maxRetries, retryWaitMs, _logger);
    }

    public static <T> T tryAction(Actor<T> actor, long maxRetries, long retryWaitMs, Logger logger) throws ActionFailed {
        T returnValue = null;
        int i = 0;
        boolean redo = false;
        do {
            try {
                if (i > 0 && logger != null) {
                    logger.debug("Retry #" + i);
                }
                returnValue = actor.action();
                redo = false;
            }
            catch (FailAction e) {
                if (logger != null) {
                    logger.error("Action failed and no retry will be attempted.", (Throwable)e);
                }
                if (e.getCause() != null) {
                    throw new ActionFailed(e.getCause());
                }
                throw new ActionFailed();
            }
            catch (RedoAction e) {
                redo = true;
                if (maxRetries < 1L) {
                    if (logger != null) {
                        logger.error("Failed with max retry setting of " + maxRetries + ".", (Throwable)e);
                    }
                    if (e.getCause() != null) {
                        throw new ActionFailed(e.getCause());
                    }
                    throw new ActionFailed();
                }
                if ((long)(++i) > maxRetries) {
                    if (logger != null) {
                        logger.debug("Retry #" + i + " exceeded max retry setting of " + maxRetries + ".", (Throwable)e);
                        logger.error("Retry failed.", (Throwable)e);
                    }
                    if (e.getCause() != null) {
                        throw new ActionFailed(e.getCause());
                    }
                    throw new ActionFailed();
                }
                if (retryWaitMs >= 0L) {
                    if (logger != null) {
                        logger.debug("Retry pausing thread for " + retryWaitMs + " milliseconds.");
                    }
                    try {
                        Thread.sleep(retryWaitMs);
                        continue;
                    }
                    catch (InterruptedException e1) {
                        if (logger != null) {
                            logger.debug("Retry interrupted.", (Throwable)e1);
                            logger.error("Retry failed.", (Throwable)e);
                        }
                        if (e.getCause() != null) {
                            throw new ActionFailed(e.getCause());
                        }
                        throw new ActionFailed();
                    }
                }
                if (logger == null) continue;
                logger.debug("Retry not pausing thread.");
            }
        } while (redo);
        return returnValue;
    }

    public static interface Actor<V> {
        public V action() throws RedoAction, FailAction;
    }

    public static class FailAction
    extends Exception {
        private static final long serialVersionUID = 1L;

        public FailAction(Throwable e) {
            super(e);
        }

        public FailAction() {
        }
    }

    public static class ActionFailed
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ActionFailed(Throwable e) {
            super(e);
        }

        public ActionFailed() {
        }
    }

    public static class RedoAction
    extends Exception {
        private static final long serialVersionUID = 1L;

        public RedoAction(Throwable e) {
            super(e);
        }

        public RedoAction() {
        }
    }
}

