/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IDataService;
import com.sas.iom.SAS.IFormatService;
import com.sas.iom.SAS.ILanguageService;
import com.sas.iom.SAS.IOptionService;
import com.sas.iom.SAS.IOptionServicePackage.DataTypeSeqHolder;
import com.sas.iom.SAS.IOptionServicePackage.GetErrorSeqHolder;
import com.sas.iom.SAS.IOptionServicePackage.SetErrorSeqHolder;
import com.sas.iom.SAS.IUtilities;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.SASIOMCommon.IServerLocale;
import com.sas.iom.SASIOMCommon.IServerLocaleHelper;
import com.sas.iom.SASIOMCommon.IServerStatus;
import com.sas.iom.SASIOMCommon.IServerStatusHelper;
import com.sas.iom.SASIOMCommon.ISessionControl;
import com.sas.iom.SASIOMCommon.ISessionControlHelper;
import com.sas.iom.SASIOMDefs.BooleanSeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.ShortSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.UUIDSeqHolder;
import com.sas.iom.SASMDX.EmptySet;
import com.sas.iom.SASMDX.IMDXAdmin;
import com.sas.iom.SASMDX.IMDXAdminHelper;
import com.sas.iom.SASMDX.IMDXAdmin_1_1;
import com.sas.iom.SASMDX.IMDXAdmin_1_1Helper;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iom.SASMDX.IMDXServerHelper;
import com.sas.iom.SASMDX.IMeasureSet;
import com.sas.iom.SASMDX.ISession;
import com.sas.iom.SASMDX.ISession_1_1;
import com.sas.iom.SASMDX.ISession_1_1Helper;
import com.sas.iom.SASMDX.ISession_1_2;
import com.sas.iom.SASMDX.ISession_1_2Helper;
import com.sas.iom.SASMDX.InvalidMask;
import com.sas.iom.SASMDX.InvalidRow;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataservices.DataServicesException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionRecycler;
import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.execution.OLAPConnectionResource;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.physical.AccessPath;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.OMAResource;
import com.sas.iquery.metadata.physical.OMAResourceFactory;
import com.sas.iquery.metadata.physical.oma.OMACube;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.OLAPUtilities;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Measure;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.util.LocalizableString;
import com.sas.util.xmlpersist.impl.LocalizablePersistableString;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Object;

@SASScope
public final class IOMServerUtils {
    static final Logger _logger = LogManager.getLogger(IOMServerUtils.class);
    static final Logger _perfCLogger = LogManager.getLogger((String)"com.sas.iquery.perf.Connections");
    private static final String SAS_LOCALE_OPTION_NAME = "LOCALE";
    private static final String[] fromLanguages = new String[]{"iw", "ji", "in", "no"};
    private static final String[] toLanguages = new String[]{"he", "yi", "id", "nb"};
    private static final Map<String, MessageFormatter> fixupLangToCodeNames = new HashMap<String, MessageFormatter>();
    private static final Map<String, String> fixupLangFromToCodes = new HashMap<String, String>();
    private static final boolean[] measureFieldInclusion;

    public static IMDXServer GetIMDXServer(Object iomCorbaObject) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Narrowing the IOM CORBA object (" + iomCorbaObject + ") to a MDX server interface.");
        }
        return IMDXServerHelper.narrow((Object)iomCorbaObject);
    }

    public static ISession_1_1 GetISession_1_1(Object iomCorbaObject) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Narrowing the IOM CORBA object (" + iomCorbaObject + ") to a ISession 1.1 interface.");
        }
        return ISession_1_1Helper.narrow((Object)iomCorbaObject);
    }

    public static ISessionControl GetISessionControl(Object iomCorbaObject) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Narrowing the IOM CORBA object (" + iomCorbaObject + ") to a ISession control interface.");
        }
        return ISessionControlHelper.narrow((Object)iomCorbaObject);
    }

    public static IServerStatus GetIServerStatus(Object iomCorbaObject) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Narrowing the IOM CORBA object (" + iomCorbaObject + ") to a MDX admin interface.");
        }
        return IServerStatusHelper.narrow((Object)iomCorbaObject);
    }

    public static IMDXAdmin GetIMDXAdmin(Object iomCorbaObject) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Narrowing the IOM CORBA object (" + iomCorbaObject + ") to a MDX admin interface.");
        }
        return IMDXAdminHelper.narrow((Object)iomCorbaObject);
    }

    public static IMDXAdmin_1_1 GetIMDXAdmin_1_1(Object iomCorbaObject) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Narrowing the IOM CORBA object (" + iomCorbaObject + ") to a MDX admin 1.1 interface.");
        }
        return IMDXAdmin_1_1Helper.narrow((Object)iomCorbaObject);
    }

    public static IWorkspace GetIWorkspace(Object iomCorbaObject) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Narrowing the IOM CORBA object (" + iomCorbaObject + ") to a IWorkspace interface.");
        }
        return IWorkspaceHelper.narrow((Object)iomCorbaObject);
    }

    public static LocalizableString getOLAPMeasureCaptions(SessionContextInterface session, MetadataServerInterface metadataServer, Measure omrMeasure, List<String> locales) throws ServiceException, RemoteException, MetadataException, MdException, ExecutionException, GenericError, OLAPException, ConnectionFactoryException {
        LocalizablePersistableString localizedStr = new LocalizablePersistableString();
        List<com.sas.metadata.remote.Cube> cubes = AssociationListUtil.filteredSnapshot(omrMeasure.getCubes(true), com.sas.metadata.remote.Cube.class);
        block0: for (com.sas.metadata.remote.Cube omrCube : cubes) {
            OMACube omaCube = (OMACube)OMAResourceFactory.getReposObject((CMetadata)omrCube, session, metadataServer);
            if (omaCube == null) continue;
            List<AccessPath> accessPaths = omaCube.getAccessPaths();
            for (AccessPath accessPath : accessPaths) {
                LogicalServerInterface lsi = accessPath.getLogicalServer();
                if (lsi == null) continue;
                IOMServerUtils.getCaptions((LocalizableString)localizedStr, lsi, session, omrCube, omrMeasure, locales);
                continue block0;
            }
        }
        return localizedStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void getCaptions(LocalizableString localizedStr, LogicalServerInterface lsi, SessionContextInterface session, com.sas.metadata.remote.Cube omrCube, Measure omrMeasure, List<String> locales) throws ServiceException, RemoteException, MetadataException, MdException, ExecutionException, GenericError, OLAPException, ConnectionFactoryException {
        ConnectionInterface userSessionConnection;
        block14: {
            String measureUniqueName = omrMeasure.getUniqueName();
            String cubeName = omrCube.getCubeName();
            RetrievalPolicy userSessionPolicy = new RetrievalPolicy();
            userSessionPolicy.getConnectionConfiguration().setConnectionLifetime(1);
            Locale connectionLocale = LocaleUtilities.getDefaultViewerLocale(session);
            UserContextInterface userContext = ConnectionUtil.getUserContext(session);
            ConnectionRecycler recycler = ConnectionUtil.getConnectionRecycler(session);
            userSessionConnection = null;
            try {
                userSessionConnection = recycler.getWorkspaceConnection(lsi, userContext, userSessionPolicy, connectionLocale);
                ConnectionUtil.LoggerDebugConnectionObtained(_logger, OLAPConnectionInfoUtil.class, userSessionConnection);
                ConnectionInterface pfsConnection = ConnectionUtil.findPfsConnection(userSessionConnection);
                OLAPConnectionResource olapConnection = OLAPUtilities.findOlapConnectionResource(pfsConnection);
                if (olapConnection == null) break block14;
                Object iomConnectionObject = olapConnection.getObject();
                IMDXServer mdxServer = IOMServerUtils.GetIMDXServer(iomConnectionObject);
                for (String localeString : locales) {
                    Locale loc = IOMServerUtils.ConvertSASLocaleToJavaLocale(localeString);
                    ISession isesssionForOLAPServer = null;
                    try {
                        isesssionForOLAPServer = ConnectionResources.newISession(mdxServer, loc);
                        List<String> olapCaptions = null;
                        try {
                            olapCaptions = IOMServerUtils.getMeasuresFromIom(cubeName, measureUniqueName, isesssionForOLAPServer);
                        }
                        catch (InvalidMask e) {
                            throw new ExecutionException(e);
                        }
                        catch (EmptySet e) {
                            throw new ExecutionException(e);
                        }
                        catch (InvalidRow e) {
                            throw new ExecutionException(e);
                        }
                        if (olapCaptions.size() > 0) {
                            String measureCaption = olapCaptions.get(0);
                            localizedStr.setText(measureCaption, loc);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (isesssionForOLAPServer == null) throw throwable;
                            isesssionForOLAPServer.Close();
                            isesssionForOLAPServer._release();
                            throw throwable;
                        }
                        catch (GenericError e) {
                            ConnectionUtil.LoggerErrorWithObjects(_logger, (java.lang.Object)e, isesssionForOLAPServer);
                        }
                        throw throwable;
                    }
                    try {
                        if (isesssionForOLAPServer == null) continue;
                        isesssionForOLAPServer.Close();
                        isesssionForOLAPServer._release();
                    }
                    catch (GenericError e) {
                        ConnectionUtil.LoggerErrorWithObjects(_logger, (java.lang.Object)e, isesssionForOLAPServer);
                    }
                }
            }
            catch (Throwable throwable) {
                ConnectionResources.close(userSessionConnection);
                throw throwable;
            }
        }
        ConnectionResources.close(userSessionConnection);
    }

    public static List<StringExpression> translateOLAPMembers(DataSelection dataSelection, List<StringExpression> currentMembers, Locale inLocale) {
        OLAPConnectionResource olapConnection;
        List<StringExpression> returnValues = new ArrayList<StringExpression>();
        RetrievalPolicy policy = new RetrievalPolicy();
        policy.getConnectionConfiguration().setConnectionLifetime(1);
        try {
            olapConnection = OLAPConnectionInfoUtil.getConnection(dataSelection, policy, dataSelection.getComputationalLocale());
        }
        catch (ExecutionException e1) {
            _logger.error(e1.getLocalizedMessage(), (Throwable)e1);
            return currentMembers;
        }
        catch (MetadataException e1) {
            _logger.error(e1.getLocalizedMessage(), (Throwable)e1);
            return currentMembers;
        }
        catch (GenerationException e1) {
            _logger.error(e1.getLocalizedMessage(), (Throwable)e1);
            return currentMembers;
        }
        DataSourceCube dsCube = null;
        try {
            dsCube = OLAPConnectionInfoUtil.getCube(dataSelection);
        }
        catch (GenerationException e2) {
            _logger.error(e2.getLocalizedMessage(), (Throwable)e2);
            return returnValues;
        }
        Locale computationalLocale = dataSelection.getComputationalLocale();
        Locale outLocale = LocaleUtilities.getDefaultViewerLocale(dataSelection.getSession());
        if (inLocale == null) {
            Locale computationLocale;
            if (_logger.isDebugEnabled()) {
                _logger.debug("Input locale is null. Computational locale is used.");
            }
            inLocale = (computationLocale = dataSelection.getComputationalLocale()) != null ? IOMServerUtils.negotiateValidServerLocale(olapConnection, computationalLocale) : IOMServerUtils.negotiateValidServerLocale(olapConnection, Locale.getDefault());
        }
        inLocale = IOMServerUtils.negotiateStoredCubeLocale(dsCube, inLocale, computationalLocale);
        if (_logger.isDebugEnabled()) {
            _logger.debug("Out Locale: " + outLocale + " Input Locale: " + inLocale);
        }
        if (outLocale == null || inLocale == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Viewer and input locale are null.  No locale to build could be found.");
            }
            return currentMembers;
        }
        if (outLocale.toString().equalsIgnoreCase(inLocale.toString())) {
            _logger.debug(" No translation because there is no difference in input and output Locales.");
            return currentMembers;
        }
        if (dataSelection != null) {
            String cubeName;
            try {
                cubeName = dsCube.getCubeName();
            }
            catch (MetadataException e2) {
                _logger.error(e2.getLocalizedMessage(), (Throwable)e2);
                return returnValues;
            }
            Locale tempOut = IOMServerUtils.negotiateStoredCubeLocale(dsCube, outLocale, computationalLocale);
            if (tempOut.toString().equalsIgnoreCase(inLocale.toString())) {
                _logger.debug(" No translation because cube alternate locales and input locales were not different.");
                return returnValues;
            }
            outLocale = tempOut;
            returnValues = IOMServerUtils.translateOLAPMembers(cubeName, currentMembers, inLocale, outLocale, olapConnection);
        }
        return returnValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<StringExpression> translateOLAPMembers(String cubeName, List<StringExpression> currentMembers, Locale inLocale, Locale outLocale, ConnectionInterface olapConnection) {
        ArrayList<StringExpression> returnValue = new ArrayList<StringExpression>();
        returnValue.addAll(currentMembers);
        if (olapConnection instanceof OLAPConnectionResource) {
            ISession isesssionForOLAPServer = null;
            try {
                Object iomConnectionObject = olapConnection.getObject();
                IMDXServer mdxServer = IOMServerUtils.GetIMDXServer(iomConnectionObject);
                try {
                    isesssionForOLAPServer = ConnectionResources.newISession(mdxServer, outLocale);
                }
                catch (Exception e) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                    List<StringExpression> list = currentMembers;
                    try {
                        if (isesssionForOLAPServer != null) {
                            isesssionForOLAPServer.Close();
                        }
                    }
                    catch (GenericError e2) {
                        _logger.error(e2.getLocalizedMessage(), (Throwable)e2);
                    }
                    return list;
                }
                ISession_1_2 obSessionS_1_2 = ISession_1_2Helper.narrow((Object)isesssionForOLAPServer);
                StringSeqHolder membersListTranslated = new StringSeqHolder();
                LongSeqHolder membersStatus = new LongSeqHolder();
                int ct = 0;
                String[] current = new String[currentMembers.size()];
                for (StringExpression currentMember : currentMembers) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Member Translated: " + currentMember);
                    }
                    try {
                        current[ct] = currentMember.getText();
                    }
                    catch (MetadataException e1) {
                        _logger.error(e1.getLocalizedMessage(), (Throwable)e1);
                        List<StringExpression> list = currentMembers;
                        try {
                            if (isesssionForOLAPServer != null) {
                                isesssionForOLAPServer.Close();
                            }
                        }
                        catch (GenericError e) {
                            _logger.error(e.getLocalizedMessage(), (Throwable)e);
                        }
                        return list;
                    }
                    ++ct;
                }
                try {
                    long start = 0L;
                    if (_perfCLogger.isDebugEnabled()) {
                        ExtraLoggingContexts.debugLogConnectionPerformance("> Translating Members with MemberTranslate() ");
                        start = System.currentTimeMillis();
                    }
                    String actualLocale = obSessionS_1_2.MemberTranslate(cubeName, inLocale.toString(), outLocale.toString(), current, membersListTranslated, membersStatus);
                    if (_perfCLogger.isDebugEnabled()) {
                        long end = System.currentTimeMillis();
                        ExtraLoggingContexts.debugLogConnectionPerformance("< done (" + (end - start) + "ms)");
                    }
                    if (_logger.isDebugEnabled() && actualLocale != null) {
                        _logger.debug("The actual Locale returned from IOM method call: " + actualLocale);
                    }
                }
                catch (GenericError e) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                    List<StringExpression> e1 = currentMembers;
                    try {
                        if (isesssionForOLAPServer != null) {
                            isesssionForOLAPServer.Close();
                        }
                    }
                    catch (GenericError e3) {
                        _logger.error(e3.getLocalizedMessage(), (Throwable)e3);
                    }
                    return e1;
                }
                int[] status = membersStatus.value;
                int ctt = 0;
                for (int stat : status) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Translation status: " + stat + "\n");
                    }
                    if (stat == -1) {
                        _logger.error("Translation failed on Member: " + currentMembers.get(ctt));
                        List<StringExpression> list = currentMembers;
                        return list;
                    }
                    ++ctt;
                }
                String[] membersTrans = membersListTranslated.value;
                if (membersTrans.length > 0) {
                    returnValue.clear();
                }
                for (String currentMember : membersTrans) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Member Translated: " + currentMember);
                    }
                    StringExpression transMem = new StringExpression();
                    transMem.setText(currentMember);
                    transMem.setExpressionType(3);
                    returnValue.add(transMem);
                }
            }
            finally {
                try {
                    if (isesssionForOLAPServer != null) {
                        isesssionForOLAPServer.Close();
                    }
                }
                catch (GenericError e) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return returnValue;
    }

    public static Locale negotiateStoredCubeLocale(DataSourceCube dsCube, Locale toBeCheckLocale, Locale computationLocale) {
        boolean languageFound = false;
        boolean languagePropertyPresent = false;
        if (dsCube != null) {
            try {
                if (dsCube instanceof DataSourceCube) {
                    Cube cube = dsCube.getCube();
                    if (cube instanceof OMACube) {
                        OMACube omaCube = (OMACube)cube;
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Cube: " + omaCube.getCubeName());
                        }
                        if (omaCube instanceof OMAResource) {
                            long start = 0L;
                            if (_perfCLogger.isDebugEnabled()) {
                                ExtraLoggingContexts.debugLogConnectionPerformance("> Finding Language property metadata. ");
                                start = System.currentTimeMillis();
                            }
                            OMACube omaResource = omaCube;
                            CMetadata remoteMetadataObject = omaResource.getOMAObject();
                            String defaultLocaleFound = "";
                            if (remoteMetadataObject instanceof com.sas.metadata.remote.Cube) {
                                com.sas.metadata.remote.Cube omrCube = (com.sas.metadata.remote.Cube)remoteMetadataObject;
                                AssociationList cubePropertySet = omrCube.getPropertySets(true);
                                int bSize = cubePropertySet.size();
                                for (int i = 0; i < bSize; ++i) {
                                    PropertySet languagePropertySet = (PropertySet)cubePropertySet.elementAt(i);
                                    String name = languagePropertySet.getName();
                                    if (!name.equals("Languages")) continue;
                                    languagePropertyPresent = true;
                                    AssociationList setProperties = languagePropertySet.getSetProperties(true);
                                    int jSize = setProperties.size();
                                    for (int j = 0; j < jSize; ++j) {
                                        String twoBitAltLocale;
                                        java.lang.Object objProp = setProperties.elementAt(j);
                                        if (!(objProp instanceof Property)) continue;
                                        Property language = (Property)setProperties.elementAt(j);
                                        String alternateCubeLocale = language.getDefaultValue();
                                        if (_logger.isDebugEnabled()) {
                                            _logger.debug("Cube Locale: " + alternateCubeLocale);
                                        }
                                        if (defaultLocaleFound.isEmpty() && !alternateCubeLocale.isEmpty()) {
                                            defaultLocaleFound = alternateCubeLocale;
                                        }
                                        if (toBeCheckLocale.toString().equalsIgnoreCase(alternateCubeLocale)) {
                                            languageFound = true;
                                            Locale returnLocale = new Locale(alternateCubeLocale);
                                            return returnLocale;
                                        }
                                        String twoBitCheckLocale = toBeCheckLocale.toString().substring(0, 2);
                                        if (!twoBitCheckLocale.equalsIgnoreCase(twoBitAltLocale = alternateCubeLocale.substring(0, 2))) continue;
                                        languageFound = true;
                                        Locale returnLocale = new Locale(alternateCubeLocale);
                                        return returnLocale;
                                    }
                                }
                            }
                            if (_perfCLogger.isDebugEnabled()) {
                                long end = System.currentTimeMillis();
                                ExtraLoggingContexts.debugLogConnectionPerformance("< done (" + (end - start) + "ms)");
                            }
                            if (!languageFound && !defaultLocaleFound.isEmpty() && languagePropertyPresent) {
                                MessageFormatter mf = IQDataServicesResourceBundle.getMessageFormatter("IOMServerUtils.OLAPLocaleUtilNoMatchingCubeDefault.fmt.txt", toBeCheckLocale);
                                _logger.error((java.lang.Object)mf);
                                _logger.error("No matching cube locale found.  Using the default locale stored in cube: " + defaultLocaleFound);
                                Locale returnLocale = new Locale(defaultLocaleFound);
                                return returnLocale;
                            }
                            if (toBeCheckLocale != null && !toBeCheckLocale.toString().trim().isEmpty()) {
                                _logger.debug("Not a MLS cube OR no default locale in Cube. " + toBeCheckLocale + " Locale used. ");
                                return toBeCheckLocale;
                            }
                            _logger.debug("No input locale found. Computation Locale used. ");
                            return computationLocale;
                        }
                        _logger.error(IQDataServicesResourceBundle.getStringResource("IOMServerUtils.OLAPLocaleUtilNoOMACube.txt"));
                        return computationLocale;
                    }
                    _logger.error(IQDataServicesResourceBundle.getStringResource("IOMServerUtils.OLAPLocaleUtilNoOMRCube.txt"));
                    return computationLocale;
                }
            }
            catch (RemoteException e) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (MdException e) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            return null;
        }
        return null;
    }

    public static IServerLocale GetIServerLocale(Object iomCorbaObject) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Narrowing the IOM CORBA object (" + iomCorbaObject + ") to a IServer locale interface.");
        }
        return IServerLocaleHelper.narrow((Object)iomCorbaObject);
    }

    public static String GetWorkspaceLocale(IOptionService iOpts) throws DataServicesException {
        StringSeqHolder values = new StringSeqHolder();
        DataServicesException getFailure = IOMServerUtils.getServerOption(iOpts, SAS_LOCALE_OPTION_NAME, values);
        if (getFailure != null) {
            throw getFailure;
        }
        String workspaceLocale = values.value != null && values.value.length >= 1 ? values.value[0] : null;
        return workspaceLocale;
    }

    public static IOptionService GetIOptionService(IWorkspace iWorkspace) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Finding IOM option service interface of IOM workspace (" + iWorkspace + ").");
        }
        IUtilities iUtil = iWorkspace.Utilities();
        IOptionService iOpts = iUtil.OptionService();
        return iOpts;
    }

    public static ILanguageService GetILanguageService(IWorkspace iWorkspace) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Finding IOM option service interface of IOM workspace (" + iWorkspace + ").");
        }
        return iWorkspace.LanguageService();
    }

    public static IDataService GetIDataService(IWorkspace iWorkspace) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Finding IOM data service interface of IOM workspace (" + iWorkspace + ").");
        }
        return iWorkspace.DataService();
    }

    public static IFormatService GetIFormatService(IWorkspace iWorkspace) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Finding data service of IOM workspace (" + iWorkspace + ").");
        }
        IUtilities iUtil = iWorkspace.Utilities();
        IFormatService iFormats = iUtil.FormatService();
        return iFormats;
    }

    public static Locale ConvertSASLocaleToJavaLocale(String sasLocale) {
        if (sasLocale == null || sasLocale.trim().length() == 0) {
            return null;
        }
        sasLocale = sasLocale.trim();
        String language = "";
        String country = "";
        String variant = "";
        String[] parts = sasLocale.split("[\\s\\-\\_]", 3);
        if (parts.length > 0) {
            language = parts[0];
            if (language.length() == 2) {
                language = language.toLowerCase();
            }
            if (parts.length > 1) {
                country = parts[1];
                if (parts.length > 2) {
                    variant = parts[2];
                }
            }
        }
        Locale javaLocale = new Locale(language, country, variant);
        return javaLocale;
    }

    public static Locale ChangeServerLocale(ConnectionInterface connection, Locale connectionLocale) throws DataServicesException {
        Locale outLocale;
        Object iomConnectionObject = connection.getObject();
        IServerLocale iServerLocale = IServerLocaleHelper.narrow((Object)iomConnectionObject);
        IWorkspace iWorkspace = IOMServerUtils.GetIWorkspace(iomConnectionObject);
        if (iWorkspace == null) {
            outLocale = null;
        } else {
            IOptionService iOpts = IOMServerUtils.GetIOptionService(iWorkspace);
            String workspaceLocale = IOMServerUtils.GetWorkspaceLocale(iOpts);
            if (connectionLocale == null) {
                outLocale = IOMServerUtils.ConvertSASLocaleToJavaLocale(workspaceLocale);
            } else {
                DataServicesException setFailure1;
                String desiredLocale = connectionLocale.toString();
                if (!workspaceLocale.equalsIgnoreCase(desiredLocale) && (setFailure1 = IOMServerUtils.setServerOption(iOpts, SAS_LOCALE_OPTION_NAME, desiredLocale, workspaceLocale)) != null) {
                    ArrayList<String> tried = new ArrayList<String>();
                    tried.add(desiredLocale.toUpperCase());
                    if (!(IOMServerUtils.tryAgain1(connectionLocale, iOpts, workspaceLocale, tried) || IOMServerUtils.tryAgain2(connectionLocale, iOpts, workspaceLocale, tried) || IOMServerUtils.tryAgain3(connectionLocale, iOpts, workspaceLocale, tried) || IOMServerUtils.tryAgain4(connectionLocale, iOpts, workspaceLocale, tried) || IOMServerUtils.tryAgain5(connectionLocale, iOpts, workspaceLocale, tried) || iServerLocale == null || IOMServerUtils.tryAgain6(connectionLocale, iServerLocale, iOpts, workspaceLocale, tried) || IOMServerUtils.tryAgain7(connectionLocale, iServerLocale, iOpts, workspaceLocale, tried))) {
                        throw setFailure1;
                    }
                }
                String finalWorkspaceLocale = IOMServerUtils.GetWorkspaceLocale(iOpts);
                outLocale = IOMServerUtils.ConvertSASLocaleToJavaLocale(finalWorkspaceLocale);
            }
        }
        return outLocale;
    }

    private static boolean tryLocale(IOptionService iOpts, String workspaceLocale, List<String> tried, String newLocale) {
        boolean setOk = false;
        if (newLocale != null && !newLocale.equalsIgnoreCase(workspaceLocale) && !tried.contains(newLocale.toUpperCase())) {
            tried.add(newLocale.toUpperCase());
            DataServicesException setFailure1 = IOMServerUtils.setServerOption(iOpts, SAS_LOCALE_OPTION_NAME, newLocale, workspaceLocale);
            if (setFailure1 == null) {
                IOMServerUtils.loggerSetOk(iOpts, newLocale);
                setOk = true;
            }
        }
        return setOk;
    }

    private static void loggerSetOk(IOptionService iOpts, String rebuiltLocale) {
        String finalWorkspaceLocale;
        try {
            finalWorkspaceLocale = IOMServerUtils.GetWorkspaceLocale(iOpts);
        }
        catch (DataServicesException e) {
            finalWorkspaceLocale = rebuiltLocale;
        }
        MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("IOMServerUtils.SetServerLocaleRecoveredFromFailure.fmt.txt", finalWorkspaceLocale);
        _logger.warn(mf.toString());
    }

    private static boolean tryAgain1(Locale connectionLocale, IOptionService iOpts, String workspaceLocale, List<String> tried) {
        boolean setOk = false;
        String lang = connectionLocale.getLanguage();
        String country = connectionLocale.getCountry();
        String[] parts = lang.split("[;_\\s\\-]", 4);
        if (parts.length > 0) {
            if (country != null && parts.length > 1 && country.trim().length() == 0) {
                country = parts[1];
            }
            lang = parts[0];
            String rebuiltLocale = lang + (country != null && country.length() > 0 ? "_" + country : "");
            setOk = IOMServerUtils.tryLocale(iOpts, workspaceLocale, tried, rebuiltLocale);
        }
        return setOk;
    }

    private static boolean tryAgain2(Locale connectionLocale, IOptionService iOpts, String workspaceLocale, List<String> tried) {
        boolean setOk = false;
        String lang = connectionLocale.getLanguage();
        String country = connectionLocale.getCountry();
        String[] parts = lang.split("[;_\\s\\-]", 4);
        if (parts.length > 2 && country != null && country.trim().length() != 0 && !country.trim().equalsIgnoreCase(parts[1].trim())) {
            lang = parts[0];
            country = parts[1];
            String rebuiltLocale = lang + (country != null && country.length() > 0 ? "_" + country : "");
            setOk = IOMServerUtils.tryLocale(iOpts, workspaceLocale, tried, rebuiltLocale);
        }
        return setOk;
    }

    private static boolean tryAgain3(Locale connectionLocale, IOptionService iOpts, String workspaceLocale, List<String> tried) {
        boolean setOk = false;
        String lang = connectionLocale.getLanguage();
        String country = connectionLocale.getCountry();
        String lang2 = IOMServerUtils.fixupLangCode(lang);
        if (lang2 != null) {
            String rebuiltLocale = lang2 + (country != null && country.length() > 0 ? "_" + country : "");
            setOk = IOMServerUtils.tryLocale(iOpts, workspaceLocale, tried, rebuiltLocale);
        }
        return setOk;
    }

    private static boolean tryAgain4(Locale connectionLocale, IOptionService iOpts, String workspaceLocale, List<String> tried) {
        boolean setOk = false;
        String languageName = connectionLocale.getDisplayLanguage();
        setOk = IOMServerUtils.tryLocale(iOpts, workspaceLocale, tried, languageName);
        return setOk;
    }

    private static boolean tryAgain5(Locale connectionLocale, IOptionService iOpts, String workspaceLocale, List<String> tried) {
        boolean setOk = false;
        String lang = connectionLocale.getLanguage();
        String[] parts = lang.split("[;_\\s\\-]", 4);
        if (parts.length > 0) {
            lang = parts[0];
        }
        String languageName = IOMServerUtils.fixupLanguage(lang);
        setOk = IOMServerUtils.tryLocale(iOpts, workspaceLocale, tried, languageName);
        return setOk;
    }

    private static boolean tryAgain6(Locale connectionLocale, IServerLocale iServerLocale, IOptionService iOpts, String workspaceLocale, List<String> tried) {
        String validLocale;
        boolean setOk = false;
        String desiredLocale = connectionLocale.toString();
        try {
            validLocale = IOMServerUtils.GetValidLocaleFromServer(iServerLocale, desiredLocale);
        }
        catch (DataServicesException e) {
            MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("IOMServerUtils.GetValidLocaleFromServerWarning.fmt.txt", desiredLocale, e);
            _logger.warn(mf.toString());
            validLocale = null;
        }
        setOk = IOMServerUtils.tryLocale(iOpts, workspaceLocale, tried, validLocale);
        return setOk;
    }

    private static boolean tryAgain7(Locale connectionLocale, IServerLocale iServerLocale, IOptionService iOpts, String workspaceLocale, List<String> tried) {
        boolean setOk = false;
        String desiredLocaleOrig = connectionLocale.toString();
        String[] parts = desiredLocaleOrig.split("[;_\\s\\-]", 4);
        if (parts.length > 0) {
            String lang = parts[0];
            String country = parts.length > 1 ? "" : parts[1];
            String rebuiltLocale = lang + (country != null && country.length() > 0 ? "_" + country : "");
            if (!(rebuiltLocale.equalsIgnoreCase(workspaceLocale) || tried.contains(rebuiltLocale) || rebuiltLocale.equals(desiredLocaleOrig))) {
                String validLocale;
                try {
                    validLocale = IOMServerUtils.GetValidLocaleFromServer(iServerLocale, rebuiltLocale);
                }
                catch (DataServicesException e) {
                    MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("IOMServerUtils.GetValidLocaleFromServerWarning.fmt.txt", rebuiltLocale, e);
                    _logger.warn(mf.toString());
                    validLocale = null;
                }
                setOk = IOMServerUtils.tryLocale(iOpts, workspaceLocale, tried, validLocale);
            }
        }
        return setOk;
    }

    public static String GetValidLocaleFromServer(IServerLocale iServerLocale, String desiredLocale) throws ExecutionException {
        String validLocale = null;
        try {
            validLocale = iServerLocale.ValidateLocale(desiredLocale);
        }
        catch (BAD_PARAM e) {
            MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("IOMServerUtils.GetValidLocaleFromServerWarning.fmt.txt", new java.lang.Object[]{desiredLocale, e});
            _logger.warn(mf.toString());
        }
        catch (GenericError e) {
            throw new ExecutionException(e);
        }
        return validLocale;
    }

    private static DataServicesException getServerOption(IOptionService iOpts, String optionName, StringSeqHolder values) {
        String[] optionNames = new String[]{optionName};
        DataTypeSeqHolder types = new DataTypeSeqHolder();
        BooleanSeqHolder isStartupOnly = new BooleanSeqHolder();
        BooleanSeqHolder isPortable = new BooleanSeqHolder();
        GetErrorSeqHolder errorGetCodes = new GetErrorSeqHolder();
        LongSeqHolder errorIndices = new LongSeqHolder();
        StringSeqHolder errorMsgs = new StringSeqHolder();
        try {
            iOpts.GetOptions(optionNames, types, isPortable, isStartupOnly, values, errorIndices, errorGetCodes, errorMsgs);
        }
        catch (GenericError e) {
            return new DataServicesException(e);
        }
        MessageFormatter retErrorMsg = null;
        if (errorIndices.value != null && errorIndices.value.length > 0) {
            int errIndex = errorIndices.value[0];
            String errMsg = errorMsgs.value[errIndex];
            int errCode = errorGetCodes.value[errIndex].value();
            if (errCode == 0) {
                MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("IOMServerUtils.GetServerOptionOkWithWarning.fmt.txt", optionName, errMsg);
                _logger.warn(mf.toString());
            } else {
                retErrorMsg = IQMetadataResourceBundle.getMessageFormatter("IOMServerUtils.GetServerOptionFailedError.fmt.txt", optionName, errMsg);
                _logger.error(retErrorMsg.toString());
            }
        }
        if (retErrorMsg != null) {
            DataServicesException e = new DataServicesException(retErrorMsg);
            return e;
        }
        return null;
    }

    public static String GetServerOption(Object iomCorbaObject, String optionName) throws DataServicesException {
        StringSeqHolder values;
        IWorkspace iWorkspace = IOMServerUtils.GetIWorkspace(iomCorbaObject);
        if (iWorkspace == null) {
            return null;
        }
        IOptionService iOpts = IOMServerUtils.GetIOptionService(iWorkspace);
        DataServicesException e = IOMServerUtils.getServerOption(iOpts, optionName, values = new StringSeqHolder());
        if (e != null) {
            throw e;
        }
        return values.value == null ? null : (values.value.length == 0 ? null : values.value[0]);
    }

    public static boolean SetServerOption(Object iomCorbaObject, String optionName, String optionValue) throws DataServicesException {
        IWorkspace iWorkspace = IOMServerUtils.GetIWorkspace(iomCorbaObject);
        if (iWorkspace == null) {
            return false;
        }
        IOptionService iOpts = IOMServerUtils.GetIOptionService(iWorkspace);
        DataServicesException e = IOMServerUtils.setServerOption(iOpts, optionName, optionValue, null);
        if (e != null) {
            throw e;
        }
        return true;
    }

    private static DataServicesException setServerOption(IOptionService iOpts, String optionName, String optionValue, String oldValue) {
        String[] optionNames = new String[]{optionName};
        String[] newValues = new String[]{optionValue};
        SetErrorSeqHolder errorSetCodes = new SetErrorSeqHolder();
        LongSeqHolder errorIndices = new LongSeqHolder();
        StringSeqHolder errorMsgs = new StringSeqHolder();
        try {
            iOpts.SetOptions(optionNames, newValues, errorIndices, errorSetCodes, errorMsgs);
        }
        catch (GenericError e) {
            return new DataServicesException(e);
        }
        MessageFormatter retErrorMsg = null;
        if (errorIndices.value != null && errorIndices.value.length > 0) {
            int errIndex = errorIndices.value[0];
            String errMsg = errorMsgs.value[errIndex];
            int errCode = errorSetCodes.value[errIndex].value();
            if (errCode == 0) {
                MessageFormatter mf = null;
                mf = oldValue == null ? IQMetadataResourceBundle.getMessageFormatter("IOMServerUtils.SetServerOptionOkWithWarning.fmt.txt", optionName, optionValue, errMsg) : IQMetadataResourceBundle.getMessageFormatter("IOMServerUtils.ChangeServerOptionOkWithWarning.fmt.txt", optionName, oldValue, optionValue, errMsg);
                _logger.warn(mf.toString());
            } else {
                retErrorMsg = oldValue == null ? IQMetadataResourceBundle.getMessageFormatter("IOMServerUtils.SetServerOptionFailedError.fmt.txt", optionName, optionValue, errMsg) : IQMetadataResourceBundle.getMessageFormatter("IOMServerUtils.ChangeServerOptionFailedError.fmt.txt", optionName, oldValue, optionValue, errMsg);
                _logger.error(retErrorMsg.toString());
            }
        }
        if (retErrorMsg != null) {
            DataServicesException e = new DataServicesException(retErrorMsg);
            return e;
        }
        return null;
    }

    private static String fixupLangCode(String lang) {
        String lang2 = fixupLangFromToCodes.get(lang);
        if (lang2 != null) {
            MessageFormatter toName = fixupLangToCodeNames.get(lang);
            MessageFormatter msF = IQMetadataResourceBundle.getMessageFormatter("IOMServerUtils.ConvertingLangCodeForSAS.fmt.txt", lang, lang2, toName == null ? "" : lang);
            _logger.warn((java.lang.Object)msF);
        }
        return lang2;
    }

    private static String fixupLanguage(String lang) {
        String language2 = null;
        if (lang.equalsIgnoreCase("gv")) {
            _logger.debug("The Locale's language name for 'Manx' (gv) in SAS is 'MaxGaelic'.");
            language2 = "ManxGaelic";
        } else if (lang.equalsIgnoreCase("nb")) {
            _logger.debug("The Locale's language name for 'Norwegian Bokmal' (nb) in SAS is 'NorwegianBokmal'.");
            language2 = "NorwegianBokmal";
        } else if (lang.equalsIgnoreCase("nn")) {
            _logger.debug("The Locale's language name for 'Norwegian Nynorsk' (nn) in SAS is 'NorwegianNynorsk'.");
            language2 = "NorwegianNynorsk";
        } else if (lang.equalsIgnoreCase("sh")) {
            _logger.debug("The Locale's language name for 'Serbian Latin' (sh) in SAS is 'SerbianLatin'.");
            language2 = "SerbianLatin";
        }
        return language2;
    }

    public static Locale negotiateValidServerLocale(ConnectionInterface connection, Locale connectionLocale) {
        Locale validLocale = null;
        Object iomConnectionObject = connection.getObject();
        if (iomConnectionObject == null) {
            _logger.warn("Could not find CORBA object for IOM connection=" + connection);
        } else {
            long start = 0L;
            if (_perfCLogger.isDebugEnabled()) {
                ExtraLoggingContexts.debugLogConnectionPerformance("> Getting Service Locale object withIServerLocaleHelper.narrow(iomConnectionObject) ");
                start = System.currentTimeMillis();
            }
            IServerLocale iServerLocale = IServerLocaleHelper.narrow((Object)iomConnectionObject);
            if (_perfCLogger.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                ExtraLoggingContexts.debugLogConnectionPerformance("< done (" + (end - start) + "ms)");
            }
            if (iServerLocale == null) {
                _logger.warn("Could not find IServerLocale interface for CORBA object='" + iomConnectionObject + "', IOM connection=" + connection);
            } else {
                try {
                    String validLocaleString = IOMServerUtils.GetValidLocaleFromServer(iServerLocale, connectionLocale.toString());
                    validLocale = IOMServerUtils.ConvertSASLocaleToJavaLocale(validLocaleString);
                }
                catch (Exception e) {
                    _logger.warn((java.lang.Object)e);
                }
            }
        }
        return validLocale;
    }

    private static List<String> getMeasuresFromIom(String cubeName, String measureUniqueName, ISession iSession) throws InvalidMask, EmptySet, GenericError, InvalidRow {
        String catalogNameFilter = "";
        String schemaNameFilter = "";
        String nameFilter = "";
        String uniqueNameFilter = measureUniqueName;
        IMeasureSet measureSet = iSession.MeasureMetadata("", "", cubeName, "", uniqueNameFilter, measureFieldInclusion);
        StringSeqHolder pCatalogName = new StringSeqHolder();
        StringSeqHolder pSchemaName = new StringSeqHolder();
        StringSeqHolder pCubeName = new StringSeqHolder();
        StringSeqHolder pName = new StringSeqHolder();
        StringSeqHolder pUniqueName = new StringSeqHolder();
        StringSeqHolder pCaption = new StringSeqHolder();
        StringSeqHolder pUnits = new StringSeqHolder();
        StringSeqHolder pDesc = new StringSeqHolder();
        UUIDSeqHolder pGUID = new UUIDSeqHolder();
        LongSeqHolder pAggregator = new LongSeqHolder();
        LongSeqHolder pDataType = new LongSeqHolder();
        ShortSeqHolder pPrecision = new ShortSeqHolder();
        ShortSeqHolder pScale = new ShortSeqHolder();
        boolean startRow = false;
        int numToRead = -1;
        long nRows = measureSet.ReadRows(0, -1, pCatalogName, pSchemaName, pCubeName, pName, pUniqueName, pCaption, pGUID, pAggregator, pDataType, pPrecision, pScale, pUnits, pDesc);
        String[] caption = IOMServerUtils.hldToString(pCaption);
        ArrayList<String> measures = new ArrayList<String>();
        measures.addAll(Arrays.asList(caption));
        return measures;
    }

    private static String[] hldToString(StringSeqHolder arr) {
        String[] newarr = new String[arr.value.length];
        for (int i = 0; i < arr.value.length; ++i) {
            newarr[i] = arr.value[i];
        }
        return newarr;
    }

    static {
        for (int i = 0; i < fromLanguages.length; ++i) {
            String from = fromLanguages[i];
            String to = toLanguages[i];
            fixupLangFromToCodes.put(from, to);
            try {
                MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("IOMServerUtils.ConvertingLangCode." + to + ".ToName.txt", new java.lang.Object[0]);
                fixupLangToCodeNames.put(from, mf);
                continue;
            }
            catch (Exception e) {
                fixupLangToCodeNames.put(from, null);
            }
        }
        measureFieldInclusion = new boolean[]{true, true, true, true, true, true, false, true, true, true, true, true, true};
    }
}

