/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.InstructionInterface;
import com.sas.iquery.dataretrieval.QueryContainer;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataretrieval.StrategyInterface;
import com.sas.iquery.dataretrieval.StrategySelector;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionRecycler;
import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.execution.OverrideLocaleInterface;
import com.sas.iquery.execution.OverrideMLSLookupsInterface;
import com.sas.iquery.execution.OverrideStpNamesInterface;
import com.sas.iquery.execution.instructions.ExecutionBlock;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.ExecutionInstructionInterface;
import com.sas.iquery.execution.instructions.SASSubmitInstruction;
import com.sas.iquery.execution.instructions.StpNames;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.AssociationRule;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.CompoundFilter;
import com.sas.iquery.metadata.business.CreateTableDataSelection;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceRelationalQuery;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.JoinRelationshipType;
import com.sas.iquery.metadata.business.JoinType;
import com.sas.iquery.metadata.business.JoinTypeList;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.RootDataItem;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.SetOperationDataSelection;
import com.sas.iquery.metadata.business.SetOperationType;
import com.sas.iquery.metadata.expr.AbstractTimeValueExpression;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.DateValueExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.TimeValueExpression;
import com.sas.iquery.metadata.expr.TimestampValueExpression;
import com.sas.iquery.metadata.expr.relational.AbstractRelativeTimeValueExpression;
import com.sas.iquery.metadata.expr.relational.ConditionalExpressionAdapter;
import com.sas.iquery.metadata.expr.relational.RelativeDateValueExpression;
import com.sas.iquery.metadata.expr.relational.RelativeTimestampValueExpression;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Between;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Contains;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_In;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Like;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_TestForNull;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.AccessPath;
import com.sas.iquery.metadata.physical.AccessPathToRelationalData;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.MLSLookup;
import com.sas.iquery.metadata.physical.OMAResourceFactory;
import com.sas.iquery.metadata.physical.OMAWrapper;
import com.sas.iquery.metadata.physical.RelationalSchema;
import com.sas.iquery.metadata.physical.RelationalServer;
import com.sas.iquery.metadata.physical.SASWorkspaceServer;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.Server;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.inmemory.InMemoryColumn;
import com.sas.iquery.metadata.physical.inmemory.InMemoryFactory;
import com.sas.iquery.metadata.physical.inmemory.InMemorySASLibrary;
import com.sas.iquery.metadata.physical.inmemory.InMemoryTable;
import com.sas.iquery.strategies.sas.oma.AbstractStrategy;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.RelationalDataSelectionProcessor;
import com.sas.iquery.util.ColumnBasedDataItemRequest;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.information.metadata.datalocalization.DataLocalizationModel;
import com.sas.services.session.SessionContextInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class DataSelectionUtilities {
    private static final Logger _logger = LogManager.getLogger(DataSelectionUtilities.class);

    @Deprecated
    public static boolean isDataPreFormatted(BusinessQuery businessQuery, DataItem item) {
        return DataSelectionUtilities.isPreFormattedData(businessQuery, item);
    }

    public static boolean isPreFormattedData(BusinessQuery businessQuery, DataItem item) {
        boolean returnValue = false;
        if (item.isFormattingForced()) {
            returnValue = true;
            if (businessQuery != null) {
                boolean returnsUnformattedValues = businessQuery.getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA);
                if (!returnsUnformattedValues) {
                    List<SelectedItem> selectedItems = businessQuery.getSelectedItems();
                    for (SelectedItem sItem : selectedItems) {
                        if (sItem.getItem() != item) continue;
                        returnsUnformattedValues = sItem.getFormatType() == 1;
                        break;
                    }
                }
                int type = item.getExpressionTypeIgnoringFormattingForced();
                boolean isUnformattedNeededForItem = !(item.getUsage() != DataItemActionType.USAGE_CATEGORY || item.getSortDirection() == DataItemActionType.SORT_NONE && !returnsUnformattedValues || type != 4 && type != 5 && type != 6 && type != 2);
                boolean isUnformattedReturned = isUnformattedNeededForItem && returnsUnformattedValues;
                returnValue = !isUnformattedReturned;
            }
        }
        return returnValue;
    }

    @Deprecated
    public static AccessPathToRelationalData getPhysicalTableAccessPath(InformationMap map, String libraryName) throws MetadataException {
        return DataSelectionUtilities.getPhysicalTableAccessPath((BusinessModel)map, libraryName);
    }

    @Deprecated
    public static AccessPathToRelationalData getPhysicalTableAccessPath(BusinessModel model, String libraryName) throws MetadataException {
        DataSourceTable dataSource = model.getObjects(false, DataSourceTable.class).get(0);
        AccessPath accessPath = dataSource.getAccessPath();
        Server server = accessPath.getServer();
        Schema schema = DataSelectionUtilities.newPreAssignedSchema(server, libraryName);
        AccessPathToRelationalData newAccessPath = null;
        if (accessPath instanceof AccessPathToRelationalData) {
            newAccessPath = (AccessPathToRelationalData)accessPath.copy();
            newAccessPath.setSchema(schema);
        } else {
            newAccessPath = new AccessPathToRelationalData(server, schema);
        }
        return newAccessPath;
    }

    public static AccessPath newAccessPathToPreAssignedSchema(BusinessModel model, String libraryName) throws MetadataException {
        DataSourceTable dataSource = model.getObjects(false, DataSourceTable.class).get(0);
        AccessPath accessPath = dataSource.getAccessPath();
        Server server = accessPath.getServer();
        Schema schema = DataSelectionUtilities.newPreAssignedSchema(server, libraryName);
        AccessPath newAccessPath = accessPath.copy();
        newAccessPath.setSchema(schema);
        return newAccessPath;
    }

    public static Schema newPreAssignedSchema(BusinessModel businessModel, String sasLibraryName) throws MetadataException {
        DataSourceTable dataSource = businessModel.getObjects(false, DataSourceTable.class).get(0);
        AccessPath accessPath = dataSource.getAccessPath();
        Server server = accessPath.getServer();
        return DataSelectionUtilities.newPreAssignedSchema(server, sasLibraryName);
    }

    private static Schema newPreAssignedSchema(Server server, String libraryName) throws MetadataException {
        InMemorySASLibrary schema = InMemoryFactory.getInstance().newSASLibrary();
        schema.setIsPreassigned(true);
        schema.setLabel(libraryName);
        schema.setSASWorkspaceServer((SASWorkspaceServer)server);
        return schema;
    }

    public static DataSelection getDataSelectionForPhysicalTable(IntelligentQueryMetadataServiceInterface service, DataSelection inputSelection, AccessPath accessPath, String tableName) throws MetadataException {
        DataSelection returnSelection = null;
        Locale computationalLocale = inputSelection.getComputationalLocale();
        InformationMap informationMap = service.newInformationMap(inputSelection.getSession(), computationalLocale);
        InMemoryTable table = InMemoryFactory.getInstance().newTable();
        table.setLabel(tableName);
        Schema schema = accessPath != null ? accessPath.getSchema() : null;
        table.setSchema(schema);
        table.setDataSetOptionsAsString("");
        List<SelectedItem> selectedItems = inputSelection.getSelectedItems();
        ArrayList<InMemoryColumn> columns = new ArrayList<InMemoryColumn>(selectedItems.size());
        for (SelectedItem selectedItem : selectedItems) {
            DataItem item = selectedItem.getItem();
            Role role = selectedItem.getRole();
            boolean isOutputResultItem = Role.isOutputResultRole(inputSelection, role);
            if (!isOutputResultItem) continue;
            InMemoryColumn column = DataSelectionUtilities.createColumn(item, table);
            columns.add(column);
        }
        table.setColumns(columns);
        DataSourceTable newDataSource = informationMap.newDataSourceTable(accessPath, table);
        informationMap.addDataSource(newDataSource);
        List<QualifiedColumn> qualifiedColumns = newDataSource.getQualifiedColumns();
        for (QualifiedColumn qc : qualifiedColumns) {
            RootDataItem item = informationMap.newDataItem();
            item.setExpression(qc);
            item.setLabel(qc.getLabel());
            item.setResultSetID(qc.getSasName());
            informationMap.addBusinessItem(item);
        }
        returnSelection = DataSelectionFactory.newDataSelection(informationMap);
        List<DataItem> dataItems = informationMap.getObjects(false, DataItem.class);
        for (DataItem item : dataItems) {
            DataItemReference itemRef = returnSelection.newDataItemReference(item);
            itemRef.setResultSetID(item.getResultSetID());
            returnSelection.addBusinessItem(itemRef);
            returnSelection.addResultItem(itemRef, Role.COLUMN);
        }
        return returnSelection;
    }

    public static DataSelection getDataSelectionSortedByItems(DataSelection selection, List sortOrderPrecedence, DataSourceTable subjectTable, List keyColumns) throws MetadataException {
        DataSelection returnSelection = selection;
        if (sortOrderPrecedence != null && !sortOrderPrecedence.isEmpty()) {
            returnSelection = DataSelectionUtilities._getDataSelectionForSorting(selection, sortOrderPrecedence, subjectTable, keyColumns);
        }
        return returnSelection;
    }

    public static DataSelection getDataSelectionWithExtraItems(DataSelection selection, List extraResultItems, DataSourceTable subjectTable, List keyColumns) throws MetadataException {
        DataSelection returnSelection = selection;
        if (extraResultItems != null && !extraResultItems.isEmpty()) {
            returnSelection = DataSelectionUtilities._getDataSelectionForExtraItems(selection, extraResultItems, subjectTable, keyColumns);
        }
        return returnSelection;
    }

    public static DataSelection getDataSelectionForMAMapNode(DataSelection selection, List filters, DataSourceTable subjectTable, List oldKeyItems, List newKeyItems) throws MetadataException {
        DataSelection returnSelection = selection;
        returnSelection = DataSelectionUtilities._getDataSelectionForMapNode(selection, filters, subjectTable, oldKeyItems, newKeyItems);
        return returnSelection;
    }

    private static DataSelection _getDataSelectionForSorting(DataSelection originalSelection, List sortOrderPrecedence, DataSourceTable subjectTable, List keyColumns) throws MetadataException {
        DataSelection returnSelection = null;
        DataSelection finalSelection = DataSelectionUtilities._wrapSelectionForUsingExtraColumns(originalSelection, sortOrderPrecedence, subjectTable, keyColumns);
        List newSortItems = DataSelectionUtilities._getNearlyEquivalentSortItems(finalSelection, sortOrderPrecedence);
        finalSelection.setSortOrderPrecedence(newSortItems);
        returnSelection = finalSelection;
        return returnSelection;
    }

    private static DataSelection _getDataSelectionForExtraItems(DataSelection originalSelection, List extraItems, DataSourceTable subjectTable, List keyColumns) throws MetadataException {
        DataSelection finalSelection = DataSelectionUtilities._wrapSelectionForUsingExtraColumns(originalSelection, extraItems, subjectTable, keyColumns);
        for (DataItem item : DataSelectionUtilities._getNearlyEquivalentResultItems(finalSelection, extraItems)) {
            finalSelection.addResultItem(item, Role.COLUMN);
        }
        return finalSelection;
    }

    private static DataSelection _getDataSelectionForMapNode(DataSelection originalSelection, List filters, DataSourceTable subjectTable, List oldKeyItems, List newKeyItems) throws MetadataException {
        ArrayList<ExpressionInterface> keyColumns = new ArrayList<ExpressionInterface>(oldKeyItems.size());
        Iterator inputIt = oldKeyItems.iterator();
        while (inputIt.hasNext()) {
            keyColumns.add(((DataItem)inputIt.next()).getExpression());
        }
        ArrayList extraItems = new ArrayList(newKeyItems);
        for (FilterItem filter : filters) {
            List<DataItem> filterDataItems = filter.getDataItems(1);
            Utils.addButNoDuplicates(extraItems, filterDataItems);
        }
        ListIterator extraIt = extraItems.listIterator();
        block2: while (extraIt.hasNext()) {
            DataItem item = (DataItem)extraIt.next();
            for (DataItem resultItem : originalSelection.getResultItems()) {
                if (!item.getResultSetID().equalsIgnoreCase(resultItem.getResultSetID())) continue;
                extraIt.remove();
                continue block2;
            }
        }
        DataSelection finalSelection = DataSelectionUtilities._wrapSelectionForUsingExtraColumns(originalSelection, extraItems, subjectTable, keyColumns);
        for (DataItem item : finalSelection.getResultItems()) {
            finalSelection.setResultItemRole(item, Role.HIDDEN);
        }
        for (DataItem item : DataSelectionUtilities._getNearlyEquivalentResultItems(finalSelection, newKeyItems)) {
            finalSelection.addResultItem(item, Role.COLUMN);
        }
        return finalSelection;
    }

    private static DataSelection _wrapSelectionForUsingExtraColumns(DataSelection originalSelection, List extraItems, DataSourceTable subjectTable, List keyColumns) throws MetadataException {
        InformationMap oldMap = DataSelectionUtilities._getInformationMap(subjectTable);
        IntelligentQueryMetadataServiceInterface _iqService = IntelligentQueryMetadataServiceFactory.newService();
        InformationMap newInformationMap = null;
        Locale computationalLocale = originalSelection.getComputationalLocale();
        newInformationMap = _iqService.newInformationMap(originalSelection.getSession(), computationalLocale);
        DataSelection sortSubSelection = DataSelectionUtilities._getSubSelectionWithExtraItems(oldMap, extraItems, keyColumns);
        sortSubSelection.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, true);
        DataSourceRelationalQuery sortDsrq = newInformationMap.newDataSourceRelationalQuery(sortSubSelection);
        newInformationMap.addDataSource(sortDsrq);
        DataSelection finalSelection = DataSelectionFactory.newDataSelection(newInformationMap);
        finalSelection.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, true);
        List newKeyColumns = DataSelectionUtilities._getEquivalentKeyColumns(sortDsrq, keyColumns);
        DataSourceRelationalQuery setDsrq = newInformationMap.newDataSourceRelationalQuery(originalSelection);
        newInformationMap.addDataSource(setDsrq);
        DataSelectionUtilities.addNewJoin(setDsrq, newKeyColumns, sortDsrq, JoinType.LEFT);
        List newResultColumns = DataSelectionUtilities._getEquivalentKeyColumns(setDsrq, keyColumns);
        DataSelectionUtilities._addResultItemsForKeyColumns(newInformationMap, finalSelection, newResultColumns);
        return finalSelection;
    }

    private static void _addResultItemsForKeyColumns(InformationMap informationMap, DataSelection selection, List keyColumns) throws MetadataException {
        for (Column column : keyColumns) {
            RootDataItem newItem = informationMap.newDataItem();
            newItem.setExpression(column);
            String id = column.getSasName();
            newItem.setLabel(id);
            informationMap.addBusinessItem(newItem);
            String resultSetID = DataSelectionUtilities._getColumnName(newItem);
            if (resultSetID != null) {
                newItem.setResultSetID(resultSetID);
            }
            DataItemReference businessItem = selection.newDataItemReference(newItem);
            businessItem.setResultSetID(newItem.getResultSetID());
            selection.addBusinessItem(businessItem);
            selection.addResultItem(businessItem, Role.COLUMN);
        }
    }

    private static DataSelection _getSubSelectionWithExtraItems(InformationMap oldMap, List<? extends DataItem> extraItems, List keyColumns) throws MetadataException {
        DataSelection sortSubSelection = DataSelectionFactory.newDataSelection(oldMap);
        DataSelectionUtilities._addResultItemsForKeyColumns(oldMap, sortSubSelection, keyColumns);
        ArrayList<DataItem> newDataItems = new ArrayList<DataItem>();
        for (DataItem dataItem : extraItems) {
            DataItem item = DataSelectionUtilities.getEquivalentDataItem(sortSubSelection, dataItem);
            newDataItems.add(item);
        }
        for (DataItem dataItem : newDataItems) {
            if (DataSelectionUtilities._getEquivalentResultItem(sortSubSelection, dataItem) != null) continue;
            DataItemReference businessItem = sortSubSelection.newDataItemReference(dataItem);
            sortSubSelection.addBusinessItem(businessItem);
            String resultSetID = DataSelectionUtilities._getColumnName(dataItem);
            if (resultSetID != null) {
                businessItem.setResultSetID(resultSetID);
            }
            businessItem.setUsage(DataItemActionType.USAGE_DETAIL);
            sortSubSelection.addResultItem(businessItem, Role.COLUMN);
        }
        return sortSubSelection;
    }

    private static List _getNearlyEquivalentSortItems(DataSelection selection, List sortOrderPrecedence) throws MetadataException {
        ArrayList<DataItem> newOrderPrecedence = new ArrayList<DataItem>();
        for (DataItem diToSortBy : sortOrderPrecedence) {
            DataItem di = DataSelectionUtilities.getNearlyEquivalentDataItem(selection, diToSortBy);
            DataItem dir = DataSelectionUtilities._getEquivalentResultItem(selection, di);
            if (dir == null) {
                dir = selection.newDataItemReference(di);
                String resultSetID = DataSelectionUtilities._getColumnName(di);
                if (resultSetID != null) {
                    dir.setResultSetID(resultSetID);
                }
                selection.addBusinessItem(dir);
                dir.setFormat(null);
                selection.addResultItem(dir, Role.HIDDEN);
            }
            dir.setSortDirection(diToSortBy.getSortDirection());
            newOrderPrecedence.add(dir);
        }
        return newOrderPrecedence;
    }

    private static List _getNearlyEquivalentResultItems(DataSelection selection, List extraItems) throws MetadataException {
        ArrayList<DataItem> newResultItems = new ArrayList<DataItem>();
        for (DataItem oldItem : extraItems) {
            DataItem di = DataSelectionUtilities.getNearlyEquivalentDataItem(selection, oldItem);
            DataItem dir = DataSelectionUtilities._getEquivalentResultItem(selection, di);
            if (dir == null) {
                dir = selection.newDataItemReference(di);
                String resultSetID = DataSelectionUtilities._getColumnName(di);
                if (resultSetID != null) {
                    dir.setResultSetID(resultSetID);
                }
                selection.addBusinessItem(dir);
            }
            newResultItems.add(dir);
        }
        return newResultItems;
    }

    public static DataItem getEquivalentDataItem(DataSelection selection, DataItem oldItem) throws MetadataException {
        DataItem item = null;
        if (DataSelectionUtilities._isItemInBusinessModelChain(selection, oldItem)) {
            item = oldItem;
        } else {
            item = DataSelectionUtilities._getEquivalentResultItem(selection, oldItem);
            if (item == null) {
                item = selection.newDataItem();
                ExpressionInterface oldExpression = oldItem.getExpression();
                ExpressionInterface newExpression = DataSelectionUtilities._getEquivalentExpression(selection, oldExpression);
                item.setExpression(newExpression);
                item.setLabel(oldItem.getLabel());
                selection.addBusinessItem(item);
            }
        }
        return item;
    }

    public static DataItem getNearlyEquivalentDataItem(DataSelection selection, DataItem diToSortBy) throws MetadataException {
        DataItem item = null;
        if (DataSelectionUtilities._isItemInBusinessModelChain(selection, diToSortBy)) {
            item = diToSortBy;
        } else {
            item = DataSelectionUtilities._getEquivalentResultItem(selection, diToSortBy);
            if (item == null) {
                item = selection.newDataItem();
                ExpressionInterface oldExpression = diToSortBy.getExpression();
                ExpressionInterface newExpression = DataSelectionUtilities._getNearlyEquivalentExpression(selection, oldExpression);
                item.setExpression(newExpression);
                item.setLabel(diToSortBy.getLabel());
                selection.addBusinessItem(item);
            }
        }
        return item;
    }

    private static ExpressionInterface _getEquivalentExpression(DataSelection selection, ExpressionInterface oldExpression) throws MetadataException, InvalidIDException {
        ExpressionInterface newExpression = null;
        if (oldExpression instanceof DataItem) {
            newExpression = DataSelectionUtilities.getEquivalentDataItem(selection, (DataItem)oldExpression);
            return newExpression;
        }
        if (oldExpression instanceof ConstantExpression) {
            newExpression = oldExpression;
            return newExpression;
        }
        if (oldExpression instanceof AbstractTimeValueExpression) {
            newExpression = DataSelectionUtilities._getNewTimeExpression(oldExpression);
            return newExpression;
        }
        if (oldExpression instanceof AbstractRelativeTimeValueExpression) {
            newExpression = DataSelectionUtilities._getNewRelativeTimeExpression(selection, oldExpression);
            AbstractRelativeTimeValueExpression oldTimeExpression = (AbstractRelativeTimeValueExpression)oldExpression;
            AbstractRelativeTimeValueExpression newTimeExpression = (AbstractRelativeTimeValueExpression)newExpression;
            newTimeExpression.setShiftingFrom(DataSelectionUtilities._getEquivalentExpression(selection, oldTimeExpression.getShiftingFrom()));
            newExpression = newTimeExpression;
            return newExpression;
        }
        if (oldExpression instanceof FunctionCall) {
            FunctionCall func = (FunctionCall)oldExpression;
            FunctionCall newFunc = null;
            try {
                newFunc = (FunctionCall)func.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnableToCloneExpression.txt", new Object[0]), (Throwable)e);
            }
            newExpression = newFunc;
            return newExpression;
        }
        if (oldExpression instanceof MultipleConditionalExpression) {
            MultipleConditionalExpression newMCExpression;
            MultipleConditionalExpression oldMCExpression = (MultipleConditionalExpression)oldExpression;
            try {
                newMCExpression = (MultipleConditionalExpression)oldMCExpression.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnableToCloneExpression.txt", new Object[0]), (Throwable)e);
            }
            newMCExpression.setCascades(oldMCExpression.getCascades(false));
            ArrayList<ExpressionInterface> newChildList = new ArrayList<ExpressionInterface>(oldMCExpression.getExpressionCount());
            for (ExpressionInterface oldChild : oldMCExpression.getExpressionList()) {
                newChildList.add(DataSelectionUtilities._getEquivalentExpression(selection, oldChild));
            }
            newMCExpression.setExpressionList(newChildList);
            newExpression = newMCExpression;
            return newExpression;
        }
        if (oldExpression instanceof SimpleConditionalExpression_Comparison) {
            SimpleConditionalExpression_Comparison simple = (SimpleConditionalExpression_Comparison)oldExpression;
            SimpleConditionalExpression_Comparison newSimpleExpression = new SimpleConditionalExpression_Comparison();
            newSimpleExpression.setComparisonOperator(simple.getComparisonOperator());
            newSimpleExpression.setFormattingForcedOverridden(simple.isFormattingForcedOverridden());
            newSimpleExpression.setFormattingForcedOverrideValue(simple.getFormattingForcedOverrideValue());
            newSimpleExpression.setIsNegated(simple.isNegated());
            newSimpleExpression.setLeftExpression(DataSelectionUtilities._getEquivalentExpression(selection, simple.getLeftExpression()));
            newSimpleExpression.setRightExpression(DataSelectionUtilities._getEquivalentExpression(selection, simple.getRightExpression()));
            newExpression = newSimpleExpression;
            return newExpression;
        }
        if (oldExpression instanceof ConditionalExpressionAdapter) {
            ConditionalExpressionAdapter cea = (ConditionalExpressionAdapter)oldExpression;
            return DataSelectionUtilities._getEquivalentExpression(selection, cea.getExpression());
        }
        if (oldExpression instanceof SimpleConditionalExpression_Like) {
            newExpression = DataSelectionUtilities._createSimpleConditionalExpressionLike(selection, (SimpleConditionalExpression_Like)oldExpression);
            return newExpression;
        }
        if (oldExpression instanceof SimpleConditionalExpression_Between) {
            newExpression = DataSelectionUtilities._createSimpleConditionalExpressionBetween(selection, (SimpleConditionalExpression_Between)oldExpression);
            return newExpression;
        }
        if (oldExpression instanceof SimpleConditionalExpression_Contains) {
            newExpression = DataSelectionUtilities._createSimpleConditionalExpressionContains(selection, (SimpleConditionalExpression_Contains)oldExpression);
            return newExpression;
        }
        if (oldExpression instanceof SimpleConditionalExpression_In) {
            newExpression = DataSelectionUtilities._createSimpleConditionalExpressionIn(selection, (SimpleConditionalExpression_In)oldExpression);
            return newExpression;
        }
        if (oldExpression instanceof SimpleConditionalExpression_TestForNull) {
            newExpression = DataSelectionUtilities._createSimpleConditionalExpressionTestForNull(selection, (SimpleConditionalExpression_TestForNull)oldExpression);
            return newExpression;
        }
        if (!(oldExpression instanceof QualifiedColumn)) {
            if (oldExpression instanceof ResourceAwareStringExpression) {
                ResourceAwareStringExpression rase = (ResourceAwareStringExpression)oldExpression;
                List<QualifiedColumn> resources = rase.getResources(QualifiedColumn.class, 65535);
                if (resources.isEmpty()) {
                    newExpression = oldExpression;
                    return newExpression;
                }
                newExpression = DataSelectionUtilities._createRASEExpression(selection, (ResourceAwareStringExpression)oldExpression);
                return newExpression;
            }
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesSortSimpleExpression.fmt.txt", oldExpression.getClass().getName(), oldExpression));
        }
        BusinessModel businessModel = selection.getBusinessModel();
        List<DataSourceTable> tables = businessModel.getObjects(true, DataSourceTable.class);
        DataSelectionUtilities._getTablesInJoins(businessModel, tables);
        QualifiedColumn qualifiedColumnFromItem = (QualifiedColumn)oldExpression;
        String qcFromItemName = qualifiedColumnFromItem.getSasName();
        Iterator<DataSourceTable> tableIt = tables.iterator();
        while (tableIt.hasNext() && newExpression == null) {
            DataSourceTable table = tableIt.next();
            if (!table.getID().equals(qualifiedColumnFromItem.getDataSource().getID())) continue;
            newExpression = DataSelectionUtilities._findColumnByName(qcFromItemName, table);
        }
        if (newExpression == null) {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesCantFindExpression.fmt.txt", oldExpression.toString());
            throw new MetadataException(msg);
        }
        return newExpression;
    }

    private static ExpressionInterface _getNewTimeExpression(ExpressionInterface oldExpression) throws MetadataException {
        AbstractTimeValueExpression newTimeExpression;
        AbstractTimeValueExpression oldTimeExpression = (AbstractTimeValueExpression)oldExpression;
        if (oldExpression instanceof DateValueExpression) {
            newTimeExpression = new DateValueExpression();
        } else if (oldExpression instanceof TimestampValueExpression) {
            newTimeExpression = new TimestampValueExpression();
        } else if (oldExpression instanceof TimeValueExpression) {
            newTimeExpression = new TimeValueExpression();
        } else {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnsupportedBaseExpr.fmt.txt", oldExpression.getClass().getName());
            throw new MetadataException(msg);
        }
        newTimeExpression.setExplicitDoubleValue(oldTimeExpression.getExplicitDoubleValue());
        newTimeExpression.setValue(oldTimeExpression.getValue());
        AbstractTimeValueExpression newExpression = newTimeExpression;
        return newExpression;
    }

    private static ExpressionInterface _getNearlyEquivalentExpression(DataSelection selection, ExpressionInterface oldExpression) throws MetadataException, InvalidIDException {
        ExpressionInterface newExpression = null;
        if (oldExpression instanceof DataItem) {
            return DataSelectionUtilities._getNearlyEquivalentExpression(selection, ((DataItem)oldExpression).getExpression());
        }
        if (oldExpression instanceof ConstantExpression) {
            newExpression = oldExpression;
            return newExpression;
        }
        if (oldExpression instanceof AbstractTimeValueExpression) {
            newExpression = DataSelectionUtilities._getNewTimeExpression(oldExpression);
            return newExpression;
        }
        if (oldExpression instanceof AbstractRelativeTimeValueExpression) {
            newExpression = DataSelectionUtilities._getNewRelativeTimeExpression(selection, oldExpression);
            AbstractRelativeTimeValueExpression oldTimeExpression = (AbstractRelativeTimeValueExpression)oldExpression;
            AbstractRelativeTimeValueExpression newTimeExpression = (AbstractRelativeTimeValueExpression)newExpression;
            newTimeExpression.setShiftingFrom(DataSelectionUtilities._getNearlyEquivalentExpression(selection, oldTimeExpression.getShiftingFrom()));
            newExpression = newTimeExpression;
            return newExpression;
        }
        if (oldExpression instanceof FunctionCall) {
            FunctionCall func = (FunctionCall)oldExpression;
            FunctionCall newFunc = null;
            try {
                newFunc = (FunctionCall)func.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnableToCloneExpression.txt", new Object[0]), (Throwable)e);
            }
            ArrayList<ExpressionInterface> newArgList = new ArrayList<ExpressionInterface>(func.getArguments().size());
            for (ExpressionInterface oldChild : func.getArguments()) {
                newArgList.add(DataSelectionUtilities._getNearlyEquivalentExpression(selection, oldChild));
            }
            newFunc.setArguments(newArgList);
            newExpression = newFunc;
            return newExpression;
        }
        if (oldExpression instanceof MultipleConditionalExpression) {
            MultipleConditionalExpression newMCExpression;
            MultipleConditionalExpression oldMCExpression = (MultipleConditionalExpression)oldExpression;
            try {
                newMCExpression = (MultipleConditionalExpression)oldMCExpression.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnableToCloneExpression.txt", new Object[0]), (Throwable)e);
            }
            newMCExpression.setCascades(oldMCExpression.getCascades(false));
            ArrayList<ExpressionInterface> newChildList = new ArrayList<ExpressionInterface>(oldMCExpression.getExpressionCount());
            for (ExpressionInterface oldChild : oldMCExpression.getExpressionList()) {
                newChildList.add(DataSelectionUtilities._getNearlyEquivalentExpression(selection, oldChild));
            }
            newMCExpression.setExpressionList(newChildList);
            newExpression = newMCExpression;
            return newExpression;
        }
        if (oldExpression instanceof SimpleConditionalExpression_Comparison) {
            SimpleConditionalExpression_Comparison simple = (SimpleConditionalExpression_Comparison)oldExpression;
            SimpleConditionalExpression_Comparison newSimpleExpression = new SimpleConditionalExpression_Comparison();
            newSimpleExpression.setComparisonOperator(simple.getComparisonOperator());
            newSimpleExpression.setFormattingForcedOverridden(simple.isFormattingForcedOverridden());
            newSimpleExpression.setFormattingForcedOverrideValue(simple.getFormattingForcedOverrideValue());
            newSimpleExpression.setIsNegated(simple.isNegated());
            newSimpleExpression.setLeftExpression(DataSelectionUtilities._getNearlyEquivalentExpression(selection, simple.getLeftExpression()));
            newSimpleExpression.setRightExpression(DataSelectionUtilities._getNearlyEquivalentExpression(selection, simple.getRightExpression()));
            newExpression = newSimpleExpression;
            return newExpression;
        }
        if (oldExpression instanceof ConditionalExpressionAdapter) {
            ConditionalExpressionAdapter cea = (ConditionalExpressionAdapter)oldExpression;
            return DataSelectionUtilities._getNearlyEquivalentExpression(selection, cea.getExpression());
        }
        if (!(oldExpression instanceof QualifiedColumn)) {
            if (oldExpression instanceof ResourceAwareStringExpression) {
                ResourceAwareStringExpression rase = (ResourceAwareStringExpression)oldExpression;
                List<QualifiedColumn> resources = rase.getResources(QualifiedColumn.class, 65535);
                if (resources.isEmpty() || resources.size() > 1 || rase.isCalculatedItem()) {
                    throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesSortSimpleExpression.fmt.txt", oldExpression.getClass().getName(), oldExpression));
                }
                oldExpression = resources.get(0);
            } else {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesSortSimpleExpression.fmt.txt", oldExpression.getClass().getName(), oldExpression));
            }
        }
        BusinessModel businessModel = selection.getBusinessModel();
        List<DataSourceTable> tables = businessModel.getObjects(true, DataSourceTable.class);
        DataSelectionUtilities._getTablesInJoins(businessModel, tables);
        QualifiedColumn qualifiedColumnFromItem = (QualifiedColumn)oldExpression;
        String qcTableID = qualifiedColumnFromItem.getDataSource().getID();
        boolean foundTable = false;
        Iterator<DataSourceTable> tableIt = tables.iterator();
        DataSourceTable equivTable = null;
        while (tableIt.hasNext()) {
            DataSourceTable table = tableIt.next();
            if (!table.getID().equals(qcTableID)) continue;
            foundTable = true;
            equivTable = table;
            break;
        }
        String qcFromItemName = qualifiedColumnFromItem.getSasName();
        if (foundTable) {
            newExpression = DataSelectionUtilities._findColumnByName(qcFromItemName, equivTable);
        } else {
            tableIt = tables.iterator();
            while (tableIt.hasNext() && newExpression == null) {
                DataSourceTable table = tableIt.next();
                newExpression = DataSelectionUtilities._findColumnByName(qcFromItemName, table);
            }
        }
        if (newExpression == null) {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesCantFindExpression.fmt.txt", oldExpression.toString());
            throw new MetadataException(msg);
        }
        return newExpression;
    }

    private static ExpressionInterface _findColumnByName(String qcFromItemName, DataSourceTable table) throws MetadataException {
        QualifiedColumn newExpression = null;
        List<QualifiedColumn> columns = table.getQualifiedColumns();
        for (QualifiedColumn qualifiedColumnFromSelection : columns) {
            String qcFromSelectionName = qualifiedColumnFromSelection.getSasName();
            if (!qcFromSelectionName.equalsIgnoreCase(qcFromItemName)) continue;
            newExpression = qualifiedColumnFromSelection;
            break;
        }
        return newExpression;
    }

    private static void _getTablesInJoins(BusinessModel businessModel, List tables) {
        List<Join> joins = businessModel.getObjects(true, Join.class);
        ArrayList<DataSourceTable> joinSources = new ArrayList<DataSourceTable>();
        for (Join join : joins) {
            DataSourceTable leftTable = join.getLeftDataSource();
            DataSourceTable rightTable = join.getRightDataSource();
            joinSources.add(leftTable);
            joinSources.add(rightTable);
        }
        IQModelImplUtilities.addButNoDuplicates(tables, joinSources);
    }

    private static ExpressionInterface _getNewRelativeTimeExpression(DataSelection selection, ExpressionInterface oldExpression) throws MetadataException, InvalidIDException {
        AbstractRelativeTimeValueExpression newTimeExpression;
        AbstractRelativeTimeValueExpression oldTimeExpression = (AbstractRelativeTimeValueExpression)oldExpression;
        if (oldExpression instanceof RelativeDateValueExpression) {
            newTimeExpression = new RelativeDateValueExpression();
        } else if (oldExpression instanceof RelativeTimestampValueExpression) {
            newTimeExpression = new RelativeTimestampValueExpression();
        } else {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnsupportedBaseExpr.fmt.txt", oldExpression.getClass().getName());
            throw new MetadataException(msg);
        }
        newTimeExpression.setAlignment(oldTimeExpression.getAlignment());
        newTimeExpression.setShiftUnit(oldTimeExpression.getShiftUnit());
        newTimeExpression.setShiftDirection(oldTimeExpression.getShiftDirection());
        newTimeExpression.setShiftMultiplier(oldTimeExpression.getShiftMultiplier());
        AbstractRelativeTimeValueExpression newExpression = newTimeExpression;
        return newExpression;
    }

    public static FilterItem getEquivalentFilterItem(DataSelection selection, FilterItem filterItem) throws MetadataException {
        FilterItem item = null;
        if (DataSelectionUtilities._isItemInBusinessModelChain(selection, filterItem)) {
            item = filterItem;
        } else if (filterItem instanceof CompoundFilter) {
            CompoundFilter oldCompound = (CompoundFilter)filterItem;
            CompoundFilter newCompound = selection.newCompoundFilter();
            selection.addBusinessItem(newCompound);
            newCompound.setIsNegated(oldCompound.isNegated());
            newCompound.setDescription(oldCompound.getDescription());
            newCompound.setExtendedAttributes(oldCompound.getExtendedAttributes());
            newCompound.setIsHidden(oldCompound.isHidden());
            newCompound.setLabel(oldCompound.getLabel());
            newCompound.setLeftFilter(DataSelectionUtilities.getEquivalentFilterItem(selection, oldCompound.getLeftFilter()));
            newCompound.setRightFilter(DataSelectionUtilities.getEquivalentFilterItem(selection, oldCompound.getRightFilter()));
            newCompound.setRelationType(oldCompound.getRelationType());
            item = newCompound;
        } else {
            item = selection.newFilterItem();
            ExpressionInterface newExpression = null;
            ExpressionInterface oldExpression = filterItem.getExpression();
            if (oldExpression instanceof CompoundConditionalExpression) {
                CompoundConditionalExpression newCompound;
                CompoundConditionalExpression oldCompound = (CompoundConditionalExpression)oldExpression;
                try {
                    newCompound = (CompoundConditionalExpression)oldCompound.clone();
                    ExpressionInterface newLeftExpression = DataSelectionUtilities._getNearlyEquivalentExpression(selection, oldCompound.getLeftExpression());
                    ExpressionInterface newRightExpression = DataSelectionUtilities._getNearlyEquivalentExpression(selection, oldCompound.getRightExpression());
                    newCompound.setLeftExpression(newLeftExpression);
                    newCompound.setRightExpression(newRightExpression);
                }
                catch (CloneNotSupportedException e) {
                    throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnableToCloneExpression.txt", new Object[0]), (Throwable)e);
                }
                newExpression = newCompound;
            } else if (oldExpression instanceof SimpleConditionalExpression_Between) {
                newExpression = DataSelectionUtilities._createSimpleConditionalExpressionBetween(selection, (SimpleConditionalExpression_Between)oldExpression);
            } else if (oldExpression instanceof SimpleConditionalExpression_Comparison) {
                newExpression = DataSelectionUtilities._createSimpleConditionalExpressionComparison(selection, (SimpleConditionalExpression_Comparison)oldExpression);
            } else if (oldExpression instanceof SimpleConditionalExpression_Contains) {
                newExpression = DataSelectionUtilities._createSimpleConditionalExpressionContains(selection, (SimpleConditionalExpression_Contains)oldExpression);
            } else if (oldExpression instanceof SimpleConditionalExpression_Like) {
                newExpression = DataSelectionUtilities._createSimpleConditionalExpressionLike(selection, (SimpleConditionalExpression_Like)oldExpression);
            } else if (oldExpression instanceof SimpleConditionalExpression_In) {
                newExpression = DataSelectionUtilities._createSimpleConditionalExpressionIn(selection, (SimpleConditionalExpression_In)oldExpression);
            } else if (oldExpression instanceof SimpleConditionalExpression_TestForNull) {
                newExpression = DataSelectionUtilities._createSimpleConditionalExpressionTestForNull(selection, (SimpleConditionalExpression_TestForNull)oldExpression);
            } else if (oldExpression instanceof ConditionalExpressionAdapter) {
                newExpression = DataSelectionUtilities._createConditionalExpressionAdapter(selection, (ConditionalExpressionAdapter)oldExpression);
            } else if (oldExpression instanceof MultipleConditionalExpression) {
                newExpression = DataSelectionUtilities._createMultipleConditionalExpression(selection, (MultipleConditionalExpression)oldExpression);
            } else if (oldExpression instanceof ResourceAwareStringExpression) {
                newExpression = DataSelectionUtilities._createRASEExpression(selection, (ResourceAwareStringExpression)oldExpression);
            } else {
                MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnsupportedFilterExpression.fmt.txt", oldExpression.getClass().getName());
                throw new MetadataException(msg);
            }
            item.setExpression(newExpression);
            item.setLabel(filterItem.getLabel());
            selection.addBusinessItem(item);
        }
        return item;
    }

    private static ConditionalExpressionAdapter _createConditionalExpressionAdapter(DataSelection selection, ConditionalExpressionAdapter oldExpression) throws MetadataException {
        ConditionalExpressionAdapter newCondExprAdapter = null;
        try {
            newCondExprAdapter = (ConditionalExpressionAdapter)oldExpression.clone();
            ExpressionInterface newInnerCond = DataSelectionUtilities._getEquivalentExpression(selection, oldExpression.getExpression());
            newCondExprAdapter.setExpression(newInnerCond);
        }
        catch (CloneNotSupportedException e) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnableToCloneExpression.txt", new Object[0]), (Throwable)e);
        }
        return newCondExprAdapter;
    }

    private static ResourceAwareStringExpression _createRASEExpression(DataSelection selection, ResourceAwareStringExpression oldExpression) throws MetadataException {
        ResourceAwareStringExpression newRASE = null;
        try {
            newRASE = (ResourceAwareStringExpression)oldExpression.clone();
            List<DataItem> oldExpressions = newRASE.getResources(DataItem.class, 0);
            ArrayList<ExpressionInterface> newResources = new ArrayList<ExpressionInterface>(oldExpressions.size());
            for (ExpressionInterface expressionInterface : oldExpressions) {
                ExpressionInterface newExpression = DataSelectionUtilities._getEquivalentExpression(selection, expressionInterface);
                newResources.add(newExpression);
            }
            newRASE.setResources(newResources);
        }
        catch (CloneNotSupportedException e) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnableToCloneExpression.txt", new Object[0]), (Throwable)e);
        }
        return newRASE;
    }

    private static ExpressionInterface _createSimpleConditionalExpressionTestForNull(DataSelection selection, SimpleConditionalExpression_TestForNull oldExpression) throws MetadataException {
        SimpleConditionalExpression_TestForNull newSimpleTestForNull = null;
        try {
            newSimpleTestForNull = (SimpleConditionalExpression_TestForNull)oldExpression.clone();
            ExpressionInterface newWhatToCompareExpression = DataSelectionUtilities._getEquivalentExpression(selection, oldExpression.getWhatToCompare());
            newSimpleTestForNull.setWhatToCompare(newWhatToCompareExpression);
            newSimpleTestForNull.setIsNegated(oldExpression.isNegated());
        }
        catch (CloneNotSupportedException e) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnableToCloneExpression.txt", new Object[0]), (Throwable)e);
        }
        return newSimpleTestForNull;
    }

    private static SimpleConditionalExpression_In _createSimpleConditionalExpressionIn(DataSelection selection, SimpleConditionalExpression_In oldExpression) throws MetadataException {
        SimpleConditionalExpression_In newSimpleIn = null;
        try {
            newSimpleIn = (SimpleConditionalExpression_In)oldExpression.clone();
            ExpressionInterface newWhatToCompareExpression = DataSelectionUtilities._getEquivalentExpression(selection, oldExpression.getWhatToCompare());
            List<ExpressionInterface> expressionList = oldExpression.getComparisonList();
            ArrayList<ExpressionInterface> newExpressionList = new ArrayList<ExpressionInterface>();
            for (ExpressionInterface expr : expressionList) {
                ExpressionInterface subExpression = DataSelectionUtilities._getEquivalentExpression(selection, expr);
                newExpressionList.add(subExpression);
            }
            newSimpleIn.setIsNegated(oldExpression.isNegated());
            newSimpleIn.setWhatToCompare(newWhatToCompareExpression);
            newSimpleIn.setComparisonList(newExpressionList);
        }
        catch (CloneNotSupportedException e) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnableToCloneExpression.txt", new Object[0]), (Throwable)e);
        }
        return newSimpleIn;
    }

    private static SimpleConditionalExpression_Like _createSimpleConditionalExpressionLike(DataSelection selection, SimpleConditionalExpression_Like oldExpression) throws MetadataException {
        SimpleConditionalExpression_Like newSimpleLike = null;
        try {
            newSimpleLike = (SimpleConditionalExpression_Like)oldExpression.clone();
            ExpressionInterface newWhatToCompareExpression = DataSelectionUtilities._getEquivalentExpression(selection, oldExpression.getWhatToCompare());
            ExpressionInterface newPatternExpression = DataSelectionUtilities._getEquivalentExpression(selection, oldExpression.getPatternExpression());
            newSimpleLike.setWhatToCompare(newWhatToCompareExpression);
            newSimpleLike.setPatternExpression(newPatternExpression);
        }
        catch (CloneNotSupportedException e) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnableToCloneExpression.txt", new Object[0]), (Throwable)e);
        }
        return newSimpleLike;
    }

    private static SimpleConditionalExpression_Contains _createSimpleConditionalExpressionContains(DataSelection selection, SimpleConditionalExpression_Contains oldExpression) throws MetadataException {
        SimpleConditionalExpression_Contains newSimpleContains = null;
        try {
            newSimpleContains = (SimpleConditionalExpression_Contains)oldExpression.clone();
            ExpressionInterface newWhatToCompareExpression = DataSelectionUtilities._getEquivalentExpression(selection, oldExpression.getWhatToCompare());
            ExpressionInterface newWhatToContainExpression = DataSelectionUtilities._getEquivalentExpression(selection, oldExpression.getWhatToContain());
            newSimpleContains.setWhatToCompare(newWhatToCompareExpression);
            newSimpleContains.setWhatToContain(newWhatToContainExpression);
        }
        catch (CloneNotSupportedException e) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnableToCloneExpression.txt", new Object[0]), (Throwable)e);
        }
        return newSimpleContains;
    }

    private static SimpleConditionalExpression_Comparison _createSimpleConditionalExpressionComparison(DataSelection selection, SimpleConditionalExpression_Comparison oldExpression) throws MetadataException {
        SimpleConditionalExpression_Comparison newSimple = null;
        try {
            newSimple = (SimpleConditionalExpression_Comparison)oldExpression.clone();
            ExpressionInterface newLeftExpression = DataSelectionUtilities._getEquivalentExpression(selection, oldExpression.getLeftExpression());
            ExpressionInterface newRightExpression = DataSelectionUtilities._getEquivalentExpression(selection, oldExpression.getRightExpression());
            newSimple.setLeftExpression(newLeftExpression);
            newSimple.setRightExpression(newRightExpression);
        }
        catch (CloneNotSupportedException e) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnableToCloneExpression.txt", new Object[0]), (Throwable)e);
        }
        return newSimple;
    }

    private static SimpleConditionalExpression_Between _createSimpleConditionalExpressionBetween(DataSelection selection, SimpleConditionalExpression_Between oldExpression) throws MetadataException {
        SimpleConditionalExpression_Between newSimpleBetween = null;
        try {
            newSimpleBetween = (SimpleConditionalExpression_Between)oldExpression.clone();
            ExpressionInterface newWhatToCompareExpression = DataSelectionUtilities._getEquivalentExpression(selection, oldExpression.getWhatToCompare());
            ExpressionInterface newLeftExpression = DataSelectionUtilities._getEquivalentExpression(selection, oldExpression.getLeftExpression());
            ExpressionInterface newRightExpression = DataSelectionUtilities._getEquivalentExpression(selection, oldExpression.getRightExpression());
            newSimpleBetween.setWhatToCompare(newWhatToCompareExpression);
            newSimpleBetween.setLeftExpression(newLeftExpression);
            newSimpleBetween.setRightExpression(newRightExpression);
        }
        catch (CloneNotSupportedException e) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnableToCloneExpression.txt", new Object[0]), (Throwable)e);
        }
        return newSimpleBetween;
    }

    private static MultipleConditionalExpression _createMultipleConditionalExpression(DataSelection selection, MultipleConditionalExpression oldExpression) throws MetadataException {
        MultipleConditionalExpression newMultiCondExpr = null;
        try {
            newMultiCondExpr = (MultipleConditionalExpression)oldExpression.clone();
            List<ExpressionInterface> oldExpressions = newMultiCondExpr.getExpressionList();
            int i = 0;
            ListIterator<ExpressionInterface> iterator = oldExpressions.listIterator();
            while (iterator.hasNext()) {
                ExpressionInterface oldConditionalExpr = iterator.next();
                ExpressionInterface newExpression = null;
                newExpression = oldConditionalExpr instanceof MultipleConditionalExpression ? DataSelectionUtilities._createMultipleConditionalExpression(selection, (MultipleConditionalExpression)oldConditionalExpr) : DataSelectionUtilities._getEquivalentExpression(selection, oldConditionalExpr);
                newMultiCondExpr.setExpression(i, newExpression);
                ++i;
            }
        }
        catch (CloneNotSupportedException e) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnableToCloneExpression.txt", new Object[0]), (Throwable)e);
        }
        return newMultiCondExpr;
    }

    private static List _getEquivalentKeyColumns(DataSourceTable dataSource, List<? extends QualifiedColumn> keyColumns) throws MetadataException {
        ArrayList<Column> newKeyColumns = new ArrayList<Column>();
        block0: for (QualifiedColumn qualifiedColumn : keyColumns) {
            for (Column column : dataSource.getColumns()) {
                if (!column.getSasName().equalsIgnoreCase(qualifiedColumn.getSasName())) continue;
                newKeyColumns.add(column);
                continue block0;
            }
        }
        return newKeyColumns;
    }

    private static QualifiedColumn _getEquivalentKeyColumn(QualifiedColumn keyColumn, List<? extends QualifiedColumn> columns) throws MetadataException {
        QualifiedColumn returnColumn = null;
        String keyColumnName = keyColumn.getSasName().toUpperCase();
        for (QualifiedColumn qualifiedColumn : columns) {
            String columnName = qualifiedColumn.getSasName().toUpperCase();
            if (!keyColumnName.equalsIgnoreCase(columnName)) continue;
            returnColumn = qualifiedColumn;
            break;
        }
        return returnColumn;
    }

    private static DataItem _getEquivalentResultItem(DataSelection selection, DataItem diToSortBy) throws MetadataException {
        DataItem returnDataItem = null;
        for (DataItem resultItem : selection.getResultItems()) {
            if (!resultItem.getResultSetID().equalsIgnoreCase(DataSelectionUtilities._getColumnName(diToSortBy))) continue;
            returnDataItem = resultItem;
            break;
        }
        return returnDataItem;
    }

    protected static Join addNewJoin(DataSourceRelationalQuery dsrq, List keyColumns, DataSourceTable subjectTable, JoinType joinType) throws MetadataException {
        InformationMap informationMap = DataSelectionUtilities._getInformationMap(dsrq.getBusinessModel());
        List<Column> setColumns = dsrq.getColumns();
        Join join = informationMap.newJoin();
        join.setLabel("Join (Left)");
        join.setDescription("A left outer join between the holding/temp table and table for the sort var.");
        join.setRelationshipType(JoinRelationshipType.ALLOWED);
        join.setLeftDataSource(dsrq);
        join.setRightDataSource(subjectTable);
        JoinTypeList joinTypeList = new JoinTypeList();
        joinTypeList.addAll((Collection)JoinTypeList.ALL_JOIN_TYPES);
        if (!joinTypeList.contains(joinType)) {
            joinTypeList.add(joinType);
        }
        join.setAllowedTypes(joinTypeList);
        join.setType(joinType);
        CompoundConditionalExpression compoundExpression = new CompoundConditionalExpression();
        compoundExpression.setRelationType(ConditionalRelationType.AND);
        CompoundConditionalExpression previousCompoundExpression = null;
        join.setJoinCondition(compoundExpression);
        for (QualifiedColumn keyColumn : keyColumns) {
            QualifiedColumn setColumn = DataSelectionUtilities._getEquivalentKeyColumn(keyColumn, setColumns);
            if (setColumn == null) {
                int keyPosition = keyColumns.indexOf(keyColumn);
                setColumn = (QualifiedColumn)setColumns.get(keyPosition);
            }
            SimpleConditionalExpression_Comparison expression = new SimpleConditionalExpression_Comparison();
            expression.setLeftExpression(setColumn);
            expression.setComparisonOperator(ComparisonOperator.COMPARE_EQ);
            expression.setRightExpression(keyColumn);
            if (compoundExpression.getLeftExpression() == null) {
                compoundExpression.setLeftExpression(expression);
                continue;
            }
            CompoundConditionalExpression newCompoundExpression = new CompoundConditionalExpression();
            newCompoundExpression.setRelationType(ConditionalRelationType.AND);
            newCompoundExpression.setLeftExpression(expression);
            compoundExpression.setRightExpression(newCompoundExpression);
            previousCompoundExpression = compoundExpression;
            compoundExpression = newCompoundExpression;
        }
        if (previousCompoundExpression == null) {
            join.setJoinCondition((ConditionalExpression)compoundExpression.getLeftExpression());
        } else {
            previousCompoundExpression.setRightExpression(compoundExpression.getLeftExpression());
        }
        informationMap.addBusinessRule(join);
        return join;
    }

    private static String _getColumnName(DataItem dataItem) throws MetadataException {
        Column column;
        String colName = null;
        List<QualifiedColumn> cols = dataItem.getResources(QualifiedColumn.class, 65535);
        if (!dataItem.isCalculatedItem() && cols != null && (column = (Column)cols.get(0)) != null && column.getSasName() != null) {
            colName = column.getSasName().toUpperCase();
        }
        return colName;
    }

    private static InformationMap _getInformationMap(BusinessModelObject businessModelObject) {
        BusinessModel businessModel = businessModelObject.getBusinessModel();
        return DataSelectionUtilities._getInformationMap(businessModel);
    }

    private static InformationMap _getInformationMap(BusinessModel businessModel) {
        InformationMap informationMap = null;
        if (businessModel instanceof InformationMap) {
            informationMap = (InformationMap)businessModel;
        } else {
            BusinessModel parent = businessModel.getParentBusinessModel();
            while (parent != null) {
                if (parent instanceof InformationMap) {
                    informationMap = (InformationMap)parent;
                    parent = null;
                    continue;
                }
                parent = parent.getParentBusinessModel();
            }
        }
        return informationMap;
    }

    private static boolean _isItemInBusinessModelChain(DataSelection selection, BusinessModelObject businessModelObject) {
        boolean returnValue = false;
        BusinessModel itemBusinessModel = businessModelObject.getBusinessModel();
        for (BusinessModel selectionBusinessModel = selection.getBusinessModel(); selectionBusinessModel != null; selectionBusinessModel = selectionBusinessModel.getParentBusinessModel()) {
            if (selectionBusinessModel != itemBusinessModel) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    public static InMemoryColumn createColumn(DataItem item, Table table) throws MetadataException {
        String sasType = "N";
        int sqlType = 6;
        int dbmsLength = 8;
        int sasLength = 8;
        if (item.getExpressionType() == 3) {
            sqlType = 12;
            sasType = "C";
            List<QualifiedColumn> columns = item.getResources(QualifiedColumn.class, 65535);
            if (columns.size() > 0) {
                QualifiedColumn qualifiedColumn = columns.get(0);
                dbmsLength = qualifiedColumn.getDbmsLength();
                sasLength = qualifiedColumn.getSasLength();
            }
        } else if (item.getExpressionType() == 4) {
            sqlType = 91;
            sasType = "N";
        } else if (item.getExpressionType() == 2) {
            sqlType = 6;
            sasType = "N";
        } else if (item.getExpressionType() == 1) {
            sqlType = -2;
            sasType = "N";
        } else if (item.getExpressionType() == 9) {
            sqlType = 16;
            sasType = "N";
        } else if (item.getExpressionType() == 5) {
            sqlType = 92;
            sasType = "N";
        } else if (item.getExpressionType() == 6) {
            sqlType = 93;
            sasType = "N";
        }
        InMemoryColumn column = InMemoryFactory.getInstance().newColumn();
        column.setOwningTable(table);
        column.setLabel(item.getLabel());
        column.setDescription(item.getDescription());
        column.setDbmsName(null);
        column.setDbmsType(sqlType);
        column.setDbmsLength(dbmsLength);
        column.setSasName(item.getResultSetID());
        column.setSasType(sasType);
        column.setSasLength(sasLength);
        if (item.isFormattingForced()) {
            column.setSasFormat(null);
        } else {
            column.setSasFormat(item.getFormat());
        }
        return column;
    }

    public static DataSelection optimizeSetOperation(SetOperationDataSelection originalSelection) throws MetadataException {
        List<DataSelection> children = originalSelection.getDataSelections();
        Iterator<DataSelection> it = children.iterator();
        while (it.hasNext()) {
            DataSelection originalChildSelection;
            DataSelection childSelection = originalChildSelection = it.next();
            if (originalChildSelection instanceof SetOperationDataSelection) {
                childSelection = DataSelectionUtilities.optimizeSetOperation((SetOperationDataSelection)originalChildSelection);
            }
            if (childSelection == originalChildSelection) continue;
            int childIndex = children.indexOf(originalChildSelection);
            children.remove(originalChildSelection);
            children.add(childIndex, childSelection);
        }
        DataSelection selection = DataSelectionUtilities._combineChildren(originalSelection);
        return selection;
    }

    public static DataSelection createDataSourceRelationalQuery(DataSelection selection) throws MetadataException {
        IntelligentQueryMetadataServiceInterface iqService = selection.getMetadataService();
        Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale(selection);
        InformationMap newMap = iqService.newInformationMap(selection.getSession(), computationalLocale);
        DataSourceRelationalQuery dataSourceFromSelection = newMap.newDataSourceRelationalQuery(selection);
        newMap.addDataSource(dataSourceFromSelection);
        DataSelection dsSelection = DataSelectionFactory.newDataSelection(newMap);
        List<Column> columns = dataSourceFromSelection.getColumns();
        for (Column column : columns) {
            RootDataItem itemFromSelection = newMap.newDataItem();
            itemFromSelection.setExpression(column);
            String id = column.getSasName();
            String label = column.getLabel();
            itemFromSelection.setLabel(label);
            newMap.addBusinessItem(itemFromSelection);
            List<DataItem> resultItems = selection.getResultItems();
            for (DataItem item : resultItems) {
                String rsId = item.getResultSetID();
                if (!rsId.equalsIgnoreCase(id)) continue;
                DataItemReference businessItem = dsSelection.newDataItemReference(itemFromSelection);
                businessItem.setResultSetID(rsId);
                dsSelection.addBusinessItem(businessItem);
                dsSelection.addResultItem(businessItem, selection.getResultItemRole(item));
            }
        }
        return dsSelection;
    }

    public static DataSelection createDataSourceRelationalQuery(DataSelection selection, List createdObjects) throws MetadataException {
        InformationMap infoMap = DataSelectionUtilities._getInformationMap(selection);
        DataSourceRelationalQuery dataSourceFromSelection = infoMap.newDataSourceRelationalQuery(selection);
        createdObjects.add(dataSourceFromSelection);
        infoMap.addDataSource(dataSourceFromSelection);
        DataSelection dsSelection = DataSelectionFactory.newDataSelection(infoMap);
        createdObjects.add(dsSelection);
        boolean flag = selection.getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA);
        dsSelection.setQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA, flag);
        List<Column> columns = dataSourceFromSelection.getColumns();
        for (Column column : columns) {
            RootDataItem itemFromSelection = infoMap.newDataItem();
            createdObjects.add(itemFromSelection);
            itemFromSelection.setExpression(column);
            String id = column.getSasName();
            String label = column.getLabel();
            itemFromSelection.setLabel(label);
            infoMap.addBusinessItem(itemFromSelection);
            List<DataItem> resultItems = selection.getResultItems();
            for (DataItem item : resultItems) {
                String rsId = item.getResultSetID();
                if (!rsId.equalsIgnoreCase(id)) continue;
                DataItemReference businessItem = dsSelection.newDataItemReference(itemFromSelection);
                businessItem.setResultSetID(rsId);
                businessItem.setFormat(item.getFormat());
                dsSelection.addBusinessItem(businessItem);
                dsSelection.addResultItem(businessItem, selection.getResultItemRole(item));
            }
        }
        return dsSelection;
    }

    private static DataSelection _combineChildren(SetOperationDataSelection originalSelection) throws MetadataException {
        DataSelection selection = originalSelection;
        ListIterator<DataSelection> iterator = originalSelection.getDataSelections().listIterator();
        while (iterator.hasNext()) {
            DataSelection child = iterator.next();
            if (!(child instanceof CreateTableDataSelection)) continue;
            iterator.set(((CreateTableDataSelection)child).getDataSelection());
        }
        List<DataSelection> children = originalSelection.getDataSelections();
        for (int outerIndex = 0; outerIndex < children.size(); ++outerIndex) {
            DataSelection child = children.get(outerIndex);
            for (int innerIndex = children.size() - 1; innerIndex > outerIndex; --innerIndex) {
                DataSelection child2 = children.get(innerIndex);
                if (!DataSelectionUtilities._canCombine(child, child2, originalSelection)) continue;
                ConditionalRelationType type = ConditionalRelationType.OR;
                if (originalSelection.getSetOperation() == SetOperationType.INTERSECT) {
                    type = ConditionalRelationType.AND;
                }
                DataSelection combinedSelection = DataSelectionUtilities._combineFilters(type, child, child2);
                children.remove(child);
                children.remove(child2);
                children.add(outerIndex, combinedSelection);
                child = combinedSelection;
            }
        }
        if (children.size() == 1) {
            selection = children.get(0);
        } else {
            originalSelection.setDataSelections(children);
        }
        return selection;
    }

    private static boolean _canCombine(DataSelection child, DataSelection child2, SetOperationDataSelection parent) throws MetadataException {
        boolean returnValue = true;
        if (child instanceof SetOperationDataSelection || child2 instanceof SetOperationDataSelection) {
            returnValue = false;
        }
        if (!child.isActionSupported(BusinessQueryActionType.FILTER_ITEM) || !child2.isActionSupported(BusinessQueryActionType.FILTER_ITEM)) {
            returnValue = false;
        }
        if (parent.getSetOperation() != SetOperationType.UNION && parent.getSetOperation() != SetOperationType.INTERSECT) {
            returnValue = false;
        }
        if (!DataSelectionUtilities._areResultItemsComparable(child, child2)) {
            returnValue = false;
        }
        List dataSources1 = DataSelectionUtilities._extractUniqueDataSources(child);
        List dataSources2 = DataSelectionUtilities._extractUniqueDataSources(child2);
        if (!(parent.getSetOperation() != SetOperationType.UNION && parent.getSetOperation() != SetOperationType.INTERSECT || dataSources1.size() <= 1 && dataSources2.size() <= 1)) {
            returnValue = false;
        }
        if (parent.getSetOperation() == SetOperationType.UNION && DataSelectionUtilities._isAggregateUsed(child) && !DataSelectionUtilities._isAggregateUsed(child2) || !DataSelectionUtilities._isAggregateUsed(child) && DataSelectionUtilities._isAggregateUsed(child2)) {
            returnValue = false;
        }
        if ((DataSelectionUtilities._isAggregateUsed(child) || DataSelectionUtilities._isAggregateUsed(child2)) && !DataSelectionUtilities._areWhereFiltersCombarable(child, child2)) {
            returnValue = false;
        }
        if (!DataSelectionUtilities._areDataSourcesComparable(child, child2)) {
            returnValue = false;
        }
        if (child.getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA) != child2.getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA)) {
            returnValue = false;
        }
        if (child.getParentBusinessModel() != child2.getParentBusinessModel()) {
            returnValue = false;
        }
        return returnValue;
    }

    private static boolean _isAggregateUsed(DataSelection selection) {
        boolean returnValue = false;
        List<DataItem> items = selection.getObjects(false, DataItem.class);
        for (DataItem item : items) {
            if (item.getUsage() != DataItemActionType.USAGE_AGGREGATE) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    private static boolean _isAggregateUsed(FilterItem filter) {
        boolean returnValue = false;
        List<DataItem> items = filter.getResources(DataItem.class, 1);
        for (DataItem item : items) {
            if (item.getUsage() != DataItemActionType.USAGE_AGGREGATE) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    private static boolean _areDataSourcesComparable(DataSelection child, DataSelection child2) throws MetadataException {
        boolean returnValue = true;
        List dataSources1 = DataSelectionUtilities._extractUniqueDataSources(child);
        List dataSources2 = DataSelectionUtilities._extractUniqueDataSources(child2);
        for (DataSource dataSource : dataSources2) {
            if (!dataSources1.contains(dataSource)) {
                returnValue = false;
                break;
            }
            dataSources1.remove(dataSource);
        }
        if (!dataSources1.isEmpty()) {
            returnValue = false;
        }
        return returnValue;
    }

    private static List _extractUniqueDataSources(DataSelection selection) throws MetadataException {
        ArrayList<QualifiedColumn> columnList = new ArrayList<QualifiedColumn>();
        List<DataItem> dataItems = selection.getEffectiveResultItems();
        for (DataItem dataItem : dataItems) {
            List<QualifiedColumn> resources = dataItem.getResources(QualifiedColumn.class, 65535);
            columnList.addAll(resources);
        }
        List<FilterItem> filters = selection.getEffectiveFilters();
        for (FilterItem fi : filters) {
            ExpressionInterface expression = fi.getExpression();
            List<QualifiedColumn> resources = expression.getResources(QualifiedColumn.class, 65531);
            columnList.addAll(resources);
        }
        LinkedHashSet<DataSourceTable> linkedHashSet = new LinkedHashSet<DataSourceTable>();
        for (QualifiedColumn qc : columnList) {
            DataSourceTable dst = qc.getDataSource();
            linkedHashSet.add(dst);
        }
        return new ArrayList(linkedHashSet);
    }

    private static boolean _areResultItemsComparable(DataSelection child, DataSelection child2) throws MetadataException {
        boolean returnValue = true;
        List<DataItem> resultItems1 = child.getResultItems();
        List<DataItem> resultItems2 = child2.getResultItems();
        Iterator<DataItem> it1 = resultItems1.iterator();
        Iterator<DataItem> it2 = resultItems2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            DataItem item1 = it1.next();
            DataItem item2 = it2.next();
            String text1 = StringExpressionUtil.getInstance().getReadableText(item1.getExpression());
            String text2 = StringExpressionUtil.getInstance().getReadableText(item2.getExpression());
            if (item1.getExpressionType() == item2.getExpressionType() && item1.getUsage() == item2.getUsage() && item1.getAggregationType() == item2.getAggregationType() && item1.getExtendedType() == item2.getExtendedType() && IQModelImplUtilities.same(text1, text2) && IQModelImplUtilities.same(item1.getLabel(), item2.getLabel()) && IQModelImplUtilities.same(item1.getResultSetID(), item2.getResultSetID()) && IQModelImplUtilities.same(item1.getFormat(), item2.getFormat())) continue;
            returnValue = false;
            break;
        }
        if (it1.hasNext() != it2.hasNext()) {
            returnValue = false;
        }
        return returnValue;
    }

    private static boolean _areWhereFiltersCombarable(DataSelection child, DataSelection child2) throws MetadataException {
        FilterItem item;
        int index;
        boolean returnValue = true;
        List<FilterItem> filters1 = child.getFilters();
        List<FilterItem> filters2 = child2.getFilters();
        for (index = filters1.size() - 1; index >= 0; --index) {
            item = filters1.get(index);
            if (!DataSelectionUtilities._isAggregateUsed(item)) continue;
            filters1.remove(index);
        }
        for (index = filters2.size() - 1; index >= 0; --index) {
            item = filters2.get(index);
            if (!DataSelectionUtilities._isAggregateUsed(item)) continue;
            filters2.remove(index);
        }
        Iterator<FilterItem> it1 = filters1.iterator();
        Iterator<FilterItem> it2 = filters2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            String text2;
            FilterItem item1 = it1.next();
            FilterItem item2 = it2.next();
            String text1 = StringExpressionUtil.getInstance().getReadableText(item1.getExpression());
            if (IQModelImplUtilities.same(text1, text2 = StringExpressionUtil.getInstance().getReadableText(item2.getExpression()))) continue;
            returnValue = false;
            break;
        }
        if (it1.hasNext() != it2.hasNext()) {
            returnValue = false;
        }
        return returnValue;
    }

    private static DataSelection _combineFilters(ConditionalRelationType type, DataSelection child, DataSelection child2) throws MetadataException {
        DataSelection combinedSelection = child.copy();
        ArrayList<FilterItem> filters = new ArrayList<FilterItem>();
        if (type == ConditionalRelationType.AND) {
            filters.addAll(DataSelectionUtilities.copyFilter(combinedSelection, child.getFilters()));
            filters.addAll(DataSelectionUtilities.copyFilter(combinedSelection, child2.getFilters()));
        } else {
            CompoundFilter compoundFilter1 = null;
            if (child.getFilters().size() > 1) {
                compoundFilter1 = DataSelectionUtilities._convertListToCompoundFilter(combinedSelection, child.getFilters());
            }
            CompoundFilter compoundFilter2 = null;
            if (child2.getFilters().size() > 1) {
                compoundFilter2 = DataSelectionUtilities._convertListToCompoundFilter(combinedSelection, child2.getFilters());
            }
            CompoundFilter combinedORFilter = combinedSelection.newCompoundFilter();
            combinedORFilter.setRelationType(ConditionalRelationType.OR);
            if (compoundFilter1 != null && compoundFilter2 != null) {
                combinedORFilter.setLeftFilter(DataSelectionUtilities.copyFilter(combinedSelection, compoundFilter1));
                combinedORFilter.setRightFilter(DataSelectionUtilities.copyFilter(combinedSelection, compoundFilter2));
            } else if (compoundFilter1 != null) {
                combinedORFilter.setLeftFilter(DataSelectionUtilities.copyFilter(combinedSelection, compoundFilter1));
                if (child2.getFilters().size() > 0) {
                    combinedORFilter.setRightFilter(DataSelectionUtilities.copyFilter(combinedSelection, child2.getFilters().get(0)));
                }
            } else if (compoundFilter2 != null) {
                combinedORFilter.setLeftFilter(DataSelectionUtilities.copyFilter(combinedSelection, compoundFilter2));
                if (child.getFilters().size() > 0) {
                    combinedORFilter.setRightFilter(DataSelectionUtilities.copyFilter(combinedSelection, child.getFilters().get(0)));
                }
            } else if (child.getFilters().size() == 1 && child2.getFilters().size() == 1) {
                combinedORFilter.setLeftFilter(DataSelectionUtilities.copyFilter(combinedSelection, child.getFilters().get(0)));
                combinedORFilter.setRightFilter(DataSelectionUtilities.copyFilter(combinedSelection, child2.getFilters().get(0)));
            } else if (child.getFilters().size() == 1) {
                combinedSelection.addBusinessItem(DataSelectionUtilities.copyFilter(combinedSelection, child.getFilters().get(0)));
                filters.add(DataSelectionUtilities.copyFilter(combinedSelection, child.getFilters().get(0)));
            } else if (child2.getFilters().size() == 1) {
                combinedSelection.addBusinessItem(DataSelectionUtilities.copyFilter(combinedSelection, child2.getFilters().get(0)));
                filters.add(DataSelectionUtilities.copyFilter(combinedSelection, child2.getFilters().get(0)));
            }
            if (combinedORFilter.getLeftFilter() != null) {
                combinedSelection.addBusinessItem(combinedORFilter);
                filters.add(combinedORFilter);
            }
        }
        combinedSelection.setFilters(filters);
        return combinedSelection;
    }

    public static List copyFilter(DataSelection dataSelection, List oldFilters) throws MetadataException {
        ArrayList<FilterItem> returnList = new ArrayList<FilterItem>();
        Iterator it = oldFilters.iterator();
        while (it.hasNext()) {
            returnList.add(DataSelectionUtilities.copyFilter(dataSelection, (FilterItem)it.next()));
        }
        return returnList;
    }

    public static FilterItem copyFilter(DataSelection dataSelection, FilterItem oldFilter) throws MetadataException {
        FilterItem returnItem = null;
        if (oldFilter instanceof CompoundFilter) {
            returnItem = dataSelection.newCompoundFilter();
            returnItem.setLabel(oldFilter.getLabel());
            returnItem.setDescription(oldFilter.getDescription());
            returnItem.setExtendedAttributes(oldFilter.getExtendedAttributes());
            returnItem.setIsHidden(oldFilter.isHidden());
            ((CompoundFilter)returnItem).setLeftFilter(DataSelectionUtilities.copyFilter(dataSelection, ((CompoundFilter)oldFilter).getLeftFilter()));
            ((CompoundFilter)returnItem).setRightFilter(DataSelectionUtilities.copyFilter(dataSelection, ((CompoundFilter)oldFilter).getRightFilter()));
            ((CompoundFilter)returnItem).setIsNegated(((CompoundFilter)oldFilter).isNegated());
            ((CompoundFilter)returnItem).setRelationType(((CompoundFilter)oldFilter).getRelationType());
        } else if (oldFilter != null) {
            returnItem = dataSelection.newFilterItem();
            returnItem.setLabel(oldFilter.getLabel());
            returnItem.setDescription(oldFilter.getDescription());
            returnItem.setExtendedAttributes(oldFilter.getExtendedAttributes());
            returnItem.setIsHidden(oldFilter.isHidden());
            if (!(oldFilter.getExpression() instanceof BusinessModelResource)) {
                try {
                    ExpressionInterface oldExpr = (ExpressionInterface)oldFilter.getExpression().clone();
                    returnItem.setExpression(oldExpr);
                }
                catch (CloneNotSupportedException e) {
                    throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnableToCloneExpression.txt", new Object[0]), (Throwable)e);
                }
            } else {
                returnItem.setExpression(oldFilter.getExpression());
            }
        }
        if (returnItem != null) {
            dataSelection.addBusinessItem(returnItem);
        }
        return returnItem;
    }

    private static CompoundFilter _convertListToCompoundFilter(BusinessModel model, List originalFilters) throws MetadataException {
        CompoundFilter compoundFilter = model.newCompoundFilter();
        model.addBusinessItem(compoundFilter);
        ArrayList filters = new ArrayList(originalFilters);
        if (filters.size() >= 1) {
            compoundFilter.setLeftFilter((FilterItem)filters.get(0));
            filters.remove(0);
        }
        if (filters.size() > 0) {
            compoundFilter.setRelationType(ConditionalRelationType.AND);
            compoundFilter.setRightFilter(DataSelectionUtilities._convertListToCompoundFilter(model, filters));
        }
        return compoundFilter;
    }

    public static List getDataItemsForPhysicalTable(String tableName, String libraryName, List tableColumnNames, List keyDataItems, List createdObjects) throws MetadataException {
        return DataSelectionUtilities.getDataItemsForPhysicalTable(tableName, libraryName, tableColumnNames, keyDataItems, createdObjects, new ArrayList());
    }

    public static List getDataItemsForPhysicalTable(String tableName, String libraryName, List tableColumnNames, List keyDataItems, List createdObjects, List additionalColInfo) throws MetadataException {
        ArrayList<RootDataItem> returnItems = new ArrayList<RootDataItem>();
        ArrayList<String> keyColumnNames = new ArrayList<String>();
        DataItem keyItem = (DataItem)keyDataItems.get(0);
        DataSourceTable originalDataSource = DataSelectionUtilities.getDataSourceFromItem(keyItem);
        InMemorySASLibrary schema = InMemoryFactory.getInstance().newSASLibrary();
        schema.setIsPreassigned(true);
        schema.setLabel(libraryName);
        schema.setSASWorkspaceServer((SASWorkspaceServer)originalDataSource.getServer());
        InMemoryTable table = InMemoryFactory.getInstance().newTable();
        table.setLabel(tableName);
        table.setSchema(schema);
        table.setDataSetOptionsAsString("");
        ArrayList<Column> columns = new ArrayList<Column>();
        for (int index = 0; index < keyDataItems.size(); ++index) {
            String columnName;
            DataItem item = (DataItem)keyDataItems.get(index);
            QualifiedColumn itemQC = DataSelectionUtilities.getColumnFromItem(item);
            String sasColumnName = columnName = itemQC.getSasName();
            if (tableColumnNames != null) {
                columnName = (String)tableColumnNames.get(index);
            }
            Column column = DataSelectionUtilities.createColumnByName(item, table, columnName);
            columns.add(column);
            keyColumnNames.add(sasColumnName);
        }
        for (ColumnBasedDataItemRequest colDataItemReq : additionalColInfo) {
            Column column = DataSelectionUtilities.createColumnByInfo(table, colDataItemReq);
            columns.add(column);
        }
        table.setColumns(columns);
        ArrayList<InMemoryTable> tables = new ArrayList<InMemoryTable>();
        tables.add(table);
        schema.setTables(tables);
        AccessPathToRelationalData accessPath = new AccessPathToRelationalData();
        accessPath.setRelationalServer((RelationalServer)originalDataSource.getServer());
        accessPath.setRelationalSchema(schema);
        BusinessModel businessModel = keyItem.getBusinessModel();
        DataSourceTable newDataSource = businessModel.newDataSourceTable(accessPath, table);
        businessModel.addDataSource(newDataSource);
        createdObjects.add(newDataSource);
        Join newJoin = DataSelectionUtilities._addNewJoin(newDataSource, originalDataSource, keyColumnNames, tableColumnNames);
        createdObjects.add(newJoin);
        List<Column> qualifiedColumns = newDataSource.getColumns();
        for (Column column : qualifiedColumns) {
            RootDataItem item = businessModel.newDataItem();
            item.setExpression(column);
            item.setLabel(column.getLabel());
            item.setFormat(column.getSasFormat());
            businessModel.addBusinessItem(item);
            createdObjects.add(item);
            returnItems.add(item);
        }
        return returnItems;
    }

    public static String getTempLibname(DataSelection dataSelection) throws MetadataException {
        String tempLibname = "WORK";
        try {
            RelationalDataSelectionProcessor relDSprocessor = new RelationalDataSelectionProcessor(dataSelection);
            relDSprocessor.populate();
            tempLibname = relDSprocessor.getTempLibname();
        }
        catch (GenerationException g) {
            MetadataException me = new MetadataException(g);
            throw me;
        }
        return tempLibname;
    }

    private static Column createColumnByInfo(Table table, ColumnBasedDataItemRequest colDataItemReq) throws MetadataException {
        String sasName = colDataItemReq.getSasName();
        String sasType = "N";
        int sqlType = 6;
        int dbmsLength = 8;
        int sasLength = 8;
        int expressionType = colDataItemReq.getExpressionType();
        if (expressionType == 3) {
            sqlType = 12;
            sasType = "C";
            sasLength = colDataItemReq.getDbmsLength();
        } else if (expressionType == 4) {
            sqlType = 91;
            sasType = "N";
        } else if (expressionType == 2) {
            sqlType = 6;
            sasType = "N";
        } else if (expressionType == 1) {
            sqlType = -2;
            sasType = "N";
        } else if (expressionType == 9) {
            sqlType = 16;
            sasType = "N";
        } else if (expressionType == 5) {
            sqlType = 92;
            sasType = "N";
        } else if (expressionType == 6) {
            sqlType = 93;
            sasType = "N";
        }
        InMemoryColumn column = InMemoryFactory.getInstance().newColumn();
        column.setOwningTable(table);
        column.setLabel(colDataItemReq.getColumnLabel());
        column.setDescription(colDataItemReq.getColumnDesc());
        column.setDbmsName(null);
        column.setDbmsType(sqlType);
        column.setDbmsLength(dbmsLength);
        column.setSasName(sasName);
        column.setSasType(sasType);
        column.setSasLength(sasLength);
        if (colDataItemReq.isFormattingForced()) {
            column.setSasFormat(null);
        } else {
            column.setSasFormat(colDataItemReq.getSasFormat());
        }
        return column;
    }

    static DataSourceTable getDataSourceFromItem(DataItem item) throws MetadataException {
        DataSourceTable returnTable = null;
        DataItem baseItem = DataSelectionUtilities.getBaseItem(item);
        QualifiedColumn qc = DataSelectionUtilities.getColumnFromItem(baseItem);
        returnTable = qc.getDataSource();
        return returnTable;
    }

    static QualifiedColumn getColumnFromItem(DataItem item) throws MetadataException {
        ResourceAwareStringExpression rase;
        List<QualifiedColumn> resources;
        QualifiedColumn returnColumn = null;
        ExpressionInterface expr = item.getExpression();
        if (expr instanceof QualifiedColumn) {
            returnColumn = (QualifiedColumn)expr;
        } else if (expr instanceof ResourceAwareStringExpression && !item.isCalculatedItem() && (resources = (rase = (ResourceAwareStringExpression)expr).getResources(QualifiedColumn.class, 65535)).size() == 1) {
            returnColumn = resources.get(0);
        }
        if (returnColumn == null) {
            Object[] args = new Object[]{item.getLabel()};
            MessageFormatter formatter = IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesUnsupportedExpr.fmt.txt", args);
            throw new MetadataException(formatter);
        }
        return returnColumn;
    }

    static DataItem getBaseItem(DataItem item) {
        DataItem returnItem = item;
        while (returnItem instanceof DataItemReference) {
            returnItem = ((DataItemReference)returnItem).getBaseDataItem();
        }
        return returnItem;
    }

    public static Column createColumnByName(DataItem item, Table table, String columnName) throws MetadataException {
        String sasName = columnName;
        String sasType = "N";
        int sqlType = 6;
        int dbmsLength = 8;
        int sasLength = 8;
        if (item.getExpressionType() == 3) {
            sqlType = 12;
            sasType = "C";
            List<QualifiedColumn> columns = item.getResources(QualifiedColumn.class, 65535);
            if (columns.size() > 0) {
                QualifiedColumn qualifiedColumn = columns.get(0);
                sasLength = dbmsLength = qualifiedColumn.getDbmsLength();
            }
        } else if (item.getExpressionType() == 4) {
            sqlType = 91;
            sasType = "N";
        } else if (item.getExpressionType() == 2) {
            sqlType = 6;
            sasType = "N";
        } else if (item.getExpressionType() == 1) {
            sqlType = -2;
            sasType = "N";
        } else if (item.getExpressionType() == 9) {
            sqlType = 16;
            sasType = "N";
        } else if (item.getExpressionType() == 5) {
            sqlType = 92;
            sasType = "N";
        } else if (item.getExpressionType() == 6) {
            sqlType = 93;
            sasType = "N";
        }
        InMemoryColumn column = InMemoryFactory.getInstance().newColumn();
        column.setOwningTable(table);
        column.setLabel(item.getLabel());
        column.setDescription(item.getDescription());
        column.setDbmsName(null);
        column.setDbmsType(sqlType);
        column.setDbmsLength(dbmsLength);
        column.setSasName(sasName);
        column.setSasType(sasType);
        column.setSasLength(sasLength);
        if (item.isFormattingForced()) {
            column.setSasFormat(null);
        } else {
            column.setSasFormat(item.getFormat());
        }
        return column;
    }

    private static Join _addNewJoin(DataSourceTable leftDataSource, DataSourceTable rightDataSource, List<String> keyColumnNames, List<String> tableColumnNames) throws MetadataException {
        InformationMap informationMap = DataSelectionUtilities._getInformationMap(leftDataSource.getBusinessModel());
        if (tableColumnNames == null) {
            tableColumnNames = keyColumnNames;
        }
        Join join = informationMap.newJoin();
        join.setLabel("Join");
        join.setDescription("A join between a table and it's subject table.");
        join.setRelationshipType(JoinRelationshipType.ALLOWED);
        join.setLeftDataSource(leftDataSource);
        join.setRightDataSource(rightDataSource);
        join.setType(JoinType.INNER);
        JoinTypeList joinTypeList = new JoinTypeList();
        joinTypeList.addAll((Collection)JoinTypeList.ALL_JOIN_TYPES);
        if (!joinTypeList.contains(JoinType.INNER)) {
            joinTypeList.add(JoinType.INNER);
        }
        join.setAllowedTypes(joinTypeList);
        CompoundConditionalExpression compoundExpression = new CompoundConditionalExpression();
        compoundExpression.setRelationType(ConditionalRelationType.AND);
        CompoundConditionalExpression previousCompoundExpression = null;
        join.setJoinCondition(compoundExpression);
        List<QualifiedColumn> leftColumns = leftDataSource.getQualifiedColumns();
        List<QualifiedColumn> rightColumns = rightDataSource.getQualifiedColumns();
        for (int index = 0; index < keyColumnNames.size(); ++index) {
            String leftColumnName = tableColumnNames.get(index);
            String rightColumnName = keyColumnNames.get(index);
            QualifiedColumn leftColumn = DataSelectionUtilities._getColumnByName(leftColumns, leftColumnName);
            if (leftColumn == null) {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesNoLeftColumn.txt", new Object[0]));
            }
            QualifiedColumn rightColumn = DataSelectionUtilities._getColumnByName(rightColumns, rightColumnName);
            if (rightColumn == null) {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionUtilitiesNoRightColumn.txt", new Object[0]));
            }
            SimpleConditionalExpression_Comparison expression = new SimpleConditionalExpression_Comparison();
            expression.setLeftExpression(leftColumn);
            expression.setComparisonOperator(ComparisonOperator.COMPARE_EQ);
            expression.setRightExpression(rightColumn);
            if (compoundExpression.getLeftExpression() == null) {
                compoundExpression.setLeftExpression(expression);
                continue;
            }
            CompoundConditionalExpression newCompoundExpression = new CompoundConditionalExpression();
            newCompoundExpression.setRelationType(ConditionalRelationType.AND);
            newCompoundExpression.setLeftExpression(expression);
            compoundExpression.setRightExpression(newCompoundExpression);
            previousCompoundExpression = compoundExpression;
            compoundExpression = newCompoundExpression;
        }
        if (previousCompoundExpression == null) {
            join.setJoinCondition((ConditionalExpression)compoundExpression.getLeftExpression());
        } else {
            previousCompoundExpression.setRightExpression(compoundExpression.getLeftExpression());
        }
        informationMap.addBusinessRule(join);
        return join;
    }

    private static QualifiedColumn _getColumnByName(List<? extends QualifiedColumn> qualifiedColumns, String columnName) throws MetadataException {
        QualifiedColumn column = null;
        for (QualifiedColumn qualifiedColumn : qualifiedColumns) {
            if (!qualifiedColumn.getSasName().equalsIgnoreCase(columnName)) continue;
            column = qualifiedColumn;
            break;
        }
        return column;
    }

    public static void getGeneratedCode(SessionContextInterface session, DataSelection dataSelection, Locale overrideComputationalLocale, String inTableName, StringBuffer outCode, StringBuffer outLibName, StringBuffer outTableName) throws ExecutionException, GenerationException {
        Object stpNames = null;
        Object mlsLookups = null;
        DataSelectionUtilities.getGeneratedCode(session, dataSelection, overrideComputationalLocale, null, null, inTableName, outCode, outLibName, outTableName);
    }

    public static void getGeneratedCode(SessionContextInterface session, DataSelection dataSelection, Locale overrideComputationalLocale, StpNames stpNames, String inTableName, StringBuffer outCode, StringBuffer outLibName, StringBuffer outTableName) throws ExecutionException, GenerationException {
        Object mlsLookups = null;
        DataSelectionUtilities.getGeneratedCode(session, dataSelection, overrideComputationalLocale, stpNames, null, inTableName, outCode, outLibName, outTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getGeneratedCode(SessionContextInterface session, DataSelection dataSelection, Locale overrideComputationalLocale, StpNames stpNames, Map<String, MLSLookup> mlsLookups, String inTableName, StringBuffer outCode, StringBuffer outLibName, StringBuffer outTableName) throws ExecutionException, GenerationException {
        String tableName = inTableName;
        if (inTableName == null) {
            ConnectionRecycler recycler = ConnectionUtil.getConnectionRecycler(session);
            tableName = recycler.getNewTemporaryTableName();
        }
        boolean tableNeedsEscaping = GenerationUtil.tableNeedsEscaping(inTableName, 1);
        RetrievalPolicy retrievalPolicy = new RetrievalPolicy();
        try (QueryContainer queryContainer = new QueryContainer(retrievalPolicy);){
            queryContainer.setBusinessQuery(dataSelection);
            queryContainer.setComputationalLocale(overrideComputationalLocale);
            queryContainer.setStpNames(stpNames);
            if (mlsLookups != null && mlsLookups.size() == 0) {
                try {
                    mlsLookups = DataSelectionUtilities.buildMLSLookups(mlsLookups, dataSelection);
                }
                catch (MetadataException e) {
                    throw new GenerationException(e);
                }
            }
            queryContainer.setMLSLookups(mlsLookups);
            StrategySelector strategySelector = new StrategySelector();
            try {
                StrategyInterface strategy = strategySelector.getStrategy(queryContainer);
                if (strategy instanceof OverrideLocaleInterface) {
                    ((OverrideLocaleInterface)((Object)strategy)).setComputationalLocale(overrideComputationalLocale);
                }
                if (strategy instanceof OverrideStpNamesInterface) {
                    ((OverrideStpNamesInterface)((Object)strategy)).setStpNames(stpNames);
                }
                if (strategy instanceof OverrideMLSLookupsInterface) {
                    ((OverrideMLSLookupsInterface)((Object)strategy)).setMLSLookups(mlsLookups);
                }
                queryContainer.setStrategy(strategy);
            }
            catch (DataRetrievalException e) {
                throw new GenerationException(e);
            }
            StrategyInterface strategyInterface = queryContainer.getStrategy();
            ExecutionInstructionInterface instruction = null;
            if (strategyInterface instanceof InstructionInterface) {
                InstructionInterface ii = (InstructionInterface)((Object)strategyInterface);
                try {
                    instruction = ii.createInstructions(dataSelection, null);
                }
                catch (GenerationException e) {
                    throw e;
                }
                catch (ExecutionException e) {
                    throw e;
                }
                catch (IQueryServicesException e) {
                    throw new GenerationException(e);
                }
            }
            if (instruction != null) {
                instruction.setID(dataSelection.getID());
                ExecutionContext context = new ExecutionContext(retrievalPolicy);
                context.setTemporaryTableName(tableName);
                context.setComputationalLocale(overrideComputationalLocale);
                context.setStpNames(stpNames);
                context.setMLSLookups(mlsLookups);
                instruction.setExecutionContext(context);
                String libName = "WORK";
                String outputFileName = DataSelectionUtilities.getOutputFileName(instruction);
                if (outputFileName == null) {
                    outputFileName = "";
                } else {
                    int dotAt = outputFileName.indexOf(46);
                    if (dotAt != -1) {
                        libName = outputFileName.substring(0, dotAt);
                        outputFileName = outputFileName.substring(dotAt + 1);
                    }
                }
                String code = instruction.toString();
                outCode.append(code);
                outTableName.append(outputFileName);
                outLibName.append(libName);
            }
        }
    }

    private static String getOutputFileName(ExecutionInstructionInterface instruction) {
        String outputFileName = null;
        if (instruction instanceof SASSubmitInstruction) {
            SASSubmitInstruction sasSubmitInstruction = (SASSubmitInstruction)instruction;
            outputFileName = sasSubmitInstruction.getResultTableName();
        } else if (instruction instanceof ExecutionBlock) {
            ExecutionBlock block = (ExecutionBlock)instruction;
            int length = block.getInstructions().length;
            for (int i = 0; outputFileName == null && i < length; ++i) {
                ExecutionInstructionInterface subInstruction = block.getInstructions()[i];
                outputFileName = DataSelectionUtilities.getOutputFileName(subInstruction);
            }
        }
        return outputFileName;
    }

    public static DataSelection convertDataSelectionToDetail(DataSelection businessQuery, AbstractStrategy strategy) throws GenerationException, MetadataException {
        boolean createTable = false;
        CreateTableDataSelection createTableDataSelection = null;
        RelationalSchema createTableRelationalSchema = null;
        DataSelection baseDataSelection = businessQuery;
        DataSelection convertedDataSelection = null;
        if (!DataSelectionUtilities._allSelectedItemsAreNotDetail(businessQuery)) {
            return businessQuery;
        }
        DataSelectionFactory dsFactory = DataSelectionFactory.getInstance();
        if (businessQuery instanceof CreateTableDataSelection) {
            createTable = true;
            createTableRelationalSchema = ((CreateTableDataSelection)businessQuery).getRelationalSchemaForCreation();
            baseDataSelection = ((CreateTableDataSelection)businessQuery).getDataSelection();
        }
        DataSelection detailDataSelection = DataSelectionFactory.newDataSelection(baseDataSelection);
        strategy.addAuxDataSelection(detailDataSelection);
        ArrayList<SelectedItem> newSelectedItems = new ArrayList<SelectedItem>();
        DataSelectionUtilities._convertAllCategoriesAndMeasuresToDetail(baseDataSelection, detailDataSelection, newSelectedItems);
        if (createTable) {
            createTableDataSelection = DataSelectionFactory.getInstance().newCreateTableDataSelection(detailDataSelection);
            strategy.addAuxDataSelection(createTableDataSelection);
            createTableDataSelection.setRelationalSchemaForCreation(createTableRelationalSchema);
            createTableDataSelection.setID(((CreateTableDataSelection)businessQuery).getID());
            createTableDataSelection.setName(((CreateTableDataSelection)businessQuery).getName());
            convertedDataSelection = createTableDataSelection;
        } else {
            convertedDataSelection = detailDataSelection;
        }
        return convertedDataSelection;
    }

    private static boolean _allSelectedItemsAreNotDetail(DataSelection businessQuery) {
        List<SelectedItem> selectedItems = businessQuery.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            DataItem dataItem = selectedItem.getItem();
            if (dataItem.getUsage() == DataItemActionType.USAGE_DETAIL) continue;
            return true;
        }
        return false;
    }

    private static void _convertAllCategoriesAndMeasuresToDetail(DataSelection oldQuery, DataSelection newQuery, List<SelectedItem> newSelectedItems) throws MetadataException {
        List<SelectedItem> selectedItems = oldQuery.getSelectedItems();
        LinkedHashSet<QualifiedColumn> masterQCList = new LinkedHashSet<QualifiedColumn>();
        LinkedHashSet<DataItem> dataItemsWithoutQCs = new LinkedHashSet<DataItem>();
        for (SelectedItem selectedItem : selectedItems) {
            DataItem oldDataItem = selectedItem.getItem();
            List<QualifiedColumn> QCList = oldDataItem.getResources(QualifiedColumn.class, 65535);
            for (QualifiedColumn qualifiedColumn : QCList) {
                masterQCList.add(qualifiedColumn);
            }
            if (QCList.isEmpty()) {
                dataItemsWithoutQCs.add(oldDataItem);
            }
            QCList.clear();
        }
        HashSet uniqueNames = new HashSet();
        for (QualifiedColumn qualifiedColumn : masterQCList) {
            DataSelectionUtilities._generateNewDataItem(qualifiedColumn, newQuery, newSelectedItems, uniqueNames);
        }
        for (DataItem dataItemWithoutQC : dataItemsWithoutQCs) {
            DataSelectionUtilities._generateNewDataItem(dataItemWithoutQC, newQuery, newSelectedItems);
        }
    }

    private static void _generateNewDataItem(QualifiedColumn qualifiedColumn, DataSelection dataSelection, List<SelectedItem> selectedItems, HashSet uniqueNames) {
        DataItemReference dir = null;
        try {
            RootDataItem item = dataSelection.newDataItem();
            item.setExpression(qualifiedColumn);
            item.setLabel(qualifiedColumn.getLabel());
            item.setUsage(DataItemActionType.USAGE_DETAIL);
            dataSelection.addBusinessItem(item);
            dir = dataSelection.newDataItemReference(item);
            String sasName = qualifiedColumn.getSasName();
            int i = 1;
            String testName = sasName;
            while (uniqueNames.contains(testName)) {
                testName = sasName + "_" + ++i;
            }
            dir.setResultSetID(testName);
            uniqueNames.add(testName);
            dataSelection.addBusinessItem(dir);
            dataSelection.addResultItem(dir, Role.COLUMN);
            SelectedItem selectedItem = new SelectedItem(dir, Role.COLUMN);
            selectedItems.add(selectedItem);
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
    }

    private static void _generateNewDataItem(DataItem originalDataItem, DataSelection dataSelection, List<SelectedItem> selectedItems) {
        try {
            DataItemReference dir = dataSelection.newDataItemReference(originalDataItem);
            dir.setLabel(originalDataItem.getLabel());
            dir.setUsage(DataItemActionType.USAGE_DETAIL);
            dataSelection.addBusinessItem(dir);
            dataSelection.addResultItem(dir, Role.COLUMN);
            SelectedItem selectedItem = new SelectedItem(dir, Role.COLUMN);
            selectedItems.add(selectedItem);
        }
        catch (MetadataException e) {
            _logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public static List<Join> getAllEffectiveJoins(DataSelection ds) throws MetadataException, DataRetrievalException {
        List<AssociationRule> returnList = ds.getEffectiveRules(AssociationRule.class);
        if (!returnList.isEmpty()) {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("DataServices.GetAllJoinsWithMFT.Message.txt", new Object[0]));
        }
        List<DataSource> dataSourceList = ds.getEffectiveDataSources();
        List<Join> joinList = ds.getObjects(true, Join.class);
        ArrayList<Join> newJoinList = new ArrayList<Join>();
        ArrayList<Join> oneEDSJoinList = new ArrayList<Join>();
        ArrayList<Join> noEDSJoinList = new ArrayList<Join>();
        List<Object> alternateJoinList = new ArrayList();
        for (Join join : joinList) {
            boolean leftTable = false;
            boolean rightTable = false;
            leftTable = DataSelectionUtilities.findEffectiveDataSourceTable(join.getLeftDataSource(), dataSourceList);
            rightTable = DataSelectionUtilities.findEffectiveDataSourceTable(join.getRightDataSource(), dataSourceList);
            if (leftTable && rightTable) {
                newJoinList.add(join);
                continue;
            }
            if (leftTable || rightTable) {
                oneEDSJoinList.add(join);
                continue;
            }
            noEDSJoinList.add(join);
        }
        if (oneEDSJoinList.size() > 1) {
            alternateJoinList = DataSelectionUtilities.findPathsToEffectiveDataSources(oneEDSJoinList, noEDSJoinList, dataSourceList);
        }
        newJoinList.addAll(alternateJoinList);
        HashSet<Join> hs = new HashSet<Join>();
        hs.addAll(newJoinList);
        newJoinList.clear();
        newJoinList.addAll(hs);
        return newJoinList;
    }

    private static List<Join> findPathsToEffectiveDataSources(List<Join> oneEDSJoinList, List<Join> noEDSJoinList, List<DataSource> dataSourceList) {
        ArrayList<Join> alternateJoinList = new ArrayList<Join>();
        ArrayList<Join> activeJoinCache = new ArrayList<Join>();
        ArrayList<Join> oneEDSSearchList = new ArrayList<Join>();
        ArrayList<Join> noEDSSearchList = new ArrayList<Join>();
        block0: for (Join oneEDSJoin : oneEDSJoinList) {
            Join lastActiveJoin;
            boolean rightTable = false;
            DataSourceTable otherSideTable = null;
            DataSourceTable effectiveSideTable = null;
            int noEDSSearchListCount = 0;
            oneEDSSearchList.clear();
            oneEDSSearchList.addAll(oneEDSJoinList);
            oneEDSSearchList.remove(oneEDSJoin);
            noEDSSearchList.clear();
            noEDSSearchList.addAll(noEDSJoinList);
            activeJoinCache.clear();
            boolean leftTable = DataSelectionUtilities.findEffectiveDataSourceTable(oneEDSJoin.getLeftDataSource(), dataSourceList);
            rightTable = DataSelectionUtilities.findEffectiveDataSourceTable(oneEDSJoin.getRightDataSource(), dataSourceList);
            if (leftTable) {
                otherSideTable = oneEDSJoin.getRightDataSource();
                effectiveSideTable = oneEDSJoin.getLeftDataSource();
            } else if (rightTable) {
                otherSideTable = oneEDSJoin.getLeftDataSource();
                effectiveSideTable = oneEDSJoin.getRightDataSource();
            }
            DataSourceTable lastOtherSideTable = otherSideTable;
            Join connectingJoin = null;
            activeJoinCache.add(oneEDSJoin);
            Join activeJoin = lastActiveJoin = oneEDSJoin;
            boolean keepGoing = true;
            while (keepGoing) {
                connectingJoin = DataSelectionUtilities.findConnectingJoin(noEDSSearchList, otherSideTable);
                if (connectingJoin == null) {
                    if (activeJoin == oneEDSJoin || ++noEDSSearchListCount == noEDSSearchList.size()) continue block0;
                    activeJoinCache.remove(activeJoin);
                    activeJoin = lastActiveJoin;
                    otherSideTable = lastOtherSideTable;
                    continue;
                }
                lastOtherSideTable = otherSideTable;
                if (connectingJoin.getLeftDataSource() == otherSideTable) {
                    otherSideTable = connectingJoin.getRightDataSource();
                } else if (connectingJoin.getRightDataSource() == otherSideTable) {
                    otherSideTable = connectingJoin.getLeftDataSource();
                }
                activeJoinCache.add(connectingJoin);
                lastActiveJoin = activeJoin;
                activeJoin = connectingJoin;
                noEDSSearchList.remove(connectingJoin);
                for (Join currentOneEDSJoin : oneEDSSearchList) {
                    if (connectingJoin.getLeftDataSource() != currentOneEDSJoin.getLeftDataSource() && connectingJoin.getLeftDataSource() != currentOneEDSJoin.getRightDataSource() && connectingJoin.getRightDataSource() != currentOneEDSJoin.getLeftDataSource() && connectingJoin.getRightDataSource() != currentOneEDSJoin.getRightDataSource() || currentOneEDSJoin.getLeftDataSource() == effectiveSideTable || currentOneEDSJoin.getRightDataSource() == effectiveSideTable) continue;
                    alternateJoinList.addAll(activeJoinCache);
                    keepGoing = false;
                    break;
                }
                if (noEDSSearchList.isEmpty()) {
                    keepGoing = false;
                    continue;
                }
                noEDSSearchListCount = 0;
            }
        }
        DataSelectionUtilities.findAdjacentJoins(oneEDSJoinList, oneEDSSearchList, alternateJoinList, dataSourceList);
        return alternateJoinList;
    }

    private static void findAdjacentJoins(List<Join> oneEDSJoinList, List<Join> oneEDSSearchList, List<Join> alternateJoinList, List<DataSource> dataSourceList) {
        DataSourceTable otherSideTable = null;
        ArrayList<Join> connectingJoins = new ArrayList<Join>();
        for (Join oneEDSJoin : oneEDSJoinList) {
            oneEDSSearchList.clear();
            oneEDSSearchList.addAll(oneEDSJoinList);
            oneEDSSearchList.remove(oneEDSJoin);
            connectingJoins.clear();
            boolean leftTable = DataSelectionUtilities.findEffectiveDataSourceTable(oneEDSJoin.getLeftDataSource(), dataSourceList);
            boolean rightTable = DataSelectionUtilities.findEffectiveDataSourceTable(oneEDSJoin.getRightDataSource(), dataSourceList);
            if (leftTable) {
                otherSideTable = oneEDSJoin.getRightDataSource();
            } else if (rightTable) {
                otherSideTable = oneEDSJoin.getLeftDataSource();
            }
            DataSelectionUtilities.findConnectingJoins(oneEDSSearchList, otherSideTable, connectingJoins);
            if (!connectingJoins.isEmpty()) {
                connectingJoins.add(oneEDSJoin);
            }
            alternateJoinList.addAll(connectingJoins);
        }
    }

    private static void findConnectingJoins(List<Join> searchList, DataSource searchTable, List<Join> connectingJoins) {
        for (Join join : searchList) {
            if (searchTable != join.getLeftDataSource() && searchTable != join.getRightDataSource()) continue;
            connectingJoins.add(join);
        }
    }

    private static Join findConnectingJoin(List<Join> searchList, DataSource searchTable) {
        Join connectingJoin = null;
        for (Join join : searchList) {
            if (searchTable != join.getLeftDataSource() && searchTable != join.getRightDataSource()) continue;
            connectingJoin = join;
            break;
        }
        return connectingJoin;
    }

    private static boolean findEffectiveDataSourceTable(DataSourceTable dataSourceTable, List<DataSource> dataSourceList) {
        for (DataSource dataSourceCompare : dataSourceList) {
            if (dataSourceCompare != dataSourceTable) continue;
            return true;
        }
        return false;
    }

    public static Map<String, MLSLookup> buildMLSLookups(Map<String, MLSLookup> mlsLookups, BusinessQuery query) throws MetadataException {
        LinkedHashMap<String, MLSLookup> lookupsCache = new LinkedHashMap<String, MLSLookup>();
        LinkedHashMap<String, QualifiedColumn> qcsByColumnAlias = new LinkedHashMap<String, QualifiedColumn>();
        List<SelectedItem> selectedItems = query.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            DataItem dataItem = selectedItem.getItem();
            if (dataItem == null || dataItem.getUsage().equals(DataItemActionType.USAGE_AGGREGATE)) continue;
            ExpressionInterface expression = dataItem.getExpression();
            String columnAlias = dataItem.getResultSetID();
            if (!(expression instanceof QualifiedColumn)) continue;
            QualifiedColumn qc = (QualifiedColumn)expression;
            qcsByColumnAlias.put(columnAlias, qc);
        }
        if (qcsByColumnAlias.size() > 0) {
            DataLocalizationModel model = new DataLocalizationModel();
            for (Map.Entry entry : qcsByColumnAlias.entrySet()) {
                String columnAlias = (String)entry.getKey();
                QualifiedColumn qc = (QualifiedColumn)entry.getValue();
                MLSLookup mlsLookup = null;
                Column column = qc.getColumn();
                if (column instanceof OMAWrapper) {
                    mlsLookup = OMAResourceFactory.buildMLSLookup(mlsLookups, lookupsCache, model, columnAlias, column);
                }
                if (mlsLookup == null) continue;
                mlsLookups.put(columnAlias, mlsLookup);
            }
        }
        return mlsLookups;
    }
}

