/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSourceRelationalQuery;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.SetOperationDataSelection;
import com.sas.iquery.metadata.business.impl.CompoundFilterImpl;
import com.sas.iquery.metadata.business.impl.EffectiveObjectsCache;
import com.sas.iquery.metadata.business.impl.FilterItemImpl;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.physical.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

@SASScope
public class DataSelectionOrganizer {
    private static final int SUBQUERYTYPE_DSRQ = 1;
    private static final int SUBQUERYTYPE_FILTERING = 2;
    private static final int SUBQUERYTYPE_SETOPCHILD = 4;
    private EffectiveObjectsCache _effectiveObjectsCache = null;

    public static DataSelectionOrganizer getInstance() {
        return new DataSelectionOrganizer();
    }

    public static DataSelectionOrganizer getInstance(EffectiveObjectsCache effectiveObjectsCache) {
        return new DataSelectionOrganizer(effectiveObjectsCache);
    }

    DataSelectionOrganizer() {
    }

    DataSelectionOrganizer(EffectiveObjectsCache effectiveObjectsCache) {
        this._effectiveObjectsCache = effectiveObjectsCache;
    }

    private List<FilterItem> getEffectiveFilters(BusinessQuery businessQuery) {
        List<FilterItem> filters = null;
        filters = this._effectiveObjectsCache == null ? businessQuery.getEffectiveFilters() : this._effectiveObjectsCache.getEffectiveFilters(businessQuery);
        return filters;
    }

    public static Collection<DataSelection> getDSRQSubqueries(BusinessQuery businessQuery) throws MetadataException {
        return DataSelectionOrganizer.getInstance()._getDSRQSubqueries(businessQuery);
    }

    public Collection _getDSRQSubqueries(BusinessQuery businessQuery) throws MetadataException {
        LinkedHashSet out = new LinkedHashSet();
        this.accumulateSubqueries(businessQuery, out, 1);
        return out;
    }

    public Collection getDataSourceRelationalQueries(BusinessQuery businessQuery) throws MetadataException {
        LinkedHashSet<DataSourceRelationalQuery> dsList = new LinkedHashSet<DataSourceRelationalQuery>();
        Collection rsList = this.getQueryDataSources(businessQuery, 1);
        for (DataSourceRelationalQuery dsQuery : rsList) {
            dsList.addAll(this.getDataSourceRelationalQueries(dsQuery.getBusinessQuery()));
            dsList.add(dsQuery);
        }
        return dsList;
    }

    public Collection getQueryDataSources(BusinessQuery businessQuery) throws MetadataException {
        int type = 7;
        return this.getQueryDataSources(businessQuery, type);
    }

    public Collection getQueryDataSources(BusinessQuery businessQuery, int type) throws MetadataException {
        LinkedHashSet<BusinessModelResourceReferencer> dsList = new LinkedHashSet<BusinessModelResourceReferencer>();
        if (businessQuery instanceof SetOperationDataSelection) {
            List<DataSelection> inputDataSelectionList = ((SetOperationDataSelection)businessQuery).getDataSelections();
            for (DataSelection childDataSelection : inputDataSelectionList) {
                if ((type & 4) != 0) {
                    dsList.add(childDataSelection);
                }
                dsList.addAll(this.getQueryDataSources(childDataSelection, type));
            }
        }
        List<DataItem> dataItems = businessQuery.getResultItems();
        LinkedHashSet<QualifiedColumn> resources = new LinkedHashSet<QualifiedColumn>();
        for (int index = 0; index < dataItems.size(); ++index) {
            List<QualifiedColumn> itemResources = dataItems.get(index).getResources(QualifiedColumn.class, 65535);
            resources.addAll(itemResources);
        }
        List<FilterItem> filters = this.getEffectiveFilters(businessQuery);
        if (filters != null) {
            for (FilterItem filter : filters) {
                ExpressionInterface expression;
                if (filter == null || (expression = filter.getExpression()) == null) continue;
                List<QualifiedColumn> filterResources = expression.getResources(QualifiedColumn.class, 65531);
                resources.addAll(filterResources);
            }
        }
        if ((type & 1) != 0) {
            for (QualifiedColumn column : resources) {
                Table table = column.getOwningTable();
                if (!(table instanceof DataSourceRelationalQuery)) continue;
                DataSourceRelationalQuery dsQuery = (DataSourceRelationalQuery)table;
                dsList.add(dsQuery);
                dsList.addAll(this.getQueryDataSources(dsQuery.getBusinessQuery(), type));
            }
        }
        return dsList;
    }

    public Collection getQueries(BusinessQuery query) throws MetadataException {
        LinkedHashSet<BusinessQuery> out = new LinkedHashSet<BusinessQuery>();
        int type = 7;
        Collection immediateSetOpSubqueries = this.getImmediateSetOpSubqueries(query);
        for (BusinessQuery setOpChildQuery : immediateSetOpSubqueries) {
            if ((type & 4) == 0) continue;
            out.add(setOpChildQuery);
        }
        Collection immediateDSRQSubqueries = this.getImmediateDSRQSubqueries(query);
        for (BusinessQuery dsrQuery : immediateDSRQSubqueries) {
            if ((type & 1) == 0) continue;
            out.add(dsrQuery);
        }
        Collection immediateFilteringSubqueries = this.getImmediateFilteringSubqueries(query);
        for (BusinessQuery subQuery : immediateFilteringSubqueries) {
            if ((type & 2) == 0) continue;
            out.add(subQuery);
        }
        return out;
    }

    public static List<DataSelection> getAllSubqueries(BusinessQuery query) throws MetadataException {
        return DataSelectionOrganizer.getInstance()._getAllSubqueries(query);
    }

    public List<DataSelection> _getAllSubqueries(BusinessQuery query) throws MetadataException {
        LinkedHashSet out = new LinkedHashSet();
        this.accumulateSubqueries(query, out, 7);
        return new ArrayList<DataSelection>(out);
    }

    private void accumulateSubqueries(BusinessQuery businessQuery, Collection accumulator, int type) throws MetadataException {
        Collection immediateSetOpSubqueries = this.getImmediateSetOpSubqueries(businessQuery);
        for (BusinessQuery query : immediateSetOpSubqueries) {
            this.accumulateSubqueries(query, accumulator, type);
            if ((type & 4) == 0) continue;
            accumulator.add(query);
        }
        Collection immediateDSRQSubqueries = this.getImmediateDSRQSubqueries(businessQuery);
        for (BusinessQuery query : immediateDSRQSubqueries) {
            this.accumulateSubqueries(query, accumulator, type);
            if ((type & 1) == 0) continue;
            accumulator.add(query);
        }
        Collection immediateFilteringSubqueries = this.getImmediateFilteringSubqueries(businessQuery);
        for (BusinessQuery query : immediateFilteringSubqueries) {
            this.accumulateSubqueries(query, accumulator, type);
            if ((type & 2) == 0) continue;
            accumulator.add(query);
        }
    }

    private Collection getImmediateSetOpSubqueries(BusinessQuery query) throws MetadataException {
        Collection c = this.getQueryDataSources(query, 4);
        LinkedHashSet out = new LinkedHashSet();
        out.addAll(c);
        return out;
    }

    private Collection getImmediateDSRQSubqueries(BusinessQuery query) throws MetadataException {
        Collection c = this.getQueryDataSources(query, 1);
        LinkedHashSet<BusinessQuery> out = new LinkedHashSet<BusinessQuery>();
        for (DataSourceRelationalQuery dsrq : c) {
            BusinessQuery bq = dsrq.getBusinessQuery();
            out.add(bq);
        }
        return out;
    }

    private Collection getImmediateFilteringSubqueries(BusinessQuery query) throws MetadataException {
        LinkedHashSet out = new LinkedHashSet();
        List<FilterItem> filters = this.getEffectiveFilters(query);
        for (FilterItem filter : filters) {
            List oneFilterSubqueries = null;
            if (filter instanceof FilterItemImpl) {
                oneFilterSubqueries = ((FilterItemImpl)filter).getImmediateSubqueries();
            } else if (filter instanceof CompoundFilterImpl) {
                oneFilterSubqueries = ((CompoundFilterImpl)filter).getImmediateSubqueries();
            }
            if (oneFilterSubqueries == null) continue;
            out.addAll(oneFilterSubqueries);
        }
        return out;
    }
}

