/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util;

import com.sas.iquery.util.RetryUtil;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;

public class AssociationListUtil {
    public static List<Object> get(final AssociationList acList) {
        Object[] array;
        RetryUtil.Actor<Object[]> actor = new RetryUtil.Actor<Object[]>(){

            @Override
            public Object[] action() throws RetryUtil.RedoAction {
                try {
                    return acList.toArray();
                }
                catch (ConcurrentModificationException e) {
                    throw new RetryUtil.RedoAction(e);
                }
            }
        };
        try {
            array = RetryUtil.tryAction(actor);
        }
        catch (RetryUtil.ActionFailed e) {
            throw new IllegalStateException(e.getCause());
        }
        ArrayList<Object> acListSnapshot = new ArrayList<Object>(array.length);
        for (Object o : array) {
            acListSnapshot.add(o);
        }
        return acListSnapshot;
    }

    public static <T> List<T> filteredSnapshot(final AssociationList acList, Class<T> type) {
        Object[] array;
        RetryUtil.Actor<Object[]> actor = new RetryUtil.Actor<Object[]>(){

            @Override
            public Object[] action() throws RetryUtil.RedoAction {
                try {
                    return acList.toArray();
                }
                catch (ConcurrentModificationException e) {
                    throw new RetryUtil.RedoAction(e);
                }
            }
        };
        try {
            array = RetryUtil.tryAction(actor);
        }
        catch (RetryUtil.ActionFailed e) {
            throw new IllegalStateException(e.getCause());
        }
        ArrayList<T> acListSnapshot = new ArrayList<T>(array.length);
        for (Object o : array) {
            if (o == null || !type.isAssignableFrom(o.getClass())) continue;
            T obj = type.cast(o);
            acListSnapshot.add(obj);
        }
        return acListSnapshot;
    }

    public static void set(AssociationList asList, List<?> sources) throws RemoteException, MdException {
        asList.clear();
        asList.addAll(sources);
        if (asList.getParent() != null) {
            asList.getParent().updateMetadataAll();
        }
    }

    public static AssociationList copy(CMetadata newParent, AssociationList oldAsList) throws RemoteException, MdException {
        List<Object> objects = AssociationListUtil.filteredSnapshot(oldAsList, Object.class);
        AssociationList newList = new AssociationList(oldAsList.getAssociationType(), oldAsList.getAssociationName(), oldAsList.getIsPredAssoc(), oldAsList.getProperties(), newParent);
        newList.addAll(objects);
        if (newList.getParent() != null) {
            newList.getParent().updateMetadataAll();
        }
        return newList;
    }

    public static void setStateUnchanged(AssociationList asList) throws RemoteException, MdException {
        if (asList.getState() == 1) {
            asList.setState(0);
            if (asList.getParent() != null) {
                asList.getParent().updateMetadataAll();
            }
        }
    }

    public static boolean add(AssociationList asList, Object object) throws RemoteException, MdException {
        boolean added = asList.add(object);
        if (added && asList.getParent() != null) {
            asList.getParent().updateMetadataAll();
        }
        return added;
    }

    public static boolean remove(AssociationList asList, Object object) throws RemoteException, MdException {
        boolean deleted = asList.remove(object);
        if (deleted && asList.getParent() != null) {
            asList.getParent().updateMetadataAll();
        }
        return deleted;
    }

    public static void clear(AssociationList asList) throws RemoteException, MdException {
        asList.clear();
        if (asList.getParent() != null) {
            asList.getParent().updateMetadataAll();
        }
    }

    public static List getCopyIfASL(List mayBeAssociationList) {
        List<Object> inputList = mayBeAssociationList instanceof AssociationList ? AssociationListUtil.filteredSnapshot((AssociationList)mayBeAssociationList, Object.class) : mayBeAssociationList;
        return inputList;
    }
}

