/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml.olap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.strategies.sas.report.xml.olap.AbstractDataElement;
import com.sas.iquery.strategies.sas.report.xml.olap.Value;
import com.sas.iquery.strategies.sas.report.xml.olap.Values;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ValuesList
extends AbstractDataElement {
    public static final String NODE_NAME = "ValuesList";
    public List<String> _cellValues = null;
    private static final Logger _logger = LogManager.getLogger(ValuesList.class);

    public String[] getFormattedCells() {
        return this._cellValues.toArray(new String[0]);
    }

    @Override
    public void read(Node domNode) throws ExecutionException {
        this._cellValues = new ArrayList<String>();
        List<Values> valuesList = AbstractDataElement.readSubElements((Element)domNode, "Values", Values.class);
        int columnValueCount = 0;
        if (valuesList.size() > 0) {
            columnValueCount = valuesList.get(0).getValues().size();
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("ColumnValueCount : " + columnValueCount);
        }
        Iterator<Values> iterator = valuesList.iterator();
        while (iterator.hasNext()) {
            Values element;
            Values values = element = iterator.next();
            List<Value> valueList = values.getValues();
            for (int i = 0; i < columnValueCount; ++i) {
                if (valueList.size() < i) continue;
                Value value = valueList.get(i);
                this._cellValues.add(value.getValue());
            }
        }
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        String[] values = this.getFormattedCells();
        output.append("Total Number of Values : ");
        output.append(values.length);
        output.append("\n");
        for (String value : values) {
            output.append(value);
            output.append("\n");
        }
        return output.toString();
    }

    @Override
    public void write(Element element) throws ExecutionException {
        try {
            Document doc = element.getOwnerDocument();
            ResultSetMetadataInterface rsmd = this._olapDataSetInterface.getResultSetMetadata();
            AxisInterface[] axes = rsmd.getAxes(0, -1);
            AxisInterface colAxis = axes[0];
            AxisInterface rowAxis = axes[1];
            int columnCount = colAxis.getTupleCount();
            int rowCount = rowAxis.getTupleCount();
            element.setAttribute("valuesCount", Integer.toString(rowCount));
            int cellPosition = 0;
            for (int row = 0; row < rowCount; ++row) {
                Element valuesElm = doc.createElement("Values");
                element.appendChild(valuesElm);
                String[] rowCells = this._olapDataSetInterface.getFormattedCells((long)cellPosition, (long)(cellPosition + columnCount - 1));
                for (int col = 0; col < columnCount; ++col) {
                    Element valueElm = doc.createElement("Value");
                    valuesElm.appendChild(valueElm);
                    Text formattedValueText = doc.createTextNode(rowCells[col]);
                    valueElm.appendChild(formattedValueText);
                }
                cellPosition += columnCount;
            }
        }
        catch (OLAPException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("ValuesList.write.OLAPException.txt"), (Throwable)e);
            }
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("ValuesList.write.OLAPException.txt", new Object[0]), (Throwable)e);
        }
    }
}

