/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml.olap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.strategies.sas.report.xml.olap.AbstractDataElement;
import com.sas.iquery.strategies.sas.report.xml.olap.Member;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Tuple
extends AbstractDataElement {
    public static final String NODE_NAME = "Tuple";
    private List<List<Member>> _dimensionList = new ArrayList<List<Member>>();
    private HashMap<String, Integer> _dimensionMap = new HashMap();
    private List<Member> _members;
    private static final Logger _logger = LogManager.getLogger(Tuple.class);

    public List<Member> getDimensionMembers(int dimensionIndex) {
        return this._dimensionList.get(dimensionIndex);
    }

    public List<List<Member>> getDimensions() {
        return this._dimensionList;
    }

    @Override
    public void read(Node domNode) throws ExecutionException {
        this._members = AbstractDataElement.readSubElements((Element)domNode, "Member", Member.class);
        for (Member member : this._members) {
            Integer listIndex = this._dimensionMap.get(member.getDimension());
            List<Object> members = null;
            if (listIndex == null) {
                members = new ArrayList();
                this._dimensionList.add(members);
                listIndex = this._dimensionList.size() - 1;
                this._dimensionMap.put(member.getDimension(), listIndex);
            }
            members = this._dimensionList.get(listIndex);
            members.add(member);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Tuple:\n");
        List<List<Member>> dimensionList = this.getDimensions();
        buffer.append("Dimensions = ");
        buffer.append(dimensionList.size());
        buffer.append("\n");
        for (List<Member> memberList : dimensionList) {
            buffer.append("Members = ");
            buffer.append(memberList.size());
            buffer.append("\n");
            for (Member member : memberList) {
                buffer.append(member.toString());
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    @Override
    public void write(Element element) throws ExecutionException {
        try {
            TupleElementInterface[] tupleElements;
            TupleInterface tuple = (TupleInterface)this._callingElement;
            for (TupleElementInterface tupleElement : tupleElements = tuple.getElements(0, -1)) {
                AbstractDataElement.writeSubElement(element, "Member", Member.class, tupleElement, this._olapDataSetInterface, this._usedDimensionsSet, this._usedLevelsSet, this._usedMembersSet, this._measureDocElements, this._membersMap, this._levelsMap);
            }
        }
        catch (OLAPException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("Tuple.write.OLAPException.txt"), (Throwable)e);
            }
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("Tuple.write.OLAPException.txt", new Object[0]), (Throwable)e);
        }
    }

    public List<Member> getMembers() {
        return this._members;
    }
}

