/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml.olap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.strategies.sas.report.xml.olap.AbstractDataElement;
import com.sas.iquery.strategies.sas.report.xml.olap.LevelMembersList;
import com.sas.iquery.strategies.sas.report.xml.olap.Member;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.OLAPException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Members
extends AbstractDataElement {
    public static final String NODE_NAME = "Members";
    private List<Member> _memberList = null;
    private final HashMap<String, Member> _memberMap = new HashMap();
    private static final Logger _logger = LogManager.getLogger(Members.class);

    public List<Member> getMembers() {
        return this._memberList;
    }

    public void setMembers(List<Member> members) {
        this._memberList = members;
    }

    public Map<String, Member> retrieveMemberMap() {
        this._memberMap.clear();
        List<Member> membersList = this.getMembers();
        for (Member member : membersList) {
            String memberName = member.getName();
            this._memberMap.put(memberName, member);
        }
        return this._memberMap;
    }

    @Override
    public void read(Node domNode) throws ExecutionException {
        this.setMembers(AbstractDataElement.readSubElements((Element)domNode, "Member", Member.class));
    }

    @Override
    public void write(Element element) throws ExecutionException {
        try {
            HierarchyInterface hierarchy = (HierarchyInterface)this._callingElement;
            LevelInterface[] levels = hierarchy.getLevels();
            if (hierarchy.getName().equals("Measures")) {
                for (Element measureDocElement : this._measureDocElements) {
                    measureDocElement.setAttribute("level", "MeasuresLevel");
                    element.appendChild(measureDocElement);
                }
            } else {
                for (int levelsArrayElement = 0; levelsArrayElement < levels.length; ++levelsArrayElement) {
                    LevelInterface level = levels[levelsArrayElement];
                    String levelUniqueName = level.getUniqueName();
                    if (!this._levelsMap.containsKey(levelUniqueName)) continue;
                    LevelMembersList membersList = (LevelMembersList)this._levelsMap.get(levelUniqueName);
                    for (Element memberElement : membersList) {
                        Element clonedMember = (Element)memberElement.cloneNode(false);
                        clonedMember.setAttribute("level", level.getName());
                        element.appendChild(clonedMember);
                    }
                }
            }
        }
        catch (OLAPException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("Members.write.OLAPException.txt"), (Throwable)e);
            }
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("Members.write.OLAPException.txt", new Object[0]), (Throwable)e);
        }
    }
}

