/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml.olap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.strategies.sas.report.xml.olap.AbstractDataElement;
import com.sas.iquery.strategies.sas.report.xml.olap.Level;
import com.sas.iquery.strategies.sas.report.xml.olap.Levels;
import com.sas.iquery.strategies.sas.report.xml.olap.Member;
import com.sas.iquery.strategies.sas.report.xml.olap.Members;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.OLAPException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Hierarchy
extends AbstractDataElement {
    public static final String NODE_NAME = "Hierarchy";
    private String _name = null;
    private String _label = null;
    private List<Level> _levelList = null;
    private final HashMap<String, Level> _levelNameMap = new HashMap();
    private final HashMap<Integer, String> _levelDepthMap = new HashMap();
    private List<Member> _memberList = null;
    private final Map<String, HashMap<String, Member>> _memberMap = new HashMap<String, HashMap<String, Member>>();
    private static final Logger _logger = LogManager.getLogger(Hierarchy.class);

    public String toString() {
        StringBuffer buffer = new StringBuffer(NODE_NAME);
        buffer.append(":");
        buffer.append(" name=");
        buffer.append(this.getName());
        buffer.append(", label=");
        buffer.append(this.getLabel());
        buffer.append("\n\tlevelList=");
        buffer.append(this._levelList);
        buffer.append("\n\tlevelNameMap=");
        buffer.append(this._levelNameMap);
        buffer.append("\n\tlevelDepthMap=");
        buffer.append(this._levelDepthMap);
        buffer.append("\n\tmemberList=");
        buffer.append(this._memberList);
        buffer.append("\n\tmemberMap=");
        buffer.append(this._memberMap);
        return buffer.toString();
    }

    public List<Level> getLevels() {
        return this._levelList;
    }

    public List<Member> getMembers() {
        return this._memberList;
    }

    public String getLabel() {
        return this._label;
    }

    public String getName() {
        return this._name;
    }

    public void setLevels(List<Level> levels) {
        this._levelList = levels;
    }

    public void setMembers(List<Member> members) {
        this._memberList = members;
    }

    public Member retrieveMember(String memberName) {
        List<Member> memberList = this.getMembers();
        Member foundMember = null;
        for (Member member : memberList) {
            if (!member.getName().equals(memberName)) continue;
            foundMember = member;
            break;
        }
        return foundMember;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Member getMember(String level, String name) {
        return this._memberMap.get(level).get(name);
    }

    public Member getMember(int depth, String name) {
        return this._memberMap.get(this._levelDepthMap.get(depth)).get(name);
    }

    public Level getLevel(String name) {
        return this._levelNameMap.get(name);
    }

    public Level getLevel(int depth) {
        return this.getLevel(this._levelDepthMap.get(depth));
    }

    @Override
    public void read(Node domNode) throws ExecutionException {
        Map<String, String> attributeMap = AbstractDataElement.readNodeAttributes(domNode);
        this.setLabel(attributeMap.get("label"));
        this.setName(attributeMap.get("name"));
        Levels levels = AbstractDataElement.readSubElement((Element)domNode, "Levels", Levels.class);
        this.setLevels(levels.getLevels());
        Members members = AbstractDataElement.readSubElement((Element)domNode, "Members", Members.class);
        this.setMembers(members.getMembers());
        for (Level level : this.getLevels()) {
            this._levelNameMap.put(level.getName(), level);
            this._levelDepthMap.put(level.getDepth(), level.getName());
            this._memberMap.put(level.getName(), new HashMap());
        }
        for (Member member : this.getMembers()) {
            String memberLevel = member.getLevel();
            String memberName = member.getName();
            Map memberMapForThisMemberLevel = this._memberMap.get(memberLevel);
            memberMapForThisMemberLevel.put(memberName, member);
        }
    }

    @Override
    public void write(Element element) throws ExecutionException {
        try {
            HierarchyInterface hierarchy = (HierarchyInterface)this._callingElement;
            String hierarchyUniqueName = hierarchy.getUniqueName();
            String hierarchyName = hierarchy.getName();
            String hierarchyLabel = hierarchy.getLabel();
            if (_logger.isDebugEnabled()) {
                _logger.debug("\tUniqueName : " + hierarchyUniqueName);
                _logger.debug("\tName ......: " + hierarchyName);
                _logger.debug("\tLabel .....: " + hierarchyLabel);
            }
            element.setAttribute("name", hierarchyName);
            element.setAttribute("label", hierarchyLabel);
            AbstractDataElement.writeSubElement(element, "Levels", Levels.class, hierarchy, this._olapDataSetInterface, this._usedDimensionsSet, this._usedLevelsSet, this._usedMembersSet, this._measureDocElements, this._membersMap, this._levelsMap);
            AbstractDataElement.writeSubElement(element, "Members", Members.class, hierarchy, this._olapDataSetInterface, this._usedDimensionsSet, this._usedLevelsSet, this._usedMembersSet, this._measureDocElements, this._membersMap, this._levelsMap);
        }
        catch (OLAPException e) {
            _logger.error(IQDataServicesResourceBundle.getStringResource("Hierarchy.write.OLAPException.txt"), (Throwable)e);
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("Hierarchy.write.OLAPException.txt", new Object[0]), (Throwable)e);
        }
    }
}

