/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml.olap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.strategies.sas.report.xml.olap.AbstractDataElement;
import com.sas.iquery.strategies.sas.report.xml.olap.Dimension;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.OLAPException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Dimensions
extends AbstractDataElement {
    public static final String NODE_NAME = "Dimensions";
    private final HashMap<String, Dimension> _dimensionMap = new HashMap();
    private static final Logger _logger = LogManager.getLogger(Dimensions.class);

    public Dimension getDimension(String name) {
        return this._dimensionMap.get(name);
    }

    private DimensionInterface[] getDimensions() throws OLAPException {
        ArrayList membersList = new ArrayList(this._usedDimensionsSet);
        Collections.sort(membersList, new Comparator(){

            public int compare(Object o1, Object o2) {
                int greaterThan;
                block2: {
                    DimensionInterface dim1 = (DimensionInterface)o1;
                    DimensionInterface dim2 = (DimensionInterface)o2;
                    greaterThan = 0;
                    try {
                        greaterThan = dim1.getUniqueName().compareTo(dim2.getUniqueName());
                    }
                    catch (OLAPException e) {
                        if (!_logger.isEnabled(Level.ERROR)) break block2;
                        _logger.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                return greaterThan;
            }
        });
        return membersList.toArray(new DimensionInterface[0]);
    }

    @Override
    public void read(Node domNode) throws ExecutionException {
        List<Dimension> dimensionList = AbstractDataElement.readSubElements((Element)domNode, "Dimension", Dimension.class);
        for (Dimension dimension : dimensionList) {
            this._dimensionMap.put(dimension.getName(), dimension);
        }
    }

    @Override
    public void write(Element element) throws ExecutionException {
        try {
            DimensionInterface[] dimensions;
            for (DimensionInterface dimension : dimensions = this.getDimensions()) {
                AbstractDataElement.writeSubElement(element, "Dimension", Dimension.class, dimension, this._olapDataSetInterface, this._usedDimensionsSet, this._usedLevelsSet, this._usedMembersSet, this._measureDocElements, this._membersMap, this._levelsMap);
            }
        }
        catch (OLAPException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("Dimensions.write.OLAPException.txt"), (Throwable)e);
            }
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("Dimensions.write.OLAPException.txt", new Object[0]), (Throwable)e);
        }
    }
}

