/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml.olap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.strategies.sas.report.xml.olap.AbstractDataElement;
import com.sas.iquery.strategies.sas.report.xml.olap.Tuple;
import com.sas.iquery.strategies.sas.report.xml.olap.Tuples;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Axis
extends AbstractDataElement {
    public static final String NODE_NAME = "Axis";
    public static final String COLUMN_AXIS = "ColumnAxis";
    public static final String ROW_AXIS = "RowAxis";
    public static final String SLICE_AXIS = "SliceAxis";
    private String _type = null;
    private List<Tuple> _tupleList = null;
    private static final Logger _logger = LogManager.getLogger(Axis.class);

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public List<Tuple> getTuples() {
        return this._tupleList;
    }

    public void setTuples(List<Tuple> tuples) {
        this._tupleList = tuples;
    }

    @Override
    public void read(Node domNode) throws ExecutionException {
        Map<String, String> attributeMap = AbstractDataElement.readNodeAttributes(domNode);
        String attributeNameType = attributeMap.get("type");
        if (_logger.isDebugEnabled()) {
            _logger.debug("Axis type=" + attributeNameType);
        }
        if (attributeNameType == null || attributeNameType.length() == 0) {
            attributeNameType = COLUMN_AXIS;
            if (_logger.isDebugEnabled()) {
                _logger.debug("change to=" + attributeNameType);
            }
        }
        this.setType(attributeNameType);
        Tuples tuples = AbstractDataElement.readSubElement((Element)domNode, "Tuples", Tuples.class);
        this.setTuples(tuples.getTupleList());
    }

    @Override
    public void write(Element element) throws ExecutionException {
        try {
            AxisInterface axis = (AxisInterface)this._callingElement;
            int axisNumber = axis.getAxisNumber();
            String axisType = null;
            switch (axisNumber) {
                case 0: {
                    axisType = COLUMN_AXIS;
                    break;
                }
                case 1: {
                    axisType = ROW_AXIS;
                    break;
                }
                case -1: {
                    axisType = SLICE_AXIS;
                    break;
                }
                default: {
                    if (_logger.isEnabled(Level.ERROR)) {
                        _logger.error(IQDataServicesResourceBundle.getMessageString("Axis.write.Default.fmt.txt", Integer.valueOf(axisNumber).toString(), axis.toString()));
                    }
                    throw new OLAPException(IQDataServicesResourceBundle.getMessageString("Axis.write.Default.fmt.txt", Integer.valueOf(axisNumber).toString(), axis.toString()));
                }
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("Axis Type : " + axisType);
            }
            element.setAttribute("type", axisType);
            AbstractDataElement.writeSubElement(element, "Tuples", Tuples.class, axis, this._olapDataSetInterface, this._usedDimensionsSet, this._usedLevelsSet, this._usedMembersSet, this._measureDocElements, this._membersMap, this._levelsMap);
        }
        catch (OLAPException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("Axes.write.OLAPException.txt", new Object[0]);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error((Object)formatter, (Throwable)e);
            }
            throw new ExecutionException(formatter, (Throwable)e);
        }
    }
}

