/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml.olap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.strategies.sas.report.xml.olap.AbstractDataElement;
import com.sas.iquery.strategies.sas.report.xml.olap.Axis;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Axes
extends AbstractDataElement {
    public static final String NODE_NAME = "Axes";
    private final Map<String, Axis> _axisMap = new HashMap<String, Axis>();
    private static final Logger _logger = LogManager.getLogger(Axes.class);

    public Axis getAxis(String axisName) {
        return this._axisMap.get(axisName);
    }

    @Override
    public void read(Node domNode) throws ExecutionException {
        List<Axis> axisList = AbstractDataElement.readSubElements((Element)domNode, "Axis", Axis.class);
        for (Axis axis : axisList) {
            this._axisMap.put(axis.getType(), axis);
        }
    }

    @Override
    public void write(Element element) throws ExecutionException {
        try {
            AxisInterface[] axes;
            ResultSetMetadataInterface resultSetMetadataInterface = this._olapDataSetInterface.getResultSetMetadata();
            for (AxisInterface axe : axes = resultSetMetadataInterface.getAxes(0, -1)) {
                AbstractDataElement.writeSubElement(element, "Axis", Axis.class, axe, this._olapDataSetInterface, this._usedDimensionsSet, this._usedLevelsSet, this._usedMembersSet, this._measureDocElements, this._membersMap, this._levelsMap);
            }
        }
        catch (OLAPException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("Axes.write.OLAPException.txt", new Object[0]);
            _logger.error(formatter.toString(), (Throwable)e);
            throw new ExecutionException(formatter, (Throwable)e);
        }
    }
}

