/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml;

import com.sas.entities.EntityInterface;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.InstructionInterface;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataretrieval.StrategyInterface;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.ExecutionInstructionInterface;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.strategies.sas.report.xml.EmbeddedData;
import com.sas.iquery.strategies.sas.report.xml.EmbeddedDataResultSet;
import com.sas.iquery.strategies.sas.report.xml.EmbeddedOLAPDataReadROM;
import com.sas.iquery.strategies.sas.report.xml.EmbeddedOLAPDataResultSet;
import com.sas.iquery.strategies.sas.report.xml.XMLIntelligentQuery;
import com.sas.iquery.strategies.sas.report.xml.XMLResultSet;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.embedded.OLAPDataSet;
import com.sas.util.ChainedException;
import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

public class XMLStrategy
implements StrategyInterface,
InstructionInterface {
    private static final Logger _logger = LogManager.getLogger(XMLStrategy.class);

    @Override
    public ResultSetInterface retrieveResultSet(BusinessQuery bq, RetrievalPolicy retrievalPolicy) throws DataRetrievalException {
        ResultSetInterface returnResultSetInterface = null;
        XMLIntelligentQuery xmlIQI = (XMLIntelligentQuery)bq;
        List<Reason> reasons = xmlIQI.getReasonsNotValid();
        if (!reasons.isEmpty()) {
            MessageFormatter baseMessage = IQDataServicesResourceBundle.getMessageFormatter("XMLStrategy.retrieveResultSet.IsValid.txt", new Object[0]);
            MessageFormatter reasonListFormatter = Reason.getMessageFormatter(baseMessage, reasons, false);
            DataRetrievalException dse = new DataRetrievalException(reasonListFormatter, reasons);
            throw dse;
        }
        returnResultSetInterface = xmlIQI.getInputStructure().isOLAP() ? this.createOLAPResultSetInterface(xmlIQI) : this.createRelationalResultSetInterface(xmlIQI);
        return returnResultSetInterface;
    }

    private ResultSetInterface createOLAPResultSetInterface(XMLIntelligentQuery xmlIQI) throws DataRetrievalException {
        EmbeddedOLAPDataResultSet returnResultSetInterface = null;
        if (xmlIQI.getEmbeddedOLAPData() != null) {
            returnResultSetInterface = xmlIQI.getEmbeddedOLAPData();
        } else if (xmlIQI.getElement() != null) {
            EmbeddedOLAPDataReadROM embeddedOLAPDataReadROM;
            Element embeddedDataElement = xmlIQI.getElement();
            try {
                embeddedOLAPDataReadROM = new EmbeddedOLAPDataReadROM(embeddedDataElement);
            }
            catch (ExecutionException e) {
                throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("XMLStrategy.createOLAPResultSetInterface.EmbeddedOLAPDataReadROM.txt", new Object[0]), (Throwable)e);
            }
            OLAPDataSet returnOLAPDataSetInterface = embeddedOLAPDataReadROM.getOLAPDataSet();
            EmbeddedOLAPDataResultSet embeddedOLAPDataResultSet = new EmbeddedOLAPDataResultSet();
            xmlIQI.setEmbeddedOLAPData(embeddedOLAPDataResultSet);
            embeddedOLAPDataResultSet.setResultSet((OLAPDataSetInterface)returnOLAPDataSetInterface);
            embeddedOLAPDataResultSet.setResultSetDate(embeddedOLAPDataReadROM.getResultSetDate());
            embeddedOLAPDataResultSet.setElement(embeddedDataElement);
            returnResultSetInterface = embeddedOLAPDataResultSet;
        } else {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("XMLStrategy.createOLAPResultSetInterface.OLAPDataSetInterface.txt", new Object[0]));
        }
        return returnResultSetInterface;
    }

    private ResultSetInterface createRelationalResultSetInterface(XMLIntelligentQuery xmlIQI) throws DataRetrievalException {
        XMLResultSet resultSet;
        EmbeddedData embeddedData = null;
        if (xmlIQI.isEmbeddedDataCreated()) {
            embeddedData = xmlIQI.getEmbeddedData();
        } else if (xmlIQI.getElement() != null) {
            embeddedData = new EmbeddedData(xmlIQI.getElement());
        } else {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("XMLStrategy.createRelationalResultSetInterface.DataRetrievalException.txt", new Object[0]));
        }
        try {
            resultSet = new XMLResultSet(embeddedData);
        }
        catch (SQLException e) {
            Throwable t = ChainedException.getRootException((Throwable)e);
            if (t == null) {
                t = e;
            }
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getMessage(), t);
            }
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("XMLStrategy.createRelationalResultSetInterface.SQLException.txt", new Object[0]), (Throwable)e);
        }
        EmbeddedDataResultSet embeddedDataResultSet = new EmbeddedDataResultSet();
        embeddedDataResultSet.setResultSet(resultSet);
        embeddedDataResultSet.setResultSetDate(embeddedData.getResultSetDate());
        return embeddedDataResultSet;
    }

    static boolean isOLAPEmbedded(Element embeddedDataElement) {
        return EmbeddedOLAPDataReadROM.isValidEmbeddedDataElement(embeddedDataElement);
    }

    @Override
    public String getPhysicalQuery(BusinessQuery businessQuery) throws IntelligentQueryException {
        return "Embedded Data";
    }

    @Override
    public String getResultSetStructure(BusinessQuery businessQuery, RetrievalPolicy retrievalPolicy) throws IntelligentQueryException {
        String returnValue = null;
        XMLIntelligentQuery xmlIQI = (XMLIntelligentQuery)businessQuery;
        ResultSetInterface resultSet = this.retrieveResultSet(xmlIQI, null);
        returnValue = resultSet instanceof EmbeddedDataResultSet ? "Tabular" : "MultiDimensional";
        return returnValue;
    }

    @Override
    public ExecutionInstructionInterface createInstructions(final DataSelection bq, EntityInterface entity) throws DataRetrievalException {
        if (!(bq instanceof XMLIntelligentQuery)) {
            throw new IllegalStateException("data selection parameter is not an XMLIntelligentQuery");
        }
        final XMLIntelligentQuery xmlIQI = (XMLIntelligentQuery)((Object)bq);
        return new ExecutionInstructionInterface(){
            ExecutionContext _context = null;
            String _id = null;

            @Override
            public void setExecutionContext(ExecutionContext context) {
                this._context = context;
            }

            @Override
            public ExecutionContext getExecutionContext() {
                return this._context;
            }

            @Override
            public String getID() {
                return this._id;
            }

            @Override
            public void setID(String id) {
                this._id = id;
            }

            @Override
            public void execute() throws ExecutionException {
            }

            @Override
            public ResultSetInterface getResult() {
                try {
                    return XMLStrategy.this.retrieveResultSet(bq, null);
                }
                catch (DataRetrievalException e) {
                    throw new IllegalStateException(e);
                }
            }

            public String toString() {
                try {
                    return this.getText();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public String getText() throws GenerationException, MetadataException {
                String exportedXml;
                Element bogusParent = IQModelImplUtilities.newDocumentWithElementName("Embedded_Data");
                Element element = xmlIQI.write(bogusParent);
                StringBuffer buf = new StringBuffer();
                buf.append("<?xml version='1.0' encoding='UTF-8'?>");
                buf.append('\n');
                buf.append(IQModelImplUtilities.toPrettyString(element, 3));
                String text = exportedXml = buf.toString();
                return text;
            }
        };
    }
}

