/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml;

import com.sas.iquery.execution.ResultSetDecorator;
import com.sas.iquery.execution.ResultSetMetaDataDecorator;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class NumericDateTimesTabularResultSet
extends ResultSetDecorator {
    protected ResultSetMetaData _numericDateTimeMetadata;
    protected boolean[] _isDate;

    public NumericDateTimesTabularResultSet(ResultSet component) throws SQLException {
        super(component);
        this.initIsDate();
    }

    private void initIsDate() throws SQLException {
        ResultSetMetaData metaData = super.getMetaData();
        int columnCount = metaData.getColumnCount();
        this._isDate = new boolean[columnCount];
        for (int columnIdx = 1; columnIdx <= columnCount; ++columnIdx) {
            int columnType = metaData.getColumnType(columnIdx);
            this._isDate[columnIdx - 1] = columnType == 91 || columnType == 92 || columnType == 93;
        }
    }

    @Override
    public String getString(int columnIdx) throws SQLException {
        if (this._isDate[columnIdx - 1]) {
            return Double.toString(super.getDouble(columnIdx));
        }
        return super.getString(columnIdx);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        int columnIdx = this.findColumn(columnName);
        return this.getString(columnIdx);
    }

    @Override
    public Object getObject(int arg0) throws SQLException {
        if (this._isDate[arg0 - 1]) {
            return super.getDouble(arg0);
        }
        return super.getObject(arg0);
    }

    @Override
    public Object getObject(String arg0) throws SQLException {
        int columnIdx = this.findColumn(arg0);
        return this.getObject(columnIdx);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this._numericDateTimeMetadata == null) {
            this._numericDateTimeMetadata = new NumericDateTimesResultSetMetaData(super.getMetaData());
        }
        return this._numericDateTimeMetadata;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException(this + " is not a wrapper for " + iface.getClass().getName());
        }
        return iface.cast(this);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public static class NumericDateTimesResultSetMetaData
    extends ResultSetMetaDataDecorator {
        public NumericDateTimesResultSetMetaData(ResultSetMetaData component) {
            super(component);
        }

        @Override
        public int getColumnType(int columnIdx) throws SQLException {
            int originalColumnType = super.getColumnType(columnIdx);
            if (this.isDateTimeColumn(originalColumnType)) {
                return 8;
            }
            return originalColumnType;
        }

        private boolean isDateTimeColumn(int columnType) {
            return columnType == 91 || columnType == 92 || columnType == 93;
        }

        @Override
        public String getColumnTypeName(int columnIdx) throws SQLException {
            return super.getColumnTypeName(columnIdx);
        }

        @Override
        public String getColumnClassName(int columnIdx) throws SQLException {
            int originalColumnType = super.getColumnType(columnIdx);
            if (this.isDateTimeColumn(originalColumnType)) {
                return "java.lang.Double";
            }
            return super.getColumnClassName(columnIdx);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return iface.isAssignableFrom(this.getClass());
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            if (!this.isWrapperFor(iface)) {
                throw new SQLException(this + " is not a wrapper for " + iface.getClass().getName());
            }
            return iface.cast(this);
        }
    }
}

