/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.strategies.sas.report.xml.olap.AbstractDataElement;
import com.sas.iquery.strategies.sas.report.xml.olap.Axes;
import com.sas.iquery.strategies.sas.report.xml.olap.Axis;
import com.sas.iquery.strategies.sas.report.xml.olap.Dimension;
import com.sas.iquery.strategies.sas.report.xml.olap.Dimensions;
import com.sas.iquery.strategies.sas.report.xml.olap.Hierarchy;
import com.sas.iquery.strategies.sas.report.xml.olap.Level;
import com.sas.iquery.strategies.sas.report.xml.olap.Member;
import com.sas.iquery.strategies.sas.report.xml.olap.Tuple;
import com.sas.iquery.strategies.sas.report.xml.olap.ValuesList;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.embedded.OLAPDataSet;
import com.sas.storage.olap.embedded.ResultSet;
import com.sas.storage.olap.embedded.ResultSetMetadata;
import com.sas.storage.olap.embedded.TupleElement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EmbeddedOLAPDataReadROM {
    private OLAPDataSet _olapDataSet = null;
    private Axes _axes = null;
    private Dimensions _dimensions = null;
    private ValuesList _valuesList = null;
    private List hierarchyNameList;
    private Date _resultSetDate = null;
    private static final Logger _logger = LogManager.getLogger(EmbeddedOLAPDataReadROM.class);

    public EmbeddedOLAPDataReadROM(Element embeddedElement) throws ExecutionException {
        this.parseXML(embeddedElement);
        this.buildCube(this.getAxes(), this.getDimensions(), this.getValuesList());
    }

    public OLAPDataSet getOLAPDataSet() {
        return this._olapDataSet;
    }

    private void setOLAPDataSet(OLAPDataSet olapDataSet) {
        this._olapDataSet = olapDataSet;
    }

    private Axes getAxes() {
        return this._axes;
    }

    private Dimensions getDimensions() {
        return this._dimensions;
    }

    private ValuesList getValuesList() {
        return this._valuesList;
    }

    private void setAxes(Axes axes) {
        this._axes = axes;
    }

    private void setDimensions(Dimensions dimensions) {
        this._dimensions = dimensions;
    }

    private void setValuesList(ValuesList valuesList) {
        this._valuesList = valuesList;
    }

    private TupleInterface[] buildTuples(List tupleList, Dimensions dimensions) throws ExecutionException {
        TupleInterface[] olapTuples = null;
        ArrayList<com.sas.storage.olap.embedded.Tuple> olapTuplesList = new ArrayList<com.sas.storage.olap.embedded.Tuple>();
        for (Tuple tuple : tupleList) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("tuple:\n" + tuple);
            }
            List<List<Member>> dimensionList = tuple.getDimensions();
            ArrayList<TupleElement> tupleElementList = new ArrayList<TupleElement>();
            for (List<Member> memberList : dimensionList) {
                int index = 0;
                for (Member member : memberList) {
                    Level level;
                    String levelUniqueName;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Found the member: " + member);
                    }
                    String memberName = member.getName();
                    String dimensionName = member.getDimension();
                    Dimension dimension = dimensions.getDimension(dimensionName);
                    Hierarchy hierarchy = dimension.getHierarchy();
                    String levelName = member.getLevel();
                    if (levelName == null) {
                        member = hierarchy.retrieveMember(memberName);
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("..found a better: " + member);
                        }
                        levelName = member.getLevel();
                    }
                    if ((levelUniqueName = (level = hierarchy.getLevel(levelName)).getUniqueName()) == null) {
                        level.setUniqueName(this.buildLevelUniqueName(dimensionName, hierarchy.getName(), level.getName()));
                        levelUniqueName = level.getUniqueName();
                    }
                    int levelDepth = level.getDepth();
                    String memberLabel = member.getLabel();
                    TupleElement tupleElement = new TupleElement(memberName);
                    try {
                        tupleElement.setLabel(memberLabel);
                        tupleElement.setUniqueLevelName(level.getUniqueName());
                    }
                    catch (OLAPException e) {
                        throw new ExecutionException(e, IQDataServicesResourceBundle.getMessageString("EmbeddedOLAPDataReadROM.buildTuples.OLAPException.fmt.txt", memberLabel));
                    }
                    try {
                        tupleElement.setLevelDepth(levelDepth);
                    }
                    catch (OLAPException e) {
                        throw new ExecutionException(e, IQDataServicesResourceBundle.getMessageString("EmbeddedOLAPDataReadROM.buildTuples.SetLevelDepth.fmt.txt", Integer.toString(levelDepth)));
                    }
                    tupleElementList.add(tupleElement);
                    ++index;
                }
            }
            TupleElementInterface[] olapTupleElements = tupleElementList.toArray(new TupleElementInterface[0]);
            com.sas.storage.olap.embedded.Tuple olapTuple = null;
            try {
                olapTuple = new com.sas.storage.olap.embedded.Tuple(olapTupleElements);
            }
            catch (OLAPException e) {
                throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("EmbeddedOLAPDataReadROM.buildTuples.OlapTuple.txt", new Object[0]), (Throwable)e);
            }
            if (olapTuple == null) continue;
            olapTuplesList.add(olapTuple);
        }
        olapTuples = olapTuplesList.toArray(new TupleInterface[0]);
        return olapTuples;
    }

    private String[] buildDimensionNames(Tuple tuple) {
        String[] dimensionNames = null;
        ArrayList<String> dimensionNameList = new ArrayList<String>();
        this.hierarchyNameList = new ArrayList();
        if (tuple != null) {
            for (Member member : tuple.getMembers()) {
                String dimensionName = member.getDimension();
                dimensionNameList.add(dimensionName);
            }
        }
        dimensionNames = dimensionNameList.toArray(new String[0]);
        return dimensionNames;
    }

    private Tuple getTupleWithMostMembers(List tupleList) {
        Tuple selectedTuple = null;
        int selectedTupleMemberCount = 0;
        for (Tuple tuple : tupleList) {
            if (tuple.getMembers().size() <= selectedTupleMemberCount) continue;
            selectedTuple = tuple;
            selectedTupleMemberCount = tuple.getMembers().size();
        }
        return selectedTuple;
    }

    private String[] buildHeaders(List tupleList, Dimensions dimensions) {
        String[] columnHeaders = null;
        ArrayList<String> columnHeaderList = new ArrayList<String>();
        if (tupleList.size() > 0) {
            Tuple tuple = (Tuple)tupleList.get(0);
            List<List<Member>> dimensionList = tuple.getDimensions();
            for (List<Member> memberList : dimensionList) {
                int index = 0;
                for (Member member : memberList) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Found the member: " + member);
                    }
                    String memberName = member.getName();
                    String dimensionName = member.getDimension();
                    Dimension dimension = dimensions.getDimension(dimensionName);
                    Hierarchy hierarchy = dimension.getHierarchy();
                    String levelName = member.getLevel();
                    if (levelName == null) {
                        member = hierarchy.retrieveMember(memberName);
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("..found a better: " + member);
                        }
                        levelName = member.getLevel();
                    }
                    Level level = hierarchy.getLevel(levelName);
                    String levelLabel = level.getLabel();
                    columnHeaderList.add(levelLabel);
                    ++index;
                }
            }
        }
        columnHeaders = columnHeaderList.toArray(new String[0]);
        return columnHeaders;
    }

    private OLAPDataSet buildOLAPDataSet(ValuesList valuesList, List olapAxesList) throws ExecutionException {
        OLAPDataSet olapDataSet = null;
        try {
            AxisInterface[] olapAxes = olapAxesList.toArray(new AxisInterface[0]);
            ResultSetMetadata resultSetMetadata = new ResultSetMetadata(olapAxes);
            ResultSet resultSet = new ResultSet();
            resultSet.setResultSetMetadata((ResultSetMetadataInterface)resultSetMetadata);
            resultSet.setCells(0L, -1L, (Object[])valuesList.getFormattedCells());
            olapDataSet = new OLAPDataSet((ResultSetInterface)resultSet);
        }
        catch (OLAPException e) {
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("EmbeddedOLAPDataReadROM.buildOLAPDataSet.Olap.txt", new Object[0]), (Throwable)e);
        }
        return olapDataSet;
    }

    private AxisInterface buildAxis(Axis axis, Dimensions dimensions, int axisType) throws ExecutionException {
        com.sas.storage.olap.embedded.Axis returnedAxis = null;
        if (axis != null) {
            List<Tuple> tuples = axis.getTuples();
            TupleInterface[] olapTuples = this.buildTuples(tuples, dimensions);
            Tuple tupleWithMostMembers = this.getTupleWithMostMembers(tuples);
            String[] dimensionNames = this.buildDimensionNames(tupleWithMostMembers);
            String[] headers = this.buildHeaders(tuples, dimensions);
            String[][] levelNamesAndLabels = this.buildUniqueLevelNamesAndLabels(dimensions, dimensionNames);
            String[] uniqueLevelNames = levelNamesAndLabels[0];
            String[] levelLabels = levelNamesAndLabels[1];
            try {
                returnedAxis = new com.sas.storage.olap.embedded.Axis(axisType, headers, olapTuples);
                returnedAxis.setDimensionNames(dimensionNames);
                returnedAxis.setHierarchyNames(this.hierarchyNameList.toArray(new String[0]));
                returnedAxis.setUniqueLevelNames(uniqueLevelNames);
                returnedAxis.setAxisHeaders(levelLabels);
            }
            catch (OLAPException e) {
                throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("EmbeddedOLAPDataReadROM.buildAxis.Olap.txt", new Object[0]), (Throwable)e);
            }
        }
        return returnedAxis;
    }

    private String[][] buildUniqueLevelNamesAndLabels(Dimensions dimensions, String[] dimensionNamesArray) {
        ArrayList<String> levelUniqueNames = new ArrayList<String>();
        ArrayList<String> levelLabels = new ArrayList<String>();
        List dimensionNames = this.distinctValues(dimensionNamesArray);
        for (String dimName : dimensionNames) {
            Dimension dim = dimensions.getDimension(dimName);
            Hierarchy hierarchy = dim.getHierarchy();
            for (Level level : hierarchy.getLevels()) {
                String levelUniqueName = level.getUniqueName();
                levelUniqueNames.add(levelUniqueName);
                levelLabels.add(level.getLabel());
                this.hierarchyNameList.add(dim.getHierarchy().getName());
            }
        }
        String[][] returnArray = new String[2][levelUniqueNames.size()];
        levelUniqueNames.toArray(returnArray[0]);
        levelLabels.toArray(returnArray[1]);
        return returnArray;
    }

    private String buildLevelUniqueName(String dimensionName, String hierarchyName, String levelName) {
        StringBuffer levelUniqueNameSB = new StringBuffer();
        levelUniqueNameSB.append("[").append(dimensionName).append("].[");
        if (!dimensionName.equals("Measures")) {
            levelUniqueNameSB.append(hierarchyName).append("].[");
        }
        levelUniqueNameSB.append(levelName).append("]");
        String levelUniqueName = levelUniqueNameSB.toString();
        return levelUniqueName;
    }

    private List distinctValues(String[] inputArray) {
        ArrayList<String> distinctValues = new ArrayList<String>();
        for (int i = 0; i < inputArray.length; ++i) {
            String value = inputArray[i];
            if (distinctValues.contains(value)) continue;
            distinctValues.add(value);
        }
        return distinctValues;
    }

    private void buildCube(Axes axes, Dimensions dimensions, ValuesList valuesList) throws ExecutionException {
        AxisInterface olapSlicerAxis;
        AxisInterface olapRowAxis;
        ArrayList<AxisInterface> olapAxesList = new ArrayList<AxisInterface>();
        AxisInterface olapColumnAxis = this.buildAxis(axes.getAxis("ColumnAxis"), dimensions, 0);
        if (olapColumnAxis != null) {
            olapAxesList.add(olapColumnAxis);
        }
        if ((olapRowAxis = this.buildAxis(axes.getAxis("RowAxis"), dimensions, 1)) != null) {
            olapAxesList.add(olapRowAxis);
        }
        if ((olapSlicerAxis = this.buildAxis(axes.getAxis("SliceAxis"), dimensions, -1)) != null) {
            olapAxesList.add(olapSlicerAxis);
        }
        OLAPDataSet olapDataSet = this.buildOLAPDataSet(valuesList, olapAxesList);
        this.setOLAPDataSet(olapDataSet);
    }

    private void parseXML(Element rootElement) throws ExecutionException {
        NodeList nodeList = rootElement.getElementsByTagName("Date");
        Element dateElement = (Element)nodeList.item(0);
        if (dateElement != null) {
            Date date;
            block3: {
                String formattedDate = dateElement.getAttribute("value");
                Locale xmlLocale = LocaleUtilities.getDefaultPersistenceLocale();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSSSZ", xmlLocale);
                date = null;
                try {
                    date = df.parse(formattedDate);
                }
                catch (ParseException e) {
                    if (!_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) break block3;
                    _logger.error("Error:  could not parse date information for attribute named 'value' with value= '" + formattedDate + "' using expected format= '" + "yyyy-MM-dd'T'HH:mm:ss:SSSSZ" + "'", (Throwable)e);
                }
            }
            this.setResultSetDate(date);
        }
        this.setDimensions(AbstractDataElement.readSubElement(rootElement, "Dimensions", Dimensions.class));
        this.setAxes(AbstractDataElement.readSubElement(rootElement, "Axes", Axes.class));
        this.setValuesList(AbstractDataElement.readSubElement(rootElement, "ValuesList", ValuesList.class));
    }

    public static boolean isValidEmbeddedDataElement(Element embeddedDataElement) {
        NodeList nodeList = embeddedDataElement.getChildNodes();
        boolean hasValuesListTag = false;
        boolean hasAxesTag = false;
        boolean hasDimensionsTag = false;
        for (int nodeNumber = 0; nodeNumber < nodeList.getLength(); ++nodeNumber) {
            String tagName = nodeList.item(nodeNumber).getNodeName();
            if (tagName.equals("ValuesList")) {
                hasValuesListTag = true;
                continue;
            }
            if (tagName.equals("Dimensions")) {
                hasDimensionsTag = true;
                continue;
            }
            if (!tagName.equals("Axes")) continue;
            hasAxesTag = true;
        }
        boolean isEmbeddedValid = false;
        if (hasAxesTag & hasDimensionsTag & hasValuesListTag) {
            isEmbeddedValid = true;
        }
        return isEmbeddedValid;
    }

    public Date getResultSetDate() {
        return this._resultSetDate;
    }

    public void setResultSetDate(Date date) {
        this._resultSetDate = date;
    }
}

