/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.AbstractResultSet;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.IQRelationalResultSetMetaData;
import com.sas.iquery.execution2.IQResultSetMetaData;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.strategies.sas.report.xml.EmbeddedData;
import com.sas.util.ChainedException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

public class EmbeddedDataResultSet
extends AbstractResultSet
implements ResultSetInterface {
    private ResultSet _resultSet;
    private IQRelationalResultSetMetaData _iqRsmd;
    private static final Logger _logger = LogManager.getLogger(EmbeddedDataResultSet.class);

    @Override
    public Object getResultSet() throws ExecutionException {
        return this._resultSet;
    }

    public void setResultSet(ResultSet resultSet) {
        this._resultSet = resultSet;
    }

    @Override
    public void write(Element parentElement) throws ExecutionException {
        try {
            EmbeddedData data = new EmbeddedData(this._resultSet);
            data.write(parentElement);
        }
        catch (SQLException e) {
            Throwable t = ChainedException.getRootException((Throwable)e);
            if (t == null) {
                t = e;
            }
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("EmbeddedDataResultSet.write.SQLException.txt"), t);
            }
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("EmbeddedDataResultSet.write.SQLException.txt", new Object[0]), (Throwable)e);
        }
        catch (Exception e) {
            Throwable t = ChainedException.getRootException((Throwable)e);
            if (t == null) {
                t = e;
            }
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("EmbeddedDataResultSet.write.Exception.txt"), t);
            }
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("EmbeddedDataResultSet.write.Exception.txt", new Object[0]), (Throwable)e);
        }
        super.write(parentElement);
    }

    @Override
    public int getType() throws ExecutionException {
        return 2;
    }

    @Override
    public IQResultSetMetaData getIQMetaData(BusinessQuery ds) throws ExecutionException {
        if (this._iqRsmd == null) {
            this._iqRsmd = new IQRelationalResultSetMetaData(this._resultSet, ds);
        }
        return this._iqRsmd;
    }

    @Override
    public IQResultSetMetaData getIQMetaData() throws ExecutionException {
        if (this._iqRsmd == null) {
            this._iqRsmd = new IQRelationalResultSetMetaData(this._resultSet);
        }
        return this._iqRsmd;
    }
}

