/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.TupleElement;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.util.Util;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public class Tuple
implements TupleInterface,
Externalizable {
    private static final long serialVersionUID = 1L;
    private int _tupleIndex;
    private AxisInterface _axis;
    private ArrayList<TupleElementInterface> _tupleElements = new ArrayList(3);

    public Tuple() throws OLAPException {
        this(null);
    }

    public Tuple(TupleElementInterface[] tupleElements) throws OLAPException {
        if (tupleElements != null) {
            for (int i = 0; i < tupleElements.length; ++i) {
                this.addElement(tupleElements[i]);
            }
        }
        this._tupleIndex = -1;
    }

    public int getTupleIndex() throws OLAPException {
        return this._tupleIndex;
    }

    void setTupleIndex(int tupleOrdinal) throws OLAPException {
        this._tupleIndex = tupleOrdinal;
    }

    public TupleElementInterface getElement(int index) throws OLAPException {
        if (index < 0 || index > this.getTupleDepth()) {
            throw new OLAPException((Throwable)new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("Tuple.invalidIndex.txt", new Object[0])));
        }
        return this._tupleElements.get(index);
    }

    @Nonnull
    public TupleElementInterface[] getElements(int index, int count) throws OLAPException {
        int endIndex;
        int elementCount = this.getTupleDepth();
        int n = endIndex = count == -1 ? elementCount : index + count;
        if (index < 0 || index > elementCount || endIndex < 0 || endIndex > elementCount) {
            throw new OLAPException((Throwable)new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("Tuple.invalidIndex.txt", new Object[0])));
        }
        List<TupleElementInterface> values = this._tupleElements.subList(index, endIndex);
        return values.toArray(new TupleElementInterface[0]);
    }

    public void addElement(TupleElementInterface element) throws OLAPException {
        this.addElement(-1, element);
    }

    public void addElement(int index, TupleElementInterface element) throws OLAPException {
        if (index == -1) {
            index = this.getTupleDepth();
        }
        if (index > this.getTupleDepth() || index < 0) {
            throw new OLAPException((Throwable)new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("Tuple.invalidIndex.txt", new Object[0])));
        }
        this._tupleElements.add(index, element);
        ((TupleElement)element).setTupleElementIndex(index);
        ((TupleElement)element).setTuple(this);
    }

    public void setElements(int index, int endIndex, TupleElementInterface[] tupleElements) throws OLAPException {
        if (tupleElements == null || index < 0 || index >= this.getTupleDepth() || endIndex < index || endIndex > this.getTupleDepth()) {
            throw new OLAPException((Throwable)new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("Tuple.invalidIndex.txt", new Object[0])));
        }
        int i = index;
        for (int j = 0; j < tupleElements.length; ++j) {
            tupleElements[j].setMinimumCoordinate(this._tupleElements.get(i).getMinimumCoordinate());
            tupleElements[j].setMaximumCoordinate(this._tupleElements.get(i).getMaximumCoordinate());
            this._tupleElements.set(i, tupleElements[j]);
            if (tupleElements[j] instanceof TupleElement) {
                ((TupleElement)tupleElements[j]).setTuple(this);
            }
            ++i;
        }
        this.calculateTupleElementIndex();
    }

    private void calculateTupleElementIndex() throws OLAPException {
        int cnt = this._tupleElements.size();
        int i = 0;
        int j = cnt - 1;
        while (i < cnt) {
            TupleElementInterface object = this._tupleElements.get(i);
            TupleElement tupleElement = (TupleElement)object;
            tupleElement.setTupleElementIndex(j);
            ++i;
            --j;
        }
    }

    public AxisInterface getAxis() throws OLAPException {
        return this._axis;
    }

    public void setAxis(AxisInterface axis) throws OLAPException {
        if (Util.unequal((Object)axis, (Object)this._axis)) {
            this._axis = axis;
        }
    }

    public int getTupleDepth() throws OLAPException {
        return this._tupleElements.size();
    }

    public String toString() {
        String elementsString;
        try {
            elementsString = Arrays.toString(this.getElements(0, -1));
        }
        catch (OLAPException e) {
            elementsString = "N/A";
        }
        return "(Tuple " + elementsString + ")";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeInt(this._tupleIndex);
        out.writeObject(this._tupleElements);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        this._tupleIndex = in.readInt();
        this._tupleElements = (ArrayList)in.readObject();
    }
}

