/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata;

import com.sas.iquery.execution.util.NamedNode;
import com.sas.iquery.execution.util.ResultColumnDef;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.AbstractMetadataFactory;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.MetadataCache;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.ROLAPNamesUtil;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.ResultSetMetadata;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.Tuple;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.TupleElement;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MeasureInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.SchemaInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ROLAPMetadataFactory
extends AbstractMetadataFactory {
    static final Logger _logger = LogManager.getLogger(ROLAPMetadataFactory.class);
    public static final String CUBE_TYPE_BIQ_ROLAP_V93 = "ROLAP SAS v9.3 BIQ";

    public ResultSetMetadata newRolapMetadata() throws OLAPException {
        ResultSetMetadata rolapRsmd = this.newResultSetMetadata(null);
        return rolapRsmd;
    }

    public AxisInterface buildAxis(ROLAPBuilderInformation.AxisInformation axisInfo, String catalogName, String schemaName, String cubeName, NamedNode tupleElementNodes, Map<String, Integer> dataItemAggregationMap, Map<String, ResultColumnDef> resultsColumnDefs) throws OLAPException, SQLException, ExecutionException {
        int axisIndex = axisInfo.getAxisIndex();
        ArrayList<Tuple> axisTuples = new ArrayList<Tuple>();
        this.printNode("Starting node: ", tupleElementNodes, "  ", true);
        ArrayList<NamedNode> parentElementNodes = new ArrayList<NamedNode>();
        this.buildAxisTuples(axisInfo, catalogName, schemaName, cubeName, tupleElementNodes, parentElementNodes, axisTuples);
        for (Tuple tuple : axisTuples) {
            this.printTuple("Tuple: ", tuple, "  ", true);
        }
        String[] axisHeaders = axisInfo.getAxisHeaders();
        int tupleCount = axisTuples.size();
        String[] dimensionsNames = axisInfo.getDimensionsNames();
        String[] hierarchiesNames = axisInfo.getHierarchiesNames();
        String[] uniqueLevelNames = axisInfo.getUniqueLevelNames();
        if (_logger.isDebugEnabled()) {
            _logger.debug("Built " + tupleCount + " tuples for axis at index " + axisIndex);
        }
        return this.newAxis(axisIndex, axisTuples, axisHeaders, dimensionsNames, hierarchiesNames, uniqueLevelNames);
    }

    private void printNode(String tag, NamedNode node, String indent, boolean recurse) {
        if (_logger.isDebugEnabled()) {
            if (node != null) {
                _logger.debug(tag + node + " path: '" + node.getPath() + "'");
                List<NamedNode> children = node.getChildren();
                if (recurse && children != null) {
                    for (NamedNode child : children) {
                        this.printNode(indent + "+ child: ", child, indent + "  ", recurse);
                    }
                }
            } else {
                _logger.debug(tag + node);
            }
        }
    }

    private void printTuple(String tag, Tuple tuple, String indent, boolean recurse) throws OLAPException {
        if (_logger.isDebugEnabled()) {
            if (tuple != null) {
                int tupleDepth = tuple.getTupleDepth();
                int tupleIndex = tuple.getTupleIndex();
                _logger.debug(tag + tuple + ", tupleIndex=" + tupleIndex + ", tupleDepth=" + tupleDepth);
                TupleElementInterface[] elements = tuple.getElements(0, tupleDepth);
                if (recurse && elements != null) {
                    for (TupleElementInterface element : elements) {
                        this.printTupleElement(indent + "+ element: ", element, indent + "  ", recurse);
                    }
                }
            } else {
                _logger.debug(tag + tuple);
            }
        }
    }

    private void printTupleElement(String tag, TupleElementInterface element, String indent, boolean recurse) throws OLAPException {
        if (_logger.isDebugEnabled()) {
            if (element != null) {
                _logger.debug(tag + "(" + element.getClass().getSimpleName() + ": name='" + element.getName() + "', label='" + element.getLabel() + "', type=" + element.getType() + ", index=" + element.getTupleElementIndex() + ", min=" + element.getMaximumCoordinate() + ", max=" + element.getMinimumCoordinate() + ", span=" + element.getSpan() + ", spanDepth=" + element.getSpanDepth() + ", levelDepth=" + element.getLevelDepth() + ", uniqueLevelName='" + element.getUniqueLevelName() + "', children=" + element.getChildCount() + ", isContextual=" + element.isContextual() + ")");
            } else {
                _logger.debug(tag + element);
            }
        }
    }

    public void buildAxisTuples(ROLAPBuilderInformation.AxisInformation axisInfo, String catalogName, String schemaName, String cubeName, NamedNode node, List<NamedNode> parentElementNodes, List<Tuple> axisTuples) throws OLAPException, SQLException, ExecutionException {
        if (node.getParent() != null) {
            parentElementNodes.add(node);
        }
        if (node.hasChildren()) {
            for (NamedNode child : node.getChildren()) {
                this.buildAxisTuples(axisInfo, catalogName, schemaName, cubeName, child, parentElementNodes, axisTuples);
                parentElementNodes.remove(parentElementNodes.size() - 1);
            }
        } else if (parentElementNodes.isEmpty()) {
            List<NamedNode> children = node.getChildren();
            for (NamedNode child : children) {
                this.buildAxisTuples(axisInfo, catalogName, schemaName, cubeName, child, parentElementNodes, axisTuples);
                parentElementNodes.remove(parentElementNodes.size() - 1);
            }
        } else {
            TupleElementInterface[] tupleElements = new TupleElementInterface[parentElementNodes.size()];
            int elementIndex = 0;
            for (NamedNode namedNodes : parentElementNodes) {
                boolean isMeasure = axisInfo.isElementIndexMeasure(elementIndex);
                TupleElementInterface tupleElement = isMeasure ? this.newMeasureTupleElement(axisInfo, elementIndex, namedNodes) : this.newRegularTupleElement(axisInfo, elementIndex, namedNodes);
                tupleElements[elementIndex] = tupleElement;
                ++elementIndex;
            }
            Tuple tuple = this.newTuple(tupleElements);
            axisTuples.add(tuple);
        }
    }

    private TupleElementInterface newRegularTupleElement(ROLAPBuilderInformation.AxisInformation axisInfo, int elementIndex, NamedNode namedNodes) throws ExecutionException, OLAPException {
        boolean isGrouped = false;
        int tupleLevelDepth = elementIndex;
        String columnName = axisInfo.getElementId(elementIndex);
        String hierarchyName = ROLAPNamesUtil.getHierarchyName(columnName);
        String dimensionName = ROLAPNamesUtil.getDimensionName(columnName);
        String hierarchyUniqueName = ROLAPNamesUtil.getHierarchyUniqueName(dimensionName, hierarchyName);
        String tupleLabel = ROLAPNamesUtil.getTupleLabel(namedNodes);
        TupleElementType type = namedNodes.getType();
        String tupleName = ROLAPNamesUtil.getTupleName(namedNodes);
        String allMemberName = ROLAPNamesUtil.getAllMemberName(columnName);
        String allMemberUniqueName = ROLAPNamesUtil.getMemberUniqueName(hierarchyName, allMemberName);
        String memberLevelName = ROLAPNamesUtil.getMemberLevelName(columnName);
        String memberLevelUniqueName = ROLAPNamesUtil.getMemberLevelUniqueName(hierarchyName, memberLevelName);
        String tupleUniqueName = ROLAPNamesUtil.getTupleUniqueName(isGrouped, namedNodes, allMemberUniqueName, tupleName);
        TupleElementInterface tupleElement = this.newTupleElement(type, tupleUniqueName, tupleLabel, namedNodes.getLeafOffset(), namedNodes.getLastLeaf().getLeafOffset(), 1, memberLevelUniqueName, tupleLevelDepth);
        if (!this.inHieararchyNames(axisInfo, hierarchyUniqueName)) {
            axisInfo.addHierarchyName(hierarchyUniqueName);
        }
        if (!this.inDimensionNames(axisInfo, dimensionName)) {
            axisInfo.addDimensionName(dimensionName);
        }
        if (!this.inUniqueLevelNames(axisInfo, memberLevelUniqueName)) {
            axisInfo.addUniqueLevelName(memberLevelUniqueName);
        }
        return tupleElement;
    }

    private TupleElementInterface newMeasureTupleElement(ROLAPBuilderInformation.AxisInformation axisInfo, int elementIndex, NamedNode namedNodes) throws OLAPException {
        int tupleLevelDepth = elementIndex;
        String nodeName = namedNodes.getName();
        String measuresDimName = "Measures";
        String hierarchyUniqueName = ROLAPNamesUtil.getHierarchyUniqueName(measuresDimName, "Measures");
        String tupleUniqueLevelName = ROLAPNamesUtil.getMeasuresLevelUniqueName("Measures", "MeasuresLevel");
        String tupleUniqueName = ROLAPNamesUtil.getMeasureUniqueName("Measures", nodeName);
        String tupleLabel = ROLAPNamesUtil.getTupleLabel(namedNodes);
        TupleElementType type = namedNodes.getType();
        TupleElementInterface tupleElement = this.newTupleElement(type, tupleUniqueName, tupleLabel, namedNodes.getLeafOffset(), namedNodes.getLastLeaf().getLeafOffset(), 1, tupleUniqueLevelName, tupleLevelDepth);
        if (!this.inHieararchyNames(axisInfo, hierarchyUniqueName)) {
            axisInfo.addHierarchyName(hierarchyUniqueName);
        }
        if (!this.inDimensionNames(axisInfo, measuresDimName)) {
            axisInfo.addDimensionName(measuresDimName);
        }
        if (!this.inUniqueLevelNames(axisInfo, tupleUniqueLevelName)) {
            axisInfo.addUniqueLevelName(tupleUniqueLevelName);
        }
        return tupleElement;
    }

    private boolean inHieararchyNames(ROLAPBuilderInformation.AxisInformation axisInfo, String uniqueHierarchyName) {
        List<String> names = Arrays.asList(axisInfo.getHierarchiesNames());
        boolean b = names != null && names.contains(uniqueHierarchyName);
        return b;
    }

    private boolean inDimensionNames(ROLAPBuilderInformation.AxisInformation axisInfo, String uniqueDimensionName) {
        List<String> names = Arrays.asList(axisInfo.getDimensionsNames());
        boolean b = names != null && names.contains(uniqueDimensionName);
        return b;
    }

    private boolean inUniqueLevelNames(ROLAPBuilderInformation.AxisInformation axisInfo, String uniqueLevelName) {
        List<String> names = Arrays.asList(axisInfo.getUniqueLevelNames());
        boolean b = names != null && names.contains(uniqueLevelName);
        return b;
    }

    public void buildAxisMembers(ROLAPBuilderInformation.AxisInformation axisInfo, String catalogName, String schemaName, String cubeName, NamedNode namedNodes, Map<String, Integer> dataItemAggregationMap, Map<String, ResultColumnDef> resultsColumnDefs) throws OLAPException, SQLException, ExecutionException {
        Date mintDate = new Date(System.currentTimeMillis());
        this.buildAxisMembers(axisInfo, catalogName, schemaName, cubeName, namedNodes, 0, dataItemAggregationMap, resultsColumnDefs, null, mintDate);
    }

    private void buildAxisMembers(ROLAPBuilderInformation.AxisInformation axisInfo, String catalogName, String schemaName, String cubeName, NamedNode namedNodes, int elementIndex, Map<String, Integer> dataItemAggregationMap, Map<String, ResultColumnDef> resultsColumnDefs, String memberParent, Date mintDate) throws OLAPException, SQLException, ExecutionException {
        String memberUniqueName;
        if (memberParent == null) {
            memberUniqueName = "";
        } else {
            boolean isMeasure = axisInfo.isElementIndexMeasure(elementIndex);
            memberUniqueName = isMeasure ? this.addMeasureMembers(axisInfo, catalogName, schemaName, cubeName, dataItemAggregationMap, resultsColumnDefs, mintDate, elementIndex, namedNodes) : this.addRegularMembers(axisInfo, catalogName, schemaName, cubeName, resultsColumnDefs, mintDate, elementIndex, namedNodes);
            ++elementIndex;
        }
        if (namedNodes.hasChildren()) {
            List<NamedNode> children = namedNodes.getChildren();
            for (NamedNode child : children) {
                this.buildAxisMembers(axisInfo, catalogName, schemaName, cubeName, child, elementIndex, dataItemAggregationMap, resultsColumnDefs, memberUniqueName, mintDate);
            }
        }
    }

    private String addRegularMembers(ROLAPBuilderInformation.AxisInformation axisInfo, String catalogName, String schemaName, String cubeName, Map<String, ResultColumnDef> resultsColumnDefs, Date mintDate, int elementIndex, NamedNode namedNodes) throws ExecutionException, OLAPException {
        String memberName;
        String memberUniqueName;
        MemberInterface member;
        LevelInterface memberLevel;
        MemberInterface allMember;
        boolean isGrouped = false;
        MetadataCache metadataCache = this.getMetadataCache();
        String columnName = axisInfo.getElementId(elementIndex);
        ResultColumnDef resultColumnDef = resultsColumnDefs.get(columnName);
        String dimensionName = ROLAPNamesUtil.getDimensionName(columnName);
        String dimensionUniqueName = ROLAPNamesUtil.getDimensionUniqueName(dimensionName);
        String hierarchyName = ROLAPNamesUtil.getHierarchyName(columnName);
        String hierarchyUniqueName = ROLAPNamesUtil.getHierarchyUniqueName(dimensionName, hierarchyName);
        DimensionInterface dimension = metadataCache.getDimension(catalogName, schemaName, cubeName, dimensionUniqueName);
        if (dimension == null) {
            String dimensionLabel = ROLAPNamesUtil.getDimensionLabel(axisInfo, namedNodes, columnName, resultColumnDef, dimensionName);
            int dimensionType = this.getDimensionType(resultColumnDef);
            dimension = this.newDimension(catalogName, schemaName, cubeName, dimensionUniqueName, dimensionName, dimensionLabel, dimensionName, dimensionType, hierarchyUniqueName, -1, mintDate);
            metadataCache.add(dimension);
            if (_logger.isDebugEnabled()) {
                _logger.debug("New dimension: " + dimension.getUniqueName());
            }
        }
        String allMemberName = ROLAPNamesUtil.getAllMemberName(columnName);
        String allMemberUniqueName = ROLAPNamesUtil.getMemberUniqueName(hierarchyName, allMemberName);
        HierarchyInterface hierarchy = metadataCache.getHierarchy(catalogName, schemaName, cubeName, hierarchyUniqueName);
        if (hierarchy == null) {
            String hierarchyLabel = ROLAPNamesUtil.getHierarchyLabel(axisInfo, namedNodes, columnName, resultColumnDef, hierarchyName);
            hierarchy = this.newHierarchy(catalogName, schemaName, cubeName, dimensionUniqueName, hierarchyUniqueName, hierarchyName, hierarchyLabel, hierarchyName, 0, -1, allMemberUniqueName, allMemberUniqueName, mintDate);
            metadataCache.add(hierarchy);
            if (_logger.isDebugEnabled()) {
                _logger.debug("New hierarchy: " + hierarchy.getUniqueName());
            }
        }
        String memberLevelName = ROLAPNamesUtil.getMemberLevelName(columnName);
        String memberLevelUniqueName = ROLAPNamesUtil.getMemberLevelUniqueName(hierarchyName, memberLevelName);
        String allLevelName = ROLAPNamesUtil.getAllLevelName(columnName);
        String allLevelUniqueName = ROLAPNamesUtil.getAllLevelUniqueName(hierarchyName, allLevelName);
        LevelInterface allLevel = metadataCache.getLevel(catalogName, schemaName, cubeName, dimensionUniqueName, allLevelUniqueName);
        if (allLevel == null) {
            boolean allLevelDepth = false;
            String allLevelLabel = ROLAPNamesUtil.getAllLevelLabel(axisInfo, namedNodes, columnName, resultColumnDef, allLevelName);
            allLevel = this.newLevel(catalogName, schemaName, cubeName, dimensionUniqueName, hierarchyUniqueName, allLevelUniqueName, allLevelName, allLevelLabel, columnName, 2, 0, -1, mintDate);
            metadataCache.add(allLevel);
            if (_logger.isDebugEnabled()) {
                _logger.debug("New all level: " + allLevel.getUniqueName());
            }
        }
        if ((allMember = metadataCache.getMember(catalogName, schemaName, cubeName, dimensionUniqueName, allMemberUniqueName)) == null) {
            boolean allMemberDepth = false;
            String allMemberLabel = ROLAPNamesUtil.getAllMemberLabel(axisInfo, namedNodes, columnName, resultColumnDef, allMemberName);
            allMember = this.newMember(catalogName, schemaName, cubeName, dimensionUniqueName, hierarchyUniqueName, allLevelUniqueName, 0, allMemberUniqueName, allMemberName, allMemberLabel, columnName, 2, null, -1, mintDate);
            metadataCache.add(allMember);
            if (_logger.isDebugEnabled()) {
                _logger.debug("New all member: " + allMember.getUniqueName() + ", parent member=" + null + ", level=" + allLevelUniqueName);
            }
            metadataCache.addLevelMember(allLevel, allMember);
        }
        if ((memberLevel = metadataCache.getLevel(catalogName, schemaName, cubeName, dimensionUniqueName, memberLevelUniqueName)) == null) {
            boolean memberLevelDepth = true;
            String memberLevelLabel = ROLAPNamesUtil.getMemberLevelLabel(axisInfo, namedNodes, columnName, resultColumnDef);
            memberLevel = this.newLevel(catalogName, schemaName, cubeName, dimensionUniqueName, hierarchyUniqueName, memberLevelUniqueName, memberLevelName, memberLevelLabel, columnName, 1, 1, -1, mintDate);
            metadataCache.add(memberLevel);
            if (_logger.isDebugEnabled()) {
                _logger.debug("New regular level: " + memberLevel.getUniqueName());
            }
        }
        if ((member = metadataCache.getMember(catalogName, schemaName, cubeName, dimensionUniqueName, memberUniqueName = ROLAPNamesUtil.getMemberUniqueName(isGrouped, namedNodes, allMemberUniqueName, memberName = ROLAPNamesUtil.getMemberName(namedNodes)))) == null) {
            boolean memberDepth = true;
            String memberLabel = ROLAPNamesUtil.getMemberLabel(namedNodes);
            String parentMemberUniqueName = isGrouped ? ROLAPNamesUtil.getParentMemberUniqueName(namedNodes, allMemberUniqueName) : allMemberUniqueName;
            member = this.newMember(catalogName, schemaName, cubeName, dimensionUniqueName, hierarchyUniqueName, memberLevelUniqueName, 1, memberUniqueName, memberName, memberLabel, memberLabel, 1, parentMemberUniqueName, -1, mintDate);
            metadataCache.add(member);
            if (_logger.isDebugEnabled()) {
                _logger.debug("New regular member: " + member.getUniqueName() + ", parent member=" + parentMemberUniqueName + ", level=" + memberLevelUniqueName);
            }
            metadataCache.addLevelMember(memberLevel, member);
            metadataCache.addMemberMember(allMember, member);
        }
        return memberUniqueName;
    }

    private String addMeasureMembers(ROLAPBuilderInformation.AxisInformation axisInfo, String catalogName, String schemaName, String cubeName, Map<String, Integer> dataItemAggregationMap, Map<String, ResultColumnDef> resultsColumnDefs, Date mintDate, int elementIndex, NamedNode node) throws OLAPException {
        String measureName;
        MeasureInterface measure;
        MemberInterface member;
        HierarchyInterface hierarchy;
        MetadataCache metadataCache = this.getMetadataCache();
        String columnName = node.getName();
        ResultColumnDef resultColumnDef = resultsColumnDefs.get(columnName);
        String dimensionName = "Measures";
        String dimensionUniqueName = ROLAPNamesUtil.getDimensionUniqueName("Measures");
        String hierarchyName = "Measures";
        String hierarchyUniqueName = ROLAPNamesUtil.getHierarchyUniqueName("Measures", "Measures");
        String memberName = node.getName();
        String memberUniqueName = ROLAPNamesUtil.getMemberUniqueName("Measures", memberName);
        DimensionInterface dimension = metadataCache.getDimension(catalogName, schemaName, cubeName, dimensionUniqueName);
        if (dimension == null) {
            String dimensionLabel = ROLAPNamesUtil.getMeasuresDimensionLabel("Measures");
            dimension = this.newDimension(catalogName, schemaName, cubeName, dimensionUniqueName, "Measures", dimensionLabel, "Measures", 2, hierarchyUniqueName, -1, mintDate);
            metadataCache.add(dimension);
        }
        if ((hierarchy = metadataCache.getHierarchy(catalogName, schemaName, cubeName, hierarchyUniqueName)) == null) {
            String hierarchyLabel = ROLAPNamesUtil.getMeasuresHierarchyLabel("Measures");
            String hierDefaultMemberUniqueName = memberUniqueName;
            hierarchy = this.newHierarchy(catalogName, schemaName, cubeName, dimensionUniqueName, hierarchyUniqueName, "Measures", hierarchyLabel, "Measures", 0, -1, hierDefaultMemberUniqueName, null, mintDate);
            metadataCache.add(hierarchy);
        }
        String measuresLevelName = "MeasuresLevel";
        String measuresLevelUniqueName = ROLAPNamesUtil.getMeasuresLevelUniqueName("Measures", "MeasuresLevel");
        LevelInterface memberLevel = metadataCache.getLevel(catalogName, schemaName, cubeName, dimensionUniqueName, measuresLevelUniqueName);
        if (memberLevel == null) {
            boolean memberLevelDepth = true;
            String measuresLevelLabel = ROLAPNamesUtil.getMeasuresLevelLabel("MeasuresLevel");
            memberLevel = this.newLevel(catalogName, schemaName, cubeName, dimensionUniqueName, hierarchyUniqueName, measuresLevelUniqueName, "MeasuresLevel", measuresLevelLabel, null, 1, 1, -1, mintDate);
            metadataCache.add(memberLevel);
        }
        if ((member = metadataCache.getMember(catalogName, schemaName, cubeName, dimensionUniqueName, memberUniqueName)) == null) {
            int memberDepth = elementIndex;
            String memberLabel = node.getLabel();
            member = this.newMember(catalogName, schemaName, cubeName, dimensionUniqueName, hierarchyUniqueName, measuresLevelUniqueName, memberDepth, memberUniqueName, memberName, memberLabel, null, 3, null, 0, mintDate);
            metadataCache.add(member);
            if (_logger.isDebugEnabled()) {
                _logger.debug("New member: " + member.getUniqueName() + ", parent member=" + null + ", level=" + measuresLevelUniqueName);
            }
            metadataCache.addLevelMember(memberLevel, member);
        }
        if ((measure = metadataCache.getMeasure(catalogName, schemaName, cubeName, measureName = node.getName())) == null) {
            String measureUniqueName = ROLAPNamesUtil.getMeasureUniqueName("Measures", measureName);
            Integer aggregation = dataItemAggregationMap.get(measureName);
            String measureDesc = resultColumnDef == null ? null : resultColumnDef.getDesc();
            String format = resultColumnDef == null ? null : resultColumnDef.getFormat();
            String unit = resultColumnDef == null ? null : resultColumnDef.getUnit();
            int precision = resultColumnDef == null ? 0 : resultColumnDef.getPrecision();
            int scale = resultColumnDef == null ? 0 : resultColumnDef.getScale();
            Class<?> dataType = resultColumnDef == null ? null : resultColumnDef.getDataType();
            String measureLabel = ROLAPNamesUtil.getMeasureLabel(axisInfo, node, measureName, resultColumnDef, measureName);
            measure = this.newMeasure(catalogName, schemaName, cubeName, measureUniqueName, measureName, measureLabel, measureDesc, aggregation, dataType, unit, scale, precision, format, mintDate);
            metadataCache.add(measure);
        }
        return memberUniqueName;
    }

    private int getDimensionType(ResultColumnDef resultColumnDef) {
        int dimensionType;
        if (resultColumnDef == null) {
            dimensionType = 3;
        } else {
            Integer iqType = resultColumnDef.getIQType();
            if (iqType != null) {
                switch (iqType) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        dimensionType = 1;
                        break;
                    }
                    default: {
                        dimensionType = 3;
                        break;
                    }
                }
            } else {
                dimensionType = 3;
            }
        }
        return dimensionType;
    }

    public TupleElementInterface newTupleElement(TupleElementType type, String name, String label, int minCoord, int maxCoord, int span, String uniqueLevelName, int levelDepth) throws OLAPException {
        TupleElement tupleElement = new TupleElement();
        tupleElement.setUniqueLevelName(uniqueLevelName);
        tupleElement.setName(name);
        tupleElement.setLabel(label);
        tupleElement.setLevelDepth(levelDepth);
        tupleElement.setType(type);
        tupleElement.setMinimumCoordinate(minCoord);
        tupleElement.setMaximumCoordinate(maxCoord);
        tupleElement.setSpan(span);
        return tupleElement;
    }

    public Tuple newTuple(TupleElementInterface[] tupleElements) throws OLAPException {
        Tuple tuple = new Tuple(tupleElements);
        return tuple;
    }

    public CubeInterface buildCube(String catalogName, String schemaName, String cubeName, String cubeLabel) throws OLAPException {
        CubeInterface cube;
        Date mintDate = new Date(System.currentTimeMillis());
        MetadataCache metadataCache = this.getMetadataCache();
        SchemaInterface schema = metadataCache.getSchema(catalogName, schemaName);
        if (schema == null) {
            schema = this.newSchema(catalogName, schemaName, schemaName);
            metadataCache.add(schema);
        }
        if ((cube = metadataCache.getCube(catalogName, schemaName, cubeName)) == null) {
            cube = this.newCube(catalogName, schemaName, cubeName, cubeLabel, null, CUBE_TYPE_BIQ_ROLAP_V93, false, mintDate);
            metadataCache.add(cube);
        }
        return cube;
    }
}

