/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.ROLAPResultSet;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PerformanceTuning;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.storage.olap.ResultSetMetadataInterface;
import java.util.Locale;

public class ROLAPDataSet
implements OLAPDataSetInterface {
    private Object connection;
    private Locale locale;
    private String queryStatement;
    private boolean readOnly;
    private int contextType;
    private ResultSetInterface _resultSet;
    private MetadataInterface _metadata;

    public ROLAPDataSet(ROLAPResultSet resultSet, MetadataInterface metadata) throws OLAPException {
        this._resultSet = resultSet;
        this._metadata = metadata;
    }

    public MetadataInterface getDatabaseMetadata() throws OLAPException {
        return this._metadata;
    }

    public String getCubeName() throws OLAPException {
        MetadataInterface databaseMetadata = this.getDatabaseMetadata();
        CubeInterface[] cubes = databaseMetadata.getCubes(null);
        if (cubes == null || cubes.length < 1) {
            throw new OLAPException(IQDataServicesResourceBundle.getStringResource("MDXGenerationUtilNoCube.txt"));
        }
        return cubes[0].getName();
    }

    public int getContextType() throws OLAPException {
        return this.contextType;
    }

    public void setContextType(int contextType) throws OLAPException {
        this.contextType = contextType;
    }

    public Object getConnection() throws OLAPException {
        return this.connection;
    }

    public void setConnection(Object connection) throws OLAPException {
        this.connection = connection;
    }

    public Locale getLocale() throws OLAPException {
        return this.locale;
    }

    public void setLocale(Locale locale) throws OLAPException {
        this.locale = locale;
    }

    public void executeQuery(String queryStatement) throws OLAPException {
        this.setQueryStatement(queryStatement);
    }

    public void executeQuery() throws OLAPException {
        this.executeQuery(this.queryStatement);
    }

    public void setQueryStatement(String queryStatement) throws OLAPException {
        this.queryStatement = queryStatement;
    }

    public void setReadOnly(boolean readOnly) throws OLAPException {
        this.readOnly = readOnly;
    }

    public ResultSetMetadataInterface getResultSetMetadata() throws OLAPException {
        return this._resultSet.getResultSetMetadata();
    }

    public String getQueryStatement() throws OLAPException {
        return this.queryStatement;
    }

    public boolean isReadOnly() throws OLAPException {
        return this.readOnly;
    }

    public Object[] getCells(long startCell, long endCell) throws OLAPException {
        return this._resultSet.getCells(startCell, endCell);
    }

    public String[] getFormattedCells(long startCell, long endCell) throws OLAPException {
        return this._resultSet.getFormattedCells(startCell, endCell);
    }

    public long getCellCount() throws OLAPException {
        return this._resultSet.getCellCount();
    }

    public void setCells(long startCell, long endCell, Object[] cellValues) throws OLAPException {
        this._resultSet.setCells(startCell, endCell, cellValues);
    }

    public void setCell(long cellIdx, Object cellValue) {
        ((ROLAPResultSet)this._resultSet).setCell(cellIdx, cellValue);
    }

    public void setFormattedCell(long cellIdx, Object cellValue) {
        ((ROLAPResultSet)this._resultSet).setFormattedCell(cellIdx, cellValue);
    }

    public void setFormattedCells(long startCell, long endCell, String[] cellValues) throws OLAPException {
        this._resultSet.setFormattedCells(startCell, endCell, cellValues);
    }

    public synchronized void close() throws OLAPException {
        this._resultSet.close();
    }

    public PerformanceTuning getPerformanceTuning() throws OLAPException {
        return null;
    }

    public void setPerformanceTuning(PerformanceTuning pf) {
    }

    public void pageOut() throws OLAPException {
        if (this._resultSet instanceof ROLAPResultSet) {
            ((ROLAPResultSet)this._resultSet).pageOut();
        }
    }
}

