/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata;

import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MeasureInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PropertyInterface;

final class MetadataFilterSasmdxCompliant {
    MetadataFilterSasmdxCompliant() {
    }

    static boolean isCompatible(CubeInterface cube, Filter filter) throws OLAPException {
        String name = filter.getNormalizedCubeName();
        boolean isCompatible = true;
        if (name != null && name.length() > 0 && cube != null) {
            isCompatible = cube.getNormalizedName().equals(name);
        }
        return isCompatible;
    }

    static boolean isCompatible(DimensionInterface dimension, Filter filter) throws OLAPException {
        String name = filter.getDimensionName();
        String uniqueName = filter.getUniqueDimensionName();
        boolean isCompatible = true;
        if (name != null && name.length() > 0) {
            isCompatible = dimension.getName().equals(name);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (uniqueName != null && uniqueName.length() > 0) {
            isCompatible = dimension.getUniqueName().equals(uniqueName);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        return MetadataFilterSasmdxCompliant.isCompatible(dimension.getCube(), filter);
    }

    static boolean isCompatible(HierarchyInterface hierarchy, Filter filter) throws OLAPException {
        String name = filter.getHierarchyName();
        String uniqueName = filter.getUniqueHierarchyName();
        boolean isCompatible = true;
        if (name != null && name.length() > 0) {
            isCompatible = hierarchy.getName().equals(name);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (uniqueName != null && uniqueName.length() > 0) {
            isCompatible = hierarchy.getUniqueName().equals(uniqueName);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        return MetadataFilterSasmdxCompliant.isCompatible(hierarchy.getDimension(), filter);
    }

    static boolean isCompatible(LevelInterface level, Filter filter) throws OLAPException {
        String name = filter.getLevelName();
        String uniqueName = filter.getUniqueLevelName();
        boolean isCompatible = true;
        if (name != null && name.length() > 0) {
            isCompatible = level.getName().equals(name);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (uniqueName != null && uniqueName.length() > 0) {
            isCompatible = level.getUniqueName().equals(uniqueName);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        return MetadataFilterSasmdxCompliant.isCompatible(level.getHierarchy(), filter);
    }

    static boolean isCompatible(MeasureInterface measure, Filter filter) throws OLAPException {
        String name = filter.getMeasureName();
        String uniqueName = filter.getUniqueMeasureName();
        boolean isCompatible = true;
        if (name != null && name.length() > 0) {
            isCompatible = measure.getName().equalsIgnoreCase(name);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (uniqueName != null && uniqueName.length() > 0) {
            isCompatible = measure.getUniqueName().equalsIgnoreCase(uniqueName);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        return MetadataFilterSasmdxCompliant.isCompatible(measure.getCube(), filter);
    }

    static boolean isCompatible(PropertyInterface property, Filter filter) throws OLAPException {
        Filter returnFilter = property.getFilter();
        String name = filter.getPropertyName();
        String uniqueMemberName = filter.getUniqueMemberName();
        String uniqueLevelName = filter.getUniqueLevelName();
        String uniqueDimensionName = filter.getUniqueDimensionName();
        String uniqueHierarchyName = filter.getUniqueHierarchyName();
        String cubeName = filter.getNormalizedCubeName();
        int propType = filter.getPropertyType();
        boolean isCompatible = true;
        if (name != null && name.length() > 0) {
            isCompatible = returnFilter.getPropertyName().equalsIgnoreCase(name);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (uniqueMemberName != null && uniqueMemberName.length() > 0) {
            isCompatible = returnFilter.getUniqueMemberName().equalsIgnoreCase(uniqueMemberName);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (uniqueLevelName != null && uniqueLevelName.length() > 0) {
            isCompatible = returnFilter.getUniqueLevelName().equalsIgnoreCase(uniqueLevelName);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (uniqueDimensionName != null && uniqueDimensionName.length() > 0) {
            isCompatible = returnFilter.getUniqueDimensionName().equalsIgnoreCase(uniqueDimensionName);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (uniqueHierarchyName != null && uniqueHierarchyName.length() > 0) {
            isCompatible = returnFilter.getUniqueHierarchyName().equalsIgnoreCase(uniqueHierarchyName);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (cubeName != null && cubeName.length() > 0) {
            isCompatible = returnFilter.getNormalizedCubeName().equals(cubeName);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (propType > 0) {
            isCompatible = returnFilter.getPropertyType() == propType;
        }
        return isCompatible;
    }

    public static boolean isCompatible(MemberInterface member, Filter filter) throws OLAPException {
        String name = filter.getMemberName();
        String uniqueName = filter.getUniqueMemberName();
        String label = filter.getMemberLabel();
        int type = filter.getMemberType();
        boolean isCompatible = true;
        if (name != null && name.length() > 0) {
            isCompatible = member.getName().equalsIgnoreCase(name);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (uniqueName != null && uniqueName.length() > 0) {
            isCompatible = member.getUniqueName().equalsIgnoreCase(uniqueName);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (label != null && label.length() > 0) {
            isCompatible = member.getLabel().equalsIgnoreCase(label);
        }
        if (!isCompatible) {
            return isCompatible;
        }
        if (type != 0) {
            isCompatible = type == member.getType();
        }
        return isCompatible;
    }
}

