/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.MetadataCache;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.MetadataFilterApiCompliant;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.MetadataFilterSasmdxCompliant;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MeasureInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PropertyInterface;
import com.sas.storage.olap.SchemaInterface;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class Metadata
implements MetadataInterface {
    private Locale _locale;
    private Object _connection;
    private MetadataCache _metadataCache;

    public Metadata(MetadataCache metadataCache) {
        this._metadataCache = metadataCache;
    }

    public CubeInterface[] getCubes(Filter filter) throws OLAPException {
        LinkedHashSet<Object> returnList;
        if (filter == null) {
            returnList = new LinkedHashSet<CubeInterface>(this._metadataCache.getCubes());
        } else {
            returnList = new LinkedHashSet();
            for (CubeInterface cube : this._metadataCache.getCubes()) {
                boolean matches = MetadataFilterSasmdxCompliant.isCompatible(cube, filter);
                if (!matches) continue;
                returnList.add(cube);
            }
        }
        return returnList.toArray(new CubeInterface[0]);
    }

    public DimensionInterface[] getDimensions(Filter filter) throws OLAPException {
        LinkedHashSet<Object> returnList;
        if (filter == null) {
            returnList = new LinkedHashSet<DimensionInterface>(this._metadataCache.getDimensions());
        } else {
            returnList = new LinkedHashSet();
            for (DimensionInterface dimension : this._metadataCache.getDimensions()) {
                boolean matches = MetadataFilterSasmdxCompliant.isCompatible(dimension, filter);
                if (!matches) continue;
                returnList.add(dimension);
            }
        }
        return returnList.toArray(new DimensionInterface[0]);
    }

    public HierarchyInterface[] getHierarchies(Filter filter) throws OLAPException {
        LinkedHashSet<Object> returnList;
        if (filter == null) {
            returnList = new LinkedHashSet<HierarchyInterface>(this._metadataCache.getHierarchies());
        } else {
            returnList = new LinkedHashSet();
            for (HierarchyInterface hierarchy : this._metadataCache.getHierarchies()) {
                boolean matches = MetadataFilterSasmdxCompliant.isCompatible(hierarchy, filter);
                if (!matches) continue;
                returnList.add(hierarchy);
            }
        }
        return returnList.toArray(new HierarchyInterface[0]);
    }

    public LevelInterface[] getLevels(Filter filter) throws OLAPException {
        LinkedHashSet<Object> returnList;
        if (filter == null) {
            returnList = new LinkedHashSet<LevelInterface>(this._metadataCache.getLevels());
        } else {
            returnList = new LinkedHashSet();
            for (LevelInterface level : this._metadataCache.getLevels()) {
                boolean matches = MetadataFilterSasmdxCompliant.isCompatible(level, filter);
                if (!matches) continue;
                returnList.add(level);
            }
        }
        return returnList.toArray(new LevelInterface[0]);
    }

    public MeasureInterface[] getMeasures(Filter filter) throws OLAPException {
        LinkedHashSet<Object> returnList;
        if (filter == null) {
            returnList = new LinkedHashSet<MeasureInterface>(this._metadataCache.getMeasures());
        } else {
            returnList = new LinkedHashSet();
            for (MeasureInterface measure : this._metadataCache.getMeasures()) {
                boolean matches = MetadataFilterSasmdxCompliant.isCompatible(measure, filter);
                if (!matches) continue;
                returnList.add(measure);
            }
        }
        return returnList.toArray(new MeasureInterface[0]);
    }

    public MemberInterface[] getMembers(Filter filter, int start, int count) throws OLAPException {
        List<MemberInterface> returnList = new ArrayList();
        for (LevelInterface level : this._metadataCache.getLevels()) {
            List<MemberInterface> members;
            int levelDepth;
            boolean matches = MetadataFilterSasmdxCompliant.isCompatible(level, filter);
            if (matches && filter != null && (levelDepth = filter.getLevelNumber()) != -1) {
                boolean bl = matches = levelDepth == level.getDepth();
            }
            if (!matches || (members = this._metadataCache.getLevelMembers(level)) == null) continue;
            for (MemberInterface member : members) {
                if (filter == null) {
                    returnList.add(member);
                    continue;
                }
                if (member == null) {
                    returnList.add(member);
                    continue;
                }
                matches = MetadataFilterSasmdxCompliant.isCompatible(member, filter);
                if (!matches) continue;
                returnList.add(member);
            }
        }
        int treeOperator = filter.getTreeOperator();
        if (treeOperator != Filter.SELF_TREE_OPERATOR && treeOperator != 0) {
            boolean getAncestors = (treeOperator & Filter.ANCESTORS_TREE_OPERATOR) != 0;
            boolean getChildren = (treeOperator & Filter.CHILDREN_TREE_OPERATOR) != 0;
            boolean getDescendents = (treeOperator & Filter.DESCENDENTS_TREE_OPERATOR) != 0;
            boolean getParent = (treeOperator & Filter.PARENT_TREE_OPERATOR) != 0;
            boolean getSelf = (treeOperator & Filter.SELF_TREE_OPERATOR) != 0;
            boolean getSiblings = (treeOperator & Filter.SIBLINGS_TREE_OPERATOR) != 0;
            List<MemberInterface> input = returnList;
            returnList = new ArrayList();
            for (MemberInterface member : input) {
                List<MemberInterface> children;
                if (getSelf) {
                    returnList.add(member);
                }
                if (getParent || getAncestors) {
                    MemberInterface parentMember;
                    if (getAncestors) {
                        for (parentMember = member.getParentMember(); parentMember != null; parentMember = parentMember.getParentMember()) {
                            returnList.add(parentMember);
                        }
                    } else if (parentMember != null) {
                        returnList.add(parentMember);
                    }
                }
                if (!getChildren && !getDescendents || (children = this._metadataCache.getMemberMembers(member)) == null || children.size() <= 0) continue;
                if (getDescendents) {
                    LinkedList<MemberInterface> queue = new LinkedList<MemberInterface>(children);
                    while (!queue.isEmpty()) {
                        MemberInterface decendant = (MemberInterface)queue.poll();
                        returnList.add(decendant);
                        children = this._metadataCache.getMemberMembers(decendant);
                        if (children == null || children.size() <= 0) continue;
                        queue.addAll(children);
                    }
                    continue;
                }
                returnList.addAll(children);
            }
        }
        if (start != 0 && count != -1) {
            ArrayList all = new ArrayList(returnList);
            int fromIndex = start < 0 ? 0 : start;
            int toIndex = count < 0 ? all.size() : fromIndex + count;
            returnList = all.subList(fromIndex, toIndex);
        }
        return returnList.toArray(new MemberInterface[0]);
    }

    public Object getConnection() throws OLAPException {
        return this._connection;
    }

    public void setConnection(Object connection) throws OLAPException {
        this._connection = connection;
    }

    public Locale getLocale() throws OLAPException {
        return this._locale;
    }

    public void setLocale(Locale locale) throws OLAPException {
        this._locale = locale;
    }

    public SchemaInterface[] getSchemas() throws OLAPException {
        return this._metadataCache.getSchemas().toArray(new SchemaInterface[0]);
    }

    public SchemaInterface[] getSchemas(Filter filter) throws OLAPException {
        LinkedHashSet<Object> returnList;
        if (filter == null) {
            returnList = new LinkedHashSet<SchemaInterface>(this._metadataCache.getSchemas());
        } else {
            returnList = new LinkedHashSet();
            for (SchemaInterface schema : this._metadataCache.getSchemas()) {
                boolean matches = MetadataFilterApiCompliant.isCompatible(schema, filter);
                if (!matches) continue;
                returnList.add(schema);
            }
        }
        return returnList.toArray(new SchemaInterface[0]);
    }

    public PropertyInterface[] getProperties(Filter filter) throws OLAPException {
        String reason = IQDataServicesResourceBundle.getStringResource("Metadata.any.unsupportedOperation.txt");
        String message = "getProperties(" + (filter == null ? null : filter.getClass().getName() + " = {" + filter.toString().replaceAll("\n", " ") + "}") + ")";
        UnsupportedOperationException un = new UnsupportedOperationException(message);
        throw new OLAPException((Throwable)un, reason);
    }

    public SchemaInterface getSchema(Filter filter) throws OLAPException {
        SchemaInterface[] schemas = this.getSchemas(filter);
        return schemas == null || schemas.length == 0 ? null : schemas[0];
    }

    public CubeInterface getCube(Filter filter) throws OLAPException {
        CubeInterface[] cubes = this.getCubes(filter);
        return cubes == null || cubes.length == 0 ? null : cubes[0];
    }

    public DimensionInterface getDimension(Filter filter) throws OLAPException {
        DimensionInterface[] dimensions = this.getDimensions(filter);
        return dimensions == null || dimensions.length == 0 ? null : dimensions[0];
    }

    public HierarchyInterface getHierarchy(Filter filter) throws OLAPException {
        HierarchyInterface[] hierarchies = this.getHierarchies(filter);
        return hierarchies == null || hierarchies.length == 0 ? null : hierarchies[0];
    }

    public LevelInterface getLevel(Filter filter) throws OLAPException {
        LevelInterface[] levels = this.getLevels(filter);
        return levels == null || levels.length == 0 ? null : levels[0];
    }

    public MeasureInterface getMeasure(Filter filter) throws OLAPException {
        MeasureInterface[] measures = this.getMeasures(filter);
        return measures == null || measures.length == 0 ? null : measures[0];
    }

    public PropertyInterface getProperty(Filter filter) throws OLAPException {
        String reason = IQDataServicesResourceBundle.getStringResource("Metadata.any.unsupportedOperation.txt");
        String message = "getProperty(" + (filter == null ? null : filter.getClass().getName() + " = {" + filter.toString().replaceAll("\n", " ") + "}") + ")";
        UnsupportedOperationException un = new UnsupportedOperationException(message);
        throw new OLAPException((Throwable)un, reason);
    }
}

