/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.AbstractMetadataEntity;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PropertyInterface;
import java.util.Date;

public class Level
extends AbstractMetadataEntity
implements LevelInterface {
    private int _type;
    private int _depth = 1;
    private String _uniqueDimensionName;
    private String _uniqueHierarchyName;
    private HierarchyInterface _hierarchy;
    private int _memberCount = -1;

    public Level(MetadataInterface metadata, String catalogName, String schemaName, String cubeName, String uniqueDimensionName, String uniqueHierarchyName, String levelUniqueName, String levelName, String levelLabel, String levelDescription, int levelType, int levelDepth, int levelMemberCount, Date mintDate) throws OLAPException {
        super(metadata, catalogName, schemaName, cubeName, levelUniqueName, levelName, levelLabel, levelDescription, mintDate, false);
        this._uniqueDimensionName = uniqueDimensionName;
        this._uniqueHierarchyName = uniqueHierarchyName;
        this._type = levelType;
        this._depth = levelDepth;
        this._memberCount = levelMemberCount;
    }

    @Override
    public Filter newFilter(boolean includeCatlogAndSchema) throws OLAPException {
        Filter filter = super.newFilter(includeCatlogAndSchema);
        filter.setUniqueDimensionName(this._uniqueDimensionName == null ? "" : this._uniqueDimensionName);
        filter.setUniqueHierarchyName(this._uniqueHierarchyName == null ? "" : this._uniqueHierarchyName);
        filter.setLevelName(this.getName());
        filter.setUniqueLevelName(this.getUniqueName());
        filter.setLevelNumber(this._depth);
        return filter;
    }

    public HierarchyInterface getHierarchy() throws OLAPException {
        if (this._hierarchy == null) {
            MetadataInterface metadata = this._getMetadata();
            Filter inFilter = super.newFilter(true);
            inFilter.setUniqueDimensionName(this._uniqueDimensionName == null ? "" : this._uniqueDimensionName);
            inFilter.setUniqueHierarchyName(this._uniqueHierarchyName == null ? "" : this._uniqueHierarchyName);
            this._hierarchy = metadata.getHierarchy(inFilter);
        }
        return this._hierarchy;
    }

    public int getMemberCount() throws OLAPException {
        if (this._memberCount != -1) {
            return this._memberCount;
        }
        return this.getMembers().length;
    }

    public MemberInterface[] getMembers() throws OLAPException {
        return this.getMembers(0, -1);
    }

    public MemberInterface[] getMembers(int index, int count) throws OLAPException {
        MetadataInterface metadata = this._getMetadata();
        Filter inFilter = this.newFilter(true);
        return metadata.getMembers(inFilter, index, count);
    }

    public int getDepth() throws OLAPException {
        return this._depth;
    }

    public int getType() throws OLAPException {
        return this._type;
    }

    public PropertyInterface[] getProperties() throws OLAPException {
        String reason = IQDataServicesResourceBundle.getStringResource("Level.any.unsupportedOperation.txt");
        UnsupportedOperationException un = new UnsupportedOperationException("getProperties()");
        throw new OLAPException((Throwable)un, reason);
    }
}

