/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.util.FileBackedListInterface;
import com.sas.iquery.execution.util.SmartFileBackedList;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.strategies.sas.oma.summaryrolap.FileBackedAxisTupleList;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPOptions;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.Tuple;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.embedded.ResultSetMetadata;
import com.sas.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Axis
implements AxisInterface {
    private int _maximumTupleDepth = 0;
    private List<String> _dimensionNames;
    private List<String> _hierarchyNames;
    private List<String> _uniqueLevelNames;
    private List<TupleInterface> _tuples;
    private int _axisNumber;
    private List<String> _labels;
    private ResultSetMetadataInterface _resultSetMetadata;

    public Axis(int axisIndex) throws OLAPException {
        this._axisNumber = axisIndex;
        try {
            ROLAPOptions options = new ROLAPOptions();
            int chunkSize = options.getTupleChunkSize();
            int pageOutThreshold = options.getTuplePageOutThreshold();
            FileBackedAxisTupleList fbl = new FileBackedAxisTupleList(chunkSize, this);
            this._tuples = this.newList(pageOutThreshold, fbl);
        }
        catch (IOException e) {
            throw new OLAPException((Throwable)e);
        }
    }

    private List<TupleInterface> newList(int pageOutThreshold, FileBackedListInterface fbl) throws IOException {
        return new SmartFileBackedList<TupleInterface>(fbl, pageOutThreshold);
    }

    public void setDimensionNames(String[] dimensionNames) throws OLAPException {
        if (dimensionNames != null) {
            this._dimensionNames = new ArrayList<String>(dimensionNames.length);
            for (int i = 0; i < dimensionNames.length; ++i) {
                this._dimensionNames.add(dimensionNames[i]);
            }
        }
    }

    public void setResultSetMetadata(ResultSetMetadataInterface rsm) throws OLAPException {
        if (Util.unequal((Object)this._resultSetMetadata, (Object)rsm)) {
            AxisInterface[] axes;
            this._resultSetMetadata = rsm;
            if (rsm instanceof ResultSetMetadata && ((axes = rsm.getAxes(this._axisNumber, 1)) == null || axes.length == 0)) {
                ((ResultSetMetadata)this._resultSetMetadata).addAxis((AxisInterface)this);
            }
        }
    }

    public String[] getDimensionNames() throws OLAPException {
        return this._dimensionNames == null ? new String[]{} : this._dimensionNames.toArray(new String[0]);
    }

    public TupleInterface[] getTuples(int index, int count) throws OLAPException {
        int endIndex;
        int tupleCount = this.getTupleCount();
        if (count == 0 || tupleCount == 0) {
            return new TupleInterface[0];
        }
        int n = endIndex = count == -1 ? tupleCount : index + count;
        if (index < 0 || index > tupleCount || endIndex <= 0 || endIndex > tupleCount) {
            throw new OLAPException((Throwable)new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("Axis.invalidIndex.txt", new Object[0])));
        }
        List<TupleInterface> subList = this._tuples.subList(index, endIndex);
        ArrayList<TupleInterface> values = new ArrayList<TupleInterface>(subList);
        return values.toArray(new TupleInterface[0]);
    }

    public TupleInterface getTuple(int index) throws OLAPException {
        if (index < 0 || index > this.getTupleCount()) {
            throw new OLAPException((Throwable)new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("Axis.invalidIndex.txt", new Object[0])));
        }
        return this._tuples.get(index);
    }

    public void addTuple(Tuple tuple) throws OLAPException {
        tuple.setAxis(this);
        tuple.setTupleIndex(this.getTupleCount());
        this.updateMaximumTupleDepth(tuple);
        this._tuples.add(tuple);
    }

    private void updateMaximumTupleDepth(Tuple tuple) throws OLAPException {
        int currentTupleDepth = tuple.getTupleDepth();
        if (currentTupleDepth > this._maximumTupleDepth) {
            this._maximumTupleDepth = currentTupleDepth;
        }
    }

    public int getTupleCount() {
        return this._tuples.size();
    }

    public int getMaximumTupleDepth() throws OLAPException {
        return this._maximumTupleDepth;
    }

    public String[] getAxisHeaders() throws OLAPException {
        return this._labels == null ? new String[]{} : this._labels.toArray(new String[0]);
    }

    public void setAxisHeaders(String[] labels) throws OLAPException {
        if (labels != null) {
            this._labels = new ArrayList<String>(labels.length);
            for (int i = 0; i < labels.length; ++i) {
                this._labels.add(labels[i]);
            }
        }
    }

    public String[] getHierarchyNames() throws OLAPException {
        return this._hierarchyNames == null ? new String[]{} : this._hierarchyNames.toArray(new String[0]);
    }

    public void setHierarchyNames(String[] hierarchyNames) throws OLAPException {
        if (hierarchyNames != null) {
            this._hierarchyNames = new ArrayList<String>(hierarchyNames.length);
            for (int i = 0; i < hierarchyNames.length; ++i) {
                this._hierarchyNames.add(hierarchyNames[i]);
            }
        }
    }

    public String[] getUniqueLevelNames() throws OLAPException {
        return this._uniqueLevelNames == null ? new String[]{} : this._uniqueLevelNames.toArray(new String[0]);
    }

    public void setUniqueLevelNames(String[] levelNames) throws OLAPException {
        if (levelNames != null) {
            this._uniqueLevelNames = new ArrayList<String>(levelNames.length);
            for (int i = 0; i < levelNames.length; ++i) {
                this._uniqueLevelNames.add(levelNames[i]);
            }
        }
    }

    public ResultSetMetadataInterface getResultSetMetadata() throws OLAPException {
        return this._resultSetMetadata;
    }

    public int getAxisNumber() throws OLAPException {
        return this._axisNumber;
    }

    void setAxisNumber(int axisIndex) {
        this._axisNumber = axisIndex;
    }

    public void close() throws OLAPException {
        if (this._tuples instanceof FileBackedListInterface) {
            try {
                ((FileBackedListInterface)this._tuples).close();
            }
            catch (IOException e) {
                throw new OLAPException((Throwable)e);
            }
        }
    }
}

