/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata;

import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.Axis;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.Cube;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.Dimension;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.Hierarchy;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.Level;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.Measure;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.Member;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.Metadata;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.MetadataCache;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.ROLAPDataSet;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.ROLAPResultSet;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.ResultSetMetadata;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.Schema;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.Tuple;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.SchemaInterface;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractMetadataFactory {
    private MetadataCache _metadataCache = new MetadataCache();
    private Metadata _metadata = new Metadata(this._metadataCache);
    public static final Logger _logger = LogManager.getLogger(AbstractMetadataFactory.class);

    public MetadataInterface getMetadata() throws OLAPException {
        return this._metadata;
    }

    public MetadataCache getMetadataCache() throws OLAPException {
        return this._metadataCache;
    }

    public ROLAPDataSet newRolapDataSet(ROLAPResultSet rolapResultSet) throws OLAPException {
        ROLAPDataSet olapDataSet = new ROLAPDataSet(rolapResultSet, this._metadata);
        return olapDataSet;
    }

    public ROLAPResultSet newRolapResultSet(ResultSetMetadata rolapRsmd, boolean isDual) throws OLAPException {
        ROLAPResultSet rolapResultSet = new ROLAPResultSet(rolapRsmd, isDual);
        return rolapResultSet;
    }

    public ResultSetMetadata newResultSetMetadata(AxisInterface[] axes) throws OLAPException {
        ResultSetMetadata rolapRsmd = new ResultSetMetadata(axes);
        return rolapRsmd;
    }

    protected Axis newAxis(int axisIndex, List<Tuple> axisTuples, String[] axisHeaders, String[] dimensionsNames, String[] hierarchiesNames, String[] uniqueLevelNames) throws OLAPException {
        Axis axis = new Axis(axisIndex);
        for (Tuple tuple : axisTuples) {
            axis.addTuple(tuple);
        }
        if (axis.getTupleCount() > 0) {
            axis.setAxisHeaders(axisHeaders);
        }
        axis.setDimensionNames(dimensionsNames);
        axis.setHierarchyNames(hierarchiesNames);
        axis.setUniqueLevelNames(uniqueLevelNames);
        return axis;
    }

    protected SchemaInterface newSchema(String catalogName, String schemaName, String schemaLabel) {
        Schema schema = new Schema(this._metadata, catalogName, schemaName, schemaLabel);
        return schema;
    }

    protected Cube newCube(String catalogName, String schemaName, String cubeName, String cubeLabel, String cubeDescription, String cubeType, boolean isDrillthroughEnabled, Date mintDate) throws OLAPException {
        Cube cube = new Cube(this._metadata, catalogName, schemaName, cubeName, cubeLabel, cubeDescription, cubeType, isDrillthroughEnabled, mintDate);
        return cube;
    }

    protected Dimension newDimension(String catalogName, String schemaName, String cubeName, String dimensionUniqueName, String dimensionName, String dimensionLabel, String dimensionDescription, int dimensionType, String defaultHierName, int nMems, Date mintDate) throws OLAPException {
        Dimension dimension = new Dimension(this._metadata, catalogName, schemaName, cubeName, dimensionUniqueName, dimensionName, dimensionLabel, dimensionDescription, dimensionType, defaultHierName, nMems, mintDate);
        return dimension;
    }

    protected Hierarchy newHierarchy(String catalogName, String schemaName, String cubeName, String uniqueDimensionName, String hierarchyUniqueName, String hierarchyName, String hierarchyLabel, String hierarchyDescription, int structure, int memberCount, String defaultMemberName, String topMemberName, Date mintDate) throws OLAPException {
        Hierarchy hierarchy = new Hierarchy(this._metadata, catalogName, schemaName, cubeName, uniqueDimensionName, hierarchyUniqueName, hierarchyName, hierarchyLabel, hierarchyDescription, structure, memberCount, defaultMemberName, topMemberName, mintDate);
        return hierarchy;
    }

    protected Level newLevel(String catalogName, String schemaName, String cubeName, String uniqueDimensionName, String uniqueHierarchyName, String levelUniqueName, String levelName, String levelLabel, String levelDescription, int levelType, int levelDepth, int levelMemberCount, Date mintDate) throws OLAPException {
        Level level = new Level(this._metadata, catalogName, schemaName, cubeName, uniqueDimensionName, uniqueHierarchyName, levelUniqueName, levelName, levelLabel, levelDescription, levelType, levelDepth, levelMemberCount, mintDate);
        return level;
    }

    protected Member newMember(String catalogName, String schemaName, String cubeName, String uniqueDimensionName, String uniqueHierarchyName, String uniqueLevelName, int levelDepth, String memberUniqueName, String memberName, String memberLabel, String memberDescription, int memberType, String parentMemberName, int childCount, Date mintDate) throws OLAPException {
        Member member = new Member(this._metadata, catalogName, schemaName, cubeName, uniqueDimensionName, uniqueHierarchyName, uniqueLevelName, levelDepth, memberUniqueName, memberName, memberLabel, memberDescription, memberType, parentMemberName, childCount, mintDate);
        return member;
    }

    protected Measure newMeasure(String catalogName, String schemaName, String cubeName, String measureUniqueName, String measureName, String measureLabel, String measureDescription, Integer aggregator, Class dataType, String unit, int scale, int precision, String format, Date mintDate) throws OLAPException {
        Measure measure = new Measure(this._metadata, catalogName, schemaName, cubeName, measureUniqueName, measureName, measureLabel, measureDescription, aggregator, dataType, unit, scale, precision, format, mintDate);
        return measure;
    }
}

