/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MetadataEntityInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.SchemaInterface;
import java.util.Date;

public abstract class AbstractMetadataEntity
implements MetadataEntityInterface {
    private MetadataInterface _metadata;
    private String _catalogName;
    private String _schemaName;
    private SchemaInterface _schema;
    private String _cubeName;
    private CubeInterface _cube;
    private String _name;
    private String _label;
    private String _description;
    private String _uniqueName;
    private boolean _isShared;
    private boolean _isSharedAllowedForCube;
    private Date _mintDate;

    protected AbstractMetadataEntity(MetadataInterface metadata, String catalogName, String schemaName, String cubeName, String uniqueName, String name, String label, String description, Date mintDate, boolean isSharedAllowedForCube) {
        this._metadata = metadata;
        this._catalogName = catalogName;
        this._schemaName = schemaName;
        this._cubeName = cubeName;
        this._name = name;
        this._label = label;
        this._description = description;
        this._uniqueName = uniqueName;
        this._mintDate = mintDate;
        if (this._cubeName == null || this._cubeName.length() == 0) {
            this._isShared = true;
        }
        this._isSharedAllowedForCube = isSharedAllowedForCube;
    }

    public final MetadataInterface getMetadata() throws OLAPException {
        return this._metadata;
    }

    public final String getName() throws OLAPException {
        return this._name;
    }

    public final String getLabel() throws OLAPException {
        return this._label;
    }

    public final String getUniqueName() throws OLAPException {
        return this._uniqueName;
    }

    public final String getDescription() throws OLAPException {
        return this._description;
    }

    public final Date getCreationDateTime() throws OLAPException {
        return this._mintDate;
    }

    public final Date getUpdateDateTime() throws OLAPException {
        return this._mintDate;
    }

    protected final boolean isShared() throws OLAPException {
        return this._isShared;
    }

    public final Filter getFilter() throws OLAPException {
        return this.newFilter(true);
    }

    public Filter newFilter(boolean includeCatlogAndSchema) throws OLAPException {
        Filter filter = new Filter();
        if (includeCatlogAndSchema) {
            filter.setCatalogName(this._catalogName == null ? "" : this._catalogName);
            filter.setSchemaName(this._schemaName == null ? "" : this._schemaName);
        }
        filter.setCubeName(this._cubeName == null ? "" : this._cubeName);
        filter.setIncludeSharedDimensions(this._isShared);
        return filter;
    }

    protected final MetadataInterface _getMetadata() throws IllegalStateException {
        if (this._metadata == null) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("Metadata.isNull.txt", new Object[0]);
            throw new IllegalStateException(formatter.toString());
        }
        return this._metadata;
    }

    public CubeInterface getCube() throws OLAPException {
        if (this.isShared() && !this._isSharedAllowedForCube) {
            return null;
        }
        if (this._cube == null) {
            if (this._metadata == null) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("Metadata.isNull.txt", new Object[0]);
                throw new IllegalStateException(formatter.toString());
            }
            Filter inFilter = new Filter();
            inFilter.setCatalogName(this._catalogName);
            inFilter.setSchemaName(this._schemaName);
            inFilter.setCubeName(this._cubeName);
            this._cube = this._metadata.getCube(inFilter);
        }
        return this._cube;
    }

    public SchemaInterface getSchema() throws OLAPException {
        if (this._schema == null) {
            Filter filter = new Filter();
            filter.setCatalogName(this._catalogName == null ? "" : this._catalogName);
            filter.setSchemaName(this._schemaName);
            if (this._metadata == null) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("Metadata.isNull.txt", new Object[0]);
                throw new IllegalStateException(formatter.toString());
            }
            this._schema = this._metadata.getSchema(filter);
        }
        return this._schema;
    }

    public String toString() {
        return this._label != null ? this._label : (this._name != null ? this._name : (this._uniqueName != null ? this._uniqueName : super.toString()));
    }
}

